/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.Tools;
import freemind.modes.MindMapEdge;
import freemind.modes.MindMapNode;
import freemind.view.mindmapview.MainView;
import freemind.view.mindmapview.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ListIterator;

class ForkMainView
extends MainView {
    ForkMainView() {
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        NodeView nodeView = this.getNodeView();
        MindMapNode model = nodeView.getModel();
        if (model == null) {
            return;
        }
        Object renderingHint = this.getController().setEdgesRenderingHint(g);
        this.paintSelected(g);
        this.paintDragOver(g);
        int edgeWidth = this.getEdgeWidth();
        Color oldColor = g.getColor();
        g.setStroke(new BasicStroke(edgeWidth));
        g.setColor(model.getEdge().getColor());
        g.drawLine(0, this.getHeight() - edgeWidth / 2 - 1, this.getWidth(), this.getHeight() - edgeWidth / 2 - 1);
        g.setColor(oldColor);
        Tools.restoreAntialiasing(g, renderingHint);
        super.paint(g);
    }

    @Override
    protected int getMainViewWidthWithFoldingMark() {
        int width = this.getWidth();
        if (this.getNodeView().getModel().isFolded()) {
            width += this.getZoomedFoldingSymbolHalfWidth() * 2 + this.getZoomedFoldingSymbolHalfWidth();
        }
        return width;
    }

    @Override
    protected int getMainViewHeightWithFoldingMark() {
        int height = this.getHeight();
        if (this.getNodeView().getModel().isFolded()) {
            height += this.getZoomedFoldingSymbolHalfWidth();
        }
        return height;
    }

    @Override
    public int getDeltaX() {
        if (this.getNodeView().getModel().isFolded() && this.getNodeView().isLeft()) {
            return super.getDeltaX() + this.getZoomedFoldingSymbolHalfWidth() * 3;
        }
        return super.getDeltaX();
    }

    @Override
    String getStyle() {
        return "fork";
    }

    @Override
    int getAlignment() {
        return -1;
    }

    @Override
    Point getLeftPoint() {
        int edgeWidth = this.getEdgeWidth();
        Point in = new Point(0, this.getHeight() - edgeWidth / 2 - 1);
        return in;
    }

    protected int getEdgeWidth() {
        MindMapNode nodeModel = this.getNodeView().getModel();
        MindMapEdge edge = nodeModel.getEdge();
        int edgeWidth = edge.getWidth();
        if (edgeWidth == 0) {
            edgeWidth = 1;
        }
        switch (edge.getStyleAsInt()) {
            case 2: 
            case 3: {
                edgeWidth = 1;
                ListIterator it = nodeModel.childrenUnfolded();
                while (it.hasNext()) {
                    MindMapNode child = (MindMapNode)it.next();
                    edgeWidth = Math.max(edgeWidth, child.getEdge().getWidth());
                }
                break;
            }
        }
        return edgeWidth;
    }

    @Override
    Point getCenterPoint() {
        Point in = new Point(this.getWidth() / 2, this.getHeight() / 2);
        return in;
    }

    @Override
    Point getRightPoint() {
        int edgeWidth = this.getEdgeWidth();
        Point in = new Point(this.getWidth() - 1, this.getHeight() - edgeWidth / 2 - 1);
        return in;
    }
}

