/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigInteger;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpGt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpLt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnCompare;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CtrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSString
extends CtrType
implements CmpEq,
CmpGt,
CmpLt {
    private static final String XS_STRING = "xs:string";
    private String _value;

    public XSString(String x) {
        this._value = x;
    }

    public XSString() {
        this(null);
    }

    public String string_type() {
        return XS_STRING;
    }

    public String type_name() {
        return "string";
    }

    public String getStringValue() {
        return this._value;
    }

    public String value() {
        return this.getStringValue();
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        return new XSString(aat.getStringValue());
    }

    private int do_compare(AnyType arg, DynamicContext dc) throws DynamicError {
        if (arg == null) {
            return 666;
        }
        XSString comparand = arg instanceof XSString ? (XSString)arg : new XSString(arg.getStringValue());
        BigInteger result = FnCompare.compare_string(dc.getCollationProvider().getDefaultCollation(), this, comparand, dc);
        return result.intValue();
    }

    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        int cmp = this.do_compare(arg, dynamicContext);
        if (cmp == 666) assert (false);
        return cmp == 0;
    }

    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        int cmp = this.do_compare(arg, context);
        assert (cmp != 666);
        return cmp > 0;
    }

    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        int cmp = this.do_compare(arg, context);
        assert (cmp != 666);
        return cmp < 0;
    }

    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_STRING;
    }

    public Object getNativeValue() {
        return this._value;
    }
}

