/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.decorators.impl;

import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter.FilterUtil;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter.IFilterNode;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.decorators.IFilterNodeDecorationService;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.decorators.impl.AbstractDecorationService;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.icons.ImageDescription;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;

public class FilterNodeDecorationService
extends AbstractDecorationService
implements ILightweightLabelDecorator,
IFilterNodeDecorationService {
    private static final String FILTERED = " " + ResourceLoader.getResourceLoader().queryString("DATATOOLS.SERVER.UI.EXPLORER.FILTER_DECORATION");

    private boolean hasFiltering(IFilterNode filterNode) {
        return FilterUtil.hasFilter(filterNode);
    }

    public void decorate(Object element, IDecoration decoration) {
        IFilterNode filterNode = (IFilterNode)element;
        if (this.hasFiltering(filterNode)) {
            decoration.addOverlay(ImageDescription.getFilterDecorationDescriptor(), 3);
            decoration.addSuffix(FILTERED);
        }
    }

    public void refreshDecoration(Object[] elements) {
        this.fireLabelChangedEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, elements));
    }

    @Override
    protected void fireLabelChangedEvent(final LabelProviderChangedEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FilterNodeDecorationService.this.fireLabelProviderChanged(event);
            }
        });
    }
}

