/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.jem.util.emf.workbench.FlexibleProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.ModelProviderEvent;
import org.eclipse.jst.javaee.core.internal.util.JavaeeResourceImpl;
import org.eclipse.jst.jee.JEEPlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateInputProvider;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorImpl;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorPresenter;

public class JEE5ModelProvider
implements IModelProvider,
ResourceStateInputProvider,
ResourceStateValidator,
IModelProviderListener {
    protected XMLResourceImpl writableResource;
    protected IProject proj;
    protected IPath defaultResourcePath;
    protected ResourceStateValidator stateValidator;
    protected ResourceAdapter resourceAdapter = new ResourceAdapter();
    protected final ListenerList listeners = new ListenerList();
    private List modelResources = new ArrayList();

    protected ProjectResourceSet getResourceSet(IProject proj2) {
        return (ProjectResourceSet)WorkbenchResourceHelperBase.getResourceSet((IProject)this.proj);
    }

    public XMLResourceImpl getWritableResource() {
        return this.writableResource;
    }

    public void setWritableResource(XMLResourceImpl writableResource) {
        this.writableResource = writableResource;
    }

    protected void resourceChanged(Resource aResource) {
        if (this.hasListeners()) {
            int eventCode = 256;
            ModelProviderEvent evt = new ModelProviderEvent(eventCode, (IModelProvider)this, this.proj);
            evt.addResource((Object)aResource);
            this.notifyListeners((IModelProviderEvent)evt);
        }
    }

    protected void resourceIsLoadedChanged(Resource aResource, boolean oldValue, boolean newValue) {
        if (this.hasListeners()) {
            int eventCode = newValue ? 32 : 64;
            ModelProviderEvent evt = new ModelProviderEvent(eventCode, (IModelProvider)this, this.proj);
            evt.addResource((Object)aResource);
            this.notifyListeners((IModelProviderEvent)evt);
        }
    }

    private synchronized void addManagedResource(XMLResourceImpl res) {
        if (res == null || this.modelResources.contains(res)) {
            return;
        }
        URI uri = res.getURI();
        Iterator iterator = this.modelResources.iterator();
        while (iterator.hasNext()) {
            XMLResourceImpl resource = (XMLResourceImpl)iterator.next();
            if (resource == null) {
                iterator.remove();
                continue;
            }
            if (resource.getURI() == null || !resource.getURI().equals(uri)) continue;
            resource.eAdapters().remove((Object)this.resourceAdapter);
            iterator.remove();
        }
        this.modelResources.add(res);
        if (!res.eAdapters().contains((Object)this.resourceAdapter)) {
            res.eAdapters().add((Object)this.resourceAdapter);
        }
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    private URI getModuleURI(URI uri) {
        URI moduleuri = ModuleURIUtil.fullyQualifyURI((IProject)this.proj, (String)this.getContentTypeDescriber());
        IPath requestPath = new Path(moduleuri.path()).append((IPath)new Path(uri.path()));
        URI resourceURI = URI.createURI((String)("module:" + requestPath.toString()));
        return resourceURI;
    }

    protected XMLResourceImpl getModelResource(IPath modelPath) {
        if (this.proj == null || !this.proj.isAccessible()) {
            throw new IllegalStateException("The project <" + this.proj + "> is not accessible.");
        }
        if (this.writableResource != null) {
            this.addManagedResource(this.writableResource);
            return this.writableResource;
        }
        IPath innerModelPath = modelPath;
        if (innerModelPath == null || innerModelPath.equals((Object)IModelProvider.FORCESAVE)) {
            innerModelPath = this.getDefaultResourcePath();
        }
        ProjectResourceSet resSet = this.getResourceSet(this.proj);
        IVirtualFolder container = ComponentCore.createComponent((IProject)this.proj).getRootFolder();
        String modelPathURI = innerModelPath.toString();
        URI uri = URI.createURI((String)modelPathURI);
        IVirtualFile dd = container.getFile(innerModelPath);
        URI projURI = URI.createURI((String)dd.getProjectRelativePath().toString());
        XMLResourceImpl res = null;
        try {
            if (!dd.exists()) {
                XMLResourceImpl newRes = this.createModelResource(innerModelPath, resSet, projURI);
                this.addManagedResource(newRes);
                return newRes;
            }
            res = (XMLResourceImpl)resSet.getResource(this.getModuleURI(uri), true);
            this.addManagedResource(res);
        }
        catch (WrappedException ex) {
            if (ex.getCause() instanceof FileNotFoundException) {
                return null;
            }
            throw ex;
        }
        return res;
    }

    protected XMLResourceImpl createModelResource(IPath modelPath, ProjectResourceSet resourceSet, URI uri) {
        XMLResourceImpl res = (XMLResourceImpl)resourceSet.getResource(this.getModuleURI(uri), false);
        if (res == null || !res.isLoaded()) {
            res = (XMLResourceImpl)((FlexibleProjectResourceSet)resourceSet).createResource(this.getModuleURI(uri), WTPResourceFactoryRegistry.INSTANCE.getFactory(uri, this.getContentType(this.getContentTypeDescriber())));
            res.setEncoding("UTF-8");
            this.populateRoot(res, resourceSet.getProject().getName());
        }
        return res;
    }

    public void populateRoot(XMLResourceImpl res, String string) {
    }

    private IContentDescription getContentType(String contentTypeDescriber) {
        if (contentTypeDescriber != null) {
            return Platform.getContentTypeManager().getContentType(contentTypeDescriber).getDefaultDescription();
        }
        return null;
    }

    public IPath getDefaultResourcePath() {
        return this.defaultResourcePath;
    }

    public void setDefaultResourcePath(IPath defaultResourcePath) {
        this.defaultResourcePath = defaultResourcePath;
    }

    public Object getModelObject() {
        return this.getModelObject(this.getDefaultResourcePath());
    }

    public Object getModelObject(IPath modelPath) {
        return null;
    }

    protected String getContentTypeDescriber() {
        return null;
    }

    public IStatus validateEdit(IPath modelPath, Object context) {
        IPath innaerModelPath = modelPath;
        Object innerContext = context;
        if (innaerModelPath == null) {
            innaerModelPath = this.getDefaultResourcePath();
        }
        IWorkspace work = ResourcesPlugin.getWorkspace();
        IFile file = WorkbenchResourceHelper.getFile((Resource)this.getModelResource(innaerModelPath));
        if (file != null && file.exists()) {
            IFile[] files = new IFile[]{file};
            if (innerContext == null) {
                innerContext = IWorkspace.VALIDATE_PROMPT;
            }
            return work.validateEdit(files, innerContext);
        }
        return Status.OK_STATUS;
    }

    public void modify(Runnable runnable, IPath modelPath) {
        try {
            try {
                JavaeeResourceImpl res = (JavaeeResourceImpl)this.getModelResource(modelPath);
                if (res != null) {
                    this.setWritableResource((XMLResourceImpl)res);
                }
                runnable.run();
                try {
                    if (res != null) {
                        if (modelPath != null && modelPath.equals((Object)IModelProvider.FORCESAVE)) {
                            res.save(Collections.EMPTY_MAP, true);
                        } else {
                            res.save(Collections.EMPTY_MAP);
                        }
                    }
                }
                catch (IOException e) {
                    JEEPlugin.logError(e);
                }
            }
            catch (Exception ex) {
                JEEPlugin.logError(ex);
                this.setWritableResource(null);
            }
        }
        finally {
            this.setWritableResource(null);
        }
    }

    public void addListener(IModelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IModelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void modelsChanged(IModelProviderEvent anEvent) {
        int code = anEvent.getEventCode();
        switch (code) {
            case 4: {
                if (this.hasResourceReference(anEvent.getChangedResources())) {
                    this.removeResources(anEvent.getChangedResources());
                    break;
                }
                return;
            }
        }
        if (this.hasListeners()) {
            anEvent.setModel((IModelProvider)this);
            this.notifyListeners(anEvent);
        }
    }

    protected void removeResources(List aList) {
        int i = 0;
        while (i < aList.size()) {
            Resource res = (Resource)aList.get(i);
            this.removeResource(res);
            ++i;
        }
    }

    protected synchronized boolean removeResource(Resource aResource) {
        if (aResource != null) {
            aResource.eAdapters().remove((Object)this.resourceAdapter);
            return this.modelResources.remove(aResource);
        }
        return false;
    }

    protected boolean hasResourceReference(List tResources) {
        int i = 0;
        while (i < tResources.size()) {
            if (this.hasResourceReference((Resource)tResources.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean hasResourceReference(Resource aResource) {
        if (aResource != null) {
            return this.getResources().contains(aResource);
        }
        return false;
    }

    protected void notifyListeners(IModelProviderEvent anEvent) {
        NotifyRunner notifier = new NotifyRunner(anEvent);
        Object[] notifyList = this.listeners.getListeners();
        int i = 0;
        while (i < notifyList.length) {
            notifier.setListener((IModelProviderListener)notifyList[i]);
            SafeRunner.run((ISafeRunnable)notifier);
            ++i;
        }
    }

    public ResourceStateValidator getStateValidator() {
        if (this.stateValidator == null) {
            this.stateValidator = this.createStateValidator();
        }
        return this.stateValidator;
    }

    private ResourceStateValidator createStateValidator() {
        return new ResourceStateValidatorImpl((ResourceStateInputProvider)this);
    }

    protected EnterpriseArtifactEdit createArtifactEdit() {
        return null;
    }

    public void checkActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().checkActivation(presenter);
    }

    public boolean checkReadOnly() {
        return this.getStateValidator().checkReadOnly();
    }

    public boolean checkSave(ResourceStateValidatorPresenter presenter) throws CoreException {
        return this.getStateValidator().checkSave(presenter);
    }

    public void lostActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().lostActivation(presenter);
    }

    public IStatus validateState(ResourceStateValidatorPresenter presenter) throws CoreException {
        if (presenter == null) {
            return Status.OK_STATUS;
        }
        return this.getStateValidator().validateState(presenter);
    }

    public void cacheNonResourceValidateState(List roNonResourceFiles) {
    }

    public List getNonResourceFiles() {
        return null;
    }

    public List getNonResourceInconsistentFiles() {
        return null;
    }

    public synchronized List getResources() {
        return new ArrayList(this.modelResources);
    }

    public boolean isDirty() {
        List list = this.getResources();
        int i = 0;
        while (i < list.size()) {
            if (((Resource)list.get(i)).isModified()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public class NotifyRunner
    implements ISafeRunnable {
        private final IModelProviderEvent event;
        private IModelProviderListener listener;

        public NotifyRunner(IModelProviderEvent event) {
            Assert.isNotNull((Object)event);
            this.event = event;
        }

        public void setListener(IModelProviderListener listener) {
            this.listener = listener;
        }

        public void handleException(Throwable exception) {
            JEEPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.jee", 0, exception.getMessage(), exception));
        }

        public void run() throws Exception {
            if (this.listener != null) {
                this.listener.modelsChanged(this.event);
            }
        }
    }

    protected class ResourceAdapter
    extends AdapterImpl {
        protected ResourceAdapter() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() == 1 && notification.getFeatureID(null) == 4) {
                JEE5ModelProvider.this.resourceIsLoadedChanged((Resource)notification.getNotifier(), notification.getOldBooleanValue(), notification.getNewBooleanValue());
            } else if (notification.getFeatureID(null) == 3) {
                JEE5ModelProvider.this.resourceChanged((Resource)notification.getNotifier());
            }
        }

        public boolean equals(Object arg0) {
            return ((Object)((Object)this)).getClass().equals(arg0.getClass());
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }
    }
}

