/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.DefaultASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionExpression;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.ModuleSpecifier;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableKind;
import org.eclipse.wst.jsdt.core.infer.IInferEngine;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.wst.jsdt.internal.core.ExportContainer;
import org.eclipse.wst.jsdt.internal.core.ExportDeclaration;
import org.eclipse.wst.jsdt.internal.core.ExportDeclarationElementInfo;
import org.eclipse.wst.jsdt.internal.core.ImportContainer;
import org.eclipse.wst.jsdt.internal.core.ImportDeclaration;
import org.eclipse.wst.jsdt.internal.core.ImportDeclarationElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.SourceConstructorInfo;
import org.eclipse.wst.jsdt.internal.core.SourceField;
import org.eclipse.wst.jsdt.internal.core.SourceFieldElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceMethod;
import org.eclipse.wst.jsdt.internal.core.SourceMethodElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceMethodInfo;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;
import org.eclipse.wst.jsdt.internal.core.SourceRefElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.SourceTypeElementInfo;

public class CompilationUnitStructureVisitor
extends DefaultASTVisitor {
    private final IJavaScriptElement unit;
    private final CompilationUnitElementInfo unitInfo;
    protected JavaElementInfo importContainerInfo = null;
    protected JavaElementInfo exportContainerInfo = null;
    private Stack<JavaElementInfo> infoStack;
    private Stack<JavaElement> handleStack;
    private HashMap<JavaElementInfo, ArrayList<IJavaScriptElement>> children;
    private final Map<JavaElement, Object> newElements;

    public CompilationUnitStructureVisitor(IJavaScriptElement unit, CompilationUnitElementInfo unitInfo, Map<JavaElement, Object> newElements) {
        this.unit = unit;
        this.unitInfo = unitInfo;
        this.newElements = newElements;
    }

    @Override
    protected boolean visitNode(ASTNode node) {
        return false;
    }

    @Override
    public boolean visit(ExpressionStatement node) {
        return true;
    }

    @Override
    public boolean visit(Block node) {
        return true;
    }

    @Override
    public boolean visit(TypeDeclarationExpression node) {
        return true;
    }

    @Override
    public boolean visit(TypeDeclarationStatement node) {
        return true;
    }

    @Override
    public boolean visit(FieldAccess node) {
        return true;
    }

    @Override
    public boolean visit(FunctionInvocation node) {
        return true;
    }

    @Override
    public boolean visit(JavaScriptUnit node) {
        this.infoStack = new Stack();
        this.children = new HashMap();
        this.handleStack = new Stack();
        this.infoStack.push(this.unitInfo);
        this.handleStack.push((JavaElement)this.unit);
        return true;
    }

    @Override
    public boolean visit(FunctionExpression node) {
        node.getMethod().accept(this);
        return false;
    }

    @Override
    public boolean visit(FunctionDeclarationStatement node) {
        node.getDeclaration().accept(this);
        return false;
    }

    @Override
    public boolean visit(ObjectLiteral node) {
        JavaElementInfo parentInfo = this.infoStack.peek();
        JavaElement parentHandle = this.handleStack.peek();
        SourceType handle = new SourceType(parentHandle, "", true);
        this.resolveDuplicates(handle);
        SourceTypeElementInfo info = new SourceTypeElementInfo(parentHandle instanceof ClassFile, true);
        info.setHandle(handle);
        info.setSourceRangeStart(node.getStartPosition());
        info.setNameSourceStart(node.getStartPosition());
        info.setNameSourceEnd(node.getStartPosition() + node.getLength() - 1);
        info.setSourceRangeEnd(node.getStartPosition() + node.getLength() - 1);
        info.setSuperclassName("".toCharArray());
        this.addToChildren(parentInfo, handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
        return true;
    }

    @Override
    public void endVisit(ObjectLiteral node) {
        SourceRefElementInfo info = (SourceRefElementInfo)this.infoStack.pop();
        this.setChildren(info);
        this.handleStack.pop();
    }

    @Override
    public boolean visit(ObjectLiteralField node) {
        JavaElementInfo parentInfo = this.infoStack.peek();
        JavaElement parentHandle = this.handleStack.peek();
        String fieldName = JavaModelManager.getJavaModelManager().intern(new String(node.getFieldName().toString()));
        SourceField handle = new SourceField(parentHandle, fieldName);
        this.resolveDuplicates(handle);
        SourceFieldElementInfo info = new SourceFieldElementInfo();
        info.setNameSourceStart(node.getFieldName().getStartPosition());
        info.setNameSourceEnd(node.getFieldName().getStartPosition() + node.getFieldName().getLength() - 1);
        info.setSourceRangeStart(node.getStartPosition());
        info.setSourceRangeEnd(node.getStartPosition() + node.getLength() - 1);
        this.addToChildren(parentInfo, handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
        if (node.getInitializer() != null) {
            node.getInitializer().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(ObjectLiteralField node) {
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.infoStack.pop();
        this.setChildren(info);
        this.handleStack.pop();
    }

    @Override
    public boolean visit(ParenthesizedExpression node) {
        return true;
    }

    @Override
    public boolean visit(FunctionDeclaration node) {
        JavaElementInfo parentInfo = this.infoStack.peek();
        JavaElement parentHandle = this.handleStack.peek();
        SourceMethod handle = null;
        Expression methodName = node.getMethodName();
        char[] cs = methodName != null ? node.getMethodName().toString().toCharArray() : CharOperation.concat(IInferEngine.ANONYMOUS_PREFIX, IInferEngine.ANONYMOUS_CLASS_ID);
        String selector = JavaModelManager.getJavaModelManager().intern(new String(cs));
        String[] parameterTypeSigs = new String[]{};
        handle = new SourceMethod(parentHandle, selector, parameterTypeSigs);
        this.resolveDuplicates(handle);
        SourceMethodElementInfo info = node.isConstructor() ? new SourceConstructorInfo() : new SourceMethodInfo();
        if (methodName != null) {
            info.setNameSourceStart(methodName.getStartPosition());
            info.setNameSourceEnd(methodName.getStartPosition() + methodName.getLength() - 1);
        } else {
            info.setNameSourceStart(node.getStartPosition());
            info.setNameSourceEnd(node.getStartPosition() + node.getLength() - 1);
        }
        info.setSourceRangeStart(node.getStartPosition());
        info.setSourceRangeEnd(node.getStartPosition() + node.getLength() - 1);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        List parameters = node.parameters();
        char[][] parameterNames = new char[parameters.size()][];
        int i = 0;
        while (i < parameters.size()) {
            SingleVariableDeclaration param = (SingleVariableDeclaration)parameters.get(i);
            parameterNames[i] = manager.intern(param.getPattern().toString().toCharArray());
            ++i;
        }
        info.setArgumentNames(parameterNames);
        List modifiers = node.modifiers();
        int modifierFlag = 0;
        for (Modifier modifier : modifiers) {
            if (!modifier.isStatic()) continue;
            modifierFlag |= 8;
        }
        info.setFlags(modifierFlag);
        this.addToChildren(parentInfo, handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
        node.getBody().accept(this);
        return false;
    }

    @Override
    public void endVisit(FunctionDeclaration node) {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.infoStack.pop();
        this.setChildren(info);
        this.handleStack.pop();
    }

    @Override
    public boolean visit(VariableDeclarationStatement node) {
        List fragments = node.fragments();
        for (VariableDeclarationFragment fragment : fragments) {
            fragment.accept(this);
        }
        return false;
    }

    private void visitImportModule(org.eclipse.wst.jsdt.core.dom.ImportDeclaration parent, ModuleSpecifier module) {
        JavaElement parentHandle = this.handleStack.peek();
        if (parentHandle.getElementType() != 5) {
            Assert.isTrue((boolean)false);
        }
        IJavaScriptUnit parentCU = (IJavaScriptUnit)((Object)parentHandle);
        ImportContainer importContainer = (ImportContainer)parentCU.getImportContainer();
        if (this.importContainerInfo == null) {
            this.importContainerInfo = new JavaElementInfo();
            JavaElementInfo parentInfo = this.infoStack.peek();
            this.addToChildren(parentInfo, importContainer);
            this.newElements.put(importContainer, this.importContainerInfo);
        }
        SimpleName localName = module.getLocal() != null ? module.getLocal() : module.getDiscoverableName();
        StringBuilder nameString = new StringBuilder(parent.getSource().getLiteralValue());
        nameString.append(" as ");
        nameString.append(localName.getIdentifier());
        String elementName = JavaModelManager.getJavaModelManager().intern(nameString.toString());
        ImportDeclaration handle = new ImportDeclaration(importContainer, elementName, parent.isOnDemand());
        this.resolveDuplicates(handle);
        ImportDeclarationElementInfo info = new ImportDeclarationElementInfo();
        info.setNameSourceStart(localName.getStartPosition());
        info.setNameSourceEnd(localName.getStartPosition() + localName.getLength() - 1);
        info.setSourceRangeStart(parent.getStartPosition());
        info.setSourceRangeEnd(parent.getStartPosition() + parent.getLength() - 1);
        this.addToChildren(this.importContainerInfo, handle);
        this.newElements.put(handle, info);
    }

    @Override
    public boolean visit(org.eclipse.wst.jsdt.core.dom.ImportDeclaration node) {
        List specifiers = node.specifiers();
        if (specifiers.isEmpty()) {
            JavaElement parentHandle = this.handleStack.peek();
            if (parentHandle.getElementType() != 5) {
                Assert.isTrue((boolean)false);
            }
            IJavaScriptUnit parentCU = (IJavaScriptUnit)((Object)parentHandle);
            ImportContainer importContainer = (ImportContainer)parentCU.getImportContainer();
            if (this.importContainerInfo == null) {
                this.importContainerInfo = new JavaElementInfo();
                JavaElementInfo parentInfo = this.infoStack.peek();
                this.addToChildren(parentInfo, importContainer);
                this.newElements.put(importContainer, this.importContainerInfo);
            }
            String elementName = JavaModelManager.getJavaModelManager().intern(node.getSource().getLiteralValue());
            ImportDeclaration handle = new ImportDeclaration(importContainer, elementName, false);
            this.resolveDuplicates(handle);
            ImportDeclarationElementInfo info = new ImportDeclarationElementInfo();
            info.setNameSourceStart(node.getStartPosition());
            info.setNameSourceEnd(node.getStartPosition() + node.getLength() - 1);
            info.setSourceRangeStart(node.getStartPosition());
            info.setSourceRangeEnd(node.getStartPosition() + node.getLength() - 1);
            this.addToChildren(this.importContainerInfo, handle);
            this.newElements.put(handle, info);
        } else {
            for (ModuleSpecifier module : specifiers) {
                this.visitImportModule(node, module);
            }
        }
        return false;
    }

    private void visitExportModule(org.eclipse.wst.jsdt.core.dom.ExportDeclaration parent, ModuleSpecifier module) {
        JavaElement parentHandle = this.handleStack.peek();
        if (parentHandle.getElementType() != 5) {
            Assert.isTrue((boolean)false);
        }
        IJavaScriptUnit parentCU = (IJavaScriptUnit)((Object)parentHandle);
        ExportContainer exportContainer = (ExportContainer)parentCU.getExportContainer();
        if (this.exportContainerInfo == null) {
            this.exportContainerInfo = new JavaElementInfo();
            JavaElementInfo parentInfo = this.infoStack.peek();
            this.addToChildren(parentInfo, exportContainer);
            this.newElements.put(exportContainer, this.exportContainerInfo);
        }
        SimpleName localName = module.getLocal();
        StringBuilder nameString = parent.getSource() != null ? new StringBuilder(parent.getSource().getLiteralValue()) : new StringBuilder("export");
        nameString.append(" as ");
        nameString.append(localName.getIdentifier());
        String elementName = JavaModelManager.getJavaModelManager().intern(nameString.toString());
        ExportDeclaration handle = new ExportDeclaration(exportContainer, elementName);
        this.resolveDuplicates(handle);
        ExportDeclarationElementInfo info = new ExportDeclarationElementInfo();
        info.setNameSourceStart(localName.getStartPosition());
        info.setNameSourceEnd(localName.getStartPosition() + localName.getLength() - 1);
        info.setSourceRangeStart(parent.getStartPosition());
        info.setSourceRangeEnd(parent.getStartPosition() + parent.getLength() - 1);
        this.addToChildren(this.exportContainerInfo, handle);
        this.newElements.put(handle, info);
    }

    @Override
    public boolean visit(org.eclipse.wst.jsdt.core.dom.ExportDeclaration node) {
        List specifiers = node.specifiers();
        if (specifiers.isEmpty()) {
            JavaElement parentHandle = this.handleStack.peek();
            if (parentHandle.getElementType() != 5) {
                Assert.isTrue((boolean)false);
            }
            IJavaScriptUnit parentCU = (IJavaScriptUnit)((Object)parentHandle);
            ExportContainer exportContainer = (ExportContainer)parentCU.getExportContainer();
            if (this.exportContainerInfo == null) {
                this.exportContainerInfo = new JavaElementInfo();
                JavaElementInfo parentInfo = this.infoStack.peek();
                this.addToChildren(parentInfo, exportContainer);
                this.newElements.put(exportContainer, this.exportContainerInfo);
            }
            String elementName = node.getSource() != null ? JavaModelManager.getJavaModelManager().intern(node.getSource().getLiteralValue()) : "export";
            ExportDeclaration handle = new ExportDeclaration(exportContainer, elementName);
            this.resolveDuplicates(handle);
            ExportDeclarationElementInfo info = new ExportDeclarationElementInfo();
            info.setNameSourceStart(node.getStartPosition());
            info.setNameSourceEnd(node.getStartPosition() + node.getLength() - 1);
            info.setSourceRangeStart(node.getStartPosition());
            info.setSourceRangeEnd(node.getStartPosition() + node.getLength() - 1);
            this.addToChildren(this.exportContainerInfo, handle);
            this.newElements.put(handle, info);
        } else {
            for (ModuleSpecifier module : specifiers) {
                this.visitExportModule(node, module);
            }
        }
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        JavaElementInfo parentInfo = this.infoStack.peek();
        JavaElement parentHandle = this.handleStack.peek();
        if (node.getPattern().getNodeType() == 42) {
            String fieldName = JavaModelManager.getJavaModelManager().intern(String.valueOf(node.getName().getIdentifier()));
            SourceField handle = new SourceField(parentHandle, fieldName);
            this.resolveDuplicates(handle);
            SourceFieldElementInfo info = new SourceFieldElementInfo();
            info.setNameSourceStart(node.getName().getStartPosition());
            info.setNameSourceEnd(node.getName().getStartPosition() + node.getName().getLength() - 1);
            info.setSourceRangeStart(node.getStartPosition());
            if (node.getParent().getNodeType() == 60 && node.getParent().getStructuralProperty(VariableDeclarationStatement.KIND_PROPERTY) == VariableKind.CONST) {
                info.flags |= 0x18;
            }
            if (node.getInitializer() != null) {
                int initializerType = node.getInitializer().getNodeType();
                String typeString = null;
                switch (initializerType) {
                    case 9: {
                        typeString = Signature.createTypeSignature("boolean", false);
                        break;
                    }
                    case 34: {
                        typeString = "Number";
                        break;
                    }
                    case 45: {
                        typeString = "String";
                        break;
                    }
                    case 85: {
                        typeString = "{}";
                        break;
                    }
                }
                if (typeString != null) {
                    char[] typeName = JavaModelManager.getJavaModelManager().intern(typeString.toCharArray());
                    info.setTypeName(typeName);
                }
            }
            this.addToChildren(parentInfo, handle);
            this.newElements.put(handle, info);
            this.infoStack.push(info);
            this.handleStack.push(handle);
            if (node.getInitializer() != null) {
                node.getInitializer().accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(VariableDeclarationFragment node) {
        if (node.getPattern().getNodeType() == 42) {
            SourceFieldElementInfo info = (SourceFieldElementInfo)this.infoStack.pop();
            info.setSourceRangeEnd(node.getStartPosition() + node.getLength() - 1);
            this.setChildren(info);
            this.handleStack.pop();
        }
    }

    @Override
    public void endVisit(JavaScriptUnit node) {
        if (this.importContainerInfo != null) {
            this.setChildren(this.importContainerInfo);
        }
        if (this.exportContainerInfo != null) {
            this.setChildren(this.exportContainerInfo);
        }
        this.setChildren(this.unitInfo);
        this.unitInfo.setSourceLength(node.getLength() + 1);
        IProblem[] problems = node.getProblems();
        this.unitInfo.setIsStructureKnown(problems == null || problems.length == 0);
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        JavaElementInfo parentInfo = this.infoStack.peek();
        JavaElement parentHandle = this.handleStack.peek();
        String nameString = node.getName().getIdentifier();
        SourceType handle = new SourceType(parentHandle, nameString, false);
        this.resolveDuplicates(handle);
        SourceTypeElementInfo info = new SourceTypeElementInfo(parentHandle instanceof ClassFile, false);
        info.setHandle(handle);
        info.setSourceRangeStart(node.getStartPosition());
        info.setSourceRangeEnd(node.getStartPosition() + node.getLength() - 1);
        info.setNameSourceStart(node.getName().getStartPosition());
        info.setNameSourceEnd(node.getName().getStartPosition() + node.getName().getLength() - 1);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        char[] superclass = null;
        if (node.getSuperclassExpression() != null) {
            superclass = node.getSuperclassExpression().toString().toCharArray();
        }
        info.setSuperclassName(superclass == null ? "".toCharArray() : manager.intern(superclass));
        this.addToChildren(parentInfo, handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
        return true;
    }

    @Override
    public void endVisit(TypeDeclaration node) {
        SourceRefElementInfo info = (SourceRefElementInfo)this.infoStack.pop();
        this.setChildren(info);
        this.handleStack.pop();
    }

    private void addToChildren(JavaElementInfo parentInfo, JavaElement handle) {
        ArrayList<IJavaScriptElement> childrenList = this.children.get(parentInfo);
        if (childrenList == null) {
            childrenList = new ArrayList();
            this.children.put(parentInfo, childrenList);
        }
        childrenList.add(handle);
    }

    private void setChildren(JavaElementInfo info) {
        ArrayList<IJavaScriptElement> childrenList = this.children.get(info);
        if (childrenList != null) {
            int length = childrenList.size();
            IJavaScriptElement[] elements = new IJavaScriptElement[length];
            childrenList.toArray(elements);
            info.children = elements;
        }
    }

    protected void resolveDuplicates(SourceRefElement handle) {
        while (this.newElements.containsKey(handle)) {
            ++handle.occurrenceCount;
        }
    }
}

