/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.launch;

import java.io.IOException;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.Messages;
import org.eclipse.cdt.arduino.core.internal.build.ArduinoBuildConfiguration;
import org.eclipse.cdt.arduino.core.internal.build.ArduinoBuildConfigurationProvider;
import org.eclipse.cdt.arduino.core.internal.launch.ArduinoLaunch;
import org.eclipse.cdt.arduino.core.internal.remote.ArduinoRemoteConnection;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.launch.ITargetedLaunch;
import org.eclipse.launchbar.core.target.launch.LaunchConfigurationTargetedDelegate;
import org.eclipse.remote.core.IRemoteConnection;

public class ArduinoLaunchConfigurationDelegate
extends LaunchConfigurationTargetedDelegate {
    public static final String TYPE_ID = "org.eclipse.cdt.arduino.core.launchConfigurationType";
    public static final String CONNECTION_NAME = String.valueOf(Activator.getId()) + ".connectionName";
    private static final ICBuildConfigurationManager buildConfigManager = Activator.getService(ICBuildConfigurationManager.class);

    public ITargetedLaunch getLaunch(ILaunchConfiguration configuration, String mode, ILaunchTarget target) throws CoreException {
        return new ArduinoLaunch(configuration, mode, null, target);
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, ILaunchTarget target, IProgressMonitor monitor) throws CoreException {
        IRemoteConnection connection = (IRemoteConnection)target.getAdapter(IRemoteConnection.class);
        if (target != null) {
            ArduinoRemoteConnection arduinoTarget = (ArduinoRemoteConnection)connection.getService(ArduinoRemoteConnection.class);
            IProject project = configuration.getMappedResources()[0].getProject();
            ArduinoBuildConfiguration arduinoConfig = this.getArduinoConfiguration(project, mode, arduinoTarget, monitor);
            arduinoConfig.setActive(monitor);
        }
        return super.buildForLaunch(configuration, mode, target, monitor);
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject project = configuration.getMappedResources()[0].getProject();
        return new IProject[]{project};
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            ILaunchTarget target = ((ITargetedLaunch)launch).getLaunchTarget();
            IRemoteConnection connection = (IRemoteConnection)target.getAdapter(IRemoteConnection.class);
            if (connection == null) {
                throw new CoreException((IStatus)new Status(4, Activator.getId(), Messages.ArduinoLaunchConfigurationDelegate_2));
            }
            ArduinoRemoteConnection arduinoTarget = (ArduinoRemoteConnection)connection.getService(ArduinoRemoteConnection.class);
            IProject project = (IProject)configuration.getMappedResources()[0];
            ArduinoBuildConfiguration arduinoConfig = this.getArduinoConfiguration(project, mode, arduinoTarget, monitor);
            String[] uploadCmd = arduinoConfig.getUploadCommand(arduinoTarget.getPortName());
            StringBuilder cmdStr = new StringBuilder(uploadCmd[0]);
            int i = 1;
            while (i < uploadCmd.length) {
                cmdStr.append(' ');
                cmdStr.append(uploadCmd[i]);
                ++i;
            }
            ((ArduinoLaunch)launch).start();
            ProcessBuilder processBuilder = new ProcessBuilder(uploadCmd).directory(arduinoConfig.getBuildDirectory().toFile());
            arduinoConfig.setBuildEnvironment(processBuilder.environment());
            Process process = processBuilder.start();
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)cmdStr.toString());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), e.getLocalizedMessage(), (Throwable)e));
        }
    }

    public ArduinoBuildConfiguration getArduinoConfiguration(IProject project, String launchMode, ArduinoRemoteConnection arduinoTarget, IProgressMonitor monitor) throws CoreException {
        ArduinoBuildConfigurationProvider provider = (ArduinoBuildConfigurationProvider)buildConfigManager.getProvider("org.eclipse.cdt.arduino.core.provider");
        return provider.getConfiguration(project, arduinoTarget, launchMode, monitor);
    }
}

