/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.script.ScriptEngine;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlLocationCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlMappingGroupCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenMappingGroup;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenRuntimeData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlPatternEventHandler;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioHistoryBuilder;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.readwrite.TmfXmlReadWriteModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.ISegmentListener;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternSegmentStoreModule;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfAttributePool;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlPatternStateProvider
extends AbstractTmfStateProvider
implements IXmlStateSystemContainer {
    private final Path fFilePath;
    private final @NonNull String fStateId;
    private final Map<Integer, TmfAttributePool> fAttributePools = new HashMap<Integer, TmfAttributePool>();
    private final Map<@NonNull String, @NonNull DataDrivenMappingGroup> fMappingGroups = new HashMap<String, DataDrivenMappingGroup>();
    private final @NonNull Map<@NonNull String, @NonNull String> fStoredFields = new HashMap<String, String>();
    private final TmfXmlPatternEventHandler fHandler;
    private final ISegmentListener fListener;
    private final @NonNull TmfXmlScenarioHistoryBuilder fHistoryBuilder;
    private final AnalysisCompilationData fAnalysisCompilationData;
    private Map<String, ScriptEngine> fScriptengine = new HashMap<String, ScriptEngine>();
    private final DataDrivenRuntimeData fExecutionData = new DataDrivenRuntimeData();

    public XmlPatternStateProvider(@NonNull ITmfTrace trace, @NonNull String stateid, @Nullable Path file, ISegmentListener listener) {
        super(trace, stateid);
        AnalysisCompilationData analysisData;
        this.fStateId = stateid;
        this.fFilePath = file;
        this.fListener = listener;
        this.fHistoryBuilder = new TmfXmlScenarioHistoryBuilder();
        String pathString = this.fFilePath.toAbsolutePath().toString();
        Element doc = TmfXmlUtils.getElementInFile(pathString, "pattern", this.fStateId);
        if (doc == null) {
            throw new IllegalArgumentException("XmlPatternStateProvider: Cannot find pattern element in file " + pathString);
        }
        NodeList storedFieldNodes = doc.getElementsByTagName("storedField");
        int i = 0;
        while (i < storedFieldNodes.getLength()) {
            Element element = (Element)storedFieldNodes.item(i);
            String key = element.getAttribute("alias");
            this.fStoredFields.put(element.getAttribute("id"), key.isEmpty() ? element.getAttribute("id") : key);
            ++i;
        }
        this.fAnalysisCompilationData = analysisData = new AnalysisCompilationData();
        List<@NonNull Element> childElements = TmfXmlUtils.getChildElements(doc, "definedValue");
        for (Element element : childElements) {
            analysisData.addDefinedValue(element.getAttribute("name"), element.getAttribute("value"));
        }
        childElements = TmfXmlUtils.getChildElements(doc, "location");
        for (Element element : childElements) {
            TmfXmlLocationCu.compile(analysisData, element);
        }
        ArrayList<TmfXmlMappingGroupCu> mapGroups = new ArrayList<TmfXmlMappingGroupCu>();
        childElements = TmfXmlUtils.getChildElements(doc, "mappingGroup");
        for (Element map : childElements) {
            TmfXmlMappingGroupCu compile = TmfXmlMappingGroupCu.compile(analysisData, map);
            if (compile == null) {
                throw new NullPointerException("Problem compiling a mapping group");
            }
            mapGroups.add(compile);
        }
        for (TmfXmlMappingGroupCu mapGroup : mapGroups) {
            DataDrivenMappingGroup group = mapGroup.generate();
            this.fMappingGroups.put(group.getId(), group);
        }
        ITmfXmlModelFactory modelFactory = TmfXmlReadWriteModelFactory.getInstance();
        NodeList nodes = doc.getElementsByTagName("patternHandler");
        this.fHandler = modelFactory.createPatternEventHandler((Element)NonNullUtils.checkNotNull((Object)((Element)nodes.item(0))), this);
    }

    @Override
    public String getAttributeValue(String name) {
        String attribute = name;
        if (attribute.startsWith("$")) {
            attribute = this.getDefinedValue(attribute.substring(1));
        }
        return attribute;
    }

    public String getDefinedValue(String constant) {
        if (constant != null) {
            return this.fAnalysisCompilationData.getStringValue(constant);
        }
        return null;
    }

    public @NonNull Map<@NonNull String, @NonNull String> getStoredFields() {
        return this.fStoredFields;
    }

    public int getVersion() {
        return 0;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        return new XmlPatternStateProvider(this.getTrace(), this.getStateId(), this.fFilePath, this.fListener);
    }

    public @NonNull String getStateId() {
        return this.fStateId;
    }

    @Override
    public ITmfStateSystem getStateSystem() {
        ITmfStateSystemBuilder ss = this.getStateSystemBuilder();
        if (ss == null) {
            throw new NullPointerException("The state system should not be requested at this point, it is null");
        }
        return ss;
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        this.fHandler.handleEvent(event);
    }

    public ISegmentListener getListener() {
        return this.fListener;
    }

    public void dispose() {
        this.waitForEmptyQueue();
        this.fListener.onNewSegment(XmlPatternSegmentStoreModule.END_SEGMENT);
        this.fHandler.dispose();
        super.dispose();
    }

    public @NonNull TmfXmlScenarioHistoryBuilder getHistoryBuilder() {
        return this.fHistoryBuilder;
    }

    @Override
    public @Nullable TmfAttributePool getAttributePool(int startNodeQuark) {
        ITmfStateSystem ss = this.getStateSystem();
        if (!(ss instanceof ITmfStateSystemBuilder)) {
            throw new IllegalStateException("The state system hasn't been initialized yet");
        }
        TmfAttributePool pool = this.fAttributePools.get(startNodeQuark);
        if (pool == null) {
            pool = new TmfAttributePool((ITmfStateSystemBuilder)ss, Integer.valueOf(startNodeQuark), TmfAttributePool.QueueType.PRIORITY);
            this.fAttributePools.put(startNodeQuark, pool);
        }
        return pool;
    }

    @Override
    public boolean isReadOnlyContainer() {
        return false;
    }

    @Override
    public AnalysisCompilationData getAnalysisCompilationData() {
        return this.fAnalysisCompilationData;
    }

    @Override
    public void setScriptengine(String name, ScriptEngine engine) {
        this.fScriptengine.put(name, engine);
    }

    @Override
    public ScriptEngine getScriptEngine(String name) {
        return this.fScriptengine.get(name);
    }

    @Override
    public DataDrivenMappingGroup getMappingGroup(String id) {
        return Objects.requireNonNull(this.fMappingGroups.get(id));
    }

    @Override
    public DataDrivenRuntimeData getExecutionData() {
        return this.fExecutionData;
    }
}

