/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.greenplum.model;

import java.sql.ResultSet;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumExternalTable;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumSchemaCache;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumTable;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumWithClauseBuilder;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDialect;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableRegular;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerExtensionBase;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PostgreServerGreenplum
extends PostgreServerExtensionBase {
    public PostgreServerGreenplum(PostgreDataSource dataSource) {
        super(dataSource);
    }

    public String getServerTypeName() {
        return "Greenplum";
    }

    public boolean supportFunctionDefRead() {
        return false;
    }

    public boolean supportsSessionActivity() {
        return true;
    }

    public boolean supportsClientInfo() {
        return false;
    }

    public PostgreTableBase createRelationOfClass(PostgreSchema schema, PostgreClass.RelKind kind, JDBCResultSet dbResult) {
        if (kind == PostgreClass.RelKind.r) {
            if (this.isRelationExternal(dbResult)) {
                return new GreenplumExternalTable(schema, (ResultSet)dbResult);
            }
            return new GreenplumTable(schema, (ResultSet)dbResult);
        }
        return super.createRelationOfClass(schema, kind, dbResult);
    }

    public PostgreTableBase createNewRelation(PostgreSchema schema, PostgreClass.RelKind kind) {
        if (kind == PostgreClass.RelKind.r) {
            return new GreenplumTable(schema);
        }
        return super.createNewRelation(schema, kind);
    }

    private boolean isRelationExternal(JDBCResultSet dbResult) {
        return JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_ext_table");
    }

    public PostgreDatabase.SchemaCache createSchemaCache(PostgreDatabase database) {
        return new GreenplumSchemaCache();
    }

    public void configureDialect(PostgreDialect dialect) {
        dialect.addExtraKeywords(new String[]{"DISTRIBUTED", "SEGMENT", "REJECT", "FORMAT", "MASTER", "WEB", "WRITABLE", "READABLE", "LOG", "ERRORS"});
    }

    public boolean supportsExplainPlanXML() {
        return false;
    }

    public boolean supportsExplainPlanVerbose() {
        return false;
    }

    public String createWithClause(PostgreTableRegular table, PostgreTableBase tableBase) {
        return GreenplumWithClauseBuilder.generateWithClause((PostgreTable)table, tableBase);
    }

    public String readTableDDL(DBRProgressMonitor monitor, PostgreTableBase table) throws DBException {
        if (table instanceof GreenplumExternalTable) {
            return ((GreenplumExternalTable)table).generateDDL(monitor);
        }
        return super.readTableDDL(monitor, table);
    }
}

