/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.plan;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCSavedQueryPlanner;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.controls.VerticalButton;
import org.jkiss.dbeaver.ui.controls.VerticalFolder;
import org.jkiss.dbeaver.ui.editors.sql.SQLPlanViewProvider;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorActivator;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.editors.sql.plan.registry.SQLPlanViewDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.plan.registry.SQLPlanViewRegistry;
import org.jkiss.utils.CommonUtils;

public class ExplainPlanViewer
extends Viewer
implements IAdaptable {
    static final Log log = Log.getLog(ExplainPlanViewer.class);
    private final IWorkbenchPart workbenchPart;
    private final DBPContextProvider contextProvider;
    private final ProgressControl planPresentationContainer;
    private final VerticalFolder tabViewFolder;
    private final Composite planViewComposite;
    private PlanViewInfo activeViewInfo;
    private SQLQuery lastQuery;
    private Object lastQueryId;
    private DBCPlan lastPlan;
    private RefreshPlanAction refreshPlanAction;

    public ExplainPlanViewer(IWorkbenchPart workbenchPart, DBPContextProvider contextProvider, Composite parent) {
        this.workbenchPart = workbenchPart;
        this.contextProvider = contextProvider;
        this.refreshPlanAction = new RefreshPlanAction();
        this.refreshPlanAction.setEnabled(false);
        this.planPresentationContainer = new ProgressControl(parent);
        this.planPresentationContainer.getLayout().numColumns = 2;
        this.planPresentationContainer.setLayoutData(new GridData(1808));
        this.tabViewFolder = new VerticalFolder((Composite)this.planPresentationContainer, 16384);
        ((GridLayout)this.tabViewFolder.getLayout()).marginTop = 20;
        this.tabViewFolder.setLayoutData((Object)new GridData(1040));
        for (SQLPlanViewDescriptor viewDesc : SQLPlanViewRegistry.getInstance().getPlanViewDescriptors()) {
            VerticalButton treeViewButton = new VerticalButton(this.tabViewFolder, 16400);
            treeViewButton.setText(viewDesc.getLabel());
            if (!CommonUtils.isEmpty((String)viewDesc.getDescription())) {
                treeViewButton.setToolTipText(viewDesc.getDescription());
                if (viewDesc.getIcon() != null) {
                    treeViewButton.setImage(DBeaverIcons.getImage((DBPImage)viewDesc.getIcon()));
                }
            }
            treeViewButton.setData((Object)new PlanViewInfo(viewDesc));
            treeViewButton.setLayoutData((Object)new GridData(2));
        }
        this.tabViewFolder.addListener(13, event -> {
            try {
                this.changeActiveView(this.tabViewFolder.getSelection());
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_execution_plan_title, SQLEditorMessages.editors_sql_error_execution_plan_message, (Throwable)e);
            }
        });
        this.planViewComposite = new Composite((Composite)this.planPresentationContainer, 0);
        this.planViewComposite.setLayoutData((Object)new GridData(1808));
        this.planViewComposite.setLayout((Layout)new StackLayout());
        this.planPresentationContainer.setShowDivider(false);
        Composite progressPanel = this.planPresentationContainer.createProgressPanel();
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        progressPanel.setLayoutData((Object)gd);
        IDialogSettings settings = this.getPlanViewSettings();
        VerticalButton curItem = null;
        String activeViewId = settings.get("activeView");
        VerticalButton[] verticalButtonArray = this.tabViewFolder.getItems();
        int n = verticalButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            VerticalButton item = verticalButtonArray[n2];
            PlanViewInfo data = (PlanViewInfo)item.getData();
            if (curItem == null) {
                curItem = item;
            } else if (activeViewId != null && activeViewId.equals(data.descriptor.getId())) {
                curItem = item;
            }
            ++n2;
        }
        this.tabViewFolder.setSelection(curItem);
    }

    public SQLQuery getQuery() {
        return this.lastQuery;
    }

    public void explainQueryPlan(SQLQuery query, Object queryId) {
        this.lastQuery = query;
        this.lastQueryId = queryId;
        this.refresh();
    }

    private PlanViewInfo[] getPlanViews() {
        VerticalButton[] items = this.tabViewFolder.getItems();
        PlanViewInfo[] infos = new PlanViewInfo[items.length];
        int i = 0;
        while (i < items.length) {
            infos[i] = (PlanViewInfo)items[i].getData();
            ++i;
        }
        return infos;
    }

    private void changeActiveView(VerticalButton viewButton) throws DBException {
        this.activeViewInfo = (PlanViewInfo)viewButton.getData();
        if (this.activeViewInfo.planViewer == null) {
            this.activeViewInfo.planViewer = this.activeViewInfo.descriptor.createInstance();
            this.activeViewInfo.viewer = this.activeViewInfo.planViewer.createPlanViewer(this.workbenchPart, this.planViewComposite);
            if (this.lastPlan != null) {
                this.activeViewInfo.planViewer.visualizeQueryPlan(this.activeViewInfo.viewer, this.lastQuery, this.lastPlan);
            }
        }
        if (this.activeViewInfo.planViewer != null) {
            ((StackLayout)this.planViewComposite.getLayout()).topControl = this.activeViewInfo.viewer.getControl();
            this.planViewComposite.layout();
            this.getPlanViewSettings().put("activeView", this.activeViewInfo.descriptor.getId());
        } else {
            this.activeViewInfo = null;
        }
        this.planPresentationContainer.refreshActions();
    }

    private IDialogSettings getPlanViewSettings() {
        return UIUtils.getSettingsSection((IDialogSettings)SQLEditorActivator.getDefault().getDialogSettings(), (String)((Object)((Object)this)).getClass().getSimpleName());
    }

    public Control getControl() {
        return this.planPresentationContainer;
    }

    public Object getInput() {
        return this.activeViewInfo == null ? null : this.activeViewInfo.viewer.getInput();
    }

    public ISelection getSelection() {
        return this.activeViewInfo == null ? null : this.activeViewInfo.viewer.getSelection();
    }

    public void refresh() {
        DBCQueryPlanner planner;
        DBCExecutionContext executionContext = this.contextProvider.getExecutionContext();
        if (executionContext != null) {
            DBPDataSource dataSource = executionContext.getDataSource();
            planner = (DBCQueryPlanner)DBUtils.getAdapter(DBCQueryPlanner.class, (Object)dataSource);
        } else {
            planner = null;
        }
        if (planner == null) {
            DBWorkbench.getPlatformUI().showError("No SQL Plan", "This datasource doesn't support execution plans");
        } else {
            LoadingJob service = LoadingJob.createService((ILoadService)new ExplainPlanService(planner, executionContext, this.lastQuery.getText(), this.lastQueryId), (ILoadVisualizer)this.planPresentationContainer.createVisualizer());
            service.schedule();
        }
    }

    private void visualizePlan(DBCPlan plan) {
        this.lastPlan = plan;
        this.refreshPlanAction.setEnabled(true);
        PlanViewInfo[] planViewInfoArray = this.getPlanViews();
        int n = planViewInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlanViewInfo viewInfo = planViewInfoArray[n2];
            if (viewInfo.viewer != null) {
                viewInfo.planViewer.visualizeQueryPlan(viewInfo.viewer, this.lastQuery, plan);
            }
            ++n2;
        }
        this.planPresentationContainer.refreshActions();
    }

    public void setInput(Object input) {
        if (this.activeViewInfo != null) {
            this.activeViewInfo.viewer.setInput(input);
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (this.activeViewInfo != null) {
            this.activeViewInfo.viewer.setSelection(selection, reveal);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.activeViewInfo != null && this.activeViewInfo.viewer instanceof IAdaptable) {
            return (T)((IAdaptable)this.activeViewInfo.viewer).getAdapter(adapter);
        }
        return null;
    }

    public static class ExplainPlanService
    extends DatabaseLoadService<DBCPlan> {
        private final DBCQueryPlanner planner;
        private final DBCExecutionContext executionContext;
        private final String query;
        private final Object savedQueryId;
        private DBCPlan plan;

        ExplainPlanService(DBCQueryPlanner planner, DBCExecutionContext executionContext, String query, Object savedQueryId) {
            super("Explain plan", planner.getDataSource());
            this.planner = planner;
            this.executionContext = executionContext;
            this.query = query;
            this.savedQueryId = savedQueryId;
        }

        public DBCPlan evaluate(DBRProgressMonitor monitor) throws InvocationTargetException {
            try {
                DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)this.executionContext.getDataSource(), param -> {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    try (DBCSession session = this.executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Explain '" + this.query + "'");){
                        try {
                            this.plan = this.savedQueryId != null && this.planner instanceof DBCSavedQueryPlanner ? ((DBCSavedQueryPlanner)this.planner).readSavedQueryExecutionPlan(session, this.savedQueryId) : this.planner.planQueryExecution(session, this.query);
                        }
                        catch (DBException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                });
            }
            catch (Throwable ex) {
                throw new InvocationTargetException(ex);
            }
            return this.plan;
        }
    }

    private static class PlanViewInfo {
        private SQLPlanViewDescriptor descriptor;
        private SQLPlanViewProvider planViewer;
        private Viewer viewer;

        public PlanViewInfo(SQLPlanViewDescriptor descriptor) {
            this.descriptor = descriptor;
        }
    }

    private class ProgressControl
    extends ProgressPageControl {
        ProgressControl(Composite parent) {
            super(parent, 0x10000000);
        }

        public void fillCustomActions(IContributionManager contributionManager) {
            super.fillCustomActions(contributionManager);
            if (ExplainPlanViewer.this.activeViewInfo != null && ExplainPlanViewer.this.activeViewInfo.viewer != null) {
                ExplainPlanViewer.this.activeViewInfo.planViewer.contributeActions(ExplainPlanViewer.this.activeViewInfo.viewer, contributionManager, ExplainPlanViewer.this.lastQuery, ExplainPlanViewer.this.lastPlan);
            }
            contributionManager.add((IAction)ExplainPlanViewer.this.refreshPlanAction);
        }

        PlanLoadVisualizer createVisualizer() {
            return new PlanLoadVisualizer();
        }

        class PlanLoadVisualizer
        extends ProgressPageControl.ProgressVisualizer<DBCPlan> {
            PlanLoadVisualizer() {
                super((ProgressPageControl)ProgressControl.this);
            }

            public void completeLoading(DBCPlan plan) {
                super.completeLoading((Object)plan);
                if (plan != null) {
                    ExplainPlanViewer.this.visualizePlan(plan);
                }
            }
        }
    }

    private class RefreshPlanAction
    extends Action {
        private RefreshPlanAction() {
            super("Reevaluate", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.REFRESH));
        }

        public void run() {
            ExplainPlanViewer.this.refresh();
        }
    }
}

