/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectPersistAction;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSourceType;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablespace;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;
import org.jkiss.dbeaver.model.struct.DBSObjectState;

public class OracleMaterializedView
extends OracleTableBase
implements OracleSourceObject,
DBSObjectLazy<OracleDataSource> {
    private Object container;
    private String query;
    private boolean updatable;
    private boolean rewriteEnabled;
    private boolean valid;
    private String rewriteCapability;
    private String refreshMode;
    private String refreshMethod;
    private String buildMode;
    private String fastRefreshable;
    private String lastRefreshType;
    private Date lastRefreshDate;
    private String staleness;

    public OracleMaterializedView(OracleSchema schema, String name) {
        super(schema, name, false);
    }

    public OracleMaterializedView(OracleSchema schema, ResultSet dbResult) {
        super(schema, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"MVIEW_NAME"), true);
        this.query = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"QUERY");
        this.valid = "VALID".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COMPILE_STATE"));
        this.container = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONTAINER_NAME");
        this.updatable = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"UPDATABLE", (String)"Y");
        this.rewriteEnabled = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"REWRITE_ENABLED", (String)"Y");
        this.rewriteCapability = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REWRITE_CAPABILITY");
        this.refreshMode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REFRESH_MODE");
        this.refreshMethod = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REFRESH_METHOD");
        this.buildMode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"BUILD_MODE");
        this.fastRefreshable = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FAST_REFRESHABLE");
        this.lastRefreshType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LAST_REFRESH_TYPE");
        this.lastRefreshDate = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_REFRESH_DATE");
        this.staleness = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STALENESS");
    }

    @Property(viewable=true, order=10)
    @LazyProperty(cacheValidator=OracleTablespace.TablespaceReferenceValidator.class)
    public Object getContainer(DBRProgressMonitor monitor) throws DBException {
        return OracleUtils.resolveLazyReference(monitor, this.getSchema(), this.getSchema().tableCache, this, "container");
    }

    @Property(viewable=true, order=14)
    public boolean isUpdatable() {
        return this.updatable;
    }

    @Property(viewable=false, order=15)
    public boolean isRewriteEnabled() {
        return this.rewriteEnabled;
    }

    @Property(viewable=false, order=16)
    public String getRewriteCapability() {
        return this.rewriteCapability;
    }

    @Property(viewable=false, order=17)
    public String getRefreshMode() {
        return this.refreshMode;
    }

    @Property(viewable=true, order=18)
    public String getRefreshMethod() {
        return this.refreshMethod;
    }

    @Property(viewable=false, order=19)
    public String getBuildMode() {
        return this.buildMode;
    }

    @Property(viewable=false, order=20)
    public String getFastRefreshable() {
        return this.fastRefreshable;
    }

    @Property(viewable=true, order=21)
    public String getLastRefreshType() {
        return this.lastRefreshType;
    }

    @Property(viewable=true, order=22)
    public Date getLastRefreshDate() {
        return this.lastRefreshDate;
    }

    @Property(viewable=false, order=23)
    public String getStaleness() {
        return this.staleness;
    }

    @Override
    public OracleSourceType getSourceType() {
        return OracleSourceType.MATERIALIZED_VIEW;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) {
        return this.query;
    }

    public void setObjectDefinitionText(String source) {
        this.query = source;
    }

    @Override
    public DBEPersistAction[] getCompileActions() {
        return new DBEPersistAction[]{new OracleObjectPersistAction(OracleObjectType.MATERIALIZED_VIEW, "Compile materialized view", "ALTER MATERIALIZED VIEW " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " COMPILE")};
    }

    @Override
    @NotNull
    public DBSObjectState getObjectState() {
        return this.valid ? DBSObjectState.NORMAL : DBSObjectState.INVALID;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
        this.valid = OracleUtils.getObjectStatus(monitor, this, OracleObjectType.MATERIALIZED_VIEW);
    }

    public Object getLazyReference(Object propertyId) {
        return this.container;
    }

    public boolean isView() {
        return true;
    }

    @Override
    public OracleTableBase.TableAdditionalInfo getAdditionalInfo() {
        return null;
    }

    @Override
    protected String getTableTypeName() {
        return "MVIEW";
    }

    @Override
    protected String queryTableComment(JDBCSession session) throws SQLException {
        return JDBCUtils.queryString((JDBCSession)session, (String)"SELECT COMMENTS FROM ALL_MVIEW_COMMENTS WHERE OWNER=? AND MVIEW_NAME=?", (Object[])new Object[]{this.getSchema().getName(), this.getName()});
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((OracleSchema)this.getContainer()).constraintCache.clearObjectCache(this);
        return ((OracleSchema)this.getContainer()).mviewCache.refreshObject(monitor, (OracleSchema)this.getContainer(), this);
    }
}

