/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.utils.CommonUtils;

public enum OracleDDLFormat {
    FULL("Full DDL", true, true, true),
    NO_STORAGE("No storage information", false, true, true),
    COMPACT("Compact form", false, false, false);

    private final String title;
    private final boolean showStorage;
    private final boolean showSegments;
    private final boolean showTablespace;
    private static final Log log;

    static {
        log = Log.getLog(OracleDDLFormat.class);
    }

    private OracleDDLFormat(String title, boolean showStorage, boolean showSegments, boolean showTablespace) {
        this.showTablespace = showTablespace;
        this.showSegments = showSegments;
        this.showStorage = showStorage;
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isShowStorage() {
        return this.showStorage;
    }

    public boolean isShowSegments() {
        return this.showSegments;
    }

    public boolean isShowTablespace() {
        return this.showTablespace;
    }

    public static OracleDDLFormat getCurrentFormat(OracleDataSource dataSource) {
        String ddlFormatString = dataSource.getContainer().getPreferenceStore().getString("oracle.ddl.format");
        if (!CommonUtils.isEmpty((String)ddlFormatString)) {
            try {
                return OracleDDLFormat.valueOf(ddlFormatString);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
            }
        }
        return FULL;
    }
}

