/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
"use strict";const trackFocus=({onFocus:t,onBlur:e})=>{let n=document.hasFocus();setInterval(()=>{const o=document.hasFocus();o!==n&&(n=o,o?t():e())},50)
},getActiveFrame=()=>document.getElementById("active-frame"),getPendingFrame=()=>document.getElementById("pending-frame"),defaultCssRules="\n\tbody {\n\t\tbackground-color: var(--vscode-editor-background);\n\t\tcolor: var(--vscode-editor-foreground);\n\t\tfont-family: var(--vscode-font-family);\n\t\tfont-weight: var(--vscode-font-weight);\n\t\tfont-size: var(--vscode-font-size);\n\t\tmargin: 0;\n\t\tpadding: 0 20px;\n\t}\n\n\timg {\n\t\tmax-width: 100%;\n\t\tmax-height: 100%;\n\t}\n\n\ta {\n\t\tcolor: var(--vscode-textLink-foreground);\n\t}\n\n\ta:hover {\n\t\tcolor: var(--vscode-textLink-activeForeground);\n\t}\n\n\ta:focus,\n\tinput:focus,\n\tselect:focus,\n\ttextarea:focus {\n\t\toutline: 1px solid -webkit-focus-ring-color;\n\t\toutline-offset: -1px;\n\t}\n\n\tcode {\n\t\tcolor: var(--vscode-textPreformat-foreground);\n\t}\n\n\tblockquote {\n\t\tbackground: var(--vscode-textBlockQuote-background);\n\t\tborder-color: var(--vscode-textBlockQuote-border);\n\t}\n\n\t::-webkit-scrollbar {\n\t\twidth: 10px;\n\t\theight: 10px;\n\t}\n\n\t::-webkit-scrollbar-thumb {\n\t\tbackground-color: var(--vscode-scrollbarSlider-background);\n\t}\n\t::-webkit-scrollbar-thumb:hover {\n\t\tbackground-color: var(--vscode-scrollbarSlider-hoverBackground);\n\t}\n\t::-webkit-scrollbar-thumb:active {\n\t\tbackground-color: var(--vscode-scrollbarSlider-activeBackground);\n\t}"
;module.exports=function(t){let e,n=!0,o=[],s=!1;const r={initialScrollProgress:void 0},a=(t,e)=>{if(t&&(e&&(e.classList.remove("vscode-light","vscode-dark","vscode-high-contrast"),e.classList.add(r.activeTheme)),r.styles))for(const e of Object.keys(r.styles))t.documentElement.style.setProperty(`--${e}`,r.styles[e])};let i=!1;document.addEventListener("DOMContentLoaded",()=>{document.body&&(t.onMessage("styles",(t,e,n)=>{r.styles=e,r.activeTheme=n;const o=getActiveFrame();o&&o.contentDocument&&a(o.contentDocument,o.contentDocument.body)}),t.onMessage("focus",()=>{const t=getActiveFrame();t&&t.contentWindow.focus()}),t.onMessage("content",(c,d)=>{const l=d.options,u=d.contents,g=(new DOMParser).parseFromString(u,"text/html");if(g.querySelectorAll("a").forEach(t=>{t.title||(t.title=t.getAttribute("href"))}),l.allowScripts){const t=g.createElement("script")
;t.textContent=`\n\t\t\t\t\tconst acquireVsCodeApi = (function() {\n\t\t\t\t\t\tconst originalPostMessage = window.parent.postMessage.bind(window.parent);\n\t\t\t\t\t\tlet acquired = false;\n\n\t\t\t\t\t\tlet state = ${d.state?`JSON.parse(${JSON.stringify(d.state)})`:void 0};\n\n\t\t\t\t\t\treturn () => {\n\t\t\t\t\t\t\tif (acquired) {\n\t\t\t\t\t\t\t\tthrow new Error('An instance of the VS Code API has already been acquired');\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tacquired = true;\n\t\t\t\t\t\t\treturn Object.freeze({\n\t\t\t\t\t\t\t\tpostMessage: function(msg) {\n\t\t\t\t\t\t\t\t\treturn originalPostMessage({ command: 'onmessage', data: msg }, '*');\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\tsetState: function(newState) {\n\t\t\t\t\t\t\t\t\tstate = newState;\n\t\t\t\t\t\t\t\t\toriginalPostMessage({ command: 'do-update-state', data: JSON.stringify(newState) }, '*');\n\t\t\t\t\t\t\t\t\treturn newState;\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\tgetState: function() {\n\t\t\t\t\t\t\t\t\treturn state;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t};\n\t\t\t\t\t})();\n\t\t\t\t\tdelete window.parent;\n\t\t\t\t\tdelete window.top;\n\t\t\t\t\tdelete window.frameElement;\n\t\t\t\t`,
g.head.prepend(t)}const m=g.createElement("style");m.id="_defaultStyles",m.innerHTML=defaultCssRules,g.head.prepend(m),a(g,g.body);const v=getActiveFrame(),f=n;let b;if(n)n=!1,b=((t,e)=>{isNaN(r.initialScrollProgress)||0===e.scrollY&&e.scroll(0,t.clientHeight*r.initialScrollProgress)});else{const t=v&&v.contentDocument&&v.contentDocument.body?v.contentWindow.scrollY:0;b=((e,n)=>{0===n.scrollY&&n.scroll(0,t)})}const h=getPendingFrame();h&&(h.setAttribute("id",""),document.body.removeChild(h)),f||(o=[]);const w=document.createElement("iframe");w.setAttribute("id","pending-frame"),w.setAttribute("frameborder","0"),w.setAttribute("sandbox",l.allowScripts?"allow-scripts allow-forms allow-same-origin":"allow-same-origin"),w.style.cssText="display: block; margin: 0; overflow: hidden; position: absolute; width: 100%; height: 100%; visibility: hidden",document.body.appendChild(w),w.contentDocument.open("text/html","replace"),w.contentWindow.addEventListener("keydown",e=>{t.postMessage("did-keydown",{key:e.key,
keyCode:e.keyCode,code:e.code,shiftKey:e.shiftKey,altKey:e.altKey,ctrlKey:e.ctrlKey,metaKey:e.metaKey,repeat:e.repeat})}),w.contentWindow.addEventListener("DOMContentLoaded",t=>{const e=t.target?t.target:void 0;e&&a(e,e.body)}),w.contentWindow.onbeforeunload=(()=>s?(t.postMessage("do-reload"),!1):(console.log("prevented webview navigation"),!1));const p=(e,n)=>{e&&e.body&&b(e.body,n);const s=getPendingFrame();if(s&&s.contentDocument&&s.contentDocument===e){const e=getActiveFrame();e&&document.body.removeChild(e),a(s.contentDocument,s.contentDocument.body),s.setAttribute("id","active-frame"),s.style.visibility="visible",s.contentWindow.focus(),n.addEventListener("scroll",e=>{if(!e.target||!e.target.body)return;if(i)return;const n=e.currentTarget.scrollY/e.target.body.clientHeight;isNaN(n)||(i=!0,window.requestAnimationFrame(()=>{try{t.postMessage("did-scroll",n)}catch(t){}i=!1}))}),o.forEach(t=>{n.postMessage(t,"*")}),o=[]}};clearTimeout(e),e=void 0,e=setTimeout(()=>{clearTimeout(e),e=void 0,
p(w.contentDocument,w.contentWindow)},200),w.contentWindow.addEventListener("load",function(t){e&&(clearTimeout(e),e=void 0,p(t.target,this))}),w.contentWindow.addEventListener("click",e=>{if(!e||!e.view||!e.view.document)return;let n=e.view.document.getElementsByTagName("base")[0],o=e.target;for(;o;){if(o.tagName&&"a"===o.tagName.toLowerCase()&&o.href){if("#"===o.getAttribute("href"))e.view.scrollTo(0,0);else if(o.hash&&(o.getAttribute("href")===o.hash||n&&o.href.indexOf(n.href)>=0)){let t=e.view.document.getElementById(o.hash.substr(1,o.hash.length-1));t&&t.scrollIntoView()}else t.postMessage("did-click-link",o.href.baseVal||o.href);e.preventDefault();break}o=o.parentNode}}),w.contentDocument.write("<!DOCTYPE html>"),w.contentDocument.write(g.documentElement.innerHTML),w.contentDocument.close(),t.postMessage("did-set-content",void 0)}),t.onMessage("message",(t,e)=>{if(!getPendingFrame()){const t=getActiveFrame();if(t)return void t.contentWindow.postMessage(e,"*")}o.push(e)}),
t.onMessage("initial-scroll-position",(t,e)=>{r.initialScrollProgress=e}),t.onMessage("devtools-opened",()=>{s=!0}),trackFocus({onFocus:()=>t.postMessage("did-focus"),onBlur:()=>t.postMessage("did-blur")}),window.onmessage=(e=>{t.postMessage(e.data.command,e.data.data)}),t.postMessage("webview-ready",process.pid))})};
//# sourceMappingURL=https://ticino.blob.core.windows.net/sourcemaps/553cfb2c2205db5f15f3ee8395bbd5cf066d357d/core/vs/workbench/contrib/webview/browser/pre/main.js.map
