/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class StringHelper {
    public static String capitalize(String string) {
        StringBuilder sb = new StringBuilder();
        sb.append(string.substring(0, 1).toUpperCase(Locale.US)).append(string.substring(1));
        return sb.toString();
    }

    public static String combineAsCamelCase(Iterable<String> stringList) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String str : stringList) {
            if (first) {
                sb.append(str);
                first = false;
                continue;
            }
            sb.append(StringHelper.capitalize(str));
        }
        return sb.toString();
    }

    public static List<String> toStrings(Object ... objects) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object path : objects) {
            if (path instanceof String) {
                builder.add((Object)((String)path));
                continue;
            }
            if (path instanceof Collection) {
                Collection pathCollection = (Collection)path;
                for (Object item : pathCollection) {
                    if (item instanceof String) {
                        builder.add((Object)((String)item));
                        continue;
                    }
                    builder.add((Object)path.toString());
                }
                continue;
            }
            builder.add((Object)path.toString());
        }
        return builder.build();
    }

    public static void appendCamelCase(StringBuilder sb, String word) {
        if (word != null) {
            if (sb.length() == 0) {
                sb.append(word);
            } else {
                sb.append(StringHelper.capitalize(word));
            }
        }
    }

    public static List<String> tokenizeCommand(String commandLine) {
        Iterable split = Splitter.on((char)' ').trimResults().split((CharSequence)commandLine);
        ArrayList command = Lists.newArrayList();
        char quote = '\u0000';
        StringBuilder quotedText = new StringBuilder();
        for (String arg : split) {
            if (quote == '\u0000') {
                quote = StringHelper.findFirstQuoteChar(arg, "'\"");
            }
            if (quote != '\u0000') {
                if (quotedText.length() > 0) {
                    quotedText.append(" ");
                }
                quotedText.append(arg);
                if (arg.isEmpty() || arg.charAt(arg.length() - 1) != quote || arg.length() != 1 && arg.charAt(arg.length() - 2) == '\\') continue;
                quote = '\u0000';
                command.add(quotedText.toString());
                quotedText = new StringBuilder();
                continue;
            }
            if (arg.isEmpty()) continue;
            command.add(arg);
        }
        if (quote != '\u0000') {
            throw new RuntimeException("Unable to parse command string: " + commandLine + "\n" + "Missing " + quote + ".");
        }
        return command;
    }

    private static char findFirstQuoteChar(String str, CharSequence quote) {
        int firstIndex = -1;
        char firstQuote = '\u0000';
        for (int i = 0; i < quote.length(); ++i) {
            int index = str.indexOf(quote.charAt(i));
            if (index == -1 || firstIndex != -1 && index >= firstIndex) continue;
            firstIndex = index;
            firstQuote = quote.charAt(i);
        }
        return firstQuote;
    }
}

