/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.collect.Iterables;
import com.google.errorprone.refaster.AutoValue_UFreeIdent;
import com.google.errorprone.refaster.Bindings;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.StringName;
import com.google.errorprone.refaster.UIdent;
import com.google.errorprone.refaster.ULocalVarIdent;
import com.google.errorprone.refaster.Unifier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Names;
import javax.annotation.Nullable;

@AutoValue
public abstract class UFreeIdent
extends UIdent {
    public static UFreeIdent create(CharSequence identifier) {
        return new AutoValue_UFreeIdent(StringName.of(identifier));
    }

    @Override
    public abstract StringName getName();

    public Key key() {
        return new Key(this.getName());
    }

    @Override
    public JCTree.JCExpression inline(Inliner inliner) {
        return inliner.getBinding(this.key());
    }

    private static boolean trueOrNull(@Nullable Boolean condition) {
        return condition == null || condition != false;
    }

    @Override
    public Choice<Unifier> visitIdentifier(IdentifierTree node, Unifier unifier) {
        Names names = Names.instance(unifier.getContext());
        return node.getName().equals(names._super) ? Choice.none() : this.defaultAction((Tree)node, unifier);
    }

    @Override
    protected Choice<Unifier> defaultAction(Tree target, final Unifier unifier) {
        if (target instanceof JCTree.JCExpression) {
            JCTree.JCExpression expression = (JCTree.JCExpression)target;
            JCTree.JCExpression currentBinding = unifier.getBinding(this.key());
            boolean isGood = UFreeIdent.trueOrNull((Boolean)new TreeScanner<Boolean, Void>(){

                @Override
                public Boolean reduce(@Nullable Boolean left, @Nullable Boolean right) {
                    return UFreeIdent.trueOrNull(left) && UFreeIdent.trueOrNull(right);
                }

                @Override
                public Boolean visitIdentifier(IdentifierTree ident, Void v) {
                    Symbol identSym = ASTHelpers.getSymbol((Tree)ident);
                    for (ULocalVarIdent.Key key : Iterables.filter((Iterable)unifier.getBindings().keySet(), ULocalVarIdent.Key.class)) {
                        if (identSym != unifier.getBinding(key).getSymbol()) continue;
                        return false;
                    }
                    return true;
                }
            }.scan(expression, null));
            if (!isGood) {
                return Choice.none();
            }
            if (currentBinding == null) {
                unifier.putBinding(this.key(), expression);
                return Choice.of(unifier);
            }
            if (currentBinding.toString().equals(expression.toString())) {
                return Choice.of(unifier);
            }
        }
        return Choice.none();
    }

    static class Key
    extends Bindings.Key<JCTree.JCExpression> {
        Key(CharSequence name) {
            super(name.toString());
        }
    }
}

