/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Ice;

import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.MarshalException;
import com.zeroc.Ice.OptionalFormat;
import com.zeroc.Ice.OutputStream;
import java.io.Serializable;
import java.util.Optional;

public enum LogMessageType implements Serializable
{
    PrintMessage(0),
    TraceMessage(1),
    WarningMessage(2),
    ErrorMessage(3);

    private final int _value;

    public int value() {
        return this._value;
    }

    public static LogMessageType valueOf(int v) {
        switch (v) {
            case 0: {
                return PrintMessage;
            }
            case 1: {
                return TraceMessage;
            }
            case 2: {
                return WarningMessage;
            }
            case 3: {
                return ErrorMessage;
            }
        }
        return null;
    }

    private LogMessageType(int v) {
        this._value = v;
    }

    public void ice_write(OutputStream ostr) {
        ostr.writeEnum(this._value, 3);
    }

    public static void ice_write(OutputStream ostr, LogMessageType v) {
        if (v == null) {
            ostr.writeEnum(PrintMessage.value(), 3);
        } else {
            ostr.writeEnum(v.value(), 3);
        }
    }

    public static LogMessageType ice_read(InputStream istr) {
        int v = istr.readEnum(3);
        return LogMessageType.validate(v);
    }

    public static void ice_write(OutputStream ostr, int tag, Optional<LogMessageType> v) {
        if (v != null && v.isPresent()) {
            LogMessageType.ice_write(ostr, tag, v.get());
        }
    }

    public static void ice_write(OutputStream ostr, int tag, LogMessageType v) {
        if (ostr.writeOptional(tag, OptionalFormat.Size)) {
            LogMessageType.ice_write(ostr, v);
        }
    }

    public static Optional<LogMessageType> ice_read(InputStream istr, int tag) {
        if (istr.readOptional(tag, OptionalFormat.Size)) {
            return Optional.of(LogMessageType.ice_read(istr));
        }
        return Optional.empty();
    }

    private static LogMessageType validate(int v) {
        LogMessageType e = LogMessageType.valueOf(v);
        if (e == null) {
            throw new MarshalException("enumerator value " + v + " is out of range");
        }
        return e;
    }
}

