/// <reference types="platform" />
declare enum OperatingSystem {
    ANDROID = "OperatingSystem.ANDROID",
    IOS = "OperatingSystem.IOS",
    LINUX = "OperatingSystem.LINUX",
    MAC = "OperatingSystem.MAC",
    WINDOWS = "OperatingSystem.WINDOWS"
}
export interface OS {
    architecture: string | number;
    family: string;
    version: string;
}
declare class Runtime {
    static getPlatform(): Platform;
    static getOSFamily(): OperatingSystem;
    static getBrowserName(): string;
    static getBrowserVersion(): {
        major: number;
        minor: number;
    };
    static getUserAgent(): string;
    static isWebappSupportedBrowser(): boolean;
    static getOS(): OS;
    static isChrome(): boolean;
    static isEdge(): boolean;
    static isFirefox(): boolean;
    static isInternetExplorer(): boolean;
    static isOpera(): boolean;
    static isSafari(): boolean;
    static isDesktopOS(): boolean;
    static isElectron(): boolean;
    static isDesktopApp(): boolean;
    static isFranz(): boolean;
    static isMacOS(): boolean;
    static isWindows(): boolean;
    static isLinux(): boolean;
    static isMobileOS(): boolean;
    static isAndroid(): boolean;
    static isIOS(): boolean;
}
export { OperatingSystem, Runtime };
