/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.DarculaColors;
import com.intellij.ui.Gray;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.roots.FilePathClipper;
import com.intellij.ui.roots.IconActionComponent;
import com.intellij.ui.roots.ResizingWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Stroke;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;

public abstract class ContentRootPanel
extends JPanel {
    private static final Color EXCLUDED_COLOR = new JBColor(new Color(10038784), DarculaColors.RED);
    private static final Color SELECTED_HEADER_COLOR = new JBColor(() -> UIUtil.isUnderDarcula() ? UIUtil.getPanelBackground().darker() : new Color(14611199));
    private static final Color HEADER_COLOR = new JBColor(new Color(0xF5F5F5), (Color)Gray._82);
    private static final Color SELECTED_CONTENT_COLOR = new Color(0xF0F9FF);
    private static final Color CONTENT_COLOR = new JBColor(() -> UIUtil.isUnderDarcula() ? UIUtil.getPanelBackground() : Gray._255);
    private static final Color UNSELECTED_TEXT_COLOR = Gray._51;
    protected final ActionCallback myCallback;
    private final List<? extends ModuleSourceRootEditHandler<?>> myModuleSourceRootEditHandlers;
    private JComponent myHeader;
    private JComponent myBottom;
    private final Map<JComponent, Color> myComponentToForegroundMap = new HashMap<JComponent, Color>();

    public ContentRootPanel(ActionCallback callback2, List<? extends ModuleSourceRootEditHandler<?>> moduleSourceRootEditHandlers) {
        super(new GridBagLayout());
        this.myCallback = callback2;
        this.myModuleSourceRootEditHandlers = moduleSourceRootEditHandlers;
    }

    @Nullable
    protected abstract ContentEntry getContentEntry();

    public void initUI() {
        this.myHeader = this.createHeader();
        this.myHeader.setBorder(new EmptyBorder(0, 8, 0, 0));
        this.add((Component)this.myHeader, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsBottom((int)8), 0, 0));
        this.addFolderGroupComponents();
        this.myBottom = new JPanel(new BorderLayout());
        this.myBottom.add(Box.createVerticalStrut(3), "North");
        this.add((Component)this.myBottom, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.setSelected(false);
    }

    protected void addFolderGroupComponents() {
        SourceFolder[] sourceFolders = this.getContentEntry().getSourceFolders();
        MultiMap folderByType = new MultiMap();
        for (SourceFolder folder : sourceFolders) {
            if (folder.isSynthetic()) continue;
            folderByType.putValue((Object)folder.getRootType(), (Object)folder);
        }
        JBInsets insets = JBUI.insetsBottom((int)10);
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, (Insets)insets, 0, 0);
        for (ModuleSourceRootEditHandler<?> editor : this.myModuleSourceRootEditHandlers) {
            Collection folders = folderByType.get(editor.getRootType());
            if (folders.isEmpty()) continue;
            ContentFolder[] foldersArray = folders.toArray(new ContentFolder[0]);
            JComponent sourcesComponent = this.createFolderGroupComponent(editor.getRootsGroupTitle(), foldersArray, editor.getRootsGroupColor(), editor);
            this.add((Component)sourcesComponent, constraints);
        }
        ExcludeFolder[] excluded = this.getContentEntry().getExcludeFolders();
        if (excluded.length > 0) {
            JComponent excludedComponent = this.createFolderGroupComponent(ProjectBundle.message((String)"module.paths.excluded.group", (Object[])new Object[0]), (ContentFolder[])excluded, EXCLUDED_COLOR, null);
            this.add((Component)excludedComponent, constraints);
        }
    }

    private JComponent createHeader() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        JLabel headerLabel = new JLabel(ContentRootPanel.toDisplayPath(this.getContentEntry().getUrl()));
        headerLabel.setFont(headerLabel.getFont().deriveFont(1));
        headerLabel.setOpaque(false);
        if (this.getContentEntry().getFile() == null) {
            headerLabel.setForeground((Color)JBColor.RED);
        }
        IconActionComponent deleteIconComponent = new IconActionComponent(AllIcons.Modules.DeleteContentRoot, AllIcons.Modules.DeleteContentRootRollover, ProjectBundle.message((String)"module.paths.remove.content.tooltip", (Object[])new Object[0]), () -> this.myCallback.deleteContentEntry());
        ResizingWrapper wrapper2 = new ResizingWrapper((JComponent)headerLabel);
        panel2.add((Component)wrapper2, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.insetsLeft((int)2), 0, 0));
        panel2.add((Component)deleteIconComponent, new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 13, 0, (Insets)JBUI.insetsRight((int)5), 0, 0));
        FilePathClipper.install((JLabel)headerLabel, (JComponent)wrapper2);
        return panel2;
    }

    protected JComponent createFolderGroupComponent(String title, ContentFolder[] folders, Color foregroundColor, @Nullable ModuleSourceRootEditHandler<?> editor) {
        JPanel panel2 = new JPanel((LayoutManager)new GridLayoutManager(folders.length, 3, (Insets)JBUI.insets((int)1, (int)17, (int)0, (int)5), 0, 1));
        panel2.setOpaque(false);
        for (int idx = 0; idx < folders.length; ++idx) {
            JComponent additionalComponent;
            ContentFolder folder = folders[idx];
            int verticalPolicy = idx == folders.length - 1 ? 2 : 0;
            panel2.add((Component)this.createFolderComponent(folder, foregroundColor, editor), new GridConstraints(idx, 0, 1, 1, 9, 1, 3, verticalPolicy, null, null, null));
            int column = 1;
            int colspan = 2;
            if (editor != null && (additionalComponent = this.createRootPropertiesEditor(editor, (SourceFolder)folder)) != null) {
                panel2.add((Component)additionalComponent, new GridConstraints(idx, column++, 1, 1, 0, 0, 0, verticalPolicy, null, null, null));
                colspan = 1;
            }
            panel2.add((Component)this.createFolderDeleteComponent(folder, editor), new GridConstraints(idx, column, 1, colspan, 4, 0, 0, verticalPolicy, null, null, null));
        }
        JLabel titleLabel = new JLabel(title);
        Font labelFont = UIUtil.getLabelFont();
        titleLabel.setFont(labelFont.deriveFont(1));
        titleLabel.setOpaque(false);
        titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.registerTextComponent(titleLabel, foregroundColor);
        JPanel groupPanel = new JPanel(new BorderLayout());
        groupPanel.setOpaque(false);
        groupPanel.add((Component)titleLabel, "North");
        groupPanel.add((Component)panel2, "Center");
        return groupPanel;
    }

    @Nullable
    protected JComponent createRootPropertiesEditor(ModuleSourceRootEditHandler<?> editor, SourceFolder folder) {
        return null;
    }

    private void registerTextComponent(JComponent component, Color foreground) {
        component.setForeground(foreground);
        this.myComponentToForegroundMap.put(component, foreground);
    }

    private <P extends JpsElement> JComponent createFolderComponent(final ContentFolder folder, Color foreground, ModuleSourceRootEditHandler<P> editor) {
        String properties;
        VirtualFile folderFile = folder.getFile();
        VirtualFile contentEntryFile = this.getContentEntry().getFile();
        String string = properties = folder instanceof SourceFolder ? StringUtil.notNullize((String)editor.getPropertiesString(((SourceFolder)folder).getJpsElement().getProperties())) : "";
        if (folderFile != null && contentEntryFile != null) {
            String path = folderFile.equals(contentEntryFile) ? "." : VfsUtilCore.getRelativePath((VirtualFile)folderFile, (VirtualFile)contentEntryFile, (char)File.separatorChar);
            HoverHyperlinkLabel hyperlinkLabel = new HoverHyperlinkLabel(path + properties, foreground);
            hyperlinkLabel.setMinimumSize(new Dimension(0, 0));
            hyperlinkLabel.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    ContentRootPanel.this.myCallback.navigateFolder(ContentRootPanel.this.getContentEntry(), folder);
                }
            });
            this.registerTextComponent(hyperlinkLabel, foreground);
            return new UnderlinedPathLabel(hyperlinkLabel);
        }
        String path = ContentRootPanel.toRelativeDisplayPath(folder.getUrl(), this.getContentEntry().getUrl());
        JLabel pathLabel = new JLabel(path + properties);
        pathLabel.setOpaque(false);
        pathLabel.setForeground((Color)JBColor.RED);
        return new UnderlinedPathLabel(pathLabel);
    }

    private JComponent createFolderDeleteComponent(ContentFolder folder, @Nullable ModuleSourceRootEditHandler<?> editor) {
        String tooltipText = folder.getFile() != null && this.getContentEntry().getFile() != null ? (editor != null ? editor.getUnmarkRootButtonText() : (folder instanceof ExcludeFolder ? ProjectBundle.message((String)"module.paths.include.excluded.tooltip", (Object[])new Object[0]) : null)) : ProjectBundle.message((String)"module.paths.remove.tooltip", (Object[])new Object[0]);
        return new IconActionComponent(AllIcons.Modules.DeleteContentFolder, AllIcons.Modules.DeleteContentFolderRollover, tooltipText, () -> this.myCallback.deleteContentFolder(this.getContentEntry(), folder));
    }

    public boolean isExcludedOrUnderExcludedDirectory(VirtualFile file2) {
        ContentEntry contentEntry = this.getContentEntry();
        if (contentEntry == null) {
            return false;
        }
        for (VirtualFile excludedDir : contentEntry.getExcludeFolderFiles()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)excludedDir, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    protected static String toRelativeDisplayPath(String url, String ancestorUrl) {
        if (!StringUtil.endsWithChar((CharSequence)ancestorUrl, (char)'/')) {
            ancestorUrl = ancestorUrl + "/";
        }
        if (url.startsWith(ancestorUrl)) {
            return url.substring(ancestorUrl.length()).replace('/', File.separatorChar);
        }
        return ContentRootPanel.toDisplayPath(url);
    }

    private static String toDisplayPath(String url) {
        return VirtualFileManager.extractPath((String)url).replace('/', File.separatorChar);
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.myHeader.setBackground(SELECTED_HEADER_COLOR);
            this.setBackground(UIUtil.isUnderDarcula() ? UIUtil.getPanelBackground() : SELECTED_CONTENT_COLOR);
            this.myBottom.setBackground(UIUtil.isUnderDarcula() ? UIUtil.getPanelBackground() : SELECTED_HEADER_COLOR);
            for (JComponent component : this.myComponentToForegroundMap.keySet()) {
                component.setForeground(this.myComponentToForegroundMap.get(component));
            }
        } else {
            this.myHeader.setBackground(HEADER_COLOR);
            this.setBackground(CONTENT_COLOR);
            this.myBottom.setBackground(UIUtil.isUnderDarcula() ? UIUtil.getPanelBackground() : HEADER_COLOR);
            for (JComponent component : this.myComponentToForegroundMap.keySet()) {
                component.setForeground(UNSELECTED_TEXT_COLOR);
            }
        }
    }

    private static class UnderlinedPathLabel
    extends ResizingWrapper {
        private static final float[] DASH = new float[]{0.0f, 2.0f, 0.0f, 2.0f};
        private static final Color DASH_LINE_COLOR = new JBColor((Color)Gray._201, (Color)Gray._100);

        UnderlinedPathLabel(JLabel wrappedComponent) {
            super((JComponent)wrappedComponent);
            FilePathClipper.install((JLabel)wrappedComponent, (JComponent)((Object)this));
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int startX = this.myWrappedComponent.getWidth();
            int endX = this.getWidth();
            if (endX > startX) {
                FontMetrics fontMetrics = this.myWrappedComponent.getFontMetrics(this.myWrappedComponent.getFont());
                int y = fontMetrics.getMaxAscent();
                Color savedColor = g.getColor();
                g.setColor(DASH_LINE_COLOR);
                this.drawDottedLine((Graphics2D)g, startX, y, endX, y);
                g.setColor(savedColor);
            }
        }

        private void drawDottedLine(Graphics2D g, int x1, int y1, int x2, int y2) {
            Stroke saved = g.getStroke();
            if (!SystemInfo.isMac && !UIUtil.isUnderDarcula()) {
                g.setStroke(new BasicStroke(1.0f, 1, 1, 0.0f, DASH, y1 % 2));
            }
            if (UIUtil.isUnderDarcula()) {
                UIUtil.drawDottedLine((Graphics2D)g, (int)x1, (int)y1, (int)x2, (int)y2, null, (Color)g.getColor());
            } else {
                UIUtil.drawLine((Graphics)g, (int)x1, (int)y1, (int)x2, (int)y2);
            }
            g.setStroke(saved);
        }
    }

    public static interface ActionCallback {
        public void deleteContentEntry();

        public void deleteContentFolder(ContentEntry var1, ContentFolder var2);

        public void navigateFolder(ContentEntry var1, ContentFolder var2);

        public void onSourceRootPropertiesChanged(@NotNull SourceFolder var1);
    }
}

