/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatChangedTextUtil {
    public static final Key<CharSequence> TEST_REVISION_CONTENT = Key.create((String)"test.revision.content");
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.FormatChangedTextUtil");

    protected FormatChangedTextUtil() {
    }

    @NotNull
    public static FormatChangedTextUtil getInstance() {
        FormatChangedTextUtil formatChangedTextUtil = (FormatChangedTextUtil)ServiceManager.getService(FormatChangedTextUtil.class);
        if (formatChangedTextUtil == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(0);
        }
        return formatChangedTextUtil;
    }

    public static boolean hasChanges(@NotNull PsiFile file2) {
        if (file2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(1);
        }
        Project project = file2.getProject();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null) {
            Change change = ChangeListManager.getInstance((Project)project).getChange(virtualFile);
            return change != null;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull PsiDirectory directory) {
        if (directory == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(2);
        }
        return FormatChangedTextUtil.hasChanges(directory.getVirtualFile(), directory.getProject());
    }

    public static boolean hasChanges(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(3);
        }
        if (project == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(4);
        }
        Collection changes2 = ChangeListManager.getInstance((Project)project).getChangesIn(file2);
        for (Change change : changes2) {
            if (change.getType() != Change.Type.NEW && change.getType() != Change.Type.MODIFICATION) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull VirtualFile[] files2, @NotNull Project project) {
        if (files2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(5);
        }
        if (project == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(6);
        }
        for (VirtualFile file2 : files2) {
            if (!FormatChangedTextUtil.hasChanges(file2, project)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull Module module) {
        if (module == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(7);
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile root : rootManager.getSourceRoots()) {
            if (!FormatChangedTextUtil.hasChanges(root, module.getProject())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasChanges(@NotNull Project project) {
        if (project == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(8);
        }
        ModifiableModuleModel moduleModel = (ModifiableModuleModel)ReadAction.compute(() -> ModuleManager.getInstance((Project)project).getModifiableModel());
        try {
            for (Module module : moduleModel.getModules()) {
                if (!FormatChangedTextUtil.hasChanges(module)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            moduleModel.dispose();
        }
    }

    @NotNull
    public static List<PsiFile> getChangedFilesFromDirs(@NotNull Project project, @NotNull List<? extends PsiDirectory> dirs) {
        if (project == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(9);
        }
        if (dirs == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(10);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        ArrayList changes2 = ContainerUtil.newArrayList();
        for (PsiDirectory psiDirectory : dirs) {
            changes2.addAll(changeListManager.getChangesIn(psiDirectory.getVirtualFile()));
        }
        List<PsiFile> list2 = FormatChangedTextUtil.getChangedFiles(project, changes2);
        if (list2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @NotNull
    public static List<PsiFile> getChangedFiles(final @NotNull Project project, @NotNull Collection<? extends Change> changes2) {
        if (project == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(12);
        }
        if (changes2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(13);
        }
        Function<Change, PsiFile> changeToPsiFileMapper = new Function<Change, PsiFile>(){
            private final PsiManager myPsiManager;
            {
                this.myPsiManager = PsiManager.getInstance((Project)project);
            }

            public PsiFile fun(Change change) {
                VirtualFile vFile = change.getVirtualFile();
                return vFile != null ? this.myPsiManager.findFile(vFile) : null;
            }
        };
        List list2 = ContainerUtil.mapNotNull(changes2, (Function)changeToPsiFileMapper);
        if (list2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @NotNull
    public List<TextRange> getChangedTextRanges(@NotNull Project project, @NotNull PsiFile file2) {
        if (project == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(16);
        }
        List list2 = ContainerUtil.emptyList();
        if (list2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(17);
        }
        return list2;
    }

    public int calculateChangedLinesNumber(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        if (document == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(18);
        }
        if (contentFromVcs == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(19);
        }
        return -1;
    }

    public boolean isChangeNotTrackedForFile(@NotNull Project project, @NotNull PsiFile file2) {
        if (project == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(20);
        }
        if (file2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(21);
        }
        return false;
    }

    @Nullable
    public ChangedRangesInfo getChangedRangesInfo(@NotNull PsiFile file2) {
        if (file2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(22);
        }
        return null;
    }

    @NotNull
    public <T extends PsiElement> List<T> getChangedElements(@NotNull Project project, @NotNull Change[] changes2, @NotNull Convertor<? super VirtualFile, ? extends List<T>> elementsConvertor) {
        if (project == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(23);
        }
        if (changes2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(24);
        }
        if (elementsConvertor == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(25);
        }
        List list2 = Arrays.stream(changes2).map(Change::getVirtualFile).filter(Objects::nonNull).flatMap(file2 -> ((List)elementsConvertor.convert(file2)).stream()).filter(Objects::nonNull).collect(Collectors.toList());
        if (list2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(26);
        }
        return list2;
    }

    public void runHeavyModificationTask(@NotNull Project project, @NotNull Document document, @NotNull Runnable o) {
        if (project == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(27);
        }
        if (document == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(28);
        }
        if (o == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(29);
        }
        o.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/FormatChangedTextUtil";
                break;
            }
            case 1: 
            case 3: 
            case 16: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 20: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentFromVcs";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConvertor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/FormatChangedTextUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedFilesFromDirs";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedFiles";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedTextRanges";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasChanges";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChangedFilesFromDirs";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getChangedFiles";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getChangedTextRanges";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "calculateChangedLinesNumber";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isChangeNotTrackedForFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRangesInfo";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getChangedElements";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "runHeavyModificationTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

