/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages.serviceMessages;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import jetbrains.buildServer.ComparisonFailureData;
import jetbrains.buildServer.ComparisonFailureUtil;
import jetbrains.buildServer.messages.serviceMessages.BaseTestMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestFailed
extends BaseTestMessage {
    TestFailed() {
    }

    public TestFailed(@NotNull String name, @Nullable Throwable exception) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/TestFailed.<init> must not be null");
        }
        super("testFailed", name, TestFailed.createMap(exception));
    }

    private static Map<String, String> createMap(Throwable exception) {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        if (exception == null) {
            return res;
        }
        ComparisonFailureData cfd = ComparisonFailureUtil.extractComparisonFailure((Throwable)exception);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        exception.printStackTrace(new PrintStream(out));
        String stacktrace = out.toString();
        res.put("message", exception.getMessage());
        res.put("details", stacktrace);
        if (cfd != null) {
            res.put("actual", cfd.getActual());
            res.put("expected", cfd.getExpected());
            res.put("type", "comparisonFailure");
        }
        return res;
    }

    public boolean isComparisonFailure() {
        return "comparisonFailure".equals(this.getAttributeValue("type"));
    }

    public String getFailureMessage() {
        return this.getAttributeValue("message");
    }

    public String getStacktrace() {
        return this.getAttributeValue("details");
    }

    public String getExpected() {
        return this.getAttributeValue("expected");
    }

    public String getActual() {
        return this.getAttributeValue("actual");
    }

    @Override
    public void visit(@NotNull ServiceMessageVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/TestFailed.visit must not be null");
        }
        visitor.visitTestFailed(this);
    }
}

