/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.filter;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.filter.DecodeResult;
import org.sejda.sambox.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JBIG2Filter
extends Filter {
    private static final Logger LOG = LoggerFactory.getLogger(JBIG2Filter.class);
    private static boolean levigoLogged = false;

    JBIG2Filter() {
    }

    private static synchronized void logLevigoDonated() {
        if (!levigoLogged) {
            LOG.info("The Levigo JBIG2 plugin has been donated to the Apache Foundation");
            LOG.info("and an improved version is available for download at https://pdfbox.apache.org/download.cgi");
            levigoLogged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        block13: {
            ImageReader reader = JBIG2Filter.findImageReader("JBIG2", "jbig2-imageio is not installed");
            if (reader.getClass().getName().contains("levigo")) {
                JBIG2Filter.logLevigoDonated();
            }
            DecodeResult result = new DecodeResult(new COSDictionary());
            result.getParameters().addAll(parameters);
            int bits = parameters.getInt(COSName.BITS_PER_COMPONENT, 1);
            COSDictionary params = this.getDecodeParams(parameters, index);
            COSStream globals = null;
            if (params != null) {
                globals = (COSStream)params.getDictionaryObject(COSName.JBIG2_GLOBALS);
            }
            ImageInputStream iis = null;
            try {
                DataBuffer dBuf;
                BufferedImage image;
                if (globals != null) {
                    iis = ImageIO.createImageInputStream(new SequenceInputStream(globals.getUnfilteredStream(), encoded));
                    reader.setInput(iis);
                } else {
                    iis = ImageIO.createImageInputStream(encoded);
                    reader.setInput(iis);
                }
                try {
                    image = reader.read(0, reader.getDefaultReadParam());
                }
                catch (Exception e) {
                    throw new IOException("Could not read JBIG2 image", e);
                }
                if (image.getColorModel().getPixelSize() != bits) {
                    if (bits != 1) {
                        LOG.warn("Attempting to handle a JBIG2 with more than 1-bit depth");
                    }
                    BufferedImage packedImage = new BufferedImage(image.getWidth(), image.getHeight(), 12);
                    Graphics graphics = packedImage.getGraphics();
                    graphics.drawImage(image, 0, 0, null);
                    graphics.dispose();
                    image = packedImage;
                }
                if ((dBuf = image.getData().getDataBuffer()).getDataType() == 0) {
                    decoded.write(((DataBufferByte)dBuf).getData());
                    break block13;
                }
                throw new IOException("Unexpected image buffer type");
            }
            finally {
                if (iis != null) {
                    iis.close();
                }
                reader.dispose();
            }
        }
        return new DecodeResult(parameters);
    }

    @Override
    public void encode(InputStream input, OutputStream encoded, COSDictionary parameters) {
        throw new UnsupportedOperationException("JBIG2 encoding not implemented");
    }
}

