/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sejda.conversion.PdfFileSourceAdapter;
import org.sejda.conversion.PdfInputFilesSource;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.exception.SejdaRuntimeException;
import org.sejda.model.input.PdfFileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractPdfInputFilesSource
implements PdfInputFilesSource {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPdfInputFilesSource.class);

    AbstractPdfInputFilesSource() {
    }

    @Override
    public List<PdfFileSource> getInputFiles(File file) {
        List<String> filenames = this.parseFileNames(file);
        LOG.trace("Input files: '" + StringUtils.join(filenames, (String)"', '") + "'");
        try {
            return PdfFileSourceAdapter.fromStrings(filenames);
        }
        catch (SejdaRuntimeException e) {
            throw new ConversionException("Invalid filename found: " + e.getMessage(), e);
        }
    }

    protected abstract List<String> parseFileNames(File var1);
}

