/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.openide.filesystems.FileObject;

public class DeleteTransformer
extends RefactoringVisitor {
    private final HashSet<ElementHandle<ExecutableElement>> allMethods;
    private final Collection<? extends FileObject> files;

    DeleteTransformer(HashSet<ElementHandle<ExecutableElement>> allMethods, Collection<? extends FileObject> files) {
        this.allMethods = allMethods;
        this.files = files;
    }

    public Tree visitCompilationUnit(CompilationUnitTree node, Element p) {
        if (this.files.contains(this.workingCopy.getFileObject())) {
            return null;
        }
        return (Tree)super.visitCompilationUnit(node, (Object)p);
    }

    public Tree visitMethod(MethodTree tree, Element p) {
        this.deleteDeclIfMatch(tree, p);
        return (Tree)super.visitMethod(tree, (Object)p);
    }

    public Tree visitClass(ClassTree tree, Element p) {
        this.deleteDeclIfMatch(tree, p);
        return (Tree)super.visitClass(tree, (Object)p);
    }

    public Tree visitVariable(VariableTree tree, Element p) {
        this.deleteDeclIfMatch(tree, p);
        return (Tree)super.visitVariable(tree, (Object)p);
    }

    private void deleteDeclIfMatch(Tree tree, Element elementToFind) {
        if (JavaPluginUtils.isSyntheticPath((CompilationInfo)this.workingCopy, this.getCurrentPath())) {
            return;
        }
        Element el = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        if (this.isMatch(el, elementToFind)) {
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            Tree newOne = null;
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getKind())) {
                newOne = this.make.removeClassMember((ClassTree)parent, tree);
            } else if (parent.getKind() == Tree.Kind.COMPILATION_UNIT) {
                newOne = this.make.removeCompUnitTypeDecl((CompilationUnitTree)parent, tree);
            } else if (tree.getKind() == Tree.Kind.VARIABLE) {
                newOne = parent.getKind() == Tree.Kind.METHOD ? this.make.removeMethodParameter((MethodTree)parent, (VariableTree)tree) : this.make.removeBlockStatement((BlockTree)parent, (StatementTree)((VariableTree)tree));
            }
            if (newOne != null) {
                this.rewrite(parent, newOne);
            }
        }
    }

    private boolean isMatch(Element element, Element elementToFind) {
        if (element == null) {
            return false;
        }
        if (this.allMethods == null || element.getKind() != ElementKind.METHOD) {
            return element.equals(elementToFind);
        }
        for (ElementHandle<ExecutableElement> mh : this.allMethods) {
            ExecutableElement baseMethod = (ExecutableElement)mh.resolve((CompilationInfo)this.workingCopy);
            if (baseMethod == null) {
                Logger.getLogger("org.netbeans.modules.refactoring.java").log(Level.INFO, "DeleteTransformer cannot resolve {0}", mh);
                continue;
            }
            if (!baseMethod.equals(element) && !this.workingCopy.getElements().overrides((ExecutableElement)element, baseMethod, this.workingCopy.getElementUtilities().enclosingTypeElement((Element)baseMethod))) continue;
            return true;
        }
        return false;
    }
}

