/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.netbeans.modules.html.editor.lib.XmlSyntaxTreeBuilder;
import org.netbeans.modules.html.editor.lib.api.DefaultHtmlParseResult;
import org.netbeans.modules.html.editor.lib.api.HtmlParseResult;
import org.netbeans.modules.html.editor.lib.api.HtmlParser;
import org.netbeans.modules.html.editor.lib.api.HtmlSource;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.ParseException;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModelFactory;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.openide.util.Lookup;

public class SimpleXHTMLParser
implements HtmlParser {
    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean canParse(HtmlVersion version) {
        return version.isXhtml();
    }

    @Override
    public HtmlParseResult parse(HtmlSource source, HtmlVersion preferedVersion, Lookup lookup) throws ParseException {
        Node root = XmlSyntaxTreeBuilder.makeUncheckedTree(source, null, lookup);
        return new DefaultHtmlParseResult(source, root, Collections.emptyList(), preferedVersion){

            @Override
            public HtmlModel model() {
                return SimpleXHTMLParser.this.getModel(this.version());
            }

            @Override
            public Collection<HtmlTag> getPossibleOpenTags(Element context) {
                return ElementUtils.getPossibleOpenTags(this.model(), context);
            }

            @Override
            public Map<HtmlTag, OpenTag> getPossibleCloseTags(Element context) {
                return ElementUtils.getPossibleCloseTags(this.model(), context);
            }
        };
    }

    @Override
    public HtmlModel getModel(HtmlVersion version) {
        return HtmlModelFactory.getModel(version);
    }
}

