/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.templatesui;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.templatesui.AbstractWizard;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;

public final class HTMLWizard
extends AbstractWizard {
    private static final Logger LOG = Logger.getLogger(HTMLWizard.class.getName());
    private final FileObject def;
    final CountDownLatch initializationDone = new CountDownLatch(1);

    public static WizardDescriptor.InstantiatingIterator<?> create(FileObject data) {
        return new HTMLWizard(data);
    }

    private HTMLWizard(FileObject definition) {
        this.def = definition;
    }

    @Override
    protected Object initSequence(ClassLoader l) throws Exception {
        String clazz = (String)this.def.getAttribute("class");
        String method = (String)this.def.getAttribute("method");
        Method m = Class.forName(clazz, true, l).getDeclaredMethod(method, new Class[0]);
        m.setAccessible(true);
        Object ret = m.invoke(null, new Object[0]);
        return ret;
    }

    @Override
    protected URL initPage(ClassLoader l) {
        String page = (String)this.def.getAttribute("page");
        return l.getResource(page);
    }

    @Override
    protected void initializationDone(Throwable t) {
        if (t != null) {
            LOG.log(Level.SEVERE, "Problems initializing HTML wizard", t);
        }
        this.initializationDone.countDown();
    }

    @Override
    protected String[] getTechIds() {
        Object val;
        ArrayList<String> techIds = new ArrayList<String>();
        int i = 0;
        while ((val = this.def.getAttribute("techId." + i)) instanceof String) {
            techIds.add((String)val);
            ++i;
        }
        return techIds.toArray(new String[0]);
    }
}

