/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.io.File;
import java.util.Arrays;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.project.MavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.apisupport.Bundle;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.POMComponentFactory;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.Project;
import org.netbeans.modules.maven.model.pom.Properties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class NetBeansRunParamsIDEChecker
implements PrerequisitesChecker {
    private static final String MASTER_PROPERTY = "netbeans.run.params";
    static final String OLD_PROPERTY = "netbeans.run.params.ide";
    static final String PROPERTY = "netbeans.run.params.debug";

    public boolean checkRunConfig(RunConfig config) {
        String val = (String)config.getProperties().get(OLD_PROPERTY);
        MavenProject prj = config.getMavenProject();
        boolean usingNew = NetBeansRunParamsIDEChecker.usingNbmPlugin311(prj);
        if (usingNew) {
            if (val == null) {
                return true;
            }
            config.setProperty(PROPERTY, val);
            config.setProperty(OLD_PROPERTY, null);
            return true;
        }
        if (val == null) {
            val = (String)config.getProperties().get(PROPERTY);
            if (val == null) {
                return true;
            }
            config.setProperty(OLD_PROPERTY, val);
        }
        return NetBeansRunParamsIDEChecker.removeInterpolation(prj.getFile());
    }

    private static boolean removeInterpolation(File pom) {
        String upgrade = Bundle.NetBeansRunParamsIDEChecker_upgradeButton();
        NotifyDescriptor.Confirmation dd = new NotifyDescriptor.Confirmation((Object)Bundle.NetBeansRunParamsIDEChecker_msg_confirm(OLD_PROPERTY, pom), Bundle.NetBeansRunParamsIDEChecker_title_confirm());
        dd.setOptions(new Object[]{upgrade, NotifyDescriptor.CANCEL_OPTION});
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (ret != upgrade) {
            return true;
        }
        if (ret == upgrade) {
            Utilities.performPOMModelOperations((FileObject)FileUtil.toFileObject((File)pom), Arrays.asList(NetBeansRunParamsIDEChecker.createUpgradePluginOperation(), NetBeansRunParamsIDEChecker.createRemoveIdePropertyOperation()));
            return false;
        }
        return false;
    }

    private static ModelOperation<POMModel> createUpgradePluginOperation() {
        return new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                Plugin plg;
                POMComponentFactory factory = model.getFactory();
                Project project = model.getProject();
                Build bld = project.getBuild();
                if (bld == null) {
                    bld = factory.createBuild();
                    project.setBuild(bld);
                }
                if ((plg = bld.findPluginById("org.codehaus.mojo", "nbm-maven-plugin")) == null) {
                    plg = factory.createPlugin();
                    plg.setGroupId("org.codehaus.mojo");
                    plg.setArtifactId("nbm-maven-plugin");
                    plg.setExtensions(Boolean.TRUE);
                    bld.addPlugin(plg);
                }
                plg.setVersion("3.13");
            }
        };
    }

    private static ModelOperation<POMModel> createRemoveIdePropertyOperation() {
        return new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                Project project = model.getProject();
                Properties properties = project.getProperties();
                if (properties != null) {
                    String ref;
                    String args;
                    if (properties.getProperty(NetBeansRunParamsIDEChecker.OLD_PROPERTY) != null) {
                        properties.setProperty(NetBeansRunParamsIDEChecker.OLD_PROPERTY, null);
                    }
                    if ((args = properties.getProperty(NetBeansRunParamsIDEChecker.MASTER_PROPERTY)) != null && args.contains(ref = "${netbeans.run.params.ide}")) {
                        if ((args = args.replace(ref, "")).trim().length() == 0) {
                            args = null;
                        }
                        properties.setProperty(NetBeansRunParamsIDEChecker.MASTER_PROPERTY, args);
                    }
                }
            }
        };
    }

    static boolean usingNbmPlugin311(MavenProject prj) {
        String v = PluginPropertyUtils.getPluginVersion((MavenProject)prj, (String)"org.codehaus.mojo", (String)"nbm-maven-plugin");
        return v != null && new ComparableVersion(v).compareTo(new ComparableVersion("3.11.1")) >= 0;
    }
}

