/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.navigation;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.jshell.env.JShellEnvironment;
import org.netbeans.modules.jshell.model.SnippetHandle;
import org.netbeans.modules.jshell.navigation.Bundle;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;

public class DropAction
extends AbstractAction
implements ContextAwareAction {
    private final Collection<SnippetHandle> handles;
    private final JShellEnvironment env;

    public DropAction() {
        super(Bundle.ACTION_DropSnippet());
        this.handles = Collections.emptyList();
        this.env = null;
    }

    private DropAction(JShellEnvironment e, Collection<SnippetHandle> handles) {
        this.handles = handles;
        boolean enable = false;
        int cnt = 0;
        block3: for (SnippetHandle theHandle : handles) {
            switch (theHandle.getStatus()) {
                case DROPPED: 
                case NONEXISTENT: 
                case OVERWRITTEN: 
                case REJECTED: {
                    continue block3;
                }
            }
            boolean x = e.getShell() == theHandle.getState();
            if (!x) continue;
            ++cnt;
            enable = true;
        }
        this.setEnabled(enable);
        this.env = e;
        this.putValue("Name", enable && cnt > 1 ? Bundle.ACTION_DropSnippet_Count(cnt) : Bundle.ACTION_DropSnippet());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.handles.isEmpty()) {
            return;
        }
        block3: for (SnippetHandle h : this.handles) {
            if (this.env.getShell() != h.getState()) continue;
            switch (h.getStatus()) {
                case DROPPED: 
                case NONEXISTENT: 
                case OVERWRITTEN: 
                case REJECTED: {
                    continue block3;
                }
            }
            this.env.getShell().drop(h.getSnippet());
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        Collection nodes = actionContext.lookupAll(Node.class);
        ArrayList<SnippetHandle> handles = new ArrayList<SnippetHandle>();
        for (Node n : nodes) {
            SnippetHandle h = (SnippetHandle)n.getLookup().lookup(SnippetHandle.class);
            if (h == null) continue;
            handles.add(h);
        }
        return new DropAction((JShellEnvironment)actionContext.lookup(JShellEnvironment.class), handles);
    }
}

