/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.languages.yaml.IndentUtils;
import org.netbeans.modules.languages.yaml.YamlParserResult;
import org.netbeans.modules.languages.yaml.YamlTokenId;
import org.openide.util.Exceptions;

public class YamlKeystrokeHandler
implements KeystrokeHandler {
    public boolean beforeCharInserted(Document document, int caretOffset, JTextComponent target, char c) throws BadLocationException {
        Caret caret = target.getCaret();
        BaseDocument doc = (BaseDocument)document;
        int dotPos = caret.getDot();
        if (c == ' ' && dotPos >= 2) {
            try {
                String s = doc.getText(dotPos - 2, 2);
                if ("%=".equals(s) && dotPos >= 3) {
                    s = doc.getText(dotPos - 3, 3);
                }
                if ("<%".equals(s) || "<%=".equals(s)) {
                    doc.insertString(dotPos, "  ", null);
                    caret.setDot(dotPos + 1);
                    return true;
                }
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
            }
            return false;
        }
        if (dotPos > 0 && (c == '%' || c == '>')) {
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            TokenSequence ts = th.tokenSequence();
            ts.move(dotPos);
            try {
                if (ts.moveNext() || ts.movePrevious()) {
                    String s;
                    Token token = ts.token();
                    if (token.id() == YamlTokenId.TEXT && doc.getText(dotPos - 1, 1).charAt(0) == '<') {
                        int first = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)dotPos, (int)Utilities.getRowEnd((BaseDocument)doc, (int)dotPos));
                        if (first == -1) {
                            doc.insertString(dotPos, "%%>", null);
                            caret.setDot(dotPos + 1);
                            return true;
                        }
                    } else if (token.id() == YamlTokenId.DELIMITER) {
                        int first;
                        String tokenText = token.text().toString();
                        if (tokenText.endsWith("%>")) {
                            int tokenPos = c == '%' ? dotPos : dotPos - 1;
                            CharSequence suffix = DocumentUtilities.getText((Document)doc, (int)tokenPos, (int)2);
                            if (CharSequenceUtilities.textEquals((CharSequence)suffix, (CharSequence)"%>")) {
                                caret.setDot(dotPos + 1);
                                return true;
                            }
                        } else if (tokenText.endsWith("<") && (first = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)dotPos, (int)Utilities.getRowEnd((BaseDocument)doc, (int)dotPos))) == -1) {
                            doc.insertString(dotPos, "%%>", null);
                            caret.setDot(dotPos + 1);
                            return true;
                        }
                    } else if ((token.id() == YamlTokenId.RUBY || token.id() == YamlTokenId.RUBY_EXPR) && dotPos >= 1 && dotPos <= doc.getLength() - 3 && "% %>".equals(s = doc.getText(dotPos - 1, 4))) {
                        doc.remove(dotPos - 1, 2);
                        caret.setDot(dotPos + 1);
                        return true;
                    }
                }
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
            }
        }
        return false;
    }

    public boolean afterCharInserted(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        return false;
    }

    public boolean charBackspaced(Document doc, int dotPos, JTextComponent target, char ch) throws BadLocationException {
        String s;
        if (ch == '%' && dotPos > 0 && dotPos <= doc.getLength() - 2 && "<%>".equals(s = doc.getText(dotPos - 1, 3))) {
            doc.remove(dotPos, 2);
            return true;
        }
        return false;
    }

    public int beforeBreak(Document document, int offset, JTextComponent target) throws BadLocationException {
        char c;
        Caret caret = target.getCaret();
        BaseDocument doc = (BaseDocument)document;
        int lineBegin = Utilities.getRowStart((BaseDocument)doc, (int)offset);
        int lineEnd = Utilities.getRowEnd((BaseDocument)doc, (int)offset);
        if (lineBegin == offset && lineEnd == offset) {
            return -1;
        }
        int indent = YamlKeystrokeHandler.getLineIndent(doc, offset);
        String linePrefix = doc.getText(lineBegin, offset - lineBegin);
        String lineSuffix = doc.getText(offset, lineEnd + 1 - offset);
        if (linePrefix.trim().endsWith(":") && lineSuffix.trim().length() == 0) {
            indent += IndentUtils.getIndentSize((Document)doc);
        }
        int remove = 0;
        String line = doc.getText(lineBegin, lineEnd + 1 - lineBegin);
        int n = line.length();
        for (int i = offset - lineBegin; i < n && ((c = line.charAt(i)) == ' ' || c == '\t'); ++i) {
            ++remove;
        }
        if (remove > 0) {
            doc.remove(offset, remove);
        }
        String str = IndentUtils.getIndentString(indent);
        int newPos = offset + str.length();
        doc.insertString(offset, str, null);
        caret.setDot(offset);
        return newPos + 1;
    }

    public OffsetRange findMatching(Document doc, int caretOffset) {
        return OffsetRange.NONE;
    }

    public List<OffsetRange> findLogicalRanges(ParserResult info, int caretOffset) {
        YamlParserResult result = (YamlParserResult)info;
        if (result == null) {
            return Collections.emptyList();
        }
        List<? extends StructureItem> items = result.getItems();
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OffsetRange> ranges = new ArrayList<OffsetRange>();
        for (StructureItem structureItem : items) {
            this.addRanges(ranges, caretOffset, structureItem);
        }
        Collections.reverse(ranges);
        Document doc = info.getSnapshot().getSource().getDocument(false);
        if (doc != null) {
            ranges.add(new OffsetRange(0, doc.getLength()));
        }
        return ranges;
    }

    private void addRanges(List<OffsetRange> ranges, int caretOffset, StructureItem item) {
        int start = (int)item.getPosition();
        int end = (int)item.getEndPosition();
        if (caretOffset >= start && caretOffset <= end) {
            ranges.add(new OffsetRange(start, end));
            for (StructureItem child : item.getNestedItems()) {
                this.addRanges(ranges, caretOffset, child);
            }
        }
    }

    public int getNextWordOffset(Document doc, int caretOffset, boolean reverse) {
        return -1;
    }

    public static int getLineIndent(BaseDocument doc, int offset) {
        try {
            int start = Utilities.getRowStart((BaseDocument)doc, (int)offset);
            int end = Utilities.isRowWhite((BaseDocument)doc, (int)start) ? Utilities.getRowEnd((BaseDocument)doc, (int)offset) : Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)start);
            int indent = Utilities.getVisualColumn((BaseDocument)doc, (int)end);
            return indent;
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
            return 0;
        }
    }
}

