/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;

public class AnnotatedNode
extends ASTNode {
    private Map annotations = Collections.EMPTY_MAP;
    private Map annotationClasses = Collections.EMPTY_MAP;
    private boolean synthetic;
    ClassNode declaringClass;

    public Map getAnnotations() {
        return this.annotations;
    }

    public AnnotationNode getAnnotations(String name) {
        return this.annotations == Collections.EMPTY_MAP ? null : (AnnotationNode)this.annotations.get(name);
    }

    public ClassNode getAnnotationClass(String name) {
        return this.annotationClasses == Collections.EMPTY_MAP ? null : (ClassNode)this.annotationClasses.get(name);
    }

    public void addAnnotation(String name, AnnotationNode value) {
        this.checkInit();
        this.annotationClasses.put(name, value.getClassNode());
        AnnotationNode oldValue = (AnnotationNode)this.annotations.get(name);
        if (oldValue == null) {
            this.annotations.put(name, value);
        } else {
            ArrayList<AnnotationNode> list = null;
            if (oldValue instanceof List) {
                list = (ArrayList<AnnotationNode>)((Object)oldValue);
            } else {
                list = new ArrayList<AnnotationNode>();
                list.add(oldValue);
                this.annotations.put(name, list);
            }
            list.add(value);
        }
    }

    private void checkInit() {
        if (this.annotations == Collections.EMPTY_MAP) {
            this.annotations = new HashMap();
        }
        if (this.annotationClasses == Collections.EMPTY_MAP) {
            this.annotationClasses = new HashMap();
        }
    }

    public void addAnnotations(List annotations) {
        Iterator iter = annotations.iterator();
        while (iter.hasNext()) {
            AnnotationNode node = (AnnotationNode)iter.next();
            this.addAnnotation(node.getClassNode().getName(), node);
        }
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public void setSynthetic(boolean synthetic) {
        this.synthetic = synthetic;
    }

    public ClassNode getDeclaringClass() {
        return this.declaringClass;
    }

    public void setDeclaringClass(ClassNode declaringClass) {
        this.declaringClass = declaringClass;
    }
}

