/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.seqno;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class RetentionLeaseActions {
    public static final long RETAIN_ALL = -1L;

    public static class Response
    extends ActionResponse {
    }

    public static class RemoveRequest
    extends Request<RemoveRequest> {
        public RemoveRequest() {
        }

        public RemoveRequest(ShardId shardId, String id) {
            super(shardId, id);
        }
    }

    public static class RenewRequest
    extends AddOrRenewRequest<RenewRequest> {
        public RenewRequest() {
        }

        public RenewRequest(ShardId shardId, String id, long retainingSequenceNumber, String source) {
            super(shardId, id, retainingSequenceNumber, source);
        }
    }

    public static class AddRequest
    extends AddOrRenewRequest<AddRequest> {
        public AddRequest() {
        }

        public AddRequest(ShardId shardId, String id, long retainingSequenceNumber, String source) {
            super(shardId, id, retainingSequenceNumber, source);
        }
    }

    private static abstract class AddOrRenewRequest<T extends SingleShardRequest<T>>
    extends Request<T> {
        private long retainingSequenceNumber;
        private String source;

        public long getRetainingSequenceNumber() {
            return this.retainingSequenceNumber;
        }

        public String getSource() {
            return this.source;
        }

        AddOrRenewRequest() {
        }

        AddOrRenewRequest(ShardId shardId, String id, long retainingSequenceNumber, String source) {
            super(shardId, id);
            if (retainingSequenceNumber < 0L && retainingSequenceNumber != -1L) {
                throw new IllegalArgumentException("retaining sequence number [" + retainingSequenceNumber + "] out of range");
            }
            this.retainingSequenceNumber = retainingSequenceNumber;
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.retainingSequenceNumber = in.readZLong();
            this.source = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeZLong(this.retainingSequenceNumber);
            out.writeString(this.source);
        }
    }

    private static abstract class Request<T extends SingleShardRequest<T>>
    extends SingleShardRequest<T> {
        private ShardId shardId;
        private String id;

        public ShardId getShardId() {
            return this.shardId;
        }

        public String getId() {
            return this.id;
        }

        Request() {
        }

        Request(ShardId shardId, String id) {
            super(Objects.requireNonNull(shardId).getIndexName());
            this.shardId = shardId;
            this.id = Objects.requireNonNull(id);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = ShardId.readShardId(in);
            this.id = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeString(this.id);
        }
    }

    public static class Remove
    extends Action<Response> {
        public static final Remove INSTANCE = new Remove();
        public static final String ACTION_NAME = "indices:admin/seq_no/remove_retention_lease";

        private Remove() {
            super(ACTION_NAME);
        }

        @Override
        public Response newResponse() {
            return new Response();
        }

        public static class TransportAction
        extends TransportRetentionLeaseAction<RemoveRequest> {
            @Inject
            public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
                super(Remove.ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, indicesService, RemoveRequest::new);
            }

            @Override
            void doRetentionLeaseAction(IndexShard indexShard, RemoveRequest request, ActionListener<Response> listener) {
                indexShard.removeRetentionLease(request.getId(), ActionListener.wrap(r -> listener.onResponse(new Response()), listener::onFailure));
            }
        }
    }

    public static class Renew
    extends Action<Response> {
        public static final Renew INSTANCE = new Renew();
        public static final String ACTION_NAME = "indices:admin/seq_no/renew_retention_lease";

        private Renew() {
            super(ACTION_NAME);
        }

        @Override
        public Response newResponse() {
            return new Response();
        }

        public static class TransportAction
        extends TransportRetentionLeaseAction<RenewRequest> {
            @Inject
            public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
                super(Renew.ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, indicesService, RenewRequest::new);
            }

            @Override
            void doRetentionLeaseAction(IndexShard indexShard, RenewRequest request, ActionListener<Response> listener) {
                indexShard.renewRetentionLease(request.getId(), request.getRetainingSequenceNumber(), request.getSource());
                listener.onResponse(new Response());
            }
        }
    }

    public static class Add
    extends Action<Response> {
        public static final Add INSTANCE = new Add();
        public static final String ACTION_NAME = "indices:admin/seq_no/add_retention_lease";

        private Add() {
            super(ACTION_NAME);
        }

        @Override
        public Response newResponse() {
            return new Response();
        }

        public static class TransportAction
        extends TransportRetentionLeaseAction<AddRequest> {
            @Inject
            public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
                super(Add.ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, indicesService, AddRequest::new);
            }

            @Override
            void doRetentionLeaseAction(IndexShard indexShard, AddRequest request, ActionListener<Response> listener) {
                indexShard.addRetentionLease(request.getId(), request.getRetainingSequenceNumber(), request.getSource(), ActionListener.wrap(r -> listener.onResponse(new Response()), listener::onFailure));
            }
        }
    }

    static abstract class TransportRetentionLeaseAction<T extends Request<T>>
    extends TransportSingleShardAction<T, Response> {
        private final IndicesService indicesService;

        @Inject
        TransportRetentionLeaseAction(String name, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService, Supplier<T> requestSupplier) {
            super(name, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, requestSupplier, "management");
            this.indicesService = Objects.requireNonNull(indicesService);
        }

        @Override
        protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
            return state.routingTable().shardRoutingTable(request.concreteIndex(), ((Request)request.request()).getShardId().id()).primaryShardIt();
        }

        @Override
        protected void asyncShardOperation(final T request, ShardId shardId, final ActionListener<Response> listener) {
            IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
            final IndexShard indexShard = indexService.getShard(shardId.id());
            indexShard.acquirePrimaryOperationPermit(new ActionListener<Releasable>(){

                @Override
                public void onResponse(Releasable releasable) {
                    try (Releasable ignore = releasable;){
                        this.doRetentionLeaseAction(indexShard, request, listener);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            }, "same", request);
        }

        @Override
        protected Response shardOperation(T request, ShardId shardId) {
            throw new UnsupportedOperationException();
        }

        abstract void doRetentionLeaseAction(IndexShard var1, T var2, ActionListener<Response> var3);

        @Override
        protected Response newResponse() {
            return new Response();
        }

        @Override
        protected boolean resolveIndex(T request) {
            return false;
        }
    }
}

