/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.cargo.core.CargoTools;
import org.eclipse.corrosion.launch.RustLaunchDelegateTools;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;

public class CargoTestDelegate
extends LaunchConfigurationDelegate
implements ILaunchShortcut {
    public static final String TEST_NAME_ATTRIBUTE = "TEST_NAME";

    public void launch(ISelection selection, String mode) {
        ILaunchConfiguration launchConfig = CargoTestDelegate.getLaunchConfiguration(RustLaunchDelegateTools.firstResourceFromSelection(selection));
        try {
            RustLaunchDelegateTools.launch(launchConfig, mode);
        }
        catch (CoreException e) {
            CorrosionPlugin.logError(e);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        ILaunchConfiguration launchConfig = CargoTestDelegate.getLaunchConfiguration(RustLaunchDelegateTools.resourceFromEditor(editor));
        try {
            RustLaunchDelegateTools.launch(launchConfig, mode);
        }
        catch (CoreException e) {
            CorrosionPlugin.logError(e);
        }
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IFile cargoManifest;
        String projectName = configuration.getAttribute("PROJECT", "");
        String options = configuration.getAttribute("OPTIONS", "").trim();
        String testName = configuration.getAttribute(TEST_NAME_ATTRIBUTE, "");
        String arguments = configuration.getAttribute("ARGUMENTS", "").trim();
        String workingDirectoryString = RustLaunchDelegateTools.performVariableSubstitution(configuration.getAttribute("WORKING_DIRECTORY", "").trim());
        File workingDirectory = RustLaunchDelegateTools.convertToAbsolutePath(workingDirectoryString);
        ILaunchConfigurationWorkingCopy wc = null;
        IProject project = null;
        if (!projectName.isEmpty()) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        if (project == null || !project.exists()) {
            RustLaunchDelegateTools.openError(Messages.CargoRunDelegate_unableToLaunch, Messages.CargoRunDelegate_unableToFindProject);
            return;
        }
        if ((workingDirectoryString.isEmpty() || !workingDirectory.exists() || !workingDirectory.isDirectory()) && configuration instanceof ILaunchConfigurationWorkingCopy) {
            wc = (ILaunchConfigurationWorkingCopy)configuration;
            wc.setAttribute("WORKING_DIRECTORY", project.getLocation().toString());
        }
        if (!(cargoManifest = project.getFile("Cargo.toml")).exists()) {
            RustLaunchDelegateTools.openError(Messages.CargoRunDelegate_unableToLaunch, Messages.CargoRunDelegate_unableToFindToml);
            return;
        }
        ArrayList<String> cargoTestCommand = new ArrayList<String>();
        cargoTestCommand.add(CargoTools.getCargoCommand());
        cargoTestCommand.add("test");
        if (!options.isEmpty()) {
            cargoTestCommand.addAll(Arrays.asList(RustLaunchDelegateTools.performVariableSubstitution(options).split("\\s+")));
        }
        String cargoPathString = cargoManifest.getLocation().toPortableString();
        cargoTestCommand.add("--manifest-path");
        cargoTestCommand.add(cargoPathString);
        if (testName != null && !testName.isEmpty()) {
            cargoTestCommand.add(testName);
        }
        if (!arguments.isEmpty()) {
            cargoTestCommand.add("--");
            cargoTestCommand.addAll(Arrays.asList(RustLaunchDelegateTools.performVariableSubstitution(arguments).split("\\s+")));
        }
        ArrayList<String> finalTestCommand = cargoTestCommand;
        File finalWorkingDirectory = workingDirectory;
        CompletableFuture.runAsync(() -> {
            try {
                CharSequence[] cmdLine = finalTestCommand.toArray(new String[finalTestCommand.size()]);
                Process p = DebugPlugin.exec((String[])cmdLine, (File)finalWorkingDirectory);
                IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)"cargo test");
                process.setAttribute(IProcess.ATTR_CMDLINE, String.join((CharSequence)" ", cmdLine));
            }
            catch (CoreException e) {
                RustLaunchDelegateTools.openError(Messages.CargoRunDelegate_unableToLaunch, e.getLocalizedMessage());
            }
        });
        if (wc != null) {
            wc.doSave();
        }
    }

    private static ILaunchConfiguration getLaunchConfiguration(IResource resource) {
        ILaunchConfiguration launchConfiguration = RustLaunchDelegateTools.getLaunchConfiguration(resource, "org.eclipse.corrosion.test.CargoTestDelegate");
        if (launchConfiguration instanceof ILaunchConfigurationWorkingCopy) {
            ILaunchConfigurationWorkingCopy wc = (ILaunchConfigurationWorkingCopy)launchConfiguration;
            wc.setAttribute("PROJECT", resource.getProject().getName());
        }
        return launchConfiguration;
    }
}

