/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.internal.qt.core.QtInstall;
import org.eclipse.cdt.qt.core.IQtInstall;
import org.eclipse.cdt.qt.core.IQtInstallListener;
import org.eclipse.cdt.qt.core.IQtInstallManager;
import org.eclipse.cdt.qt.core.IQtInstallProvider;
import org.eclipse.cdt.qt.core.QtInstallEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class QtInstallManager
implements IQtInstallManager {
    private Map<Path, IQtInstall> installs;
    private Map<String, IConfigurationElement> toolChainMap;
    private List<IQtInstallListener> listeners = new LinkedList<IQtInstallListener>();

    private Preferences getPreferences() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.cdt.qt.core").node("qtInstalls");
    }

    private void initInstalls() {
        if (this.installs == null) {
            int n;
            int n2;
            String[] stringArray;
            this.installs = new HashMap<Path, IQtInstall>();
            try {
                Preferences prefs = this.getPreferences();
                stringArray = prefs.keys();
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    String key = stringArray[n];
                    QtInstall install = new QtInstall(Paths.get(prefs.get(key, "/"), new String[0]));
                    this.installs.put(install.getQmakePath(), install);
                    ++n;
                }
            }
            catch (BackingStoreException e) {
                Activator.log(e);
            }
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.qt.core", "qtInstallProvider");
            stringArray = point.getConfigurationElements();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String element = stringArray[n];
                try {
                    IQtInstallProvider provider = (IQtInstallProvider)element.createExecutableExtension("class");
                    for (IQtInstall install : provider.getInstalls()) {
                        this.installs.put(install.getQmakePath(), install);
                    }
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
                ++n;
            }
        }
    }

    private void saveInstalls() {
        try {
            Preferences prefs = this.getPreferences();
            String[] stringArray = prefs.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (this.installs.get(Paths.get(key, new String[0])) == null) {
                    prefs.remove(key);
                }
                ++n2;
            }
            for (Path path : this.installs.keySet()) {
                String key = path.toString();
                if (prefs.get(key, null) != null) continue;
                prefs.put(key, this.installs.get(path).getQmakePath().toString());
            }
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Activator.log(e);
        }
    }

    @Override
    public Collection<IQtInstall> getInstalls() {
        this.initInstalls();
        return Collections.unmodifiableCollection(this.installs.values());
    }

    @Override
    public void addInstall(IQtInstall qt) {
        this.initInstalls();
        this.installs.put(qt.getQmakePath(), qt);
        this.saveInstalls();
    }

    @Override
    public IQtInstall getInstall(Path qmakePath) {
        this.initInstalls();
        return this.installs.get(qmakePath);
    }

    @Override
    public Collection<IQtInstall> getInstall(String spec) {
        this.initInstalls();
        ArrayList<IQtInstall> installList = new ArrayList<IQtInstall>();
        for (IQtInstall install : this.installs.values()) {
            if (!install.getSpec().equals(spec)) continue;
            installList.add(install);
        }
        return installList;
    }

    @Override
    public void removeInstall(IQtInstall install) {
        this.fireEvent(new QtInstallEvent(QtInstallEvent.REMOVED, install));
        this.installs.remove(install.getQmakePath());
        this.saveInstalls();
    }

    @Override
    public boolean supports(IQtInstall install, IToolChain toolChain) {
        IConfigurationElement element;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        if (this.toolChainMap == null) {
            this.toolChainMap = new HashMap<String, IConfigurationElement>();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.qt.core", "qtToolChainMapper");
            iConfigurationElementArray = point.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                if (iConfigurationElement.getName().equals("mapping")) {
                    String spec = iConfigurationElement.getAttribute("spec");
                    this.toolChainMap.put(spec, iConfigurationElement);
                }
                ++n;
            }
        }
        if ((element = this.toolChainMap.get(install.getSpec())) != null) {
            iConfigurationElementArray = element.getChildren("property");
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                String key = iConfigurationElement.getAttribute("key");
                String value = iConfigurationElement.getAttribute("value");
                if (!value.equals(toolChain.getProperty(key))) {
                    return false;
                }
                ++n;
            }
            for (Map.Entry<String, String> entry : install.getProperties().entrySet()) {
                if (entry.getValue().equals(toolChain.getProperty(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void addListener(IQtInstallListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IQtInstallListener listener) {
        this.listeners.remove(listener);
    }

    private void fireEvent(QtInstallEvent event) {
        for (IQtInstallListener listener : this.listeners) {
            listener.installChanged(event);
        }
    }
}

