/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.IOUtils;

public class BytesContentStorage
implements DBDContentStorage,
DBDContentCached {
    private static final Log log = Log.getLog(BytesContentStorage.class);
    private byte[] data;
    private String encoding;

    public BytesContentStorage(byte[] data, String encoding) {
        this.data = data;
        this.encoding = encoding;
    }

    @Override
    public InputStream getContentStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public Reader getContentReader() throws IOException {
        return new InputStreamReader(this.getContentStream(), this.encoding);
    }

    @Override
    public long getContentLength() {
        return this.data.length;
    }

    @Override
    public String getCharset() {
        return this.encoding;
    }

    @Override
    public DBDContentStorage cloneStorage(DBRProgressMonitor monitor) throws IOException {
        return new BytesContentStorage(this.data, this.encoding);
    }

    @Override
    public void release() {
        this.data = null;
    }

    public static BytesContentStorage createFromStream(InputStream stream, long contentLength, String encoding) throws IOException {
        if (contentLength > Integer.MAX_VALUE) {
            throw new IOException("Too big content length for memory storage: " + contentLength);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copyStream((InputStream)stream, (OutputStream)baos);
        byte[] result = baos.toByteArray();
        if ((long)result.length != contentLength) {
            log.warn("Actual content length (" + result.length + ") is less than declared: " + contentLength);
        }
        return new BytesContentStorage(result, encoding);
    }

    @Override
    public Object getCachedValue() {
        return this.data;
    }
}

