/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.ButtonBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.FocusListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Triangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.internal.InternalImages;
import org.eclipse.gef.internal.ui.palette.PaletteColorUtil;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteMessages;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;

public class FlyoutPaletteComposite
extends Composite {
    private static final FontManager FONT_MGR = new FontManager();
    private static final String PROPERTY_PALETTE_WIDTH = "org.eclipse.gef.ui.palette.fpa.paletteWidth";
    private static final String PROPERTY_STATE = "org.eclipse.gef.ui.palette.fpa.state";
    private static final String PROPERTY_DOCK_LOCATION = "org.eclipse.gef.ui.palette.fpa.dock";
    private static final int DEFAULT_PALETTE_SIZE = 125;
    private static final int MIN_PALETTE_SIZE = 20;
    private static final int MAX_PALETTE_SIZE = 500;
    private static final int STATE_HIDDEN = 8;
    private static final int STATE_EXPANDED = 1;
    private static final Dimension ARROW_SIZE = new Dimension(6, 11);
    private static final int SASH_BUTTON_WIDTH = 11;
    public static final int STATE_COLLAPSED = 2;
    public static final int STATE_PINNED_OPEN = 4;
    private PropertyChangeSupport listeners = new PropertyChangeSupport((Object)this);
    private Composite paletteContainer;
    private PaletteViewer pViewer;
    private PaletteViewer externalViewer;
    private IMemento capturedPaletteState;
    private Control graphicalControl;
    private Composite sash;
    private PaletteViewerProvider provider;
    private FlyoutPreferences prefs;
    private Point cachedBounds = new Point(0, 0);
    private boolean transferFocus = false;
    private int dock = 16;
    private int paletteState = 8;
    private int paletteWidth = 125;
    private int minWidth = 20;
    private int cachedSize = -1;
    private int cachedState = -1;
    private int cachedLocation = -1;
    private int cachedTitleHeight = 24;
    private IPerspectiveListener perspectiveListener = new IPerspectiveListener(){

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            FlyoutPaletteComposite.this.handlePerspectiveActivated(page, perspective);
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            FlyoutPaletteComposite.this.handlePerspectiveChanged(page, perspective, changeId);
        }
    };

    public FlyoutPaletteComposite(Composite parent, int style, IWorkbenchPage page, PaletteViewerProvider pvProvider, FlyoutPreferences preferences) {
        super(parent, style | 0x40000 | 0x100000 | 0x20000000);
        this.provider = pvProvider;
        this.prefs = preferences;
        this.sash = this.createSash();
        this.paletteContainer = this.createPaletteContainer();
        this.hookIntoWorkbench(page.getWorkbenchWindow());
        if (this.prefs.getPaletteWidth() <= 0) {
            this.prefs.setPaletteWidth(125);
        }
        this.setPaletteWidth(this.prefs.getPaletteWidth());
        this.setDockLocation(this.prefs.getDockLocation());
        this.updateState(page);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                org.eclipse.swt.graphics.Rectangle area = FlyoutPaletteComposite.this.getClientArea();
                if (area.width > FlyoutPaletteComposite.this.minWidth) {
                    FlyoutPaletteComposite.this.layout(true);
                }
            }
        });
        this.listeners.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                if (property.equals(FlyoutPaletteComposite.PROPERTY_PALETTE_WIDTH)) {
                    FlyoutPaletteComposite.this.prefs.setPaletteWidth(FlyoutPaletteComposite.this.paletteWidth);
                } else if (property.equals(FlyoutPaletteComposite.PROPERTY_DOCK_LOCATION)) {
                    FlyoutPaletteComposite.this.prefs.setDockLocation(FlyoutPaletteComposite.this.dock);
                } else if (property.equals(FlyoutPaletteComposite.PROPERTY_STATE) && (FlyoutPaletteComposite.this.paletteState == 2 || FlyoutPaletteComposite.this.paletteState == 4)) {
                    FlyoutPaletteComposite.this.prefs.setPaletteState(FlyoutPaletteComposite.this.paletteState);
                }
            }
        });
    }

    private void addListenerToCtrlHierarchy(Control parent, int eventType, Listener listener) {
        parent.addListener(eventType, listener);
        if (!(parent instanceof Composite)) {
            return;
        }
        Control[] children = ((Composite)parent).getChildren();
        int i = 0;
        while (i < children.length) {
            this.addListenerToCtrlHierarchy(children[i], eventType, listener);
            ++i;
        }
    }

    private IMemento capturePaletteState(PaletteViewer viewer) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"paletteState");
        try {
            viewer.saveState((IMemento)memento);
        }
        catch (RuntimeException runtimeException) {
            memento = null;
        }
        return memento;
    }

    private Control createFlyoutControlButton(Composite parent) {
        return new ButtonCanvas(parent);
    }

    public static FlyoutPreferences createFlyoutPreferences(Preferences prefs) {
        return new DefaultFlyoutPreferences(prefs);
    }

    private Composite createPaletteContainer() {
        return new PaletteComposite(this, 538181632);
    }

    private Composite createSash() {
        return new Sash(this, 0);
    }

    private Control createTitle(Composite parent, boolean isHorizontal) {
        return new TitleCanvas(parent, isHorizontal);
    }

    private Control getPaletteViewerControl() {
        Control result = null;
        if (this.pViewer != null) {
            result = this.pViewer.getControl();
        }
        if (result != null && !result.isDisposed() && result.getParent() != this.paletteContainer) {
            result = result.getParent();
        }
        return result;
    }

    private void handlePerspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.updateState(page);
    }

    private void handlePerspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        if (changeId.equals("viewShow") || changeId.equals("viewHide")) {
            this.updateState(page);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean isDescendantOf(Control ancestor, Control descendant) {
        if (ancestor != null && descendant != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (ancestor == descendant) {
                return true;
            }
            descendant = descendant.getParent();
lbl6:
            // 2 sources

            ** while (descendant != null)
        }
lbl7:
        // 1 sources

        return false;
    }

    private boolean isInState(int state) {
        return (this.paletteState & state) != 0;
    }

    private boolean isMirrored() {
        return (this.getStyle() & 0x8000000) != 0;
    }

    public void layout(boolean changed) {
        if (this.graphicalControl == null || this.graphicalControl.isDisposed()) {
            return;
        }
        org.eclipse.swt.graphics.Rectangle area = this.getClientArea();
        if (area.width == 0 || area.height == 0) {
            return;
        }
        int sashWidth = this.sash.computeSize((int)-1, (int)-1).x;
        int pWidth = this.paletteWidth;
        int maxWidth = Math.min(area.width / 2, 500);
        maxWidth = Math.max(maxWidth, this.minWidth);
        pWidth = Math.max(pWidth, this.minWidth);
        pWidth = Math.min(pWidth, maxWidth);
        if (this.paletteState == this.cachedState && pWidth == this.cachedSize && this.cachedLocation == this.dock && this.cachedBounds == this.getSize()) {
            return;
        }
        this.cachedState = this.paletteState;
        this.cachedSize = pWidth;
        this.cachedLocation = this.dock;
        this.cachedBounds = this.getSize();
        if (!Platform.getWS().equals("cocoa")) {
            this.setRedraw(false);
        }
        if (this.isInState(8)) {
            this.sash.setVisible(false);
            this.paletteContainer.setVisible(false);
            this.graphicalControl.setBounds(area);
        } else if (this.dock == 16) {
            this.layoutComponentsEast(area, sashWidth, pWidth);
        } else {
            this.layoutComponentsWest(area, sashWidth, pWidth);
        }
        this.sash.layout();
        if (!Platform.getWS().equals("cocoa")) {
            this.setRedraw(true);
        }
        this.update();
    }

    private void layoutComponentsEast(org.eclipse.swt.graphics.Rectangle area, int sashWidth, int pWidth) {
        if (this.isInState(2)) {
            this.paletteContainer.setVisible(false);
            this.sash.setBounds(area.x + area.width - sashWidth, area.y, sashWidth, area.height);
            this.sash.setVisible(true);
            this.graphicalControl.setBounds(area.x, area.y, area.width - sashWidth, area.height);
        } else if (this.isInState(1)) {
            this.paletteContainer.moveAbove(this.graphicalControl);
            this.sash.moveAbove((Control)this.paletteContainer);
            this.sash.setBounds(area.x + area.width - pWidth - sashWidth, area.y, sashWidth, area.height);
            this.paletteContainer.setBounds(area.x + area.width - pWidth, area.y, pWidth, area.height);
            this.sash.setVisible(true);
            this.paletteContainer.setVisible(true);
            this.graphicalControl.setBounds(area.x, area.y, area.width - sashWidth, area.height);
        } else if (this.isInState(4)) {
            this.sash.setBounds(area.x + area.width - pWidth - sashWidth, area.y, sashWidth, area.height);
            this.paletteContainer.setBounds(area.x + area.width - pWidth, area.y, pWidth, area.height);
            this.sash.setVisible(true);
            this.paletteContainer.setVisible(true);
            this.graphicalControl.setBounds(area.x, area.y, area.width - sashWidth - pWidth, area.height);
        }
    }

    private void layoutComponentsWest(org.eclipse.swt.graphics.Rectangle area, int sashWidth, int pWidth) {
        if (this.isInState(2)) {
            this.paletteContainer.setVisible(false);
            this.sash.setBounds(area.x, area.y, sashWidth, area.height);
            this.sash.setVisible(true);
            this.graphicalControl.setBounds(area.x + sashWidth, area.y, area.width - sashWidth, area.height);
        } else if (this.isInState(1)) {
            this.paletteContainer.setVisible(true);
            this.paletteContainer.moveAbove(this.graphicalControl);
            this.sash.moveAbove((Control)this.paletteContainer);
            this.sash.setBounds(area.x + pWidth, area.y, sashWidth, area.height);
            this.paletteContainer.setBounds(area.x, area.y, pWidth, area.height);
            this.sash.setVisible(true);
            this.graphicalControl.setBounds(area.x + sashWidth, area.y, area.width - sashWidth, area.height);
        } else if (this.isInState(4)) {
            this.paletteContainer.setVisible(true);
            this.sash.setBounds(area.x + pWidth, area.y, sashWidth, area.height);
            this.paletteContainer.setBounds(area.x, area.y, pWidth, area.height);
            this.sash.setVisible(true);
            this.graphicalControl.setBounds(area.x + pWidth + sashWidth, area.y, area.width - sashWidth - pWidth, area.height);
        }
    }

    private void hookIntoWorkbench(final IWorkbenchWindow window) {
        window.addPerspectiveListener(this.perspectiveListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                window.removePerspectiveListener(FlyoutPaletteComposite.this.perspectiveListener);
                FlyoutPaletteComposite.this.perspectiveListener = null;
            }
        });
    }

    private boolean restorePaletteState(PaletteViewer newPalette, IMemento state) {
        if (state != null) {
            try {
                return newPalette.restoreState(state);
            }
            catch (RuntimeException runtimeException) {}
        }
        return false;
    }

    public void setExternalViewer(PaletteViewer viewer) {
        if (viewer == null && this.externalViewer != null) {
            this.capturedPaletteState = this.capturePaletteState(this.externalViewer);
        }
        this.externalViewer = viewer;
        if (this.externalViewer != null && this.pViewer != null) {
            this.transferState(this.pViewer, this.externalViewer);
        }
    }

    private void setDockLocation(int position) {
        if (position != 16 && position != 8) {
            return;
        }
        if (position != this.dock) {
            int oldPosition = this.dock;
            this.dock = position;
            this.listeners.firePropertyChange(PROPERTY_DOCK_LOCATION, oldPosition, this.dock);
            if (this.pViewer != null) {
                this.layout(true);
            }
        }
    }

    private void setPaletteWidth(int newSize) {
        if (this.paletteWidth != newSize) {
            int oldValue = this.paletteWidth;
            this.paletteWidth = newSize;
            this.listeners.firePropertyChange(PROPERTY_PALETTE_WIDTH, oldValue, this.paletteWidth);
            if (this.pViewer != null) {
                this.layout(true);
            }
        }
    }

    public void setGraphicalControl(Control graphicalViewer) {
        Assert.isTrue((graphicalViewer != null ? 1 : 0) != 0);
        Assert.isTrue((graphicalViewer.getParent() == this ? 1 : 0) != 0);
        Assert.isTrue((this.graphicalControl == null ? 1 : 0) != 0);
        this.graphicalControl = graphicalViewer;
        this.addListenerToCtrlHierarchy(this.graphicalControl, 6, new Listener(){

            public void handleEvent(Event event) {
                if (!FlyoutPaletteComposite.this.isInState(1)) {
                    return;
                }
                Display.getCurrent().timerExec(250, new Runnable(this){
                    final /* synthetic */ 24 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        if (FlyoutPaletteComposite.access$14(24.access$0(this.this$1), FlyoutPaletteComposite.access$13(24.access$0(this.this$1)), Display.getCurrent().getCursorControl()) && FlyoutPaletteComposite.access$2(24.access$0(this.this$1), 1)) {
                            FlyoutPaletteComposite.access$3(24.access$0(this.this$1), 2);
                        }
                    }
                });
            }

            static /* synthetic */ FlyoutPaletteComposite access$0(24 var0) {
                return var0.FlyoutPaletteComposite.this;
            }
        });
    }

    public void hookDropTargetListener(GraphicalViewer viewer) {
        viewer.addDropTargetListener(new TransferDropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public Transfer getTransfer() {
                return TemplateTransfer.getInstance();
            }

            public boolean isEnabled(DropTargetEvent event) {
                if (FlyoutPaletteComposite.this.isInState(1)) {
                    FlyoutPaletteComposite.this.setState(2);
                }
                return false;
            }
        });
    }

    private void setState(int newState) {
        if (newState != 8 && newState != 4 && newState != 1) {
            newState = 2;
        }
        if (this.paletteState == newState) {
            return;
        }
        int oldState = this.paletteState;
        this.paletteState = newState;
        switch (this.paletteState) {
            case 1: 
            case 2: 
            case 4: {
                if (this.pViewer != null) break;
                this.pViewer = this.provider.createPaletteViewer(this.paletteContainer);
                if (this.externalViewer != null) {
                    this.transferState(this.externalViewer, this.pViewer);
                } else {
                    this.restorePaletteState(this.pViewer, this.capturedPaletteState);
                }
                this.capturedPaletteState = null;
                this.minWidth = Math.max(this.pViewer.getControl().computeSize((int)0, (int)0).x, 20);
                break;
            }
            case 8: {
                Control pViewerCtrl;
                if (this.pViewer == null) break;
                if (this.externalViewer != null) {
                    this.provider.getEditDomain().setPaletteViewer(this.externalViewer);
                    this.transferState(this.pViewer, this.externalViewer);
                }
                if (this.provider.getEditDomain().getPaletteViewer() == this.pViewer) {
                    this.provider.getEditDomain().setPaletteViewer(null);
                }
                if ((pViewerCtrl = this.getPaletteViewerControl()) != null && !pViewerCtrl.isDisposed()) {
                    pViewerCtrl.dispose();
                }
                this.pViewer = null;
            }
        }
        if (this.paletteState == 2 && this.pViewer.getControl().isFocusControl()) {
            this.graphicalControl.setFocus();
        }
        this.layout(true);
        this.listeners.firePropertyChange(PROPERTY_STATE, oldState, newState);
    }

    private void transferState(PaletteViewer src, PaletteViewer dest) {
        this.restorePaletteState(dest, this.capturePaletteState(src));
    }

    private void updateState(IWorkbenchPage page) {
        IViewReference view = page.findViewReference("org.eclipse.gef.ui.palette_view");
        if (view == null && this.isInState(8)) {
            this.setState(this.prefs.getPaletteState());
        }
        if (view != null && !this.isInState(8)) {
            this.setState(8);
        }
    }

    static /* synthetic */ Control access$13(FlyoutPaletteComposite flyoutPaletteComposite) {
        return flyoutPaletteComposite.graphicalControl;
    }

    static /* synthetic */ boolean access$14(FlyoutPaletteComposite flyoutPaletteComposite, Control control, Control control2) {
        return flyoutPaletteComposite.isDescendantOf(control, control2);
    }

    private class ButtonCanvas
    extends Canvas {
        private LightweightSystem lws;

        public ButtonCanvas(Composite parent) {
            super(parent, 0x140000);
            this.init();
            this.provideAccSupport();
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            Dimension size = this.lws.getRootFigure().getPreferredSize(wHint, hHint);
            size.union(new Dimension(wHint, hHint));
            return new Point(size.width, size.height);
        }

        private int getArrowDirection() {
            int direction = 16;
            if (FlyoutPaletteComposite.this.isInState(5)) {
                direction = FlyoutPaletteComposite.this.dock == 8 ? 8 : 16;
            } else {
                int n = direction = FlyoutPaletteComposite.this.dock == 8 ? 16 : 8;
            }
            if (FlyoutPaletteComposite.this.isMirrored()) {
                direction = direction == 8 ? 16 : 8;
            }
            return direction;
        }

        private String getButtonTooltipText() {
            if (FlyoutPaletteComposite.this.isInState(2)) {
                return PaletteMessages.PALETTE_SHOW;
            }
            return PaletteMessages.PALETTE_HIDE;
        }

        private void init() {
            this.setCursor(SharedCursors.ARROW);
            this.lws = new LightweightSystem();
            this.lws.setControl((Canvas)this);
            ArrowButton b = new ArrowButton(this.getArrowDirection());
            b.setRolloverEnabled(true);
            b.setBorder((Border)new ButtonBorder(ButtonBorder.SCHEMES.TOOLBAR));
            b.addActionListener(new ActionListener(this){
                final /* synthetic */ ButtonCanvas this$1;
                {
                    this.this$1 = buttonCanvas;
                }

                public void actionPerformed(ActionEvent event) {
                    FlyoutPaletteComposite.access$11(ButtonCanvas.access$2(this.this$1), true);
                    if (FlyoutPaletteComposite.access$2(ButtonCanvas.access$2(this.this$1), 2)) {
                        FlyoutPaletteComposite.access$3(ButtonCanvas.access$2(this.this$1), 4);
                    } else {
                        FlyoutPaletteComposite.access$3(ButtonCanvas.access$2(this.this$1), 2);
                    }
                }
            });
            FlyoutPaletteComposite.this.listeners.addPropertyChangeListener(new PropertyChangeListener(this, b){
                final /* synthetic */ ButtonCanvas this$1;
                private final /* synthetic */ ArrowButton val$b;
                {
                    this.this$1 = buttonCanvas;
                    this.val$b = arrowButton;
                }

                public void propertyChange(java.beans.PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("org.eclipse.gef.ui.palette.fpa.state")) {
                        this.val$b.setDirection(ButtonCanvas.access$0(this.this$1));
                        this.this$1.setToolTipText(ButtonCanvas.access$1(this.this$1));
                    } else if (evt.getPropertyName().equals("org.eclipse.gef.ui.palette.fpa.dock")) {
                        this.val$b.setDirection(ButtonCanvas.access$0(this.this$1));
                    }
                }
            });
            this.lws.setContents((IFigure)b);
        }

        private void provideAccSupport() {
            this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(this){
                final /* synthetic */ ButtonCanvas this$1;
                {
                    this.this$1 = buttonCanvas;
                }

                public void getDescription(AccessibleEvent e) {
                    e.result = PaletteMessages.ACC_DESC_PALETTE_BUTTON;
                }

                public void getHelp(AccessibleEvent e) {
                    this.getDescription(e);
                }

                public void getName(AccessibleEvent e) {
                    e.result = this.this$1.getToolTipText();
                }
            });
            this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(this){
                final /* synthetic */ ButtonCanvas this$1;
                {
                    this.this$1 = buttonCanvas;
                }

                public void getRole(AccessibleControlEvent e) {
                    e.detail = 43;
                }
            });
        }

        static /* synthetic */ int access$0(ButtonCanvas buttonCanvas) {
            return buttonCanvas.getArrowDirection();
        }

        static /* synthetic */ String access$1(ButtonCanvas buttonCanvas) {
            return buttonCanvas.getButtonTooltipText();
        }

        static /* synthetic */ FlyoutPaletteComposite access$2(ButtonCanvas buttonCanvas) {
            return buttonCanvas.FlyoutPaletteComposite.this;
        }

        private class ArrowButton
        extends Button {
            private Triangle triangle;

            public ArrowButton(int direction) {
                this.setDirection(direction);
                this.triangle = new Triangle();
                this.triangle.setOutline(true);
                this.triangle.setBackgroundColor(PaletteColorUtil.WIDGET_LIST_BACKGROUND);
                this.triangle.setForegroundColor(PaletteColorUtil.WIDGET_DARK_SHADOW);
                this.setContents((IFigure)this.triangle);
            }

            public void setDirection(int direction) {
                if (this.triangle != null) {
                    this.triangle.setDirection(direction);
                }
            }

            protected void layout() {
                Rectangle clientArea = this.getBounds();
                this.triangle.setBounds(new Rectangle(clientArea.getCenter().getTranslated(-ARROW_SIZE.width / 2, -ARROW_SIZE.height / 2), ARROW_SIZE));
            }

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
                graphics.pushState();
                Rectangle r = Rectangle.SINGLETON;
                r.setBounds(this.getBounds());
                graphics.setForegroundColor(PaletteColorUtil.WIDGET_LIST_BACKGROUND);
                graphics.setBackgroundColor(PaletteColorUtil.WIDGET_BACKGROUND);
                graphics.fillGradient(r, true);
                graphics.popState();
                graphics.setForegroundColor(PaletteColorUtil.WIDGET_NORMAL_SHADOW);
                graphics.drawLine(r.getBottomLeft().getTranslated(0, -1), r.getBottomRight().getTranslated(0, -1));
            }
        }
    }

    private class ChangeDockAction
    extends Action {
        private int position;

        public ChangeDockAction(String text, int position) {
            super(text, 8);
            this.position = position;
        }

        public boolean isChecked() {
            return FlyoutPaletteComposite.this.dock == this.position;
        }

        public void run() {
            FlyoutPaletteComposite.this.setDockLocation(this.position);
        }
    }

    private static class DefaultFlyoutPreferences
    implements FlyoutPreferences {
        private static final String PALETTE_DOCK_LOCATION = "org.eclipse.gef.pdock";
        private static final String PALETTE_SIZE = "org.eclipse.gef.psize";
        private static final String PALETTE_STATE = "org.eclipse.gef.pstate";
        private Preferences prefs;

        private DefaultFlyoutPreferences(Preferences preferences) {
            this.prefs = preferences;
        }

        public int getDockLocation() {
            return this.prefs.getInt(PALETTE_DOCK_LOCATION);
        }

        public int getPaletteState() {
            return this.prefs.getInt(PALETTE_STATE);
        }

        public int getPaletteWidth() {
            return this.prefs.getInt(PALETTE_SIZE);
        }

        public void setDockLocation(int location) {
            this.prefs.setValue(PALETTE_DOCK_LOCATION, location);
        }

        public void setPaletteState(int state) {
            this.prefs.setValue(PALETTE_STATE, state);
        }

        public void setPaletteWidth(int width) {
            this.prefs.setValue(PALETTE_SIZE, width);
        }
    }

    private static class DragCursors {
        public static final int INVALID = 0;
        public static final int LEFT = 1;
        public static final int RIGHT = 2;
        private static final Cursor[] cursors = new Cursor[3];

        private DragCursors() {
        }

        public static Cursor getCursor(int code) {
            Display display = Display.getCurrent();
            if (cursors[code] == null) {
                ImageDescriptor source = null;
                ImageDescriptor mask = null;
                switch (code) {
                    case 1: {
                        source = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_DND_LEFT_SOURCE");
                        mask = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_DND_LEFT_MASK");
                        DragCursors.cursors[1] = new Cursor((Device)display, source.getImageData(), mask.getImageData(), 16, 16);
                        break;
                    }
                    case 2: {
                        source = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_DND_RIGHT_SOURCE");
                        mask = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_DND_RIGHT_MASK");
                        DragCursors.cursors[2] = new Cursor((Device)display, source.getImageData(), mask.getImageData(), 16, 16);
                        break;
                    }
                    default: {
                        source = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_DND_INVALID_SOURCE");
                        mask = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_DND_INVALID_MASK");
                        DragCursors.cursors[0] = new Cursor((Device)display, source.getImageData(), mask.getImageData(), 16, 16);
                    }
                }
            }
            return cursors[code];
        }
    }

    public static interface FlyoutPreferences {
        public int getDockLocation();

        public int getPaletteState();

        public int getPaletteWidth();

        public void setDockLocation(int var1);

        public void setPaletteState(int var1);

        public void setPaletteWidth(int var1);
    }

    private static class FontManager {
        private final String fontName = this.getFontType();
        private List registrants = new ArrayList();
        private Font titleFont;
        private final IPropertyChangeListener fontListener = new IPropertyChangeListener(this){
            final /* synthetic */ FontManager this$1;
            {
                this.this$1 = fontManager;
            }

            public void propertyChange(PropertyChangeEvent event) {
                if (FontManager.access$1(this.this$1).equals(event.getProperty())) {
                    this.this$1.handleFontChanged();
                }
            }
        };

        private FontManager() {
        }

        protected final Font createTitleFont() {
            return JFaceResources.getFont((String)this.fontName);
        }

        protected void dispose() {
            this.titleFont = null;
            JFaceResources.getFontRegistry().removeListener(this.fontListener);
        }

        protected String getFontType() {
            return "org.eclipse.jface.dialogfont";
        }

        protected void handleFontChanged() {
            if (this.titleFont == null) {
                return;
            }
            Font oldFont = this.titleFont;
            this.titleFont = this.createTitleFont();
            Iterator iter = this.registrants.iterator();
            while (iter.hasNext()) {
                ((Control)iter.next()).setFont(this.titleFont);
            }
            oldFont.dispose();
        }

        protected void init() {
            this.titleFont = this.createTitleFont();
            JFaceResources.getFontRegistry().addListener(this.fontListener);
        }

        public void register(Control ctrl) {
            if (this.titleFont == null) {
                this.init();
            }
            ctrl.setFont(this.titleFont);
            this.registrants.add(ctrl);
        }

        public void unregister(Control ctrl) {
            this.registrants.remove(ctrl);
            if (this.registrants.isEmpty()) {
                this.dispose();
            }
        }

        static /* synthetic */ String access$1(FontManager fontManager) {
            return fontManager.fontName;
        }
    }

    private class PaletteComposite
    extends Composite {
        protected Control button;
        protected Control title;

        public PaletteComposite(Composite parent, int style) {
            super(parent, style);
            this.createComponents();
            FlyoutPaletteComposite.this.listeners.addPropertyChangeListener(new PropertyChangeListener(this){
                final /* synthetic */ PaletteComposite this$1;
                {
                    this.this$1 = paletteComposite;
                }

                public void propertyChange(java.beans.PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("org.eclipse.gef.ui.palette.fpa.state")) {
                        this.this$1.updateState();
                    } else if (evt.getPropertyName().equals("org.eclipse.gef.ui.palette.fpa.dock") && this.this$1.getVisible()) {
                        this.this$1.layout(true);
                    }
                }
            });
            this.addListener(11, new Listener(this){
                final /* synthetic */ PaletteComposite this$1;
                {
                    this.this$1 = paletteComposite;
                }

                public void handleEvent(Event event) {
                    this.this$1.layout(true);
                }
            });
            this.updateState();
        }

        protected void createComponents() {
            this.title = FlyoutPaletteComposite.this.createTitle(this, true);
            this.button = FlyoutPaletteComposite.this.createFlyoutControlButton(this);
        }

        public void layout(boolean changed) {
            Control pCtrl = FlyoutPaletteComposite.this.getPaletteViewerControl();
            if (pCtrl == null || pCtrl.isDisposed()) {
                return;
            }
            org.eclipse.swt.graphics.Rectangle area = this.getClientArea();
            boolean buttonVisible = this.button.getVisible();
            Point titleSize = this.title.computeSize(-1, -1);
            Point buttonSize = buttonVisible ? this.button.computeSize(-1, -1) : new Point(0, 0);
            FlyoutPaletteComposite.this.cachedTitleHeight = Math.max(titleSize.y, buttonSize.y);
            if (buttonVisible) {
                buttonSize.x = Math.max(FlyoutPaletteComposite.this.cachedTitleHeight, buttonSize.x);
            }
            if (FlyoutPaletteComposite.this.dock == 16) {
                int buttonX = area.width - buttonSize.x;
                this.button.setBounds(buttonX, 0, buttonSize.x, FlyoutPaletteComposite.this.cachedTitleHeight);
                this.title.setBounds(0, 0, buttonX, FlyoutPaletteComposite.this.cachedTitleHeight);
            } else {
                int titleX = buttonSize.x;
                this.button.setBounds(0, 0, buttonSize.x, FlyoutPaletteComposite.this.cachedTitleHeight);
                this.title.setBounds(titleX, 0, area.width - titleX, FlyoutPaletteComposite.this.cachedTitleHeight);
            }
            area.y += FlyoutPaletteComposite.this.cachedTitleHeight;
            area.height -= FlyoutPaletteComposite.this.cachedTitleHeight;
            pCtrl.setBounds(area);
        }

        protected void updateState() {
            this.button.setVisible(FlyoutPaletteComposite.this.isInState(4));
            if (FlyoutPaletteComposite.this.transferFocus && this.button.getVisible()) {
                FlyoutPaletteComposite.this.transferFocus = false;
                this.button.setFocus();
            }
            this.layout(true);
        }
    }

    private class ResizeAction
    extends Action {
        public ResizeAction() {
            super(PaletteMessages.RESIZE_LABEL);
        }

        public boolean isEnabled() {
            return !FlyoutPaletteComposite.this.isInState(2);
        }

        public void run() {
            Tracker tracker = new Tracker((Composite)FlyoutPaletteComposite.this, 147456);
            org.eclipse.swt.graphics.Rectangle[] rects = new org.eclipse.swt.graphics.Rectangle[]{FlyoutPaletteComposite.this.sash.getBounds()};
            tracker.setCursor(SharedCursors.SIZEE);
            tracker.setRectangles(rects);
            if (tracker.open()) {
                int deltaX = ((FlyoutPaletteComposite)FlyoutPaletteComposite.this).sash.getBounds().x - tracker.getRectangles()[0].x;
                if (FlyoutPaletteComposite.this.dock == 8) {
                    deltaX = -deltaX;
                }
                FlyoutPaletteComposite.this.setPaletteWidth(((FlyoutPaletteComposite)FlyoutPaletteComposite.this).paletteContainer.getBounds().width + deltaX);
            }
            tracker.dispose();
        }
    }

    private class Sash
    extends Composite {
        private Control button;

        public Sash(Composite parent, int style) {
            super(parent, style);
            this.button = FlyoutPaletteComposite.this.createFlyoutControlButton(this);
            new SashDragManager();
            this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(this){
                final /* synthetic */ Sash this$1;
                {
                    this.this$1 = sash;
                }

                public void mouseHover(MouseEvent e) {
                    if (FlyoutPaletteComposite.access$2(Sash.access$3(this.this$1), 2)) {
                        FlyoutPaletteComposite.access$3(Sash.access$3(this.this$1), 1);
                    }
                }
            });
            this.addListener(9, new Listener(this){
                final /* synthetic */ Sash this$1;
                {
                    this.this$1 = sash;
                }

                public void handleEvent(Event event) {
                    Sash.access$1(this.this$1, event.gc);
                }
            });
            this.addListener(11, new Listener(this){
                final /* synthetic */ Sash this$1;
                {
                    this.this$1 = sash;
                }

                public void handleEvent(Event event) {
                    this.this$1.layout(true);
                }
            });
            FlyoutPaletteComposite.this.listeners.addPropertyChangeListener(new PropertyChangeListener(this){
                final /* synthetic */ Sash this$1;
                {
                    this.this$1 = sash;
                }

                public void propertyChange(java.beans.PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("org.eclipse.gef.ui.palette.fpa.state")) {
                        Sash.access$2(this.this$1);
                    }
                }
            });
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            if (FlyoutPaletteComposite.this.isInState(4)) {
                return new Point(3, 3);
            }
            return new Point(13, FlyoutPaletteComposite.this.cachedTitleHeight);
        }

        private void handleSashDragged(int shiftAmount) {
            int newSize = ((FlyoutPaletteComposite)FlyoutPaletteComposite.this).paletteContainer.getBounds().width + (FlyoutPaletteComposite.this.dock == 16 ? -shiftAmount : shiftAmount);
            FlyoutPaletteComposite.this.setPaletteWidth(newSize);
        }

        public void layout(boolean changed) {
            if (this.button == null) {
                return;
            }
            if (FlyoutPaletteComposite.this.isInState(4)) {
                this.button.setVisible(false);
                return;
            }
            this.button.setVisible(true);
            org.eclipse.swt.graphics.Rectangle area = this.getClientArea();
            this.button.setBounds(area.x + 1, area.y + 1, 11, FlyoutPaletteComposite.this.cachedTitleHeight - 1);
            if (FlyoutPaletteComposite.this.transferFocus) {
                FlyoutPaletteComposite.this.transferFocus = false;
                this.button.setFocus();
            }
        }

        private void paintSash(GC gc) {
            org.eclipse.swt.graphics.Rectangle bounds = this.getBounds();
            if (FlyoutPaletteComposite.this.isInState(4)) {
                gc.setBackground(PaletteColorUtil.WIDGET_BACKGROUND);
                gc.fillRectangle(0, 0, bounds.width, bounds.height);
                gc.setForeground(PaletteColorUtil.WIDGET_LIST_BACKGROUND);
                gc.drawLine(0, 0, bounds.width, 0);
                gc.setForeground(PaletteColorUtil.WIDGET_NORMAL_SHADOW);
                gc.drawLine(0, bounds.height - 1, bounds.width - 1, bounds.height - 1);
                gc.setForeground(PaletteColorUtil.WIDGET_LIST_BACKGROUND);
                gc.drawLine(0, 0, 0, bounds.height);
                gc.setForeground(PaletteColorUtil.WIDGET_NORMAL_SHADOW);
                gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
            } else {
                gc.setForeground(PaletteColorUtil.WIDGET_NORMAL_SHADOW);
                gc.drawLine(0, 0, 0, bounds.height);
                gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height);
                gc.setForeground(PaletteColorUtil.WIDGET_LIST_BACKGROUND);
                gc.drawLine(1, 0, 1, bounds.height);
                gc.setForeground(PaletteColorUtil.WIDGET_BACKGROUND_LIST_BACKGROUND_85);
                gc.drawLine(2, 0, 2, bounds.height);
            }
        }

        private void updateState() {
            this.setCursor((Cursor)(FlyoutPaletteComposite.this.isInState(5) ? SharedCursors.SIZEWE : null));
        }

        static /* synthetic */ void access$1(Sash sash, GC gC) {
            sash.paintSash(gC);
        }

        static /* synthetic */ void access$2(Sash sash) {
            sash.updateState();
        }

        private class SashDragManager
        extends MouseAdapter
        implements MouseMoveListener {
            protected boolean dragging = false;
            protected boolean correctState = false;
            protected boolean mouseDown = false;
            protected int origX;
            protected Listener keyListener = new Listener(this){
                final /* synthetic */ SashDragManager this$2;
                {
                    this.this$2 = sashDragManager;
                }

                public void handleEvent(Event event) {
                    if (event.keyCode == 65536 || event.keyCode == 27) {
                        this.this$2.dragging = false;
                        Display.getCurrent().removeFilter(1, (Listener)this);
                    }
                    event.doit = false;
                    event.type = 0;
                }
            };

            public SashDragManager() {
                Sash.this.addMouseMoveListener(this);
                Sash.this.addMouseListener((MouseListener)this);
            }

            public void mouseDown(MouseEvent me) {
                if (me.button != 1) {
                    return;
                }
                this.mouseDown = true;
                this.correctState = FlyoutPaletteComposite.this.isInState(5);
                this.origX = me.x;
                Display.getCurrent().addFilter(1, this.keyListener);
            }

            public void mouseMove(MouseEvent me) {
                if (this.mouseDown) {
                    this.dragging = true;
                }
                if (this.dragging && this.correctState) {
                    Sash.this.handleSashDragged(me.x - this.origX);
                }
            }

            public void mouseUp(MouseEvent me) {
                Display.getCurrent().removeFilter(1, this.keyListener);
                if (!this.dragging && me.button == 1) {
                    if (FlyoutPaletteComposite.this.isInState(2)) {
                        FlyoutPaletteComposite.this.setState(1);
                    } else if (FlyoutPaletteComposite.this.isInState(1)) {
                        FlyoutPaletteComposite.this.setState(2);
                    }
                }
                this.dragging = false;
                this.correctState = false;
                this.mouseDown = false;
            }
        }
    }

    private class TitleCanvas
    extends Canvas {
        private LightweightSystem lws;

        public TitleCanvas(Composite parent, boolean horizontal) {
            super(parent, 0x140000);
            this.init(horizontal);
            this.provideAccSupport();
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            Dimension size = this.lws.getRootFigure().getPreferredSize(wHint, hHint);
            size.union(new Dimension(wHint, hHint));
            return new Point(size.width, size.height);
        }

        private void init(boolean isHorizontal) {
            TitleLabel contents = new TitleLabel(true);
            contents.setRequestFocusEnabled(true);
            contents.setFocusTraversable(true);
            contents.addFocusListener(new FocusListener(this){
                final /* synthetic */ TitleCanvas this$1;
                {
                    this.this$1 = titleCanvas;
                }

                public void focusGained(FocusEvent fe) {
                    fe.gainer.repaint();
                }

                public void focusLost(FocusEvent fe) {
                    fe.loser.repaint();
                }
            });
            this.lws = new LightweightSystem();
            this.lws.setControl((Canvas)this);
            this.lws.setContents((IFigure)contents);
            this.setCursor(SharedCursors.SIZEALL);
            FONT_MGR.register((Control)this);
            new TitleDragManager((Control)this);
            MenuManager manager = new MenuManager();
            MenuManager mgr = new MenuManager(PaletteMessages.DOCK_LABEL);
            mgr.add((IAction)new ChangeDockAction(PaletteMessages.LEFT_LABEL, 8));
            mgr.add((IAction)new ChangeDockAction(PaletteMessages.RIGHT_LABEL, 16));
            manager.add((IAction)new ResizeAction());
            manager.add((IContributionItem)mgr);
            this.setMenu(manager.createContextMenu((Control)this));
            mgr.addMenuListener(new IMenuListener(this){
                final /* synthetic */ TitleCanvas this$1;
                {
                    this.this$1 = titleCanvas;
                }

                public void menuAboutToShow(IMenuManager menuMgr) {
                    IContributionItem[] items = menuMgr.getItems();
                    int i = 0;
                    while (i < items.length) {
                        ((ActionContributionItem)items[i]).update();
                        ++i;
                    }
                }
            });
            this.addDisposeListener(new DisposeListener(this, manager){
                final /* synthetic */ TitleCanvas this$1;
                private final /* synthetic */ MenuManager val$manager;
                {
                    this.this$1 = titleCanvas;
                    this.val$manager = menuManager;
                }

                public void widgetDisposed(DisposeEvent e) {
                    FlyoutPaletteComposite.access$21().unregister((Control)this.this$1);
                    this.val$manager.dispose();
                }
            });
        }

        private void provideAccSupport() {
            this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(this){
                final /* synthetic */ TitleCanvas this$1;
                {
                    this.this$1 = titleCanvas;
                }

                public void getDescription(AccessibleEvent e) {
                    e.result = PaletteMessages.ACC_DESC_PALETTE_TITLE;
                }

                public void getHelp(AccessibleEvent e) {
                    this.getDescription(e);
                }

                public void getName(AccessibleEvent e) {
                    e.result = GEFMessages.Palette_Label;
                }
            });
            this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(this){
                final /* synthetic */ TitleCanvas this$1;
                {
                    this.this$1 = titleCanvas;
                }

                public void getRole(AccessibleControlEvent e) {
                    e.detail = 41;
                }
            });
        }

        public void setFont(Font font) {
            ((IFigure)this.lws.getRootFigure().getChildren().get(0)).setFont(font);
            if (this.isVisible()) {
                FlyoutPaletteComposite.this.layout(true);
                this.getParent().layout(true);
            }
        }
    }

    private class TitleDragManager
    extends MouseAdapter
    implements Listener,
    MouseTrackListener {
        protected boolean switchDock = false;
        protected boolean dragging = false;
        protected int threshold;

        public TitleDragManager(Control ctrl) {
            ctrl.addListener(29, (Listener)this);
            ctrl.addMouseListener((MouseListener)this);
            ctrl.addMouseTrackListener((MouseTrackListener)this);
        }

        public void handleEvent(Event event) {
            this.dragging = true;
            this.switchDock = false;
            this.threshold = FlyoutPaletteComposite.this.dock == 16 ? 0x3FFFFFFF : -1;
            FlyoutPaletteComposite flyout = FlyoutPaletteComposite.this;
            org.eclipse.swt.graphics.Rectangle flyoutBounds = flyout.getBounds();
            int switchThreshold = flyoutBounds.x + flyoutBounds.width / 2;
            org.eclipse.swt.graphics.Rectangle bounds = FlyoutPaletteComposite.this.sash.getBounds();
            if (FlyoutPaletteComposite.this.paletteContainer.getVisible()) {
                bounds = bounds.union(FlyoutPaletteComposite.this.paletteContainer.getBounds());
            }
            org.eclipse.swt.graphics.Rectangle origBounds = Display.getCurrent().map((Control)flyout, null, bounds);
            Tracker tracker = new Tracker(Display.getDefault(), 0);
            tracker.setRectangles(new org.eclipse.swt.graphics.Rectangle[]{origBounds});
            tracker.setStippled(true);
            tracker.addListener(10, new Listener(this, flyout, switchThreshold, origBounds, flyoutBounds, tracker){
                final /* synthetic */ TitleDragManager this$1;
                private final /* synthetic */ Composite val$flyout;
                private final /* synthetic */ int val$switchThreshold;
                private final /* synthetic */ org.eclipse.swt.graphics.Rectangle val$origBounds;
                private final /* synthetic */ org.eclipse.swt.graphics.Rectangle val$flyoutBounds;
                private final /* synthetic */ Tracker val$tracker;
                {
                    this.this$1 = titleDragManager;
                    this.val$flyout = composite;
                    this.val$switchThreshold = n;
                    this.val$origBounds = rectangle;
                    this.val$flyoutBounds = rectangle2;
                    this.val$tracker = tracker;
                }

                public void handleEvent(Event evt) {
                    Display.getCurrent().syncExec(new Runnable(this, this.val$flyout, evt, this.val$switchThreshold, this.val$origBounds, this.val$flyoutBounds, this.val$tracker){
                        final /* synthetic */ 7 this$2;
                        private final /* synthetic */ Composite val$flyout;
                        private final /* synthetic */ Event val$evt;
                        private final /* synthetic */ int val$switchThreshold;
                        private final /* synthetic */ org.eclipse.swt.graphics.Rectangle val$origBounds;
                        private final /* synthetic */ org.eclipse.swt.graphics.Rectangle val$flyoutBounds;
                        private final /* synthetic */ Tracker val$tracker;
                        {
                            this.this$2 = var1_1;
                            this.val$flyout = composite;
                            this.val$evt = event;
                            this.val$switchThreshold = n;
                            this.val$origBounds = rectangle;
                            this.val$flyoutBounds = rectangle2;
                            this.val$tracker = tracker;
                        }

                        public void run() {
                            Control ctrl = Display.getCurrent().getCursorControl();
                            Point pt = this.val$flyout.toControl(this.val$evt.x, this.val$evt.y);
                            7.access$0(this.this$2).switchDock = FlyoutPaletteComposite.access$14(TitleDragManager.access$0(7.access$0(this.this$2)), FlyoutPaletteComposite.access$13(TitleDragManager.access$0(7.access$0(this.this$2))), ctrl) && (FlyoutPaletteComposite.access$8(TitleDragManager.access$0(7.access$0(this.this$2))) == 8 && pt.x > 7.access$0(this.this$2).threshold - 10 || FlyoutPaletteComposite.access$8(TitleDragManager.access$0(7.access$0(this.this$2))) == 16 && pt.x < 7.access$0(this.this$2).threshold + 10);
                            boolean invalid = false;
                            if (!7.access$0(this.this$2).switchDock) {
                                boolean bl = invalid = !FlyoutPaletteComposite.access$14(TitleDragManager.access$0(7.access$0(this.this$2)), (Control)TitleDragManager.access$0(7.access$0(this.this$2)), ctrl);
                            }
                            if (7.access$0(this.this$2).switchDock) {
                                if (FlyoutPaletteComposite.access$8(TitleDragManager.access$0(7.access$0(this.this$2))) == 8) {
                                    7.access$0(this.this$2).threshold = Math.max(7.access$0(this.this$2).threshold, pt.x);
                                    7.access$0(this.this$2).threshold = Math.min(7.access$0(this.this$2).threshold, this.val$switchThreshold);
                                } else {
                                    7.access$0(this.this$2).threshold = Math.min(7.access$0(this.this$2).threshold, pt.x);
                                    7.access$0(this.this$2).threshold = Math.max(7.access$0(this.this$2).threshold, this.val$switchThreshold);
                                }
                            }
                            org.eclipse.swt.graphics.Rectangle placeHolder = this.val$origBounds;
                            if (7.access$0(this.this$2).switchDock) {
                                placeHolder = FlyoutPaletteComposite.access$8(TitleDragManager.access$0(7.access$0(this.this$2))) == 16 ? new org.eclipse.swt.graphics.Rectangle(0, 0, this.val$origBounds.width, this.val$origBounds.height) : new org.eclipse.swt.graphics.Rectangle(this.val$flyoutBounds.width - this.val$origBounds.width, 0, this.val$origBounds.width, this.val$origBounds.height);
                                placeHolder = Display.getCurrent().map((Control)this.val$flyout, null, placeHolder);
                            }
                            int cursor = invalid ? 0 : (!7.access$0(this.this$2).switchDock && FlyoutPaletteComposite.access$8(TitleDragManager.access$0(7.access$0(this.this$2))) == 16 || 7.access$0(this.this$2).switchDock && FlyoutPaletteComposite.access$8(TitleDragManager.access$0(7.access$0(this.this$2))) == 8 ? 2 : 1);
                            if (FlyoutPaletteComposite.access$15(TitleDragManager.access$0(7.access$0(this.this$2)))) {
                                if (cursor == 2) {
                                    cursor = 1;
                                } else if (cursor == 1) {
                                    cursor = 2;
                                }
                            }
                            this.val$tracker.setCursor(DragCursors.getCursor(cursor));
                            if (!this.val$tracker.getRectangles()[0].equals((Object)placeHolder)) {
                                this.val$tracker.setRectangles(new org.eclipse.swt.graphics.Rectangle[]{placeHolder});
                            }
                        }
                    });
                }

                static /* synthetic */ TitleDragManager access$0(7 var0) {
                    return var0.this$1;
                }
            });
            if (tracker.open()) {
                if (this.switchDock) {
                    FlyoutPaletteComposite.this.setDockLocation(0x18 & ~FlyoutPaletteComposite.this.dock);
                }
                this.dragging = false;
            }
            tracker.dispose();
        }

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
        }

        public void mouseHover(MouseEvent e) {
            if (FlyoutPaletteComposite.this.isInState(2)) {
                FlyoutPaletteComposite.this.setState(1);
            }
        }

        public void mouseUp(MouseEvent me) {
            if (me.button != 1) {
                return;
            }
            if (FlyoutPaletteComposite.this.isInState(2)) {
                FlyoutPaletteComposite.this.setState(1);
            } else if (FlyoutPaletteComposite.this.isInState(1)) {
                FlyoutPaletteComposite.this.setState(2);
            }
        }

        static /* synthetic */ FlyoutPaletteComposite access$0(TitleDragManager titleDragManager) {
            return titleDragManager.FlyoutPaletteComposite.this;
        }
    }

    private static class TitleLabel
    extends Label {
        protected static final Border BORDER = new MarginBorder(4, 3, 4, 3);
        protected static final Border TOOL_TIP_BORDER = new MarginBorder(0, 2, 0, 2);

        public TitleLabel(boolean isHorizontal) {
            super(GEFMessages.Palette_Label, InternalImages.get("icons/palette_view.gif"));
            this.setLabelAlignment(1);
            this.setBorder(BORDER);
            Label tooltip = new Label(this.getText());
            tooltip.setBorder(TOOL_TIP_BORDER);
            this.setToolTip((IFigure)tooltip);
            this.setForegroundColor(ColorConstants.listForeground);
        }

        public IFigure getToolTip() {
            if (this.isTextTruncated()) {
                return super.getToolTip();
            }
            return null;
        }

        protected void paintFigure(Graphics graphics) {
            graphics.pushState();
            Rectangle r = Rectangle.SINGLETON;
            r.setBounds(this.getBounds());
            graphics.setForegroundColor(PaletteColorUtil.WIDGET_LIST_BACKGROUND);
            graphics.setBackgroundColor(PaletteColorUtil.WIDGET_BACKGROUND);
            graphics.fillGradient(r, true);
            graphics.setForegroundColor(PaletteColorUtil.WIDGET_NORMAL_SHADOW);
            graphics.drawLine(r.getBottomLeft().getTranslated(0, -1), r.getBottomRight().getTranslated(0, -1));
            graphics.popState();
            super.paintFigure(graphics);
            if (this.hasFocus()) {
                Rectangle textBounds = this.getTextBounds();
                --textBounds.width;
                graphics.drawFocus(this.bounds.getResized(-1, -1).intersect(textBounds.getExpanded(this.getInsets())));
            }
        }
    }
}

