
/*
 * Copyright © 2012 - 2014 Intel Corporatio
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __OCL_CONVERT_H__
#define __OCL_CONVERT_H__
#include "ocl_types.h"

OVERLOADABLE long convert_long(long v);
OVERLOADABLE ulong convert_ulong(long v);
OVERLOADABLE int convert_int(long v);
OVERLOADABLE uint convert_uint(long v);
OVERLOADABLE short convert_short(long v);
OVERLOADABLE ushort convert_ushort(long v);
OVERLOADABLE char convert_char(long v);
OVERLOADABLE uchar convert_uchar(long v);
OVERLOADABLE double convert_double(long v);
OVERLOADABLE float convert_float(long v);
OVERLOADABLE half convert_half(long v);
OVERLOADABLE long convert_long(ulong v);
OVERLOADABLE ulong convert_ulong(ulong v);
OVERLOADABLE int convert_int(ulong v);
OVERLOADABLE uint convert_uint(ulong v);
OVERLOADABLE short convert_short(ulong v);
OVERLOADABLE ushort convert_ushort(ulong v);
OVERLOADABLE char convert_char(ulong v);
OVERLOADABLE uchar convert_uchar(ulong v);
OVERLOADABLE double convert_double(ulong v);
OVERLOADABLE float convert_float(ulong v);
OVERLOADABLE half convert_half(ulong v);
OVERLOADABLE long convert_long(int v);
OVERLOADABLE ulong convert_ulong(int v);
OVERLOADABLE int convert_int(int v);
OVERLOADABLE uint convert_uint(int v);
OVERLOADABLE short convert_short(int v);
OVERLOADABLE ushort convert_ushort(int v);
OVERLOADABLE char convert_char(int v);
OVERLOADABLE uchar convert_uchar(int v);
OVERLOADABLE double convert_double(int v);
OVERLOADABLE float convert_float(int v);
OVERLOADABLE half convert_half(int v);
OVERLOADABLE long convert_long(uint v);
OVERLOADABLE ulong convert_ulong(uint v);
OVERLOADABLE int convert_int(uint v);
OVERLOADABLE uint convert_uint(uint v);
OVERLOADABLE short convert_short(uint v);
OVERLOADABLE ushort convert_ushort(uint v);
OVERLOADABLE char convert_char(uint v);
OVERLOADABLE uchar convert_uchar(uint v);
OVERLOADABLE double convert_double(uint v);
OVERLOADABLE float convert_float(uint v);
OVERLOADABLE half convert_half(uint v);
OVERLOADABLE long convert_long(short v);
OVERLOADABLE ulong convert_ulong(short v);
OVERLOADABLE int convert_int(short v);
OVERLOADABLE uint convert_uint(short v);
OVERLOADABLE short convert_short(short v);
OVERLOADABLE ushort convert_ushort(short v);
OVERLOADABLE char convert_char(short v);
OVERLOADABLE uchar convert_uchar(short v);
OVERLOADABLE double convert_double(short v);
OVERLOADABLE float convert_float(short v);
OVERLOADABLE half convert_half(short v);
OVERLOADABLE long convert_long(ushort v);
OVERLOADABLE ulong convert_ulong(ushort v);
OVERLOADABLE int convert_int(ushort v);
OVERLOADABLE uint convert_uint(ushort v);
OVERLOADABLE short convert_short(ushort v);
OVERLOADABLE ushort convert_ushort(ushort v);
OVERLOADABLE char convert_char(ushort v);
OVERLOADABLE uchar convert_uchar(ushort v);
OVERLOADABLE double convert_double(ushort v);
OVERLOADABLE float convert_float(ushort v);
OVERLOADABLE half convert_half(ushort v);
OVERLOADABLE long convert_long(char v);
OVERLOADABLE ulong convert_ulong(char v);
OVERLOADABLE int convert_int(char v);
OVERLOADABLE uint convert_uint(char v);
OVERLOADABLE short convert_short(char v);
OVERLOADABLE ushort convert_ushort(char v);
OVERLOADABLE char convert_char(char v);
OVERLOADABLE uchar convert_uchar(char v);
OVERLOADABLE double convert_double(char v);
OVERLOADABLE float convert_float(char v);
OVERLOADABLE half convert_half(char v);
OVERLOADABLE long convert_long(uchar v);
OVERLOADABLE ulong convert_ulong(uchar v);
OVERLOADABLE int convert_int(uchar v);
OVERLOADABLE uint convert_uint(uchar v);
OVERLOADABLE short convert_short(uchar v);
OVERLOADABLE ushort convert_ushort(uchar v);
OVERLOADABLE char convert_char(uchar v);
OVERLOADABLE uchar convert_uchar(uchar v);
OVERLOADABLE double convert_double(uchar v);
OVERLOADABLE float convert_float(uchar v);
OVERLOADABLE half convert_half(uchar v);
OVERLOADABLE long convert_long(double v);
OVERLOADABLE ulong convert_ulong(double v);
OVERLOADABLE int convert_int(double v);
OVERLOADABLE uint convert_uint(double v);
OVERLOADABLE short convert_short(double v);
OVERLOADABLE ushort convert_ushort(double v);
OVERLOADABLE char convert_char(double v);
OVERLOADABLE uchar convert_uchar(double v);
OVERLOADABLE double convert_double(double v);
OVERLOADABLE float convert_float(double v);
OVERLOADABLE half convert_half(double v);
OVERLOADABLE long convert_long(float v);
OVERLOADABLE ulong convert_ulong(float v);
OVERLOADABLE int convert_int(float v);
OVERLOADABLE uint convert_uint(float v);
OVERLOADABLE short convert_short(float v);
OVERLOADABLE ushort convert_ushort(float v);
OVERLOADABLE char convert_char(float v);
OVERLOADABLE uchar convert_uchar(float v);
OVERLOADABLE double convert_double(float v);
OVERLOADABLE float convert_float(float v);
OVERLOADABLE half convert_half(float v);
OVERLOADABLE long convert_long(half v);
OVERLOADABLE ulong convert_ulong(half v);
OVERLOADABLE int convert_int(half v);
OVERLOADABLE uint convert_uint(half v);
OVERLOADABLE short convert_short(half v);
OVERLOADABLE ushort convert_ushort(half v);
OVERLOADABLE char convert_char(half v);
OVERLOADABLE uchar convert_uchar(half v);
OVERLOADABLE double convert_double(half v);
OVERLOADABLE float convert_float(half v);
OVERLOADABLE half convert_half(half v);
OVERLOADABLE long2 convert_long2(long2 v);
OVERLOADABLE ulong2 convert_ulong2(long2 v);
OVERLOADABLE int2 convert_int2(long2 v);
OVERLOADABLE uint2 convert_uint2(long2 v);
OVERLOADABLE short2 convert_short2(long2 v);
OVERLOADABLE ushort2 convert_ushort2(long2 v);
OVERLOADABLE char2 convert_char2(long2 v);
OVERLOADABLE uchar2 convert_uchar2(long2 v);
OVERLOADABLE double2 convert_double2(long2 v);
OVERLOADABLE float2 convert_float2(long2 v);
OVERLOADABLE half2 convert_half2(long2 v);
OVERLOADABLE long2 convert_long2(ulong2 v);
OVERLOADABLE ulong2 convert_ulong2(ulong2 v);
OVERLOADABLE int2 convert_int2(ulong2 v);
OVERLOADABLE uint2 convert_uint2(ulong2 v);
OVERLOADABLE short2 convert_short2(ulong2 v);
OVERLOADABLE ushort2 convert_ushort2(ulong2 v);
OVERLOADABLE char2 convert_char2(ulong2 v);
OVERLOADABLE uchar2 convert_uchar2(ulong2 v);
OVERLOADABLE double2 convert_double2(ulong2 v);
OVERLOADABLE float2 convert_float2(ulong2 v);
OVERLOADABLE half2 convert_half2(ulong2 v);
OVERLOADABLE long2 convert_long2(int2 v);
OVERLOADABLE ulong2 convert_ulong2(int2 v);
OVERLOADABLE int2 convert_int2(int2 v);
OVERLOADABLE uint2 convert_uint2(int2 v);
OVERLOADABLE short2 convert_short2(int2 v);
OVERLOADABLE ushort2 convert_ushort2(int2 v);
OVERLOADABLE char2 convert_char2(int2 v);
OVERLOADABLE uchar2 convert_uchar2(int2 v);
OVERLOADABLE double2 convert_double2(int2 v);
OVERLOADABLE float2 convert_float2(int2 v);
OVERLOADABLE half2 convert_half2(int2 v);
OVERLOADABLE long2 convert_long2(uint2 v);
OVERLOADABLE ulong2 convert_ulong2(uint2 v);
OVERLOADABLE int2 convert_int2(uint2 v);
OVERLOADABLE uint2 convert_uint2(uint2 v);
OVERLOADABLE short2 convert_short2(uint2 v);
OVERLOADABLE ushort2 convert_ushort2(uint2 v);
OVERLOADABLE char2 convert_char2(uint2 v);
OVERLOADABLE uchar2 convert_uchar2(uint2 v);
OVERLOADABLE double2 convert_double2(uint2 v);
OVERLOADABLE float2 convert_float2(uint2 v);
OVERLOADABLE half2 convert_half2(uint2 v);
OVERLOADABLE long2 convert_long2(short2 v);
OVERLOADABLE ulong2 convert_ulong2(short2 v);
OVERLOADABLE int2 convert_int2(short2 v);
OVERLOADABLE uint2 convert_uint2(short2 v);
OVERLOADABLE short2 convert_short2(short2 v);
OVERLOADABLE ushort2 convert_ushort2(short2 v);
OVERLOADABLE char2 convert_char2(short2 v);
OVERLOADABLE uchar2 convert_uchar2(short2 v);
OVERLOADABLE double2 convert_double2(short2 v);
OVERLOADABLE float2 convert_float2(short2 v);
OVERLOADABLE half2 convert_half2(short2 v);
OVERLOADABLE long2 convert_long2(ushort2 v);
OVERLOADABLE ulong2 convert_ulong2(ushort2 v);
OVERLOADABLE int2 convert_int2(ushort2 v);
OVERLOADABLE uint2 convert_uint2(ushort2 v);
OVERLOADABLE short2 convert_short2(ushort2 v);
OVERLOADABLE ushort2 convert_ushort2(ushort2 v);
OVERLOADABLE char2 convert_char2(ushort2 v);
OVERLOADABLE uchar2 convert_uchar2(ushort2 v);
OVERLOADABLE double2 convert_double2(ushort2 v);
OVERLOADABLE float2 convert_float2(ushort2 v);
OVERLOADABLE half2 convert_half2(ushort2 v);
OVERLOADABLE long2 convert_long2(char2 v);
OVERLOADABLE ulong2 convert_ulong2(char2 v);
OVERLOADABLE int2 convert_int2(char2 v);
OVERLOADABLE uint2 convert_uint2(char2 v);
OVERLOADABLE short2 convert_short2(char2 v);
OVERLOADABLE ushort2 convert_ushort2(char2 v);
OVERLOADABLE char2 convert_char2(char2 v);
OVERLOADABLE uchar2 convert_uchar2(char2 v);
OVERLOADABLE double2 convert_double2(char2 v);
OVERLOADABLE float2 convert_float2(char2 v);
OVERLOADABLE half2 convert_half2(char2 v);
OVERLOADABLE long2 convert_long2(uchar2 v);
OVERLOADABLE ulong2 convert_ulong2(uchar2 v);
OVERLOADABLE int2 convert_int2(uchar2 v);
OVERLOADABLE uint2 convert_uint2(uchar2 v);
OVERLOADABLE short2 convert_short2(uchar2 v);
OVERLOADABLE ushort2 convert_ushort2(uchar2 v);
OVERLOADABLE char2 convert_char2(uchar2 v);
OVERLOADABLE uchar2 convert_uchar2(uchar2 v);
OVERLOADABLE double2 convert_double2(uchar2 v);
OVERLOADABLE float2 convert_float2(uchar2 v);
OVERLOADABLE half2 convert_half2(uchar2 v);
OVERLOADABLE long2 convert_long2(double2 v);
OVERLOADABLE ulong2 convert_ulong2(double2 v);
OVERLOADABLE int2 convert_int2(double2 v);
OVERLOADABLE uint2 convert_uint2(double2 v);
OVERLOADABLE short2 convert_short2(double2 v);
OVERLOADABLE ushort2 convert_ushort2(double2 v);
OVERLOADABLE char2 convert_char2(double2 v);
OVERLOADABLE uchar2 convert_uchar2(double2 v);
OVERLOADABLE double2 convert_double2(double2 v);
OVERLOADABLE float2 convert_float2(double2 v);
OVERLOADABLE half2 convert_half2(double2 v);
OVERLOADABLE long2 convert_long2(float2 v);
OVERLOADABLE ulong2 convert_ulong2(float2 v);
OVERLOADABLE int2 convert_int2(float2 v);
OVERLOADABLE uint2 convert_uint2(float2 v);
OVERLOADABLE short2 convert_short2(float2 v);
OVERLOADABLE ushort2 convert_ushort2(float2 v);
OVERLOADABLE char2 convert_char2(float2 v);
OVERLOADABLE uchar2 convert_uchar2(float2 v);
OVERLOADABLE double2 convert_double2(float2 v);
OVERLOADABLE float2 convert_float2(float2 v);
OVERLOADABLE half2 convert_half2(float2 v);
OVERLOADABLE long2 convert_long2(half2 v);
OVERLOADABLE ulong2 convert_ulong2(half2 v);
OVERLOADABLE int2 convert_int2(half2 v);
OVERLOADABLE uint2 convert_uint2(half2 v);
OVERLOADABLE short2 convert_short2(half2 v);
OVERLOADABLE ushort2 convert_ushort2(half2 v);
OVERLOADABLE char2 convert_char2(half2 v);
OVERLOADABLE uchar2 convert_uchar2(half2 v);
OVERLOADABLE double2 convert_double2(half2 v);
OVERLOADABLE float2 convert_float2(half2 v);
OVERLOADABLE half2 convert_half2(half2 v);
OVERLOADABLE long3 convert_long3(long3 v);
OVERLOADABLE ulong3 convert_ulong3(long3 v);
OVERLOADABLE int3 convert_int3(long3 v);
OVERLOADABLE uint3 convert_uint3(long3 v);
OVERLOADABLE short3 convert_short3(long3 v);
OVERLOADABLE ushort3 convert_ushort3(long3 v);
OVERLOADABLE char3 convert_char3(long3 v);
OVERLOADABLE uchar3 convert_uchar3(long3 v);
OVERLOADABLE double3 convert_double3(long3 v);
OVERLOADABLE float3 convert_float3(long3 v);
OVERLOADABLE half3 convert_half3(long3 v);
OVERLOADABLE long3 convert_long3(ulong3 v);
OVERLOADABLE ulong3 convert_ulong3(ulong3 v);
OVERLOADABLE int3 convert_int3(ulong3 v);
OVERLOADABLE uint3 convert_uint3(ulong3 v);
OVERLOADABLE short3 convert_short3(ulong3 v);
OVERLOADABLE ushort3 convert_ushort3(ulong3 v);
OVERLOADABLE char3 convert_char3(ulong3 v);
OVERLOADABLE uchar3 convert_uchar3(ulong3 v);
OVERLOADABLE double3 convert_double3(ulong3 v);
OVERLOADABLE float3 convert_float3(ulong3 v);
OVERLOADABLE half3 convert_half3(ulong3 v);
OVERLOADABLE long3 convert_long3(int3 v);
OVERLOADABLE ulong3 convert_ulong3(int3 v);
OVERLOADABLE int3 convert_int3(int3 v);
OVERLOADABLE uint3 convert_uint3(int3 v);
OVERLOADABLE short3 convert_short3(int3 v);
OVERLOADABLE ushort3 convert_ushort3(int3 v);
OVERLOADABLE char3 convert_char3(int3 v);
OVERLOADABLE uchar3 convert_uchar3(int3 v);
OVERLOADABLE double3 convert_double3(int3 v);
OVERLOADABLE float3 convert_float3(int3 v);
OVERLOADABLE half3 convert_half3(int3 v);
OVERLOADABLE long3 convert_long3(uint3 v);
OVERLOADABLE ulong3 convert_ulong3(uint3 v);
OVERLOADABLE int3 convert_int3(uint3 v);
OVERLOADABLE uint3 convert_uint3(uint3 v);
OVERLOADABLE short3 convert_short3(uint3 v);
OVERLOADABLE ushort3 convert_ushort3(uint3 v);
OVERLOADABLE char3 convert_char3(uint3 v);
OVERLOADABLE uchar3 convert_uchar3(uint3 v);
OVERLOADABLE double3 convert_double3(uint3 v);
OVERLOADABLE float3 convert_float3(uint3 v);
OVERLOADABLE half3 convert_half3(uint3 v);
OVERLOADABLE long3 convert_long3(short3 v);
OVERLOADABLE ulong3 convert_ulong3(short3 v);
OVERLOADABLE int3 convert_int3(short3 v);
OVERLOADABLE uint3 convert_uint3(short3 v);
OVERLOADABLE short3 convert_short3(short3 v);
OVERLOADABLE ushort3 convert_ushort3(short3 v);
OVERLOADABLE char3 convert_char3(short3 v);
OVERLOADABLE uchar3 convert_uchar3(short3 v);
OVERLOADABLE double3 convert_double3(short3 v);
OVERLOADABLE float3 convert_float3(short3 v);
OVERLOADABLE half3 convert_half3(short3 v);
OVERLOADABLE long3 convert_long3(ushort3 v);
OVERLOADABLE ulong3 convert_ulong3(ushort3 v);
OVERLOADABLE int3 convert_int3(ushort3 v);
OVERLOADABLE uint3 convert_uint3(ushort3 v);
OVERLOADABLE short3 convert_short3(ushort3 v);
OVERLOADABLE ushort3 convert_ushort3(ushort3 v);
OVERLOADABLE char3 convert_char3(ushort3 v);
OVERLOADABLE uchar3 convert_uchar3(ushort3 v);
OVERLOADABLE double3 convert_double3(ushort3 v);
OVERLOADABLE float3 convert_float3(ushort3 v);
OVERLOADABLE half3 convert_half3(ushort3 v);
OVERLOADABLE long3 convert_long3(char3 v);
OVERLOADABLE ulong3 convert_ulong3(char3 v);
OVERLOADABLE int3 convert_int3(char3 v);
OVERLOADABLE uint3 convert_uint3(char3 v);
OVERLOADABLE short3 convert_short3(char3 v);
OVERLOADABLE ushort3 convert_ushort3(char3 v);
OVERLOADABLE char3 convert_char3(char3 v);
OVERLOADABLE uchar3 convert_uchar3(char3 v);
OVERLOADABLE double3 convert_double3(char3 v);
OVERLOADABLE float3 convert_float3(char3 v);
OVERLOADABLE half3 convert_half3(char3 v);
OVERLOADABLE long3 convert_long3(uchar3 v);
OVERLOADABLE ulong3 convert_ulong3(uchar3 v);
OVERLOADABLE int3 convert_int3(uchar3 v);
OVERLOADABLE uint3 convert_uint3(uchar3 v);
OVERLOADABLE short3 convert_short3(uchar3 v);
OVERLOADABLE ushort3 convert_ushort3(uchar3 v);
OVERLOADABLE char3 convert_char3(uchar3 v);
OVERLOADABLE uchar3 convert_uchar3(uchar3 v);
OVERLOADABLE double3 convert_double3(uchar3 v);
OVERLOADABLE float3 convert_float3(uchar3 v);
OVERLOADABLE half3 convert_half3(uchar3 v);
OVERLOADABLE long3 convert_long3(double3 v);
OVERLOADABLE ulong3 convert_ulong3(double3 v);
OVERLOADABLE int3 convert_int3(double3 v);
OVERLOADABLE uint3 convert_uint3(double3 v);
OVERLOADABLE short3 convert_short3(double3 v);
OVERLOADABLE ushort3 convert_ushort3(double3 v);
OVERLOADABLE char3 convert_char3(double3 v);
OVERLOADABLE uchar3 convert_uchar3(double3 v);
OVERLOADABLE double3 convert_double3(double3 v);
OVERLOADABLE float3 convert_float3(double3 v);
OVERLOADABLE half3 convert_half3(double3 v);
OVERLOADABLE long3 convert_long3(float3 v);
OVERLOADABLE ulong3 convert_ulong3(float3 v);
OVERLOADABLE int3 convert_int3(float3 v);
OVERLOADABLE uint3 convert_uint3(float3 v);
OVERLOADABLE short3 convert_short3(float3 v);
OVERLOADABLE ushort3 convert_ushort3(float3 v);
OVERLOADABLE char3 convert_char3(float3 v);
OVERLOADABLE uchar3 convert_uchar3(float3 v);
OVERLOADABLE double3 convert_double3(float3 v);
OVERLOADABLE float3 convert_float3(float3 v);
OVERLOADABLE half3 convert_half3(float3 v);
OVERLOADABLE long3 convert_long3(half3 v);
OVERLOADABLE ulong3 convert_ulong3(half3 v);
OVERLOADABLE int3 convert_int3(half3 v);
OVERLOADABLE uint3 convert_uint3(half3 v);
OVERLOADABLE short3 convert_short3(half3 v);
OVERLOADABLE ushort3 convert_ushort3(half3 v);
OVERLOADABLE char3 convert_char3(half3 v);
OVERLOADABLE uchar3 convert_uchar3(half3 v);
OVERLOADABLE double3 convert_double3(half3 v);
OVERLOADABLE float3 convert_float3(half3 v);
OVERLOADABLE half3 convert_half3(half3 v);
OVERLOADABLE long4 convert_long4(long4 v);
OVERLOADABLE ulong4 convert_ulong4(long4 v);
OVERLOADABLE int4 convert_int4(long4 v);
OVERLOADABLE uint4 convert_uint4(long4 v);
OVERLOADABLE short4 convert_short4(long4 v);
OVERLOADABLE ushort4 convert_ushort4(long4 v);
OVERLOADABLE char4 convert_char4(long4 v);
OVERLOADABLE uchar4 convert_uchar4(long4 v);
OVERLOADABLE double4 convert_double4(long4 v);
OVERLOADABLE float4 convert_float4(long4 v);
OVERLOADABLE half4 convert_half4(long4 v);
OVERLOADABLE long4 convert_long4(ulong4 v);
OVERLOADABLE ulong4 convert_ulong4(ulong4 v);
OVERLOADABLE int4 convert_int4(ulong4 v);
OVERLOADABLE uint4 convert_uint4(ulong4 v);
OVERLOADABLE short4 convert_short4(ulong4 v);
OVERLOADABLE ushort4 convert_ushort4(ulong4 v);
OVERLOADABLE char4 convert_char4(ulong4 v);
OVERLOADABLE uchar4 convert_uchar4(ulong4 v);
OVERLOADABLE double4 convert_double4(ulong4 v);
OVERLOADABLE float4 convert_float4(ulong4 v);
OVERLOADABLE half4 convert_half4(ulong4 v);
OVERLOADABLE long4 convert_long4(int4 v);
OVERLOADABLE ulong4 convert_ulong4(int4 v);
OVERLOADABLE int4 convert_int4(int4 v);
OVERLOADABLE uint4 convert_uint4(int4 v);
OVERLOADABLE short4 convert_short4(int4 v);
OVERLOADABLE ushort4 convert_ushort4(int4 v);
OVERLOADABLE char4 convert_char4(int4 v);
OVERLOADABLE uchar4 convert_uchar4(int4 v);
OVERLOADABLE double4 convert_double4(int4 v);
OVERLOADABLE float4 convert_float4(int4 v);
OVERLOADABLE half4 convert_half4(int4 v);
OVERLOADABLE long4 convert_long4(uint4 v);
OVERLOADABLE ulong4 convert_ulong4(uint4 v);
OVERLOADABLE int4 convert_int4(uint4 v);
OVERLOADABLE uint4 convert_uint4(uint4 v);
OVERLOADABLE short4 convert_short4(uint4 v);
OVERLOADABLE ushort4 convert_ushort4(uint4 v);
OVERLOADABLE char4 convert_char4(uint4 v);
OVERLOADABLE uchar4 convert_uchar4(uint4 v);
OVERLOADABLE double4 convert_double4(uint4 v);
OVERLOADABLE float4 convert_float4(uint4 v);
OVERLOADABLE half4 convert_half4(uint4 v);
OVERLOADABLE long4 convert_long4(short4 v);
OVERLOADABLE ulong4 convert_ulong4(short4 v);
OVERLOADABLE int4 convert_int4(short4 v);
OVERLOADABLE uint4 convert_uint4(short4 v);
OVERLOADABLE short4 convert_short4(short4 v);
OVERLOADABLE ushort4 convert_ushort4(short4 v);
OVERLOADABLE char4 convert_char4(short4 v);
OVERLOADABLE uchar4 convert_uchar4(short4 v);
OVERLOADABLE double4 convert_double4(short4 v);
OVERLOADABLE float4 convert_float4(short4 v);
OVERLOADABLE half4 convert_half4(short4 v);
OVERLOADABLE long4 convert_long4(ushort4 v);
OVERLOADABLE ulong4 convert_ulong4(ushort4 v);
OVERLOADABLE int4 convert_int4(ushort4 v);
OVERLOADABLE uint4 convert_uint4(ushort4 v);
OVERLOADABLE short4 convert_short4(ushort4 v);
OVERLOADABLE ushort4 convert_ushort4(ushort4 v);
OVERLOADABLE char4 convert_char4(ushort4 v);
OVERLOADABLE uchar4 convert_uchar4(ushort4 v);
OVERLOADABLE double4 convert_double4(ushort4 v);
OVERLOADABLE float4 convert_float4(ushort4 v);
OVERLOADABLE half4 convert_half4(ushort4 v);
OVERLOADABLE long4 convert_long4(char4 v);
OVERLOADABLE ulong4 convert_ulong4(char4 v);
OVERLOADABLE int4 convert_int4(char4 v);
OVERLOADABLE uint4 convert_uint4(char4 v);
OVERLOADABLE short4 convert_short4(char4 v);
OVERLOADABLE ushort4 convert_ushort4(char4 v);
OVERLOADABLE char4 convert_char4(char4 v);
OVERLOADABLE uchar4 convert_uchar4(char4 v);
OVERLOADABLE double4 convert_double4(char4 v);
OVERLOADABLE float4 convert_float4(char4 v);
OVERLOADABLE half4 convert_half4(char4 v);
OVERLOADABLE long4 convert_long4(uchar4 v);
OVERLOADABLE ulong4 convert_ulong4(uchar4 v);
OVERLOADABLE int4 convert_int4(uchar4 v);
OVERLOADABLE uint4 convert_uint4(uchar4 v);
OVERLOADABLE short4 convert_short4(uchar4 v);
OVERLOADABLE ushort4 convert_ushort4(uchar4 v);
OVERLOADABLE char4 convert_char4(uchar4 v);
OVERLOADABLE uchar4 convert_uchar4(uchar4 v);
OVERLOADABLE double4 convert_double4(uchar4 v);
OVERLOADABLE float4 convert_float4(uchar4 v);
OVERLOADABLE half4 convert_half4(uchar4 v);
OVERLOADABLE long4 convert_long4(double4 v);
OVERLOADABLE ulong4 convert_ulong4(double4 v);
OVERLOADABLE int4 convert_int4(double4 v);
OVERLOADABLE uint4 convert_uint4(double4 v);
OVERLOADABLE short4 convert_short4(double4 v);
OVERLOADABLE ushort4 convert_ushort4(double4 v);
OVERLOADABLE char4 convert_char4(double4 v);
OVERLOADABLE uchar4 convert_uchar4(double4 v);
OVERLOADABLE double4 convert_double4(double4 v);
OVERLOADABLE float4 convert_float4(double4 v);
OVERLOADABLE half4 convert_half4(double4 v);
OVERLOADABLE long4 convert_long4(float4 v);
OVERLOADABLE ulong4 convert_ulong4(float4 v);
OVERLOADABLE int4 convert_int4(float4 v);
OVERLOADABLE uint4 convert_uint4(float4 v);
OVERLOADABLE short4 convert_short4(float4 v);
OVERLOADABLE ushort4 convert_ushort4(float4 v);
OVERLOADABLE char4 convert_char4(float4 v);
OVERLOADABLE uchar4 convert_uchar4(float4 v);
OVERLOADABLE double4 convert_double4(float4 v);
OVERLOADABLE float4 convert_float4(float4 v);
OVERLOADABLE half4 convert_half4(float4 v);
OVERLOADABLE long4 convert_long4(half4 v);
OVERLOADABLE ulong4 convert_ulong4(half4 v);
OVERLOADABLE int4 convert_int4(half4 v);
OVERLOADABLE uint4 convert_uint4(half4 v);
OVERLOADABLE short4 convert_short4(half4 v);
OVERLOADABLE ushort4 convert_ushort4(half4 v);
OVERLOADABLE char4 convert_char4(half4 v);
OVERLOADABLE uchar4 convert_uchar4(half4 v);
OVERLOADABLE double4 convert_double4(half4 v);
OVERLOADABLE float4 convert_float4(half4 v);
OVERLOADABLE half4 convert_half4(half4 v);
OVERLOADABLE long8 convert_long8(long8 v);
OVERLOADABLE ulong8 convert_ulong8(long8 v);
OVERLOADABLE int8 convert_int8(long8 v);
OVERLOADABLE uint8 convert_uint8(long8 v);
OVERLOADABLE short8 convert_short8(long8 v);
OVERLOADABLE ushort8 convert_ushort8(long8 v);
OVERLOADABLE char8 convert_char8(long8 v);
OVERLOADABLE uchar8 convert_uchar8(long8 v);
OVERLOADABLE double8 convert_double8(long8 v);
OVERLOADABLE float8 convert_float8(long8 v);
OVERLOADABLE half8 convert_half8(long8 v);
OVERLOADABLE long8 convert_long8(ulong8 v);
OVERLOADABLE ulong8 convert_ulong8(ulong8 v);
OVERLOADABLE int8 convert_int8(ulong8 v);
OVERLOADABLE uint8 convert_uint8(ulong8 v);
OVERLOADABLE short8 convert_short8(ulong8 v);
OVERLOADABLE ushort8 convert_ushort8(ulong8 v);
OVERLOADABLE char8 convert_char8(ulong8 v);
OVERLOADABLE uchar8 convert_uchar8(ulong8 v);
OVERLOADABLE double8 convert_double8(ulong8 v);
OVERLOADABLE float8 convert_float8(ulong8 v);
OVERLOADABLE half8 convert_half8(ulong8 v);
OVERLOADABLE long8 convert_long8(int8 v);
OVERLOADABLE ulong8 convert_ulong8(int8 v);
OVERLOADABLE int8 convert_int8(int8 v);
OVERLOADABLE uint8 convert_uint8(int8 v);
OVERLOADABLE short8 convert_short8(int8 v);
OVERLOADABLE ushort8 convert_ushort8(int8 v);
OVERLOADABLE char8 convert_char8(int8 v);
OVERLOADABLE uchar8 convert_uchar8(int8 v);
OVERLOADABLE double8 convert_double8(int8 v);
OVERLOADABLE float8 convert_float8(int8 v);
OVERLOADABLE half8 convert_half8(int8 v);
OVERLOADABLE long8 convert_long8(uint8 v);
OVERLOADABLE ulong8 convert_ulong8(uint8 v);
OVERLOADABLE int8 convert_int8(uint8 v);
OVERLOADABLE uint8 convert_uint8(uint8 v);
OVERLOADABLE short8 convert_short8(uint8 v);
OVERLOADABLE ushort8 convert_ushort8(uint8 v);
OVERLOADABLE char8 convert_char8(uint8 v);
OVERLOADABLE uchar8 convert_uchar8(uint8 v);
OVERLOADABLE double8 convert_double8(uint8 v);
OVERLOADABLE float8 convert_float8(uint8 v);
OVERLOADABLE half8 convert_half8(uint8 v);
OVERLOADABLE long8 convert_long8(short8 v);
OVERLOADABLE ulong8 convert_ulong8(short8 v);
OVERLOADABLE int8 convert_int8(short8 v);
OVERLOADABLE uint8 convert_uint8(short8 v);
OVERLOADABLE short8 convert_short8(short8 v);
OVERLOADABLE ushort8 convert_ushort8(short8 v);
OVERLOADABLE char8 convert_char8(short8 v);
OVERLOADABLE uchar8 convert_uchar8(short8 v);
OVERLOADABLE double8 convert_double8(short8 v);
OVERLOADABLE float8 convert_float8(short8 v);
OVERLOADABLE half8 convert_half8(short8 v);
OVERLOADABLE long8 convert_long8(ushort8 v);
OVERLOADABLE ulong8 convert_ulong8(ushort8 v);
OVERLOADABLE int8 convert_int8(ushort8 v);
OVERLOADABLE uint8 convert_uint8(ushort8 v);
OVERLOADABLE short8 convert_short8(ushort8 v);
OVERLOADABLE ushort8 convert_ushort8(ushort8 v);
OVERLOADABLE char8 convert_char8(ushort8 v);
OVERLOADABLE uchar8 convert_uchar8(ushort8 v);
OVERLOADABLE double8 convert_double8(ushort8 v);
OVERLOADABLE float8 convert_float8(ushort8 v);
OVERLOADABLE half8 convert_half8(ushort8 v);
OVERLOADABLE long8 convert_long8(char8 v);
OVERLOADABLE ulong8 convert_ulong8(char8 v);
OVERLOADABLE int8 convert_int8(char8 v);
OVERLOADABLE uint8 convert_uint8(char8 v);
OVERLOADABLE short8 convert_short8(char8 v);
OVERLOADABLE ushort8 convert_ushort8(char8 v);
OVERLOADABLE char8 convert_char8(char8 v);
OVERLOADABLE uchar8 convert_uchar8(char8 v);
OVERLOADABLE double8 convert_double8(char8 v);
OVERLOADABLE float8 convert_float8(char8 v);
OVERLOADABLE half8 convert_half8(char8 v);
OVERLOADABLE long8 convert_long8(uchar8 v);
OVERLOADABLE ulong8 convert_ulong8(uchar8 v);
OVERLOADABLE int8 convert_int8(uchar8 v);
OVERLOADABLE uint8 convert_uint8(uchar8 v);
OVERLOADABLE short8 convert_short8(uchar8 v);
OVERLOADABLE ushort8 convert_ushort8(uchar8 v);
OVERLOADABLE char8 convert_char8(uchar8 v);
OVERLOADABLE uchar8 convert_uchar8(uchar8 v);
OVERLOADABLE double8 convert_double8(uchar8 v);
OVERLOADABLE float8 convert_float8(uchar8 v);
OVERLOADABLE half8 convert_half8(uchar8 v);
OVERLOADABLE long8 convert_long8(double8 v);
OVERLOADABLE ulong8 convert_ulong8(double8 v);
OVERLOADABLE int8 convert_int8(double8 v);
OVERLOADABLE uint8 convert_uint8(double8 v);
OVERLOADABLE short8 convert_short8(double8 v);
OVERLOADABLE ushort8 convert_ushort8(double8 v);
OVERLOADABLE char8 convert_char8(double8 v);
OVERLOADABLE uchar8 convert_uchar8(double8 v);
OVERLOADABLE double8 convert_double8(double8 v);
OVERLOADABLE float8 convert_float8(double8 v);
OVERLOADABLE half8 convert_half8(double8 v);
OVERLOADABLE long8 convert_long8(float8 v);
OVERLOADABLE ulong8 convert_ulong8(float8 v);
OVERLOADABLE int8 convert_int8(float8 v);
OVERLOADABLE uint8 convert_uint8(float8 v);
OVERLOADABLE short8 convert_short8(float8 v);
OVERLOADABLE ushort8 convert_ushort8(float8 v);
OVERLOADABLE char8 convert_char8(float8 v);
OVERLOADABLE uchar8 convert_uchar8(float8 v);
OVERLOADABLE double8 convert_double8(float8 v);
OVERLOADABLE float8 convert_float8(float8 v);
OVERLOADABLE half8 convert_half8(float8 v);
OVERLOADABLE long8 convert_long8(half8 v);
OVERLOADABLE ulong8 convert_ulong8(half8 v);
OVERLOADABLE int8 convert_int8(half8 v);
OVERLOADABLE uint8 convert_uint8(half8 v);
OVERLOADABLE short8 convert_short8(half8 v);
OVERLOADABLE ushort8 convert_ushort8(half8 v);
OVERLOADABLE char8 convert_char8(half8 v);
OVERLOADABLE uchar8 convert_uchar8(half8 v);
OVERLOADABLE double8 convert_double8(half8 v);
OVERLOADABLE float8 convert_float8(half8 v);
OVERLOADABLE half8 convert_half8(half8 v);
OVERLOADABLE long16 convert_long16(long16 v);
OVERLOADABLE ulong16 convert_ulong16(long16 v);
OVERLOADABLE int16 convert_int16(long16 v);
OVERLOADABLE uint16 convert_uint16(long16 v);
OVERLOADABLE short16 convert_short16(long16 v);
OVERLOADABLE ushort16 convert_ushort16(long16 v);
OVERLOADABLE char16 convert_char16(long16 v);
OVERLOADABLE uchar16 convert_uchar16(long16 v);
OVERLOADABLE double16 convert_double16(long16 v);
OVERLOADABLE float16 convert_float16(long16 v);
OVERLOADABLE half16 convert_half16(long16 v);
OVERLOADABLE long16 convert_long16(ulong16 v);
OVERLOADABLE ulong16 convert_ulong16(ulong16 v);
OVERLOADABLE int16 convert_int16(ulong16 v);
OVERLOADABLE uint16 convert_uint16(ulong16 v);
OVERLOADABLE short16 convert_short16(ulong16 v);
OVERLOADABLE ushort16 convert_ushort16(ulong16 v);
OVERLOADABLE char16 convert_char16(ulong16 v);
OVERLOADABLE uchar16 convert_uchar16(ulong16 v);
OVERLOADABLE double16 convert_double16(ulong16 v);
OVERLOADABLE float16 convert_float16(ulong16 v);
OVERLOADABLE half16 convert_half16(ulong16 v);
OVERLOADABLE long16 convert_long16(int16 v);
OVERLOADABLE ulong16 convert_ulong16(int16 v);
OVERLOADABLE int16 convert_int16(int16 v);
OVERLOADABLE uint16 convert_uint16(int16 v);
OVERLOADABLE short16 convert_short16(int16 v);
OVERLOADABLE ushort16 convert_ushort16(int16 v);
OVERLOADABLE char16 convert_char16(int16 v);
OVERLOADABLE uchar16 convert_uchar16(int16 v);
OVERLOADABLE double16 convert_double16(int16 v);
OVERLOADABLE float16 convert_float16(int16 v);
OVERLOADABLE half16 convert_half16(int16 v);
OVERLOADABLE long16 convert_long16(uint16 v);
OVERLOADABLE ulong16 convert_ulong16(uint16 v);
OVERLOADABLE int16 convert_int16(uint16 v);
OVERLOADABLE uint16 convert_uint16(uint16 v);
OVERLOADABLE short16 convert_short16(uint16 v);
OVERLOADABLE ushort16 convert_ushort16(uint16 v);
OVERLOADABLE char16 convert_char16(uint16 v);
OVERLOADABLE uchar16 convert_uchar16(uint16 v);
OVERLOADABLE double16 convert_double16(uint16 v);
OVERLOADABLE float16 convert_float16(uint16 v);
OVERLOADABLE half16 convert_half16(uint16 v);
OVERLOADABLE long16 convert_long16(short16 v);
OVERLOADABLE ulong16 convert_ulong16(short16 v);
OVERLOADABLE int16 convert_int16(short16 v);
OVERLOADABLE uint16 convert_uint16(short16 v);
OVERLOADABLE short16 convert_short16(short16 v);
OVERLOADABLE ushort16 convert_ushort16(short16 v);
OVERLOADABLE char16 convert_char16(short16 v);
OVERLOADABLE uchar16 convert_uchar16(short16 v);
OVERLOADABLE double16 convert_double16(short16 v);
OVERLOADABLE float16 convert_float16(short16 v);
OVERLOADABLE half16 convert_half16(short16 v);
OVERLOADABLE long16 convert_long16(ushort16 v);
OVERLOADABLE ulong16 convert_ulong16(ushort16 v);
OVERLOADABLE int16 convert_int16(ushort16 v);
OVERLOADABLE uint16 convert_uint16(ushort16 v);
OVERLOADABLE short16 convert_short16(ushort16 v);
OVERLOADABLE ushort16 convert_ushort16(ushort16 v);
OVERLOADABLE char16 convert_char16(ushort16 v);
OVERLOADABLE uchar16 convert_uchar16(ushort16 v);
OVERLOADABLE double16 convert_double16(ushort16 v);
OVERLOADABLE float16 convert_float16(ushort16 v);
OVERLOADABLE half16 convert_half16(ushort16 v);
OVERLOADABLE long16 convert_long16(char16 v);
OVERLOADABLE ulong16 convert_ulong16(char16 v);
OVERLOADABLE int16 convert_int16(char16 v);
OVERLOADABLE uint16 convert_uint16(char16 v);
OVERLOADABLE short16 convert_short16(char16 v);
OVERLOADABLE ushort16 convert_ushort16(char16 v);
OVERLOADABLE char16 convert_char16(char16 v);
OVERLOADABLE uchar16 convert_uchar16(char16 v);
OVERLOADABLE double16 convert_double16(char16 v);
OVERLOADABLE float16 convert_float16(char16 v);
OVERLOADABLE half16 convert_half16(char16 v);
OVERLOADABLE long16 convert_long16(uchar16 v);
OVERLOADABLE ulong16 convert_ulong16(uchar16 v);
OVERLOADABLE int16 convert_int16(uchar16 v);
OVERLOADABLE uint16 convert_uint16(uchar16 v);
OVERLOADABLE short16 convert_short16(uchar16 v);
OVERLOADABLE ushort16 convert_ushort16(uchar16 v);
OVERLOADABLE char16 convert_char16(uchar16 v);
OVERLOADABLE uchar16 convert_uchar16(uchar16 v);
OVERLOADABLE double16 convert_double16(uchar16 v);
OVERLOADABLE float16 convert_float16(uchar16 v);
OVERLOADABLE half16 convert_half16(uchar16 v);
OVERLOADABLE long16 convert_long16(double16 v);
OVERLOADABLE ulong16 convert_ulong16(double16 v);
OVERLOADABLE int16 convert_int16(double16 v);
OVERLOADABLE uint16 convert_uint16(double16 v);
OVERLOADABLE short16 convert_short16(double16 v);
OVERLOADABLE ushort16 convert_ushort16(double16 v);
OVERLOADABLE char16 convert_char16(double16 v);
OVERLOADABLE uchar16 convert_uchar16(double16 v);
OVERLOADABLE double16 convert_double16(double16 v);
OVERLOADABLE float16 convert_float16(double16 v);
OVERLOADABLE half16 convert_half16(double16 v);
OVERLOADABLE long16 convert_long16(float16 v);
OVERLOADABLE ulong16 convert_ulong16(float16 v);
OVERLOADABLE int16 convert_int16(float16 v);
OVERLOADABLE uint16 convert_uint16(float16 v);
OVERLOADABLE short16 convert_short16(float16 v);
OVERLOADABLE ushort16 convert_ushort16(float16 v);
OVERLOADABLE char16 convert_char16(float16 v);
OVERLOADABLE uchar16 convert_uchar16(float16 v);
OVERLOADABLE double16 convert_double16(float16 v);
OVERLOADABLE float16 convert_float16(float16 v);
OVERLOADABLE half16 convert_half16(float16 v);
OVERLOADABLE long16 convert_long16(half16 v);
OVERLOADABLE ulong16 convert_ulong16(half16 v);
OVERLOADABLE int16 convert_int16(half16 v);
OVERLOADABLE uint16 convert_uint16(half16 v);
OVERLOADABLE short16 convert_short16(half16 v);
OVERLOADABLE ushort16 convert_ushort16(half16 v);
OVERLOADABLE char16 convert_char16(half16 v);
OVERLOADABLE uchar16 convert_uchar16(half16 v);
OVERLOADABLE double16 convert_double16(half16 v);
OVERLOADABLE float16 convert_float16(half16 v);
OVERLOADABLE half16 convert_half16(half16 v);

/* The sat cvt supported by HW. */
#define DEF(DSTTYPE, SRCTYPE) \
OVERLOADABLE DSTTYPE convert_ ## DSTTYPE ## _sat(SRCTYPE x);
DEF(char, uchar);
DEF(char, short);
DEF(char, ushort);
DEF(char, int);
DEF(char, uint);
DEF(char, float);
DEF(uchar, char);
DEF(uchar, short);
DEF(uchar, ushort);
DEF(uchar, int);
DEF(uchar, uint);
DEF(uchar, float);
DEF(short, ushort);
DEF(short, int);
DEF(short, uint);
DEF(short, float);
DEF(short, double);
DEF(ushort, short);
DEF(ushort, int);
DEF(ushort, uint);
DEF(ushort, float);
DEF(ushort, double);
DEF(int, uint);
DEF(int, float);
DEF(int, double);
DEF(uint, int);
DEF(uint, float);
DEF(uint, double);
DEF(char, half);
DEF(uchar, half);
DEF(short, half);
DEF(ushort, half);
DEF(int, half);
DEF(uint, half);
#undef DEF

#define DEF(DSTTYPE, SRCTYPE, MIN, MAX)  OVERLOADABLE DSTTYPE convert_ ## DSTTYPE ## _sat(SRCTYPE x);

DEF(char, long, -128, 127);
DEF(uchar, long, 0, 255);
DEF(short, long, -32768, 32767);
DEF(ushort, long, 0, 65535);
DEF(int, long, -0x7fffffff-1, 0x7fffffff);
DEF(uint, long, 0, 0xffffffffu);
#undef DEF


#define DEF(DSTTYPE, SRCTYPE, SRC_MIN, SRC_MAX, DST_MIN, DST_MAX) OVERLOADABLE DSTTYPE convert_ ## DSTTYPE ## _sat(SRCTYPE x);

DEF(long, float, -0x1.0p63, 0x1.0p63, 0x8000000000000000, 0x7fffffffffffffff);
DEF(ulong, float, 0, 0x1.0p64, 0, 0xffffffffffffffff);
DEF(char, double, -0x1.0p7, 0x1.0p7,  0x80, 0x7F);
DEF(uchar, double, 0, 0x1.0p8, 0, 0xFF);
DEF(long, double, -0x1.0p63, 0x1.0p63, 0x8000000000000000, 0x7FFFFFFFFFFFFFFF);
DEF(ulong, double, 0, 0x1.0p64, 0, 0xFFFFFFFFFFFFFFFF);
#undef DEF

#define DEF(DSTTYPE, SRCTYPE, MAX) OVERLOADABLE DSTTYPE convert_ ## DSTTYPE ## _sat(SRCTYPE x);

DEF(char, ulong, 127);
DEF(uchar, ulong, 255);
DEF(short, ulong, 32767);
DEF(ushort, ulong, 65535);
DEF(int, ulong, 0x7fffffff);
DEF(uint, ulong, 0xffffffffu);
#undef DEF

OVERLOADABLE long convert_long_sat(ulong x);
#define DEF(DSTTYPE, SRCTYPE) OVERLOADABLE DSTTYPE convert_ ## DSTTYPE ## _sat(SRCTYPE x);

  DEF(ushort, char);
  DEF(uint, char);
  DEF(uint, short);
  DEF(ulong, char);
  DEF(ulong, short);
  DEF(ulong, int);
  DEF(ulong, long);
  #undef DEF

#define DEF(DSTTYPE, SRCTYPE) OVERLOADABLE DSTTYPE convert_ ## DSTTYPE ## _sat(SRCTYPE x);

DEF(char, char);
DEF(uchar, uchar);
DEF(short, char);
DEF(short, uchar);
DEF(short, short);
DEF(ushort, uchar);
DEF(ushort, ushort);
DEF(int, char);
DEF(int, uchar);
DEF(int, short);
DEF(int, ushort);
DEF(int, int);
DEF(uint, uchar);
DEF(uint, ushort);
DEF(uint, uint);
DEF(long, char);
DEF(long, uchar);
DEF(long, short);
DEF(long, ushort);
DEF(long, int);
DEF(long, uint);
DEF(long, long);
DEF(ulong, uchar);
DEF(ulong, ushort);
DEF(ulong, uint);
DEF(ulong, ulong);
#undef DEF


       OVERLOADABLE long convert_long_sat(half x);
       OVERLOADABLE ulong convert_ulong_sat(half x);
       
OVERLOADABLE long2 convert_long2_sat(long2 v);
OVERLOADABLE ulong2 convert_ulong2_sat(long2 v);
OVERLOADABLE int2 convert_int2_sat(long2 v);
OVERLOADABLE uint2 convert_uint2_sat(long2 v);
OVERLOADABLE short2 convert_short2_sat(long2 v);
OVERLOADABLE ushort2 convert_ushort2_sat(long2 v);
OVERLOADABLE char2 convert_char2_sat(long2 v);
OVERLOADABLE uchar2 convert_uchar2_sat(long2 v);
OVERLOADABLE long2 convert_long2_sat(ulong2 v);
OVERLOADABLE ulong2 convert_ulong2_sat(ulong2 v);
OVERLOADABLE int2 convert_int2_sat(ulong2 v);
OVERLOADABLE uint2 convert_uint2_sat(ulong2 v);
OVERLOADABLE short2 convert_short2_sat(ulong2 v);
OVERLOADABLE ushort2 convert_ushort2_sat(ulong2 v);
OVERLOADABLE char2 convert_char2_sat(ulong2 v);
OVERLOADABLE uchar2 convert_uchar2_sat(ulong2 v);
OVERLOADABLE long2 convert_long2_sat(int2 v);
OVERLOADABLE ulong2 convert_ulong2_sat(int2 v);
OVERLOADABLE int2 convert_int2_sat(int2 v);
OVERLOADABLE uint2 convert_uint2_sat(int2 v);
OVERLOADABLE short2 convert_short2_sat(int2 v);
OVERLOADABLE ushort2 convert_ushort2_sat(int2 v);
OVERLOADABLE char2 convert_char2_sat(int2 v);
OVERLOADABLE uchar2 convert_uchar2_sat(int2 v);
OVERLOADABLE long2 convert_long2_sat(uint2 v);
OVERLOADABLE ulong2 convert_ulong2_sat(uint2 v);
OVERLOADABLE int2 convert_int2_sat(uint2 v);
OVERLOADABLE uint2 convert_uint2_sat(uint2 v);
OVERLOADABLE short2 convert_short2_sat(uint2 v);
OVERLOADABLE ushort2 convert_ushort2_sat(uint2 v);
OVERLOADABLE char2 convert_char2_sat(uint2 v);
OVERLOADABLE uchar2 convert_uchar2_sat(uint2 v);
OVERLOADABLE long2 convert_long2_sat(short2 v);
OVERLOADABLE ulong2 convert_ulong2_sat(short2 v);
OVERLOADABLE int2 convert_int2_sat(short2 v);
OVERLOADABLE uint2 convert_uint2_sat(short2 v);
OVERLOADABLE short2 convert_short2_sat(short2 v);
OVERLOADABLE ushort2 convert_ushort2_sat(short2 v);
OVERLOADABLE char2 convert_char2_sat(short2 v);
OVERLOADABLE uchar2 convert_uchar2_sat(short2 v);
OVERLOADABLE long2 convert_long2_sat(ushort2 v);
OVERLOADABLE ulong2 convert_ulong2_sat(ushort2 v);
OVERLOADABLE int2 convert_int2_sat(ushort2 v);
OVERLOADABLE uint2 convert_uint2_sat(ushort2 v);
OVERLOADABLE short2 convert_short2_sat(ushort2 v);
OVERLOADABLE ushort2 convert_ushort2_sat(ushort2 v);
OVERLOADABLE char2 convert_char2_sat(ushort2 v);
OVERLOADABLE uchar2 convert_uchar2_sat(ushort2 v);
OVERLOADABLE long2 convert_long2_sat(char2 v);
OVERLOADABLE ulong2 convert_ulong2_sat(char2 v);
OVERLOADABLE int2 convert_int2_sat(char2 v);
OVERLOADABLE uint2 convert_uint2_sat(char2 v);
OVERLOADABLE short2 convert_short2_sat(char2 v);
OVERLOADABLE ushort2 convert_ushort2_sat(char2 v);
OVERLOADABLE char2 convert_char2_sat(char2 v);
OVERLOADABLE uchar2 convert_uchar2_sat(char2 v);
OVERLOADABLE long2 convert_long2_sat(uchar2 v);
OVERLOADABLE ulong2 convert_ulong2_sat(uchar2 v);
OVERLOADABLE int2 convert_int2_sat(uchar2 v);
OVERLOADABLE uint2 convert_uint2_sat(uchar2 v);
OVERLOADABLE short2 convert_short2_sat(uchar2 v);
OVERLOADABLE ushort2 convert_ushort2_sat(uchar2 v);
OVERLOADABLE char2 convert_char2_sat(uchar2 v);
OVERLOADABLE uchar2 convert_uchar2_sat(uchar2 v);
OVERLOADABLE long2 convert_long2_sat(double2 v);
OVERLOADABLE ulong2 convert_ulong2_sat(double2 v);
OVERLOADABLE int2 convert_int2_sat(double2 v);
OVERLOADABLE uint2 convert_uint2_sat(double2 v);
OVERLOADABLE short2 convert_short2_sat(double2 v);
OVERLOADABLE ushort2 convert_ushort2_sat(double2 v);
OVERLOADABLE char2 convert_char2_sat(double2 v);
OVERLOADABLE uchar2 convert_uchar2_sat(double2 v);
OVERLOADABLE long2 convert_long2_sat(float2 v);
OVERLOADABLE ulong2 convert_ulong2_sat(float2 v);
OVERLOADABLE int2 convert_int2_sat(float2 v);
OVERLOADABLE uint2 convert_uint2_sat(float2 v);
OVERLOADABLE short2 convert_short2_sat(float2 v);
OVERLOADABLE ushort2 convert_ushort2_sat(float2 v);
OVERLOADABLE char2 convert_char2_sat(float2 v);
OVERLOADABLE uchar2 convert_uchar2_sat(float2 v);
OVERLOADABLE long2 convert_long2_sat(half2 v);
OVERLOADABLE ulong2 convert_ulong2_sat(half2 v);
OVERLOADABLE int2 convert_int2_sat(half2 v);
OVERLOADABLE uint2 convert_uint2_sat(half2 v);
OVERLOADABLE short2 convert_short2_sat(half2 v);
OVERLOADABLE ushort2 convert_ushort2_sat(half2 v);
OVERLOADABLE char2 convert_char2_sat(half2 v);
OVERLOADABLE uchar2 convert_uchar2_sat(half2 v);
OVERLOADABLE long3 convert_long3_sat(long3 v);
OVERLOADABLE ulong3 convert_ulong3_sat(long3 v);
OVERLOADABLE int3 convert_int3_sat(long3 v);
OVERLOADABLE uint3 convert_uint3_sat(long3 v);
OVERLOADABLE short3 convert_short3_sat(long3 v);
OVERLOADABLE ushort3 convert_ushort3_sat(long3 v);
OVERLOADABLE char3 convert_char3_sat(long3 v);
OVERLOADABLE uchar3 convert_uchar3_sat(long3 v);
OVERLOADABLE long3 convert_long3_sat(ulong3 v);
OVERLOADABLE ulong3 convert_ulong3_sat(ulong3 v);
OVERLOADABLE int3 convert_int3_sat(ulong3 v);
OVERLOADABLE uint3 convert_uint3_sat(ulong3 v);
OVERLOADABLE short3 convert_short3_sat(ulong3 v);
OVERLOADABLE ushort3 convert_ushort3_sat(ulong3 v);
OVERLOADABLE char3 convert_char3_sat(ulong3 v);
OVERLOADABLE uchar3 convert_uchar3_sat(ulong3 v);
OVERLOADABLE long3 convert_long3_sat(int3 v);
OVERLOADABLE ulong3 convert_ulong3_sat(int3 v);
OVERLOADABLE int3 convert_int3_sat(int3 v);
OVERLOADABLE uint3 convert_uint3_sat(int3 v);
OVERLOADABLE short3 convert_short3_sat(int3 v);
OVERLOADABLE ushort3 convert_ushort3_sat(int3 v);
OVERLOADABLE char3 convert_char3_sat(int3 v);
OVERLOADABLE uchar3 convert_uchar3_sat(int3 v);
OVERLOADABLE long3 convert_long3_sat(uint3 v);
OVERLOADABLE ulong3 convert_ulong3_sat(uint3 v);
OVERLOADABLE int3 convert_int3_sat(uint3 v);
OVERLOADABLE uint3 convert_uint3_sat(uint3 v);
OVERLOADABLE short3 convert_short3_sat(uint3 v);
OVERLOADABLE ushort3 convert_ushort3_sat(uint3 v);
OVERLOADABLE char3 convert_char3_sat(uint3 v);
OVERLOADABLE uchar3 convert_uchar3_sat(uint3 v);
OVERLOADABLE long3 convert_long3_sat(short3 v);
OVERLOADABLE ulong3 convert_ulong3_sat(short3 v);
OVERLOADABLE int3 convert_int3_sat(short3 v);
OVERLOADABLE uint3 convert_uint3_sat(short3 v);
OVERLOADABLE short3 convert_short3_sat(short3 v);
OVERLOADABLE ushort3 convert_ushort3_sat(short3 v);
OVERLOADABLE char3 convert_char3_sat(short3 v);
OVERLOADABLE uchar3 convert_uchar3_sat(short3 v);
OVERLOADABLE long3 convert_long3_sat(ushort3 v);
OVERLOADABLE ulong3 convert_ulong3_sat(ushort3 v);
OVERLOADABLE int3 convert_int3_sat(ushort3 v);
OVERLOADABLE uint3 convert_uint3_sat(ushort3 v);
OVERLOADABLE short3 convert_short3_sat(ushort3 v);
OVERLOADABLE ushort3 convert_ushort3_sat(ushort3 v);
OVERLOADABLE char3 convert_char3_sat(ushort3 v);
OVERLOADABLE uchar3 convert_uchar3_sat(ushort3 v);
OVERLOADABLE long3 convert_long3_sat(char3 v);
OVERLOADABLE ulong3 convert_ulong3_sat(char3 v);
OVERLOADABLE int3 convert_int3_sat(char3 v);
OVERLOADABLE uint3 convert_uint3_sat(char3 v);
OVERLOADABLE short3 convert_short3_sat(char3 v);
OVERLOADABLE ushort3 convert_ushort3_sat(char3 v);
OVERLOADABLE char3 convert_char3_sat(char3 v);
OVERLOADABLE uchar3 convert_uchar3_sat(char3 v);
OVERLOADABLE long3 convert_long3_sat(uchar3 v);
OVERLOADABLE ulong3 convert_ulong3_sat(uchar3 v);
OVERLOADABLE int3 convert_int3_sat(uchar3 v);
OVERLOADABLE uint3 convert_uint3_sat(uchar3 v);
OVERLOADABLE short3 convert_short3_sat(uchar3 v);
OVERLOADABLE ushort3 convert_ushort3_sat(uchar3 v);
OVERLOADABLE char3 convert_char3_sat(uchar3 v);
OVERLOADABLE uchar3 convert_uchar3_sat(uchar3 v);
OVERLOADABLE long3 convert_long3_sat(double3 v);
OVERLOADABLE ulong3 convert_ulong3_sat(double3 v);
OVERLOADABLE int3 convert_int3_sat(double3 v);
OVERLOADABLE uint3 convert_uint3_sat(double3 v);
OVERLOADABLE short3 convert_short3_sat(double3 v);
OVERLOADABLE ushort3 convert_ushort3_sat(double3 v);
OVERLOADABLE char3 convert_char3_sat(double3 v);
OVERLOADABLE uchar3 convert_uchar3_sat(double3 v);
OVERLOADABLE long3 convert_long3_sat(float3 v);
OVERLOADABLE ulong3 convert_ulong3_sat(float3 v);
OVERLOADABLE int3 convert_int3_sat(float3 v);
OVERLOADABLE uint3 convert_uint3_sat(float3 v);
OVERLOADABLE short3 convert_short3_sat(float3 v);
OVERLOADABLE ushort3 convert_ushort3_sat(float3 v);
OVERLOADABLE char3 convert_char3_sat(float3 v);
OVERLOADABLE uchar3 convert_uchar3_sat(float3 v);
OVERLOADABLE long3 convert_long3_sat(half3 v);
OVERLOADABLE ulong3 convert_ulong3_sat(half3 v);
OVERLOADABLE int3 convert_int3_sat(half3 v);
OVERLOADABLE uint3 convert_uint3_sat(half3 v);
OVERLOADABLE short3 convert_short3_sat(half3 v);
OVERLOADABLE ushort3 convert_ushort3_sat(half3 v);
OVERLOADABLE char3 convert_char3_sat(half3 v);
OVERLOADABLE uchar3 convert_uchar3_sat(half3 v);
OVERLOADABLE long4 convert_long4_sat(long4 v);
OVERLOADABLE ulong4 convert_ulong4_sat(long4 v);
OVERLOADABLE int4 convert_int4_sat(long4 v);
OVERLOADABLE uint4 convert_uint4_sat(long4 v);
OVERLOADABLE short4 convert_short4_sat(long4 v);
OVERLOADABLE ushort4 convert_ushort4_sat(long4 v);
OVERLOADABLE char4 convert_char4_sat(long4 v);
OVERLOADABLE uchar4 convert_uchar4_sat(long4 v);
OVERLOADABLE long4 convert_long4_sat(ulong4 v);
OVERLOADABLE ulong4 convert_ulong4_sat(ulong4 v);
OVERLOADABLE int4 convert_int4_sat(ulong4 v);
OVERLOADABLE uint4 convert_uint4_sat(ulong4 v);
OVERLOADABLE short4 convert_short4_sat(ulong4 v);
OVERLOADABLE ushort4 convert_ushort4_sat(ulong4 v);
OVERLOADABLE char4 convert_char4_sat(ulong4 v);
OVERLOADABLE uchar4 convert_uchar4_sat(ulong4 v);
OVERLOADABLE long4 convert_long4_sat(int4 v);
OVERLOADABLE ulong4 convert_ulong4_sat(int4 v);
OVERLOADABLE int4 convert_int4_sat(int4 v);
OVERLOADABLE uint4 convert_uint4_sat(int4 v);
OVERLOADABLE short4 convert_short4_sat(int4 v);
OVERLOADABLE ushort4 convert_ushort4_sat(int4 v);
OVERLOADABLE char4 convert_char4_sat(int4 v);
OVERLOADABLE uchar4 convert_uchar4_sat(int4 v);
OVERLOADABLE long4 convert_long4_sat(uint4 v);
OVERLOADABLE ulong4 convert_ulong4_sat(uint4 v);
OVERLOADABLE int4 convert_int4_sat(uint4 v);
OVERLOADABLE uint4 convert_uint4_sat(uint4 v);
OVERLOADABLE short4 convert_short4_sat(uint4 v);
OVERLOADABLE ushort4 convert_ushort4_sat(uint4 v);
OVERLOADABLE char4 convert_char4_sat(uint4 v);
OVERLOADABLE uchar4 convert_uchar4_sat(uint4 v);
OVERLOADABLE long4 convert_long4_sat(short4 v);
OVERLOADABLE ulong4 convert_ulong4_sat(short4 v);
OVERLOADABLE int4 convert_int4_sat(short4 v);
OVERLOADABLE uint4 convert_uint4_sat(short4 v);
OVERLOADABLE short4 convert_short4_sat(short4 v);
OVERLOADABLE ushort4 convert_ushort4_sat(short4 v);
OVERLOADABLE char4 convert_char4_sat(short4 v);
OVERLOADABLE uchar4 convert_uchar4_sat(short4 v);
OVERLOADABLE long4 convert_long4_sat(ushort4 v);
OVERLOADABLE ulong4 convert_ulong4_sat(ushort4 v);
OVERLOADABLE int4 convert_int4_sat(ushort4 v);
OVERLOADABLE uint4 convert_uint4_sat(ushort4 v);
OVERLOADABLE short4 convert_short4_sat(ushort4 v);
OVERLOADABLE ushort4 convert_ushort4_sat(ushort4 v);
OVERLOADABLE char4 convert_char4_sat(ushort4 v);
OVERLOADABLE uchar4 convert_uchar4_sat(ushort4 v);
OVERLOADABLE long4 convert_long4_sat(char4 v);
OVERLOADABLE ulong4 convert_ulong4_sat(char4 v);
OVERLOADABLE int4 convert_int4_sat(char4 v);
OVERLOADABLE uint4 convert_uint4_sat(char4 v);
OVERLOADABLE short4 convert_short4_sat(char4 v);
OVERLOADABLE ushort4 convert_ushort4_sat(char4 v);
OVERLOADABLE char4 convert_char4_sat(char4 v);
OVERLOADABLE uchar4 convert_uchar4_sat(char4 v);
OVERLOADABLE long4 convert_long4_sat(uchar4 v);
OVERLOADABLE ulong4 convert_ulong4_sat(uchar4 v);
OVERLOADABLE int4 convert_int4_sat(uchar4 v);
OVERLOADABLE uint4 convert_uint4_sat(uchar4 v);
OVERLOADABLE short4 convert_short4_sat(uchar4 v);
OVERLOADABLE ushort4 convert_ushort4_sat(uchar4 v);
OVERLOADABLE char4 convert_char4_sat(uchar4 v);
OVERLOADABLE uchar4 convert_uchar4_sat(uchar4 v);
OVERLOADABLE long4 convert_long4_sat(double4 v);
OVERLOADABLE ulong4 convert_ulong4_sat(double4 v);
OVERLOADABLE int4 convert_int4_sat(double4 v);
OVERLOADABLE uint4 convert_uint4_sat(double4 v);
OVERLOADABLE short4 convert_short4_sat(double4 v);
OVERLOADABLE ushort4 convert_ushort4_sat(double4 v);
OVERLOADABLE char4 convert_char4_sat(double4 v);
OVERLOADABLE uchar4 convert_uchar4_sat(double4 v);
OVERLOADABLE long4 convert_long4_sat(float4 v);
OVERLOADABLE ulong4 convert_ulong4_sat(float4 v);
OVERLOADABLE int4 convert_int4_sat(float4 v);
OVERLOADABLE uint4 convert_uint4_sat(float4 v);
OVERLOADABLE short4 convert_short4_sat(float4 v);
OVERLOADABLE ushort4 convert_ushort4_sat(float4 v);
OVERLOADABLE char4 convert_char4_sat(float4 v);
OVERLOADABLE uchar4 convert_uchar4_sat(float4 v);
OVERLOADABLE long4 convert_long4_sat(half4 v);
OVERLOADABLE ulong4 convert_ulong4_sat(half4 v);
OVERLOADABLE int4 convert_int4_sat(half4 v);
OVERLOADABLE uint4 convert_uint4_sat(half4 v);
OVERLOADABLE short4 convert_short4_sat(half4 v);
OVERLOADABLE ushort4 convert_ushort4_sat(half4 v);
OVERLOADABLE char4 convert_char4_sat(half4 v);
OVERLOADABLE uchar4 convert_uchar4_sat(half4 v);
OVERLOADABLE long8 convert_long8_sat(long8 v);
OVERLOADABLE ulong8 convert_ulong8_sat(long8 v);
OVERLOADABLE int8 convert_int8_sat(long8 v);
OVERLOADABLE uint8 convert_uint8_sat(long8 v);
OVERLOADABLE short8 convert_short8_sat(long8 v);
OVERLOADABLE ushort8 convert_ushort8_sat(long8 v);
OVERLOADABLE char8 convert_char8_sat(long8 v);
OVERLOADABLE uchar8 convert_uchar8_sat(long8 v);
OVERLOADABLE long8 convert_long8_sat(ulong8 v);
OVERLOADABLE ulong8 convert_ulong8_sat(ulong8 v);
OVERLOADABLE int8 convert_int8_sat(ulong8 v);
OVERLOADABLE uint8 convert_uint8_sat(ulong8 v);
OVERLOADABLE short8 convert_short8_sat(ulong8 v);
OVERLOADABLE ushort8 convert_ushort8_sat(ulong8 v);
OVERLOADABLE char8 convert_char8_sat(ulong8 v);
OVERLOADABLE uchar8 convert_uchar8_sat(ulong8 v);
OVERLOADABLE long8 convert_long8_sat(int8 v);
OVERLOADABLE ulong8 convert_ulong8_sat(int8 v);
OVERLOADABLE int8 convert_int8_sat(int8 v);
OVERLOADABLE uint8 convert_uint8_sat(int8 v);
OVERLOADABLE short8 convert_short8_sat(int8 v);
OVERLOADABLE ushort8 convert_ushort8_sat(int8 v);
OVERLOADABLE char8 convert_char8_sat(int8 v);
OVERLOADABLE uchar8 convert_uchar8_sat(int8 v);
OVERLOADABLE long8 convert_long8_sat(uint8 v);
OVERLOADABLE ulong8 convert_ulong8_sat(uint8 v);
OVERLOADABLE int8 convert_int8_sat(uint8 v);
OVERLOADABLE uint8 convert_uint8_sat(uint8 v);
OVERLOADABLE short8 convert_short8_sat(uint8 v);
OVERLOADABLE ushort8 convert_ushort8_sat(uint8 v);
OVERLOADABLE char8 convert_char8_sat(uint8 v);
OVERLOADABLE uchar8 convert_uchar8_sat(uint8 v);
OVERLOADABLE long8 convert_long8_sat(short8 v);
OVERLOADABLE ulong8 convert_ulong8_sat(short8 v);
OVERLOADABLE int8 convert_int8_sat(short8 v);
OVERLOADABLE uint8 convert_uint8_sat(short8 v);
OVERLOADABLE short8 convert_short8_sat(short8 v);
OVERLOADABLE ushort8 convert_ushort8_sat(short8 v);
OVERLOADABLE char8 convert_char8_sat(short8 v);
OVERLOADABLE uchar8 convert_uchar8_sat(short8 v);
OVERLOADABLE long8 convert_long8_sat(ushort8 v);
OVERLOADABLE ulong8 convert_ulong8_sat(ushort8 v);
OVERLOADABLE int8 convert_int8_sat(ushort8 v);
OVERLOADABLE uint8 convert_uint8_sat(ushort8 v);
OVERLOADABLE short8 convert_short8_sat(ushort8 v);
OVERLOADABLE ushort8 convert_ushort8_sat(ushort8 v);
OVERLOADABLE char8 convert_char8_sat(ushort8 v);
OVERLOADABLE uchar8 convert_uchar8_sat(ushort8 v);
OVERLOADABLE long8 convert_long8_sat(char8 v);
OVERLOADABLE ulong8 convert_ulong8_sat(char8 v);
OVERLOADABLE int8 convert_int8_sat(char8 v);
OVERLOADABLE uint8 convert_uint8_sat(char8 v);
OVERLOADABLE short8 convert_short8_sat(char8 v);
OVERLOADABLE ushort8 convert_ushort8_sat(char8 v);
OVERLOADABLE char8 convert_char8_sat(char8 v);
OVERLOADABLE uchar8 convert_uchar8_sat(char8 v);
OVERLOADABLE long8 convert_long8_sat(uchar8 v);
OVERLOADABLE ulong8 convert_ulong8_sat(uchar8 v);
OVERLOADABLE int8 convert_int8_sat(uchar8 v);
OVERLOADABLE uint8 convert_uint8_sat(uchar8 v);
OVERLOADABLE short8 convert_short8_sat(uchar8 v);
OVERLOADABLE ushort8 convert_ushort8_sat(uchar8 v);
OVERLOADABLE char8 convert_char8_sat(uchar8 v);
OVERLOADABLE uchar8 convert_uchar8_sat(uchar8 v);
OVERLOADABLE long8 convert_long8_sat(double8 v);
OVERLOADABLE ulong8 convert_ulong8_sat(double8 v);
OVERLOADABLE int8 convert_int8_sat(double8 v);
OVERLOADABLE uint8 convert_uint8_sat(double8 v);
OVERLOADABLE short8 convert_short8_sat(double8 v);
OVERLOADABLE ushort8 convert_ushort8_sat(double8 v);
OVERLOADABLE char8 convert_char8_sat(double8 v);
OVERLOADABLE uchar8 convert_uchar8_sat(double8 v);
OVERLOADABLE long8 convert_long8_sat(float8 v);
OVERLOADABLE ulong8 convert_ulong8_sat(float8 v);
OVERLOADABLE int8 convert_int8_sat(float8 v);
OVERLOADABLE uint8 convert_uint8_sat(float8 v);
OVERLOADABLE short8 convert_short8_sat(float8 v);
OVERLOADABLE ushort8 convert_ushort8_sat(float8 v);
OVERLOADABLE char8 convert_char8_sat(float8 v);
OVERLOADABLE uchar8 convert_uchar8_sat(float8 v);
OVERLOADABLE long8 convert_long8_sat(half8 v);
OVERLOADABLE ulong8 convert_ulong8_sat(half8 v);
OVERLOADABLE int8 convert_int8_sat(half8 v);
OVERLOADABLE uint8 convert_uint8_sat(half8 v);
OVERLOADABLE short8 convert_short8_sat(half8 v);
OVERLOADABLE ushort8 convert_ushort8_sat(half8 v);
OVERLOADABLE char8 convert_char8_sat(half8 v);
OVERLOADABLE uchar8 convert_uchar8_sat(half8 v);
OVERLOADABLE long16 convert_long16_sat(long16 v);
OVERLOADABLE ulong16 convert_ulong16_sat(long16 v);
OVERLOADABLE int16 convert_int16_sat(long16 v);
OVERLOADABLE uint16 convert_uint16_sat(long16 v);
OVERLOADABLE short16 convert_short16_sat(long16 v);
OVERLOADABLE ushort16 convert_ushort16_sat(long16 v);
OVERLOADABLE char16 convert_char16_sat(long16 v);
OVERLOADABLE uchar16 convert_uchar16_sat(long16 v);
OVERLOADABLE long16 convert_long16_sat(ulong16 v);
OVERLOADABLE ulong16 convert_ulong16_sat(ulong16 v);
OVERLOADABLE int16 convert_int16_sat(ulong16 v);
OVERLOADABLE uint16 convert_uint16_sat(ulong16 v);
OVERLOADABLE short16 convert_short16_sat(ulong16 v);
OVERLOADABLE ushort16 convert_ushort16_sat(ulong16 v);
OVERLOADABLE char16 convert_char16_sat(ulong16 v);
OVERLOADABLE uchar16 convert_uchar16_sat(ulong16 v);
OVERLOADABLE long16 convert_long16_sat(int16 v);
OVERLOADABLE ulong16 convert_ulong16_sat(int16 v);
OVERLOADABLE int16 convert_int16_sat(int16 v);
OVERLOADABLE uint16 convert_uint16_sat(int16 v);
OVERLOADABLE short16 convert_short16_sat(int16 v);
OVERLOADABLE ushort16 convert_ushort16_sat(int16 v);
OVERLOADABLE char16 convert_char16_sat(int16 v);
OVERLOADABLE uchar16 convert_uchar16_sat(int16 v);
OVERLOADABLE long16 convert_long16_sat(uint16 v);
OVERLOADABLE ulong16 convert_ulong16_sat(uint16 v);
OVERLOADABLE int16 convert_int16_sat(uint16 v);
OVERLOADABLE uint16 convert_uint16_sat(uint16 v);
OVERLOADABLE short16 convert_short16_sat(uint16 v);
OVERLOADABLE ushort16 convert_ushort16_sat(uint16 v);
OVERLOADABLE char16 convert_char16_sat(uint16 v);
OVERLOADABLE uchar16 convert_uchar16_sat(uint16 v);
OVERLOADABLE long16 convert_long16_sat(short16 v);
OVERLOADABLE ulong16 convert_ulong16_sat(short16 v);
OVERLOADABLE int16 convert_int16_sat(short16 v);
OVERLOADABLE uint16 convert_uint16_sat(short16 v);
OVERLOADABLE short16 convert_short16_sat(short16 v);
OVERLOADABLE ushort16 convert_ushort16_sat(short16 v);
OVERLOADABLE char16 convert_char16_sat(short16 v);
OVERLOADABLE uchar16 convert_uchar16_sat(short16 v);
OVERLOADABLE long16 convert_long16_sat(ushort16 v);
OVERLOADABLE ulong16 convert_ulong16_sat(ushort16 v);
OVERLOADABLE int16 convert_int16_sat(ushort16 v);
OVERLOADABLE uint16 convert_uint16_sat(ushort16 v);
OVERLOADABLE short16 convert_short16_sat(ushort16 v);
OVERLOADABLE ushort16 convert_ushort16_sat(ushort16 v);
OVERLOADABLE char16 convert_char16_sat(ushort16 v);
OVERLOADABLE uchar16 convert_uchar16_sat(ushort16 v);
OVERLOADABLE long16 convert_long16_sat(char16 v);
OVERLOADABLE ulong16 convert_ulong16_sat(char16 v);
OVERLOADABLE int16 convert_int16_sat(char16 v);
OVERLOADABLE uint16 convert_uint16_sat(char16 v);
OVERLOADABLE short16 convert_short16_sat(char16 v);
OVERLOADABLE ushort16 convert_ushort16_sat(char16 v);
OVERLOADABLE char16 convert_char16_sat(char16 v);
OVERLOADABLE uchar16 convert_uchar16_sat(char16 v);
OVERLOADABLE long16 convert_long16_sat(uchar16 v);
OVERLOADABLE ulong16 convert_ulong16_sat(uchar16 v);
OVERLOADABLE int16 convert_int16_sat(uchar16 v);
OVERLOADABLE uint16 convert_uint16_sat(uchar16 v);
OVERLOADABLE short16 convert_short16_sat(uchar16 v);
OVERLOADABLE ushort16 convert_ushort16_sat(uchar16 v);
OVERLOADABLE char16 convert_char16_sat(uchar16 v);
OVERLOADABLE uchar16 convert_uchar16_sat(uchar16 v);
OVERLOADABLE long16 convert_long16_sat(double16 v);
OVERLOADABLE ulong16 convert_ulong16_sat(double16 v);
OVERLOADABLE int16 convert_int16_sat(double16 v);
OVERLOADABLE uint16 convert_uint16_sat(double16 v);
OVERLOADABLE short16 convert_short16_sat(double16 v);
OVERLOADABLE ushort16 convert_ushort16_sat(double16 v);
OVERLOADABLE char16 convert_char16_sat(double16 v);
OVERLOADABLE uchar16 convert_uchar16_sat(double16 v);
OVERLOADABLE long16 convert_long16_sat(float16 v);
OVERLOADABLE ulong16 convert_ulong16_sat(float16 v);
OVERLOADABLE int16 convert_int16_sat(float16 v);
OVERLOADABLE uint16 convert_uint16_sat(float16 v);
OVERLOADABLE short16 convert_short16_sat(float16 v);
OVERLOADABLE ushort16 convert_ushort16_sat(float16 v);
OVERLOADABLE char16 convert_char16_sat(float16 v);
OVERLOADABLE uchar16 convert_uchar16_sat(float16 v);
OVERLOADABLE long16 convert_long16_sat(half16 v);
OVERLOADABLE ulong16 convert_ulong16_sat(half16 v);
OVERLOADABLE int16 convert_int16_sat(half16 v);
OVERLOADABLE uint16 convert_uint16_sat(half16 v);
OVERLOADABLE short16 convert_short16_sat(half16 v);
OVERLOADABLE ushort16 convert_ushort16_sat(half16 v);
OVERLOADABLE char16 convert_char16_sat(half16 v);
OVERLOADABLE uchar16 convert_uchar16_sat(half16 v);
OVERLOADABLE long convert_long_rte(long x);
OVERLOADABLE long convert_long_rtz(long x);
OVERLOADABLE long convert_long_rtp(long x);
OVERLOADABLE long convert_long_rtn(long x);
OVERLOADABLE ulong convert_ulong_rte(long x);
OVERLOADABLE ulong convert_ulong_rtz(long x);
OVERLOADABLE ulong convert_ulong_rtp(long x);
OVERLOADABLE ulong convert_ulong_rtn(long x);
OVERLOADABLE int convert_int_rte(long x);
OVERLOADABLE int convert_int_rtz(long x);
OVERLOADABLE int convert_int_rtp(long x);
OVERLOADABLE int convert_int_rtn(long x);
OVERLOADABLE uint convert_uint_rte(long x);
OVERLOADABLE uint convert_uint_rtz(long x);
OVERLOADABLE uint convert_uint_rtp(long x);
OVERLOADABLE uint convert_uint_rtn(long x);
OVERLOADABLE short convert_short_rte(long x);
OVERLOADABLE short convert_short_rtz(long x);
OVERLOADABLE short convert_short_rtp(long x);
OVERLOADABLE short convert_short_rtn(long x);
OVERLOADABLE ushort convert_ushort_rte(long x);
OVERLOADABLE ushort convert_ushort_rtz(long x);
OVERLOADABLE ushort convert_ushort_rtp(long x);
OVERLOADABLE ushort convert_ushort_rtn(long x);
OVERLOADABLE char convert_char_rte(long x);
OVERLOADABLE char convert_char_rtz(long x);
OVERLOADABLE char convert_char_rtp(long x);
OVERLOADABLE char convert_char_rtn(long x);
OVERLOADABLE uchar convert_uchar_rte(long x);
OVERLOADABLE uchar convert_uchar_rtz(long x);
OVERLOADABLE uchar convert_uchar_rtp(long x);
OVERLOADABLE uchar convert_uchar_rtn(long x);
OVERLOADABLE float convert_float_rte(long x);
OVERLOADABLE float convert_float_rtz(long x);
OVERLOADABLE float convert_float_rtp(long x);
OVERLOADABLE float convert_float_rtn(long x);
OVERLOADABLE half convert_half_rte(long x);
OVERLOADABLE half convert_half_rtz(long x);
OVERLOADABLE half convert_half_rtp(long x);
OVERLOADABLE half convert_half_rtn(long x);
OVERLOADABLE long convert_long_rte(ulong x);
OVERLOADABLE long convert_long_rtz(ulong x);
OVERLOADABLE long convert_long_rtp(ulong x);
OVERLOADABLE long convert_long_rtn(ulong x);
OVERLOADABLE ulong convert_ulong_rte(ulong x);
OVERLOADABLE ulong convert_ulong_rtz(ulong x);
OVERLOADABLE ulong convert_ulong_rtp(ulong x);
OVERLOADABLE ulong convert_ulong_rtn(ulong x);
OVERLOADABLE int convert_int_rte(ulong x);
OVERLOADABLE int convert_int_rtz(ulong x);
OVERLOADABLE int convert_int_rtp(ulong x);
OVERLOADABLE int convert_int_rtn(ulong x);
OVERLOADABLE uint convert_uint_rte(ulong x);
OVERLOADABLE uint convert_uint_rtz(ulong x);
OVERLOADABLE uint convert_uint_rtp(ulong x);
OVERLOADABLE uint convert_uint_rtn(ulong x);
OVERLOADABLE short convert_short_rte(ulong x);
OVERLOADABLE short convert_short_rtz(ulong x);
OVERLOADABLE short convert_short_rtp(ulong x);
OVERLOADABLE short convert_short_rtn(ulong x);
OVERLOADABLE ushort convert_ushort_rte(ulong x);
OVERLOADABLE ushort convert_ushort_rtz(ulong x);
OVERLOADABLE ushort convert_ushort_rtp(ulong x);
OVERLOADABLE ushort convert_ushort_rtn(ulong x);
OVERLOADABLE char convert_char_rte(ulong x);
OVERLOADABLE char convert_char_rtz(ulong x);
OVERLOADABLE char convert_char_rtp(ulong x);
OVERLOADABLE char convert_char_rtn(ulong x);
OVERLOADABLE uchar convert_uchar_rte(ulong x);
OVERLOADABLE uchar convert_uchar_rtz(ulong x);
OVERLOADABLE uchar convert_uchar_rtp(ulong x);
OVERLOADABLE uchar convert_uchar_rtn(ulong x);
OVERLOADABLE float convert_float_rte(ulong x);
OVERLOADABLE float convert_float_rtz(ulong x);
OVERLOADABLE float convert_float_rtp(ulong x);
OVERLOADABLE float convert_float_rtn(ulong x);
OVERLOADABLE half convert_half_rte(ulong x);
OVERLOADABLE half convert_half_rtz(ulong x);
OVERLOADABLE half convert_half_rtp(ulong x);
OVERLOADABLE half convert_half_rtn(ulong x);
OVERLOADABLE long convert_long_rte(int x);
OVERLOADABLE long convert_long_rtz(int x);
OVERLOADABLE long convert_long_rtp(int x);
OVERLOADABLE long convert_long_rtn(int x);
OVERLOADABLE ulong convert_ulong_rte(int x);
OVERLOADABLE ulong convert_ulong_rtz(int x);
OVERLOADABLE ulong convert_ulong_rtp(int x);
OVERLOADABLE ulong convert_ulong_rtn(int x);
OVERLOADABLE int convert_int_rte(int x);
OVERLOADABLE int convert_int_rtz(int x);
OVERLOADABLE int convert_int_rtp(int x);
OVERLOADABLE int convert_int_rtn(int x);
OVERLOADABLE uint convert_uint_rte(int x);
OVERLOADABLE uint convert_uint_rtz(int x);
OVERLOADABLE uint convert_uint_rtp(int x);
OVERLOADABLE uint convert_uint_rtn(int x);
OVERLOADABLE short convert_short_rte(int x);
OVERLOADABLE short convert_short_rtz(int x);
OVERLOADABLE short convert_short_rtp(int x);
OVERLOADABLE short convert_short_rtn(int x);
OVERLOADABLE ushort convert_ushort_rte(int x);
OVERLOADABLE ushort convert_ushort_rtz(int x);
OVERLOADABLE ushort convert_ushort_rtp(int x);
OVERLOADABLE ushort convert_ushort_rtn(int x);
OVERLOADABLE char convert_char_rte(int x);
OVERLOADABLE char convert_char_rtz(int x);
OVERLOADABLE char convert_char_rtp(int x);
OVERLOADABLE char convert_char_rtn(int x);
OVERLOADABLE uchar convert_uchar_rte(int x);
OVERLOADABLE uchar convert_uchar_rtz(int x);
OVERLOADABLE uchar convert_uchar_rtp(int x);
OVERLOADABLE uchar convert_uchar_rtn(int x);
OVERLOADABLE float convert_float_rte(int x);
OVERLOADABLE float convert_float_rtz(int x);
OVERLOADABLE float convert_float_rtp(int x);
OVERLOADABLE float convert_float_rtn(int x);
OVERLOADABLE half convert_half_rte(int x);
OVERLOADABLE half convert_half_rtz(int x);
OVERLOADABLE half convert_half_rtp(int x);
OVERLOADABLE half convert_half_rtn(int x);
OVERLOADABLE long convert_long_rte(uint x);
OVERLOADABLE long convert_long_rtz(uint x);
OVERLOADABLE long convert_long_rtp(uint x);
OVERLOADABLE long convert_long_rtn(uint x);
OVERLOADABLE ulong convert_ulong_rte(uint x);
OVERLOADABLE ulong convert_ulong_rtz(uint x);
OVERLOADABLE ulong convert_ulong_rtp(uint x);
OVERLOADABLE ulong convert_ulong_rtn(uint x);
OVERLOADABLE int convert_int_rte(uint x);
OVERLOADABLE int convert_int_rtz(uint x);
OVERLOADABLE int convert_int_rtp(uint x);
OVERLOADABLE int convert_int_rtn(uint x);
OVERLOADABLE uint convert_uint_rte(uint x);
OVERLOADABLE uint convert_uint_rtz(uint x);
OVERLOADABLE uint convert_uint_rtp(uint x);
OVERLOADABLE uint convert_uint_rtn(uint x);
OVERLOADABLE short convert_short_rte(uint x);
OVERLOADABLE short convert_short_rtz(uint x);
OVERLOADABLE short convert_short_rtp(uint x);
OVERLOADABLE short convert_short_rtn(uint x);
OVERLOADABLE ushort convert_ushort_rte(uint x);
OVERLOADABLE ushort convert_ushort_rtz(uint x);
OVERLOADABLE ushort convert_ushort_rtp(uint x);
OVERLOADABLE ushort convert_ushort_rtn(uint x);
OVERLOADABLE char convert_char_rte(uint x);
OVERLOADABLE char convert_char_rtz(uint x);
OVERLOADABLE char convert_char_rtp(uint x);
OVERLOADABLE char convert_char_rtn(uint x);
OVERLOADABLE uchar convert_uchar_rte(uint x);
OVERLOADABLE uchar convert_uchar_rtz(uint x);
OVERLOADABLE uchar convert_uchar_rtp(uint x);
OVERLOADABLE uchar convert_uchar_rtn(uint x);
OVERLOADABLE float convert_float_rte(uint x);
OVERLOADABLE float convert_float_rtz(uint x);
OVERLOADABLE float convert_float_rtp(uint x);
OVERLOADABLE float convert_float_rtn(uint x);
OVERLOADABLE half convert_half_rte(uint x);
OVERLOADABLE half convert_half_rtz(uint x);
OVERLOADABLE half convert_half_rtp(uint x);
OVERLOADABLE half convert_half_rtn(uint x);
OVERLOADABLE long convert_long_rte(short x);
OVERLOADABLE long convert_long_rtz(short x);
OVERLOADABLE long convert_long_rtp(short x);
OVERLOADABLE long convert_long_rtn(short x);
OVERLOADABLE ulong convert_ulong_rte(short x);
OVERLOADABLE ulong convert_ulong_rtz(short x);
OVERLOADABLE ulong convert_ulong_rtp(short x);
OVERLOADABLE ulong convert_ulong_rtn(short x);
OVERLOADABLE int convert_int_rte(short x);
OVERLOADABLE int convert_int_rtz(short x);
OVERLOADABLE int convert_int_rtp(short x);
OVERLOADABLE int convert_int_rtn(short x);
OVERLOADABLE uint convert_uint_rte(short x);
OVERLOADABLE uint convert_uint_rtz(short x);
OVERLOADABLE uint convert_uint_rtp(short x);
OVERLOADABLE uint convert_uint_rtn(short x);
OVERLOADABLE short convert_short_rte(short x);
OVERLOADABLE short convert_short_rtz(short x);
OVERLOADABLE short convert_short_rtp(short x);
OVERLOADABLE short convert_short_rtn(short x);
OVERLOADABLE ushort convert_ushort_rte(short x);
OVERLOADABLE ushort convert_ushort_rtz(short x);
OVERLOADABLE ushort convert_ushort_rtp(short x);
OVERLOADABLE ushort convert_ushort_rtn(short x);
OVERLOADABLE char convert_char_rte(short x);
OVERLOADABLE char convert_char_rtz(short x);
OVERLOADABLE char convert_char_rtp(short x);
OVERLOADABLE char convert_char_rtn(short x);
OVERLOADABLE uchar convert_uchar_rte(short x);
OVERLOADABLE uchar convert_uchar_rtz(short x);
OVERLOADABLE uchar convert_uchar_rtp(short x);
OVERLOADABLE uchar convert_uchar_rtn(short x);
OVERLOADABLE float convert_float_rte(short x);
OVERLOADABLE float convert_float_rtz(short x);
OVERLOADABLE float convert_float_rtp(short x);
OVERLOADABLE float convert_float_rtn(short x);
OVERLOADABLE half convert_half_rte(short x);
OVERLOADABLE half convert_half_rtz(short x);
OVERLOADABLE half convert_half_rtp(short x);
OVERLOADABLE half convert_half_rtn(short x);
OVERLOADABLE long convert_long_rte(ushort x);
OVERLOADABLE long convert_long_rtz(ushort x);
OVERLOADABLE long convert_long_rtp(ushort x);
OVERLOADABLE long convert_long_rtn(ushort x);
OVERLOADABLE ulong convert_ulong_rte(ushort x);
OVERLOADABLE ulong convert_ulong_rtz(ushort x);
OVERLOADABLE ulong convert_ulong_rtp(ushort x);
OVERLOADABLE ulong convert_ulong_rtn(ushort x);
OVERLOADABLE int convert_int_rte(ushort x);
OVERLOADABLE int convert_int_rtz(ushort x);
OVERLOADABLE int convert_int_rtp(ushort x);
OVERLOADABLE int convert_int_rtn(ushort x);
OVERLOADABLE uint convert_uint_rte(ushort x);
OVERLOADABLE uint convert_uint_rtz(ushort x);
OVERLOADABLE uint convert_uint_rtp(ushort x);
OVERLOADABLE uint convert_uint_rtn(ushort x);
OVERLOADABLE short convert_short_rte(ushort x);
OVERLOADABLE short convert_short_rtz(ushort x);
OVERLOADABLE short convert_short_rtp(ushort x);
OVERLOADABLE short convert_short_rtn(ushort x);
OVERLOADABLE ushort convert_ushort_rte(ushort x);
OVERLOADABLE ushort convert_ushort_rtz(ushort x);
OVERLOADABLE ushort convert_ushort_rtp(ushort x);
OVERLOADABLE ushort convert_ushort_rtn(ushort x);
OVERLOADABLE char convert_char_rte(ushort x);
OVERLOADABLE char convert_char_rtz(ushort x);
OVERLOADABLE char convert_char_rtp(ushort x);
OVERLOADABLE char convert_char_rtn(ushort x);
OVERLOADABLE uchar convert_uchar_rte(ushort x);
OVERLOADABLE uchar convert_uchar_rtz(ushort x);
OVERLOADABLE uchar convert_uchar_rtp(ushort x);
OVERLOADABLE uchar convert_uchar_rtn(ushort x);
OVERLOADABLE float convert_float_rte(ushort x);
OVERLOADABLE float convert_float_rtz(ushort x);
OVERLOADABLE float convert_float_rtp(ushort x);
OVERLOADABLE float convert_float_rtn(ushort x);
OVERLOADABLE half convert_half_rte(ushort x);
OVERLOADABLE half convert_half_rtz(ushort x);
OVERLOADABLE half convert_half_rtp(ushort x);
OVERLOADABLE half convert_half_rtn(ushort x);
OVERLOADABLE long convert_long_rte(char x);
OVERLOADABLE long convert_long_rtz(char x);
OVERLOADABLE long convert_long_rtp(char x);
OVERLOADABLE long convert_long_rtn(char x);
OVERLOADABLE ulong convert_ulong_rte(char x);
OVERLOADABLE ulong convert_ulong_rtz(char x);
OVERLOADABLE ulong convert_ulong_rtp(char x);
OVERLOADABLE ulong convert_ulong_rtn(char x);
OVERLOADABLE int convert_int_rte(char x);
OVERLOADABLE int convert_int_rtz(char x);
OVERLOADABLE int convert_int_rtp(char x);
OVERLOADABLE int convert_int_rtn(char x);
OVERLOADABLE uint convert_uint_rte(char x);
OVERLOADABLE uint convert_uint_rtz(char x);
OVERLOADABLE uint convert_uint_rtp(char x);
OVERLOADABLE uint convert_uint_rtn(char x);
OVERLOADABLE short convert_short_rte(char x);
OVERLOADABLE short convert_short_rtz(char x);
OVERLOADABLE short convert_short_rtp(char x);
OVERLOADABLE short convert_short_rtn(char x);
OVERLOADABLE ushort convert_ushort_rte(char x);
OVERLOADABLE ushort convert_ushort_rtz(char x);
OVERLOADABLE ushort convert_ushort_rtp(char x);
OVERLOADABLE ushort convert_ushort_rtn(char x);
OVERLOADABLE char convert_char_rte(char x);
OVERLOADABLE char convert_char_rtz(char x);
OVERLOADABLE char convert_char_rtp(char x);
OVERLOADABLE char convert_char_rtn(char x);
OVERLOADABLE uchar convert_uchar_rte(char x);
OVERLOADABLE uchar convert_uchar_rtz(char x);
OVERLOADABLE uchar convert_uchar_rtp(char x);
OVERLOADABLE uchar convert_uchar_rtn(char x);
OVERLOADABLE float convert_float_rte(char x);
OVERLOADABLE float convert_float_rtz(char x);
OVERLOADABLE float convert_float_rtp(char x);
OVERLOADABLE float convert_float_rtn(char x);
OVERLOADABLE half convert_half_rte(char x);
OVERLOADABLE half convert_half_rtz(char x);
OVERLOADABLE half convert_half_rtp(char x);
OVERLOADABLE half convert_half_rtn(char x);
OVERLOADABLE long convert_long_rte(uchar x);
OVERLOADABLE long convert_long_rtz(uchar x);
OVERLOADABLE long convert_long_rtp(uchar x);
OVERLOADABLE long convert_long_rtn(uchar x);
OVERLOADABLE ulong convert_ulong_rte(uchar x);
OVERLOADABLE ulong convert_ulong_rtz(uchar x);
OVERLOADABLE ulong convert_ulong_rtp(uchar x);
OVERLOADABLE ulong convert_ulong_rtn(uchar x);
OVERLOADABLE int convert_int_rte(uchar x);
OVERLOADABLE int convert_int_rtz(uchar x);
OVERLOADABLE int convert_int_rtp(uchar x);
OVERLOADABLE int convert_int_rtn(uchar x);
OVERLOADABLE uint convert_uint_rte(uchar x);
OVERLOADABLE uint convert_uint_rtz(uchar x);
OVERLOADABLE uint convert_uint_rtp(uchar x);
OVERLOADABLE uint convert_uint_rtn(uchar x);
OVERLOADABLE short convert_short_rte(uchar x);
OVERLOADABLE short convert_short_rtz(uchar x);
OVERLOADABLE short convert_short_rtp(uchar x);
OVERLOADABLE short convert_short_rtn(uchar x);
OVERLOADABLE ushort convert_ushort_rte(uchar x);
OVERLOADABLE ushort convert_ushort_rtz(uchar x);
OVERLOADABLE ushort convert_ushort_rtp(uchar x);
OVERLOADABLE ushort convert_ushort_rtn(uchar x);
OVERLOADABLE char convert_char_rte(uchar x);
OVERLOADABLE char convert_char_rtz(uchar x);
OVERLOADABLE char convert_char_rtp(uchar x);
OVERLOADABLE char convert_char_rtn(uchar x);
OVERLOADABLE uchar convert_uchar_rte(uchar x);
OVERLOADABLE uchar convert_uchar_rtz(uchar x);
OVERLOADABLE uchar convert_uchar_rtp(uchar x);
OVERLOADABLE uchar convert_uchar_rtn(uchar x);
OVERLOADABLE float convert_float_rte(uchar x);
OVERLOADABLE float convert_float_rtz(uchar x);
OVERLOADABLE float convert_float_rtp(uchar x);
OVERLOADABLE float convert_float_rtn(uchar x);
OVERLOADABLE half convert_half_rte(uchar x);
OVERLOADABLE half convert_half_rtz(uchar x);
OVERLOADABLE half convert_half_rtp(uchar x);
OVERLOADABLE half convert_half_rtn(uchar x);
OVERLOADABLE long convert_long_rte(double x);
OVERLOADABLE long convert_long_rtz(double x);
OVERLOADABLE long convert_long_rtp(double x);
OVERLOADABLE long convert_long_rtn(double x);
OVERLOADABLE ulong convert_ulong_rte(double x);
OVERLOADABLE ulong convert_ulong_rtz(double x);
OVERLOADABLE ulong convert_ulong_rtp(double x);
OVERLOADABLE ulong convert_ulong_rtn(double x);
OVERLOADABLE int convert_int_rte(double x);
OVERLOADABLE int convert_int_rtz(double x);
OVERLOADABLE int convert_int_rtp(double x);
OVERLOADABLE int convert_int_rtn(double x);
OVERLOADABLE uint convert_uint_rte(double x);
OVERLOADABLE uint convert_uint_rtz(double x);
OVERLOADABLE uint convert_uint_rtp(double x);
OVERLOADABLE uint convert_uint_rtn(double x);
OVERLOADABLE short convert_short_rte(double x);
OVERLOADABLE short convert_short_rtz(double x);
OVERLOADABLE short convert_short_rtp(double x);
OVERLOADABLE short convert_short_rtn(double x);
OVERLOADABLE ushort convert_ushort_rte(double x);
OVERLOADABLE ushort convert_ushort_rtz(double x);
OVERLOADABLE ushort convert_ushort_rtp(double x);
OVERLOADABLE ushort convert_ushort_rtn(double x);
OVERLOADABLE char convert_char_rte(double x);
OVERLOADABLE char convert_char_rtz(double x);
OVERLOADABLE char convert_char_rtp(double x);
OVERLOADABLE char convert_char_rtn(double x);
OVERLOADABLE uchar convert_uchar_rte(double x);
OVERLOADABLE uchar convert_uchar_rtz(double x);
OVERLOADABLE uchar convert_uchar_rtp(double x);
OVERLOADABLE uchar convert_uchar_rtn(double x);
OVERLOADABLE float convert_float_rte(double x);
OVERLOADABLE float convert_float_rtz(double x);
OVERLOADABLE float convert_float_rtp(double x);
OVERLOADABLE float convert_float_rtn(double x);
OVERLOADABLE half convert_half_rte(double x);
OVERLOADABLE half convert_half_rtz(double x);
OVERLOADABLE half convert_half_rtp(double x);
OVERLOADABLE half convert_half_rtn(double x);
OVERLOADABLE long convert_long_rte(float x);
OVERLOADABLE long convert_long_rtz(float x);
OVERLOADABLE long convert_long_rtp(float x);
OVERLOADABLE long convert_long_rtn(float x);
OVERLOADABLE ulong convert_ulong_rte(float x);
OVERLOADABLE ulong convert_ulong_rtz(float x);
OVERLOADABLE ulong convert_ulong_rtp(float x);
OVERLOADABLE ulong convert_ulong_rtn(float x);
OVERLOADABLE int convert_int_rte(float x);
OVERLOADABLE int convert_int_rtz(float x);
OVERLOADABLE int convert_int_rtp(float x);
OVERLOADABLE int convert_int_rtn(float x);
OVERLOADABLE uint convert_uint_rte(float x);
OVERLOADABLE uint convert_uint_rtz(float x);
OVERLOADABLE uint convert_uint_rtp(float x);
OVERLOADABLE uint convert_uint_rtn(float x);
OVERLOADABLE short convert_short_rte(float x);
OVERLOADABLE short convert_short_rtz(float x);
OVERLOADABLE short convert_short_rtp(float x);
OVERLOADABLE short convert_short_rtn(float x);
OVERLOADABLE ushort convert_ushort_rte(float x);
OVERLOADABLE ushort convert_ushort_rtz(float x);
OVERLOADABLE ushort convert_ushort_rtp(float x);
OVERLOADABLE ushort convert_ushort_rtn(float x);
OVERLOADABLE char convert_char_rte(float x);
OVERLOADABLE char convert_char_rtz(float x);
OVERLOADABLE char convert_char_rtp(float x);
OVERLOADABLE char convert_char_rtn(float x);
OVERLOADABLE uchar convert_uchar_rte(float x);
OVERLOADABLE uchar convert_uchar_rtz(float x);
OVERLOADABLE uchar convert_uchar_rtp(float x);
OVERLOADABLE uchar convert_uchar_rtn(float x);
OVERLOADABLE float convert_float_rte(float x);
OVERLOADABLE float convert_float_rtz(float x);
OVERLOADABLE float convert_float_rtp(float x);
OVERLOADABLE float convert_float_rtn(float x);
OVERLOADABLE half convert_half_rte(float x);
OVERLOADABLE half convert_half_rtz(float x);
OVERLOADABLE half convert_half_rtp(float x);
OVERLOADABLE half convert_half_rtn(float x);
OVERLOADABLE long convert_long_rte(half x);
OVERLOADABLE long convert_long_rtz(half x);
OVERLOADABLE long convert_long_rtp(half x);
OVERLOADABLE long convert_long_rtn(half x);
OVERLOADABLE ulong convert_ulong_rte(half x);
OVERLOADABLE ulong convert_ulong_rtz(half x);
OVERLOADABLE ulong convert_ulong_rtp(half x);
OVERLOADABLE ulong convert_ulong_rtn(half x);
OVERLOADABLE int convert_int_rte(half x);
OVERLOADABLE int convert_int_rtz(half x);
OVERLOADABLE int convert_int_rtp(half x);
OVERLOADABLE int convert_int_rtn(half x);
OVERLOADABLE uint convert_uint_rte(half x);
OVERLOADABLE uint convert_uint_rtz(half x);
OVERLOADABLE uint convert_uint_rtp(half x);
OVERLOADABLE uint convert_uint_rtn(half x);
OVERLOADABLE short convert_short_rte(half x);
OVERLOADABLE short convert_short_rtz(half x);
OVERLOADABLE short convert_short_rtp(half x);
OVERLOADABLE short convert_short_rtn(half x);
OVERLOADABLE ushort convert_ushort_rte(half x);
OVERLOADABLE ushort convert_ushort_rtz(half x);
OVERLOADABLE ushort convert_ushort_rtp(half x);
OVERLOADABLE ushort convert_ushort_rtn(half x);
OVERLOADABLE char convert_char_rte(half x);
OVERLOADABLE char convert_char_rtz(half x);
OVERLOADABLE char convert_char_rtp(half x);
OVERLOADABLE char convert_char_rtn(half x);
OVERLOADABLE uchar convert_uchar_rte(half x);
OVERLOADABLE uchar convert_uchar_rtz(half x);
OVERLOADABLE uchar convert_uchar_rtp(half x);
OVERLOADABLE uchar convert_uchar_rtn(half x);
OVERLOADABLE float convert_float_rte(half x);
OVERLOADABLE float convert_float_rtz(half x);
OVERLOADABLE float convert_float_rtp(half x);
OVERLOADABLE float convert_float_rtn(half x);
OVERLOADABLE half convert_half_rte(half x);
OVERLOADABLE half convert_half_rtz(half x);
OVERLOADABLE half convert_half_rtp(half x);
OVERLOADABLE half convert_half_rtn(half x);
OVERLOADABLE long2 convert_long2_rte(long2 v);
OVERLOADABLE long2 convert_long2_rtz(long2 v);
OVERLOADABLE long2 convert_long2_rtp(long2 v);
OVERLOADABLE long2 convert_long2_rtn(long2 v);
OVERLOADABLE ulong2 convert_ulong2_rte(long2 v);
OVERLOADABLE ulong2 convert_ulong2_rtz(long2 v);
OVERLOADABLE ulong2 convert_ulong2_rtp(long2 v);
OVERLOADABLE ulong2 convert_ulong2_rtn(long2 v);
OVERLOADABLE int2 convert_int2_rte(long2 v);
OVERLOADABLE int2 convert_int2_rtz(long2 v);
OVERLOADABLE int2 convert_int2_rtp(long2 v);
OVERLOADABLE int2 convert_int2_rtn(long2 v);
OVERLOADABLE uint2 convert_uint2_rte(long2 v);
OVERLOADABLE uint2 convert_uint2_rtz(long2 v);
OVERLOADABLE uint2 convert_uint2_rtp(long2 v);
OVERLOADABLE uint2 convert_uint2_rtn(long2 v);
OVERLOADABLE short2 convert_short2_rte(long2 v);
OVERLOADABLE short2 convert_short2_rtz(long2 v);
OVERLOADABLE short2 convert_short2_rtp(long2 v);
OVERLOADABLE short2 convert_short2_rtn(long2 v);
OVERLOADABLE ushort2 convert_ushort2_rte(long2 v);
OVERLOADABLE ushort2 convert_ushort2_rtz(long2 v);
OVERLOADABLE ushort2 convert_ushort2_rtp(long2 v);
OVERLOADABLE ushort2 convert_ushort2_rtn(long2 v);
OVERLOADABLE char2 convert_char2_rte(long2 v);
OVERLOADABLE char2 convert_char2_rtz(long2 v);
OVERLOADABLE char2 convert_char2_rtp(long2 v);
OVERLOADABLE char2 convert_char2_rtn(long2 v);
OVERLOADABLE uchar2 convert_uchar2_rte(long2 v);
OVERLOADABLE uchar2 convert_uchar2_rtz(long2 v);
OVERLOADABLE uchar2 convert_uchar2_rtp(long2 v);
OVERLOADABLE uchar2 convert_uchar2_rtn(long2 v);
OVERLOADABLE float2 convert_float2_rte(long2 v);
OVERLOADABLE float2 convert_float2_rtz(long2 v);
OVERLOADABLE float2 convert_float2_rtp(long2 v);
OVERLOADABLE float2 convert_float2_rtn(long2 v);
OVERLOADABLE half2 convert_half2_rte(long2 v);
OVERLOADABLE half2 convert_half2_rtz(long2 v);
OVERLOADABLE half2 convert_half2_rtp(long2 v);
OVERLOADABLE half2 convert_half2_rtn(long2 v);
OVERLOADABLE long2 convert_long2_rte(ulong2 v);
OVERLOADABLE long2 convert_long2_rtz(ulong2 v);
OVERLOADABLE long2 convert_long2_rtp(ulong2 v);
OVERLOADABLE long2 convert_long2_rtn(ulong2 v);
OVERLOADABLE ulong2 convert_ulong2_rte(ulong2 v);
OVERLOADABLE ulong2 convert_ulong2_rtz(ulong2 v);
OVERLOADABLE ulong2 convert_ulong2_rtp(ulong2 v);
OVERLOADABLE ulong2 convert_ulong2_rtn(ulong2 v);
OVERLOADABLE int2 convert_int2_rte(ulong2 v);
OVERLOADABLE int2 convert_int2_rtz(ulong2 v);
OVERLOADABLE int2 convert_int2_rtp(ulong2 v);
OVERLOADABLE int2 convert_int2_rtn(ulong2 v);
OVERLOADABLE uint2 convert_uint2_rte(ulong2 v);
OVERLOADABLE uint2 convert_uint2_rtz(ulong2 v);
OVERLOADABLE uint2 convert_uint2_rtp(ulong2 v);
OVERLOADABLE uint2 convert_uint2_rtn(ulong2 v);
OVERLOADABLE short2 convert_short2_rte(ulong2 v);
OVERLOADABLE short2 convert_short2_rtz(ulong2 v);
OVERLOADABLE short2 convert_short2_rtp(ulong2 v);
OVERLOADABLE short2 convert_short2_rtn(ulong2 v);
OVERLOADABLE ushort2 convert_ushort2_rte(ulong2 v);
OVERLOADABLE ushort2 convert_ushort2_rtz(ulong2 v);
OVERLOADABLE ushort2 convert_ushort2_rtp(ulong2 v);
OVERLOADABLE ushort2 convert_ushort2_rtn(ulong2 v);
OVERLOADABLE char2 convert_char2_rte(ulong2 v);
OVERLOADABLE char2 convert_char2_rtz(ulong2 v);
OVERLOADABLE char2 convert_char2_rtp(ulong2 v);
OVERLOADABLE char2 convert_char2_rtn(ulong2 v);
OVERLOADABLE uchar2 convert_uchar2_rte(ulong2 v);
OVERLOADABLE uchar2 convert_uchar2_rtz(ulong2 v);
OVERLOADABLE uchar2 convert_uchar2_rtp(ulong2 v);
OVERLOADABLE uchar2 convert_uchar2_rtn(ulong2 v);
OVERLOADABLE float2 convert_float2_rte(ulong2 v);
OVERLOADABLE float2 convert_float2_rtz(ulong2 v);
OVERLOADABLE float2 convert_float2_rtp(ulong2 v);
OVERLOADABLE float2 convert_float2_rtn(ulong2 v);
OVERLOADABLE half2 convert_half2_rte(ulong2 v);
OVERLOADABLE half2 convert_half2_rtz(ulong2 v);
OVERLOADABLE half2 convert_half2_rtp(ulong2 v);
OVERLOADABLE half2 convert_half2_rtn(ulong2 v);
OVERLOADABLE long2 convert_long2_rte(int2 v);
OVERLOADABLE long2 convert_long2_rtz(int2 v);
OVERLOADABLE long2 convert_long2_rtp(int2 v);
OVERLOADABLE long2 convert_long2_rtn(int2 v);
OVERLOADABLE ulong2 convert_ulong2_rte(int2 v);
OVERLOADABLE ulong2 convert_ulong2_rtz(int2 v);
OVERLOADABLE ulong2 convert_ulong2_rtp(int2 v);
OVERLOADABLE ulong2 convert_ulong2_rtn(int2 v);
OVERLOADABLE int2 convert_int2_rte(int2 v);
OVERLOADABLE int2 convert_int2_rtz(int2 v);
OVERLOADABLE int2 convert_int2_rtp(int2 v);
OVERLOADABLE int2 convert_int2_rtn(int2 v);
OVERLOADABLE uint2 convert_uint2_rte(int2 v);
OVERLOADABLE uint2 convert_uint2_rtz(int2 v);
OVERLOADABLE uint2 convert_uint2_rtp(int2 v);
OVERLOADABLE uint2 convert_uint2_rtn(int2 v);
OVERLOADABLE short2 convert_short2_rte(int2 v);
OVERLOADABLE short2 convert_short2_rtz(int2 v);
OVERLOADABLE short2 convert_short2_rtp(int2 v);
OVERLOADABLE short2 convert_short2_rtn(int2 v);
OVERLOADABLE ushort2 convert_ushort2_rte(int2 v);
OVERLOADABLE ushort2 convert_ushort2_rtz(int2 v);
OVERLOADABLE ushort2 convert_ushort2_rtp(int2 v);
OVERLOADABLE ushort2 convert_ushort2_rtn(int2 v);
OVERLOADABLE char2 convert_char2_rte(int2 v);
OVERLOADABLE char2 convert_char2_rtz(int2 v);
OVERLOADABLE char2 convert_char2_rtp(int2 v);
OVERLOADABLE char2 convert_char2_rtn(int2 v);
OVERLOADABLE uchar2 convert_uchar2_rte(int2 v);
OVERLOADABLE uchar2 convert_uchar2_rtz(int2 v);
OVERLOADABLE uchar2 convert_uchar2_rtp(int2 v);
OVERLOADABLE uchar2 convert_uchar2_rtn(int2 v);
OVERLOADABLE float2 convert_float2_rte(int2 v);
OVERLOADABLE float2 convert_float2_rtz(int2 v);
OVERLOADABLE float2 convert_float2_rtp(int2 v);
OVERLOADABLE float2 convert_float2_rtn(int2 v);
OVERLOADABLE half2 convert_half2_rte(int2 v);
OVERLOADABLE half2 convert_half2_rtz(int2 v);
OVERLOADABLE half2 convert_half2_rtp(int2 v);
OVERLOADABLE half2 convert_half2_rtn(int2 v);
OVERLOADABLE long2 convert_long2_rte(uint2 v);
OVERLOADABLE long2 convert_long2_rtz(uint2 v);
OVERLOADABLE long2 convert_long2_rtp(uint2 v);
OVERLOADABLE long2 convert_long2_rtn(uint2 v);
OVERLOADABLE ulong2 convert_ulong2_rte(uint2 v);
OVERLOADABLE ulong2 convert_ulong2_rtz(uint2 v);
OVERLOADABLE ulong2 convert_ulong2_rtp(uint2 v);
OVERLOADABLE ulong2 convert_ulong2_rtn(uint2 v);
OVERLOADABLE int2 convert_int2_rte(uint2 v);
OVERLOADABLE int2 convert_int2_rtz(uint2 v);
OVERLOADABLE int2 convert_int2_rtp(uint2 v);
OVERLOADABLE int2 convert_int2_rtn(uint2 v);
OVERLOADABLE uint2 convert_uint2_rte(uint2 v);
OVERLOADABLE uint2 convert_uint2_rtz(uint2 v);
OVERLOADABLE uint2 convert_uint2_rtp(uint2 v);
OVERLOADABLE uint2 convert_uint2_rtn(uint2 v);
OVERLOADABLE short2 convert_short2_rte(uint2 v);
OVERLOADABLE short2 convert_short2_rtz(uint2 v);
OVERLOADABLE short2 convert_short2_rtp(uint2 v);
OVERLOADABLE short2 convert_short2_rtn(uint2 v);
OVERLOADABLE ushort2 convert_ushort2_rte(uint2 v);
OVERLOADABLE ushort2 convert_ushort2_rtz(uint2 v);
OVERLOADABLE ushort2 convert_ushort2_rtp(uint2 v);
OVERLOADABLE ushort2 convert_ushort2_rtn(uint2 v);
OVERLOADABLE char2 convert_char2_rte(uint2 v);
OVERLOADABLE char2 convert_char2_rtz(uint2 v);
OVERLOADABLE char2 convert_char2_rtp(uint2 v);
OVERLOADABLE char2 convert_char2_rtn(uint2 v);
OVERLOADABLE uchar2 convert_uchar2_rte(uint2 v);
OVERLOADABLE uchar2 convert_uchar2_rtz(uint2 v);
OVERLOADABLE uchar2 convert_uchar2_rtp(uint2 v);
OVERLOADABLE uchar2 convert_uchar2_rtn(uint2 v);
OVERLOADABLE float2 convert_float2_rte(uint2 v);
OVERLOADABLE float2 convert_float2_rtz(uint2 v);
OVERLOADABLE float2 convert_float2_rtp(uint2 v);
OVERLOADABLE float2 convert_float2_rtn(uint2 v);
OVERLOADABLE half2 convert_half2_rte(uint2 v);
OVERLOADABLE half2 convert_half2_rtz(uint2 v);
OVERLOADABLE half2 convert_half2_rtp(uint2 v);
OVERLOADABLE half2 convert_half2_rtn(uint2 v);
OVERLOADABLE long2 convert_long2_rte(short2 v);
OVERLOADABLE long2 convert_long2_rtz(short2 v);
OVERLOADABLE long2 convert_long2_rtp(short2 v);
OVERLOADABLE long2 convert_long2_rtn(short2 v);
OVERLOADABLE ulong2 convert_ulong2_rte(short2 v);
OVERLOADABLE ulong2 convert_ulong2_rtz(short2 v);
OVERLOADABLE ulong2 convert_ulong2_rtp(short2 v);
OVERLOADABLE ulong2 convert_ulong2_rtn(short2 v);
OVERLOADABLE int2 convert_int2_rte(short2 v);
OVERLOADABLE int2 convert_int2_rtz(short2 v);
OVERLOADABLE int2 convert_int2_rtp(short2 v);
OVERLOADABLE int2 convert_int2_rtn(short2 v);
OVERLOADABLE uint2 convert_uint2_rte(short2 v);
OVERLOADABLE uint2 convert_uint2_rtz(short2 v);
OVERLOADABLE uint2 convert_uint2_rtp(short2 v);
OVERLOADABLE uint2 convert_uint2_rtn(short2 v);
OVERLOADABLE short2 convert_short2_rte(short2 v);
OVERLOADABLE short2 convert_short2_rtz(short2 v);
OVERLOADABLE short2 convert_short2_rtp(short2 v);
OVERLOADABLE short2 convert_short2_rtn(short2 v);
OVERLOADABLE ushort2 convert_ushort2_rte(short2 v);
OVERLOADABLE ushort2 convert_ushort2_rtz(short2 v);
OVERLOADABLE ushort2 convert_ushort2_rtp(short2 v);
OVERLOADABLE ushort2 convert_ushort2_rtn(short2 v);
OVERLOADABLE char2 convert_char2_rte(short2 v);
OVERLOADABLE char2 convert_char2_rtz(short2 v);
OVERLOADABLE char2 convert_char2_rtp(short2 v);
OVERLOADABLE char2 convert_char2_rtn(short2 v);
OVERLOADABLE uchar2 convert_uchar2_rte(short2 v);
OVERLOADABLE uchar2 convert_uchar2_rtz(short2 v);
OVERLOADABLE uchar2 convert_uchar2_rtp(short2 v);
OVERLOADABLE uchar2 convert_uchar2_rtn(short2 v);
OVERLOADABLE float2 convert_float2_rte(short2 v);
OVERLOADABLE float2 convert_float2_rtz(short2 v);
OVERLOADABLE float2 convert_float2_rtp(short2 v);
OVERLOADABLE float2 convert_float2_rtn(short2 v);
OVERLOADABLE half2 convert_half2_rte(short2 v);
OVERLOADABLE half2 convert_half2_rtz(short2 v);
OVERLOADABLE half2 convert_half2_rtp(short2 v);
OVERLOADABLE half2 convert_half2_rtn(short2 v);
OVERLOADABLE long2 convert_long2_rte(ushort2 v);
OVERLOADABLE long2 convert_long2_rtz(ushort2 v);
OVERLOADABLE long2 convert_long2_rtp(ushort2 v);
OVERLOADABLE long2 convert_long2_rtn(ushort2 v);
OVERLOADABLE ulong2 convert_ulong2_rte(ushort2 v);
OVERLOADABLE ulong2 convert_ulong2_rtz(ushort2 v);
OVERLOADABLE ulong2 convert_ulong2_rtp(ushort2 v);
OVERLOADABLE ulong2 convert_ulong2_rtn(ushort2 v);
OVERLOADABLE int2 convert_int2_rte(ushort2 v);
OVERLOADABLE int2 convert_int2_rtz(ushort2 v);
OVERLOADABLE int2 convert_int2_rtp(ushort2 v);
OVERLOADABLE int2 convert_int2_rtn(ushort2 v);
OVERLOADABLE uint2 convert_uint2_rte(ushort2 v);
OVERLOADABLE uint2 convert_uint2_rtz(ushort2 v);
OVERLOADABLE uint2 convert_uint2_rtp(ushort2 v);
OVERLOADABLE uint2 convert_uint2_rtn(ushort2 v);
OVERLOADABLE short2 convert_short2_rte(ushort2 v);
OVERLOADABLE short2 convert_short2_rtz(ushort2 v);
OVERLOADABLE short2 convert_short2_rtp(ushort2 v);
OVERLOADABLE short2 convert_short2_rtn(ushort2 v);
OVERLOADABLE ushort2 convert_ushort2_rte(ushort2 v);
OVERLOADABLE ushort2 convert_ushort2_rtz(ushort2 v);
OVERLOADABLE ushort2 convert_ushort2_rtp(ushort2 v);
OVERLOADABLE ushort2 convert_ushort2_rtn(ushort2 v);
OVERLOADABLE char2 convert_char2_rte(ushort2 v);
OVERLOADABLE char2 convert_char2_rtz(ushort2 v);
OVERLOADABLE char2 convert_char2_rtp(ushort2 v);
OVERLOADABLE char2 convert_char2_rtn(ushort2 v);
OVERLOADABLE uchar2 convert_uchar2_rte(ushort2 v);
OVERLOADABLE uchar2 convert_uchar2_rtz(ushort2 v);
OVERLOADABLE uchar2 convert_uchar2_rtp(ushort2 v);
OVERLOADABLE uchar2 convert_uchar2_rtn(ushort2 v);
OVERLOADABLE float2 convert_float2_rte(ushort2 v);
OVERLOADABLE float2 convert_float2_rtz(ushort2 v);
OVERLOADABLE float2 convert_float2_rtp(ushort2 v);
OVERLOADABLE float2 convert_float2_rtn(ushort2 v);
OVERLOADABLE half2 convert_half2_rte(ushort2 v);
OVERLOADABLE half2 convert_half2_rtz(ushort2 v);
OVERLOADABLE half2 convert_half2_rtp(ushort2 v);
OVERLOADABLE half2 convert_half2_rtn(ushort2 v);
OVERLOADABLE long2 convert_long2_rte(char2 v);
OVERLOADABLE long2 convert_long2_rtz(char2 v);
OVERLOADABLE long2 convert_long2_rtp(char2 v);
OVERLOADABLE long2 convert_long2_rtn(char2 v);
OVERLOADABLE ulong2 convert_ulong2_rte(char2 v);
OVERLOADABLE ulong2 convert_ulong2_rtz(char2 v);
OVERLOADABLE ulong2 convert_ulong2_rtp(char2 v);
OVERLOADABLE ulong2 convert_ulong2_rtn(char2 v);
OVERLOADABLE int2 convert_int2_rte(char2 v);
OVERLOADABLE int2 convert_int2_rtz(char2 v);
OVERLOADABLE int2 convert_int2_rtp(char2 v);
OVERLOADABLE int2 convert_int2_rtn(char2 v);
OVERLOADABLE uint2 convert_uint2_rte(char2 v);
OVERLOADABLE uint2 convert_uint2_rtz(char2 v);
OVERLOADABLE uint2 convert_uint2_rtp(char2 v);
OVERLOADABLE uint2 convert_uint2_rtn(char2 v);
OVERLOADABLE short2 convert_short2_rte(char2 v);
OVERLOADABLE short2 convert_short2_rtz(char2 v);
OVERLOADABLE short2 convert_short2_rtp(char2 v);
OVERLOADABLE short2 convert_short2_rtn(char2 v);
OVERLOADABLE ushort2 convert_ushort2_rte(char2 v);
OVERLOADABLE ushort2 convert_ushort2_rtz(char2 v);
OVERLOADABLE ushort2 convert_ushort2_rtp(char2 v);
OVERLOADABLE ushort2 convert_ushort2_rtn(char2 v);
OVERLOADABLE char2 convert_char2_rte(char2 v);
OVERLOADABLE char2 convert_char2_rtz(char2 v);
OVERLOADABLE char2 convert_char2_rtp(char2 v);
OVERLOADABLE char2 convert_char2_rtn(char2 v);
OVERLOADABLE uchar2 convert_uchar2_rte(char2 v);
OVERLOADABLE uchar2 convert_uchar2_rtz(char2 v);
OVERLOADABLE uchar2 convert_uchar2_rtp(char2 v);
OVERLOADABLE uchar2 convert_uchar2_rtn(char2 v);
OVERLOADABLE float2 convert_float2_rte(char2 v);
OVERLOADABLE float2 convert_float2_rtz(char2 v);
OVERLOADABLE float2 convert_float2_rtp(char2 v);
OVERLOADABLE float2 convert_float2_rtn(char2 v);
OVERLOADABLE half2 convert_half2_rte(char2 v);
OVERLOADABLE half2 convert_half2_rtz(char2 v);
OVERLOADABLE half2 convert_half2_rtp(char2 v);
OVERLOADABLE half2 convert_half2_rtn(char2 v);
OVERLOADABLE long2 convert_long2_rte(uchar2 v);
OVERLOADABLE long2 convert_long2_rtz(uchar2 v);
OVERLOADABLE long2 convert_long2_rtp(uchar2 v);
OVERLOADABLE long2 convert_long2_rtn(uchar2 v);
OVERLOADABLE ulong2 convert_ulong2_rte(uchar2 v);
OVERLOADABLE ulong2 convert_ulong2_rtz(uchar2 v);
OVERLOADABLE ulong2 convert_ulong2_rtp(uchar2 v);
OVERLOADABLE ulong2 convert_ulong2_rtn(uchar2 v);
OVERLOADABLE int2 convert_int2_rte(uchar2 v);
OVERLOADABLE int2 convert_int2_rtz(uchar2 v);
OVERLOADABLE int2 convert_int2_rtp(uchar2 v);
OVERLOADABLE int2 convert_int2_rtn(uchar2 v);
OVERLOADABLE uint2 convert_uint2_rte(uchar2 v);
OVERLOADABLE uint2 convert_uint2_rtz(uchar2 v);
OVERLOADABLE uint2 convert_uint2_rtp(uchar2 v);
OVERLOADABLE uint2 convert_uint2_rtn(uchar2 v);
OVERLOADABLE short2 convert_short2_rte(uchar2 v);
OVERLOADABLE short2 convert_short2_rtz(uchar2 v);
OVERLOADABLE short2 convert_short2_rtp(uchar2 v);
OVERLOADABLE short2 convert_short2_rtn(uchar2 v);
OVERLOADABLE ushort2 convert_ushort2_rte(uchar2 v);
OVERLOADABLE ushort2 convert_ushort2_rtz(uchar2 v);
OVERLOADABLE ushort2 convert_ushort2_rtp(uchar2 v);
OVERLOADABLE ushort2 convert_ushort2_rtn(uchar2 v);
OVERLOADABLE char2 convert_char2_rte(uchar2 v);
OVERLOADABLE char2 convert_char2_rtz(uchar2 v);
OVERLOADABLE char2 convert_char2_rtp(uchar2 v);
OVERLOADABLE char2 convert_char2_rtn(uchar2 v);
OVERLOADABLE uchar2 convert_uchar2_rte(uchar2 v);
OVERLOADABLE uchar2 convert_uchar2_rtz(uchar2 v);
OVERLOADABLE uchar2 convert_uchar2_rtp(uchar2 v);
OVERLOADABLE uchar2 convert_uchar2_rtn(uchar2 v);
OVERLOADABLE float2 convert_float2_rte(uchar2 v);
OVERLOADABLE float2 convert_float2_rtz(uchar2 v);
OVERLOADABLE float2 convert_float2_rtp(uchar2 v);
OVERLOADABLE float2 convert_float2_rtn(uchar2 v);
OVERLOADABLE half2 convert_half2_rte(uchar2 v);
OVERLOADABLE half2 convert_half2_rtz(uchar2 v);
OVERLOADABLE half2 convert_half2_rtp(uchar2 v);
OVERLOADABLE half2 convert_half2_rtn(uchar2 v);
OVERLOADABLE long2 convert_long2_rte(double2 v);
OVERLOADABLE long2 convert_long2_rtz(double2 v);
OVERLOADABLE long2 convert_long2_rtp(double2 v);
OVERLOADABLE long2 convert_long2_rtn(double2 v);
OVERLOADABLE ulong2 convert_ulong2_rte(double2 v);
OVERLOADABLE ulong2 convert_ulong2_rtz(double2 v);
OVERLOADABLE ulong2 convert_ulong2_rtp(double2 v);
OVERLOADABLE ulong2 convert_ulong2_rtn(double2 v);
OVERLOADABLE int2 convert_int2_rte(double2 v);
OVERLOADABLE int2 convert_int2_rtz(double2 v);
OVERLOADABLE int2 convert_int2_rtp(double2 v);
OVERLOADABLE int2 convert_int2_rtn(double2 v);
OVERLOADABLE uint2 convert_uint2_rte(double2 v);
OVERLOADABLE uint2 convert_uint2_rtz(double2 v);
OVERLOADABLE uint2 convert_uint2_rtp(double2 v);
OVERLOADABLE uint2 convert_uint2_rtn(double2 v);
OVERLOADABLE short2 convert_short2_rte(double2 v);
OVERLOADABLE short2 convert_short2_rtz(double2 v);
OVERLOADABLE short2 convert_short2_rtp(double2 v);
OVERLOADABLE short2 convert_short2_rtn(double2 v);
OVERLOADABLE ushort2 convert_ushort2_rte(double2 v);
OVERLOADABLE ushort2 convert_ushort2_rtz(double2 v);
OVERLOADABLE ushort2 convert_ushort2_rtp(double2 v);
OVERLOADABLE ushort2 convert_ushort2_rtn(double2 v);
OVERLOADABLE char2 convert_char2_rte(double2 v);
OVERLOADABLE char2 convert_char2_rtz(double2 v);
OVERLOADABLE char2 convert_char2_rtp(double2 v);
OVERLOADABLE char2 convert_char2_rtn(double2 v);
OVERLOADABLE uchar2 convert_uchar2_rte(double2 v);
OVERLOADABLE uchar2 convert_uchar2_rtz(double2 v);
OVERLOADABLE uchar2 convert_uchar2_rtp(double2 v);
OVERLOADABLE uchar2 convert_uchar2_rtn(double2 v);
OVERLOADABLE float2 convert_float2_rte(double2 v);
OVERLOADABLE float2 convert_float2_rtz(double2 v);
OVERLOADABLE float2 convert_float2_rtp(double2 v);
OVERLOADABLE float2 convert_float2_rtn(double2 v);
OVERLOADABLE half2 convert_half2_rte(double2 v);
OVERLOADABLE half2 convert_half2_rtz(double2 v);
OVERLOADABLE half2 convert_half2_rtp(double2 v);
OVERLOADABLE half2 convert_half2_rtn(double2 v);
OVERLOADABLE long2 convert_long2_rte(float2 v);
OVERLOADABLE long2 convert_long2_rtz(float2 v);
OVERLOADABLE long2 convert_long2_rtp(float2 v);
OVERLOADABLE long2 convert_long2_rtn(float2 v);
OVERLOADABLE ulong2 convert_ulong2_rte(float2 v);
OVERLOADABLE ulong2 convert_ulong2_rtz(float2 v);
OVERLOADABLE ulong2 convert_ulong2_rtp(float2 v);
OVERLOADABLE ulong2 convert_ulong2_rtn(float2 v);
OVERLOADABLE int2 convert_int2_rte(float2 v);
OVERLOADABLE int2 convert_int2_rtz(float2 v);
OVERLOADABLE int2 convert_int2_rtp(float2 v);
OVERLOADABLE int2 convert_int2_rtn(float2 v);
OVERLOADABLE uint2 convert_uint2_rte(float2 v);
OVERLOADABLE uint2 convert_uint2_rtz(float2 v);
OVERLOADABLE uint2 convert_uint2_rtp(float2 v);
OVERLOADABLE uint2 convert_uint2_rtn(float2 v);
OVERLOADABLE short2 convert_short2_rte(float2 v);
OVERLOADABLE short2 convert_short2_rtz(float2 v);
OVERLOADABLE short2 convert_short2_rtp(float2 v);
OVERLOADABLE short2 convert_short2_rtn(float2 v);
OVERLOADABLE ushort2 convert_ushort2_rte(float2 v);
OVERLOADABLE ushort2 convert_ushort2_rtz(float2 v);
OVERLOADABLE ushort2 convert_ushort2_rtp(float2 v);
OVERLOADABLE ushort2 convert_ushort2_rtn(float2 v);
OVERLOADABLE char2 convert_char2_rte(float2 v);
OVERLOADABLE char2 convert_char2_rtz(float2 v);
OVERLOADABLE char2 convert_char2_rtp(float2 v);
OVERLOADABLE char2 convert_char2_rtn(float2 v);
OVERLOADABLE uchar2 convert_uchar2_rte(float2 v);
OVERLOADABLE uchar2 convert_uchar2_rtz(float2 v);
OVERLOADABLE uchar2 convert_uchar2_rtp(float2 v);
OVERLOADABLE uchar2 convert_uchar2_rtn(float2 v);
OVERLOADABLE float2 convert_float2_rte(float2 v);
OVERLOADABLE float2 convert_float2_rtz(float2 v);
OVERLOADABLE float2 convert_float2_rtp(float2 v);
OVERLOADABLE float2 convert_float2_rtn(float2 v);
OVERLOADABLE half2 convert_half2_rte(float2 v);
OVERLOADABLE half2 convert_half2_rtz(float2 v);
OVERLOADABLE half2 convert_half2_rtp(float2 v);
OVERLOADABLE half2 convert_half2_rtn(float2 v);
OVERLOADABLE long2 convert_long2_rte(half2 v);
OVERLOADABLE long2 convert_long2_rtz(half2 v);
OVERLOADABLE long2 convert_long2_rtp(half2 v);
OVERLOADABLE long2 convert_long2_rtn(half2 v);
OVERLOADABLE ulong2 convert_ulong2_rte(half2 v);
OVERLOADABLE ulong2 convert_ulong2_rtz(half2 v);
OVERLOADABLE ulong2 convert_ulong2_rtp(half2 v);
OVERLOADABLE ulong2 convert_ulong2_rtn(half2 v);
OVERLOADABLE int2 convert_int2_rte(half2 v);
OVERLOADABLE int2 convert_int2_rtz(half2 v);
OVERLOADABLE int2 convert_int2_rtp(half2 v);
OVERLOADABLE int2 convert_int2_rtn(half2 v);
OVERLOADABLE uint2 convert_uint2_rte(half2 v);
OVERLOADABLE uint2 convert_uint2_rtz(half2 v);
OVERLOADABLE uint2 convert_uint2_rtp(half2 v);
OVERLOADABLE uint2 convert_uint2_rtn(half2 v);
OVERLOADABLE short2 convert_short2_rte(half2 v);
OVERLOADABLE short2 convert_short2_rtz(half2 v);
OVERLOADABLE short2 convert_short2_rtp(half2 v);
OVERLOADABLE short2 convert_short2_rtn(half2 v);
OVERLOADABLE ushort2 convert_ushort2_rte(half2 v);
OVERLOADABLE ushort2 convert_ushort2_rtz(half2 v);
OVERLOADABLE ushort2 convert_ushort2_rtp(half2 v);
OVERLOADABLE ushort2 convert_ushort2_rtn(half2 v);
OVERLOADABLE char2 convert_char2_rte(half2 v);
OVERLOADABLE char2 convert_char2_rtz(half2 v);
OVERLOADABLE char2 convert_char2_rtp(half2 v);
OVERLOADABLE char2 convert_char2_rtn(half2 v);
OVERLOADABLE uchar2 convert_uchar2_rte(half2 v);
OVERLOADABLE uchar2 convert_uchar2_rtz(half2 v);
OVERLOADABLE uchar2 convert_uchar2_rtp(half2 v);
OVERLOADABLE uchar2 convert_uchar2_rtn(half2 v);
OVERLOADABLE float2 convert_float2_rte(half2 v);
OVERLOADABLE float2 convert_float2_rtz(half2 v);
OVERLOADABLE float2 convert_float2_rtp(half2 v);
OVERLOADABLE float2 convert_float2_rtn(half2 v);
OVERLOADABLE half2 convert_half2_rte(half2 v);
OVERLOADABLE half2 convert_half2_rtz(half2 v);
OVERLOADABLE half2 convert_half2_rtp(half2 v);
OVERLOADABLE half2 convert_half2_rtn(half2 v);
OVERLOADABLE long3 convert_long3_rte(long3 v);
OVERLOADABLE long3 convert_long3_rtz(long3 v);
OVERLOADABLE long3 convert_long3_rtp(long3 v);
OVERLOADABLE long3 convert_long3_rtn(long3 v);
OVERLOADABLE ulong3 convert_ulong3_rte(long3 v);
OVERLOADABLE ulong3 convert_ulong3_rtz(long3 v);
OVERLOADABLE ulong3 convert_ulong3_rtp(long3 v);
OVERLOADABLE ulong3 convert_ulong3_rtn(long3 v);
OVERLOADABLE int3 convert_int3_rte(long3 v);
OVERLOADABLE int3 convert_int3_rtz(long3 v);
OVERLOADABLE int3 convert_int3_rtp(long3 v);
OVERLOADABLE int3 convert_int3_rtn(long3 v);
OVERLOADABLE uint3 convert_uint3_rte(long3 v);
OVERLOADABLE uint3 convert_uint3_rtz(long3 v);
OVERLOADABLE uint3 convert_uint3_rtp(long3 v);
OVERLOADABLE uint3 convert_uint3_rtn(long3 v);
OVERLOADABLE short3 convert_short3_rte(long3 v);
OVERLOADABLE short3 convert_short3_rtz(long3 v);
OVERLOADABLE short3 convert_short3_rtp(long3 v);
OVERLOADABLE short3 convert_short3_rtn(long3 v);
OVERLOADABLE ushort3 convert_ushort3_rte(long3 v);
OVERLOADABLE ushort3 convert_ushort3_rtz(long3 v);
OVERLOADABLE ushort3 convert_ushort3_rtp(long3 v);
OVERLOADABLE ushort3 convert_ushort3_rtn(long3 v);
OVERLOADABLE char3 convert_char3_rte(long3 v);
OVERLOADABLE char3 convert_char3_rtz(long3 v);
OVERLOADABLE char3 convert_char3_rtp(long3 v);
OVERLOADABLE char3 convert_char3_rtn(long3 v);
OVERLOADABLE uchar3 convert_uchar3_rte(long3 v);
OVERLOADABLE uchar3 convert_uchar3_rtz(long3 v);
OVERLOADABLE uchar3 convert_uchar3_rtp(long3 v);
OVERLOADABLE uchar3 convert_uchar3_rtn(long3 v);
OVERLOADABLE float3 convert_float3_rte(long3 v);
OVERLOADABLE float3 convert_float3_rtz(long3 v);
OVERLOADABLE float3 convert_float3_rtp(long3 v);
OVERLOADABLE float3 convert_float3_rtn(long3 v);
OVERLOADABLE half3 convert_half3_rte(long3 v);
OVERLOADABLE half3 convert_half3_rtz(long3 v);
OVERLOADABLE half3 convert_half3_rtp(long3 v);
OVERLOADABLE half3 convert_half3_rtn(long3 v);
OVERLOADABLE long3 convert_long3_rte(ulong3 v);
OVERLOADABLE long3 convert_long3_rtz(ulong3 v);
OVERLOADABLE long3 convert_long3_rtp(ulong3 v);
OVERLOADABLE long3 convert_long3_rtn(ulong3 v);
OVERLOADABLE ulong3 convert_ulong3_rte(ulong3 v);
OVERLOADABLE ulong3 convert_ulong3_rtz(ulong3 v);
OVERLOADABLE ulong3 convert_ulong3_rtp(ulong3 v);
OVERLOADABLE ulong3 convert_ulong3_rtn(ulong3 v);
OVERLOADABLE int3 convert_int3_rte(ulong3 v);
OVERLOADABLE int3 convert_int3_rtz(ulong3 v);
OVERLOADABLE int3 convert_int3_rtp(ulong3 v);
OVERLOADABLE int3 convert_int3_rtn(ulong3 v);
OVERLOADABLE uint3 convert_uint3_rte(ulong3 v);
OVERLOADABLE uint3 convert_uint3_rtz(ulong3 v);
OVERLOADABLE uint3 convert_uint3_rtp(ulong3 v);
OVERLOADABLE uint3 convert_uint3_rtn(ulong3 v);
OVERLOADABLE short3 convert_short3_rte(ulong3 v);
OVERLOADABLE short3 convert_short3_rtz(ulong3 v);
OVERLOADABLE short3 convert_short3_rtp(ulong3 v);
OVERLOADABLE short3 convert_short3_rtn(ulong3 v);
OVERLOADABLE ushort3 convert_ushort3_rte(ulong3 v);
OVERLOADABLE ushort3 convert_ushort3_rtz(ulong3 v);
OVERLOADABLE ushort3 convert_ushort3_rtp(ulong3 v);
OVERLOADABLE ushort3 convert_ushort3_rtn(ulong3 v);
OVERLOADABLE char3 convert_char3_rte(ulong3 v);
OVERLOADABLE char3 convert_char3_rtz(ulong3 v);
OVERLOADABLE char3 convert_char3_rtp(ulong3 v);
OVERLOADABLE char3 convert_char3_rtn(ulong3 v);
OVERLOADABLE uchar3 convert_uchar3_rte(ulong3 v);
OVERLOADABLE uchar3 convert_uchar3_rtz(ulong3 v);
OVERLOADABLE uchar3 convert_uchar3_rtp(ulong3 v);
OVERLOADABLE uchar3 convert_uchar3_rtn(ulong3 v);
OVERLOADABLE float3 convert_float3_rte(ulong3 v);
OVERLOADABLE float3 convert_float3_rtz(ulong3 v);
OVERLOADABLE float3 convert_float3_rtp(ulong3 v);
OVERLOADABLE float3 convert_float3_rtn(ulong3 v);
OVERLOADABLE half3 convert_half3_rte(ulong3 v);
OVERLOADABLE half3 convert_half3_rtz(ulong3 v);
OVERLOADABLE half3 convert_half3_rtp(ulong3 v);
OVERLOADABLE half3 convert_half3_rtn(ulong3 v);
OVERLOADABLE long3 convert_long3_rte(int3 v);
OVERLOADABLE long3 convert_long3_rtz(int3 v);
OVERLOADABLE long3 convert_long3_rtp(int3 v);
OVERLOADABLE long3 convert_long3_rtn(int3 v);
OVERLOADABLE ulong3 convert_ulong3_rte(int3 v);
OVERLOADABLE ulong3 convert_ulong3_rtz(int3 v);
OVERLOADABLE ulong3 convert_ulong3_rtp(int3 v);
OVERLOADABLE ulong3 convert_ulong3_rtn(int3 v);
OVERLOADABLE int3 convert_int3_rte(int3 v);
OVERLOADABLE int3 convert_int3_rtz(int3 v);
OVERLOADABLE int3 convert_int3_rtp(int3 v);
OVERLOADABLE int3 convert_int3_rtn(int3 v);
OVERLOADABLE uint3 convert_uint3_rte(int3 v);
OVERLOADABLE uint3 convert_uint3_rtz(int3 v);
OVERLOADABLE uint3 convert_uint3_rtp(int3 v);
OVERLOADABLE uint3 convert_uint3_rtn(int3 v);
OVERLOADABLE short3 convert_short3_rte(int3 v);
OVERLOADABLE short3 convert_short3_rtz(int3 v);
OVERLOADABLE short3 convert_short3_rtp(int3 v);
OVERLOADABLE short3 convert_short3_rtn(int3 v);
OVERLOADABLE ushort3 convert_ushort3_rte(int3 v);
OVERLOADABLE ushort3 convert_ushort3_rtz(int3 v);
OVERLOADABLE ushort3 convert_ushort3_rtp(int3 v);
OVERLOADABLE ushort3 convert_ushort3_rtn(int3 v);
OVERLOADABLE char3 convert_char3_rte(int3 v);
OVERLOADABLE char3 convert_char3_rtz(int3 v);
OVERLOADABLE char3 convert_char3_rtp(int3 v);
OVERLOADABLE char3 convert_char3_rtn(int3 v);
OVERLOADABLE uchar3 convert_uchar3_rte(int3 v);
OVERLOADABLE uchar3 convert_uchar3_rtz(int3 v);
OVERLOADABLE uchar3 convert_uchar3_rtp(int3 v);
OVERLOADABLE uchar3 convert_uchar3_rtn(int3 v);
OVERLOADABLE float3 convert_float3_rte(int3 v);
OVERLOADABLE float3 convert_float3_rtz(int3 v);
OVERLOADABLE float3 convert_float3_rtp(int3 v);
OVERLOADABLE float3 convert_float3_rtn(int3 v);
OVERLOADABLE half3 convert_half3_rte(int3 v);
OVERLOADABLE half3 convert_half3_rtz(int3 v);
OVERLOADABLE half3 convert_half3_rtp(int3 v);
OVERLOADABLE half3 convert_half3_rtn(int3 v);
OVERLOADABLE long3 convert_long3_rte(uint3 v);
OVERLOADABLE long3 convert_long3_rtz(uint3 v);
OVERLOADABLE long3 convert_long3_rtp(uint3 v);
OVERLOADABLE long3 convert_long3_rtn(uint3 v);
OVERLOADABLE ulong3 convert_ulong3_rte(uint3 v);
OVERLOADABLE ulong3 convert_ulong3_rtz(uint3 v);
OVERLOADABLE ulong3 convert_ulong3_rtp(uint3 v);
OVERLOADABLE ulong3 convert_ulong3_rtn(uint3 v);
OVERLOADABLE int3 convert_int3_rte(uint3 v);
OVERLOADABLE int3 convert_int3_rtz(uint3 v);
OVERLOADABLE int3 convert_int3_rtp(uint3 v);
OVERLOADABLE int3 convert_int3_rtn(uint3 v);
OVERLOADABLE uint3 convert_uint3_rte(uint3 v);
OVERLOADABLE uint3 convert_uint3_rtz(uint3 v);
OVERLOADABLE uint3 convert_uint3_rtp(uint3 v);
OVERLOADABLE uint3 convert_uint3_rtn(uint3 v);
OVERLOADABLE short3 convert_short3_rte(uint3 v);
OVERLOADABLE short3 convert_short3_rtz(uint3 v);
OVERLOADABLE short3 convert_short3_rtp(uint3 v);
OVERLOADABLE short3 convert_short3_rtn(uint3 v);
OVERLOADABLE ushort3 convert_ushort3_rte(uint3 v);
OVERLOADABLE ushort3 convert_ushort3_rtz(uint3 v);
OVERLOADABLE ushort3 convert_ushort3_rtp(uint3 v);
OVERLOADABLE ushort3 convert_ushort3_rtn(uint3 v);
OVERLOADABLE char3 convert_char3_rte(uint3 v);
OVERLOADABLE char3 convert_char3_rtz(uint3 v);
OVERLOADABLE char3 convert_char3_rtp(uint3 v);
OVERLOADABLE char3 convert_char3_rtn(uint3 v);
OVERLOADABLE uchar3 convert_uchar3_rte(uint3 v);
OVERLOADABLE uchar3 convert_uchar3_rtz(uint3 v);
OVERLOADABLE uchar3 convert_uchar3_rtp(uint3 v);
OVERLOADABLE uchar3 convert_uchar3_rtn(uint3 v);
OVERLOADABLE float3 convert_float3_rte(uint3 v);
OVERLOADABLE float3 convert_float3_rtz(uint3 v);
OVERLOADABLE float3 convert_float3_rtp(uint3 v);
OVERLOADABLE float3 convert_float3_rtn(uint3 v);
OVERLOADABLE half3 convert_half3_rte(uint3 v);
OVERLOADABLE half3 convert_half3_rtz(uint3 v);
OVERLOADABLE half3 convert_half3_rtp(uint3 v);
OVERLOADABLE half3 convert_half3_rtn(uint3 v);
OVERLOADABLE long3 convert_long3_rte(short3 v);
OVERLOADABLE long3 convert_long3_rtz(short3 v);
OVERLOADABLE long3 convert_long3_rtp(short3 v);
OVERLOADABLE long3 convert_long3_rtn(short3 v);
OVERLOADABLE ulong3 convert_ulong3_rte(short3 v);
OVERLOADABLE ulong3 convert_ulong3_rtz(short3 v);
OVERLOADABLE ulong3 convert_ulong3_rtp(short3 v);
OVERLOADABLE ulong3 convert_ulong3_rtn(short3 v);
OVERLOADABLE int3 convert_int3_rte(short3 v);
OVERLOADABLE int3 convert_int3_rtz(short3 v);
OVERLOADABLE int3 convert_int3_rtp(short3 v);
OVERLOADABLE int3 convert_int3_rtn(short3 v);
OVERLOADABLE uint3 convert_uint3_rte(short3 v);
OVERLOADABLE uint3 convert_uint3_rtz(short3 v);
OVERLOADABLE uint3 convert_uint3_rtp(short3 v);
OVERLOADABLE uint3 convert_uint3_rtn(short3 v);
OVERLOADABLE short3 convert_short3_rte(short3 v);
OVERLOADABLE short3 convert_short3_rtz(short3 v);
OVERLOADABLE short3 convert_short3_rtp(short3 v);
OVERLOADABLE short3 convert_short3_rtn(short3 v);
OVERLOADABLE ushort3 convert_ushort3_rte(short3 v);
OVERLOADABLE ushort3 convert_ushort3_rtz(short3 v);
OVERLOADABLE ushort3 convert_ushort3_rtp(short3 v);
OVERLOADABLE ushort3 convert_ushort3_rtn(short3 v);
OVERLOADABLE char3 convert_char3_rte(short3 v);
OVERLOADABLE char3 convert_char3_rtz(short3 v);
OVERLOADABLE char3 convert_char3_rtp(short3 v);
OVERLOADABLE char3 convert_char3_rtn(short3 v);
OVERLOADABLE uchar3 convert_uchar3_rte(short3 v);
OVERLOADABLE uchar3 convert_uchar3_rtz(short3 v);
OVERLOADABLE uchar3 convert_uchar3_rtp(short3 v);
OVERLOADABLE uchar3 convert_uchar3_rtn(short3 v);
OVERLOADABLE float3 convert_float3_rte(short3 v);
OVERLOADABLE float3 convert_float3_rtz(short3 v);
OVERLOADABLE float3 convert_float3_rtp(short3 v);
OVERLOADABLE float3 convert_float3_rtn(short3 v);
OVERLOADABLE half3 convert_half3_rte(short3 v);
OVERLOADABLE half3 convert_half3_rtz(short3 v);
OVERLOADABLE half3 convert_half3_rtp(short3 v);
OVERLOADABLE half3 convert_half3_rtn(short3 v);
OVERLOADABLE long3 convert_long3_rte(ushort3 v);
OVERLOADABLE long3 convert_long3_rtz(ushort3 v);
OVERLOADABLE long3 convert_long3_rtp(ushort3 v);
OVERLOADABLE long3 convert_long3_rtn(ushort3 v);
OVERLOADABLE ulong3 convert_ulong3_rte(ushort3 v);
OVERLOADABLE ulong3 convert_ulong3_rtz(ushort3 v);
OVERLOADABLE ulong3 convert_ulong3_rtp(ushort3 v);
OVERLOADABLE ulong3 convert_ulong3_rtn(ushort3 v);
OVERLOADABLE int3 convert_int3_rte(ushort3 v);
OVERLOADABLE int3 convert_int3_rtz(ushort3 v);
OVERLOADABLE int3 convert_int3_rtp(ushort3 v);
OVERLOADABLE int3 convert_int3_rtn(ushort3 v);
OVERLOADABLE uint3 convert_uint3_rte(ushort3 v);
OVERLOADABLE uint3 convert_uint3_rtz(ushort3 v);
OVERLOADABLE uint3 convert_uint3_rtp(ushort3 v);
OVERLOADABLE uint3 convert_uint3_rtn(ushort3 v);
OVERLOADABLE short3 convert_short3_rte(ushort3 v);
OVERLOADABLE short3 convert_short3_rtz(ushort3 v);
OVERLOADABLE short3 convert_short3_rtp(ushort3 v);
OVERLOADABLE short3 convert_short3_rtn(ushort3 v);
OVERLOADABLE ushort3 convert_ushort3_rte(ushort3 v);
OVERLOADABLE ushort3 convert_ushort3_rtz(ushort3 v);
OVERLOADABLE ushort3 convert_ushort3_rtp(ushort3 v);
OVERLOADABLE ushort3 convert_ushort3_rtn(ushort3 v);
OVERLOADABLE char3 convert_char3_rte(ushort3 v);
OVERLOADABLE char3 convert_char3_rtz(ushort3 v);
OVERLOADABLE char3 convert_char3_rtp(ushort3 v);
OVERLOADABLE char3 convert_char3_rtn(ushort3 v);
OVERLOADABLE uchar3 convert_uchar3_rte(ushort3 v);
OVERLOADABLE uchar3 convert_uchar3_rtz(ushort3 v);
OVERLOADABLE uchar3 convert_uchar3_rtp(ushort3 v);
OVERLOADABLE uchar3 convert_uchar3_rtn(ushort3 v);
OVERLOADABLE float3 convert_float3_rte(ushort3 v);
OVERLOADABLE float3 convert_float3_rtz(ushort3 v);
OVERLOADABLE float3 convert_float3_rtp(ushort3 v);
OVERLOADABLE float3 convert_float3_rtn(ushort3 v);
OVERLOADABLE half3 convert_half3_rte(ushort3 v);
OVERLOADABLE half3 convert_half3_rtz(ushort3 v);
OVERLOADABLE half3 convert_half3_rtp(ushort3 v);
OVERLOADABLE half3 convert_half3_rtn(ushort3 v);
OVERLOADABLE long3 convert_long3_rte(char3 v);
OVERLOADABLE long3 convert_long3_rtz(char3 v);
OVERLOADABLE long3 convert_long3_rtp(char3 v);
OVERLOADABLE long3 convert_long3_rtn(char3 v);
OVERLOADABLE ulong3 convert_ulong3_rte(char3 v);
OVERLOADABLE ulong3 convert_ulong3_rtz(char3 v);
OVERLOADABLE ulong3 convert_ulong3_rtp(char3 v);
OVERLOADABLE ulong3 convert_ulong3_rtn(char3 v);
OVERLOADABLE int3 convert_int3_rte(char3 v);
OVERLOADABLE int3 convert_int3_rtz(char3 v);
OVERLOADABLE int3 convert_int3_rtp(char3 v);
OVERLOADABLE int3 convert_int3_rtn(char3 v);
OVERLOADABLE uint3 convert_uint3_rte(char3 v);
OVERLOADABLE uint3 convert_uint3_rtz(char3 v);
OVERLOADABLE uint3 convert_uint3_rtp(char3 v);
OVERLOADABLE uint3 convert_uint3_rtn(char3 v);
OVERLOADABLE short3 convert_short3_rte(char3 v);
OVERLOADABLE short3 convert_short3_rtz(char3 v);
OVERLOADABLE short3 convert_short3_rtp(char3 v);
OVERLOADABLE short3 convert_short3_rtn(char3 v);
OVERLOADABLE ushort3 convert_ushort3_rte(char3 v);
OVERLOADABLE ushort3 convert_ushort3_rtz(char3 v);
OVERLOADABLE ushort3 convert_ushort3_rtp(char3 v);
OVERLOADABLE ushort3 convert_ushort3_rtn(char3 v);
OVERLOADABLE char3 convert_char3_rte(char3 v);
OVERLOADABLE char3 convert_char3_rtz(char3 v);
OVERLOADABLE char3 convert_char3_rtp(char3 v);
OVERLOADABLE char3 convert_char3_rtn(char3 v);
OVERLOADABLE uchar3 convert_uchar3_rte(char3 v);
OVERLOADABLE uchar3 convert_uchar3_rtz(char3 v);
OVERLOADABLE uchar3 convert_uchar3_rtp(char3 v);
OVERLOADABLE uchar3 convert_uchar3_rtn(char3 v);
OVERLOADABLE float3 convert_float3_rte(char3 v);
OVERLOADABLE float3 convert_float3_rtz(char3 v);
OVERLOADABLE float3 convert_float3_rtp(char3 v);
OVERLOADABLE float3 convert_float3_rtn(char3 v);
OVERLOADABLE half3 convert_half3_rte(char3 v);
OVERLOADABLE half3 convert_half3_rtz(char3 v);
OVERLOADABLE half3 convert_half3_rtp(char3 v);
OVERLOADABLE half3 convert_half3_rtn(char3 v);
OVERLOADABLE long3 convert_long3_rte(uchar3 v);
OVERLOADABLE long3 convert_long3_rtz(uchar3 v);
OVERLOADABLE long3 convert_long3_rtp(uchar3 v);
OVERLOADABLE long3 convert_long3_rtn(uchar3 v);
OVERLOADABLE ulong3 convert_ulong3_rte(uchar3 v);
OVERLOADABLE ulong3 convert_ulong3_rtz(uchar3 v);
OVERLOADABLE ulong3 convert_ulong3_rtp(uchar3 v);
OVERLOADABLE ulong3 convert_ulong3_rtn(uchar3 v);
OVERLOADABLE int3 convert_int3_rte(uchar3 v);
OVERLOADABLE int3 convert_int3_rtz(uchar3 v);
OVERLOADABLE int3 convert_int3_rtp(uchar3 v);
OVERLOADABLE int3 convert_int3_rtn(uchar3 v);
OVERLOADABLE uint3 convert_uint3_rte(uchar3 v);
OVERLOADABLE uint3 convert_uint3_rtz(uchar3 v);
OVERLOADABLE uint3 convert_uint3_rtp(uchar3 v);
OVERLOADABLE uint3 convert_uint3_rtn(uchar3 v);
OVERLOADABLE short3 convert_short3_rte(uchar3 v);
OVERLOADABLE short3 convert_short3_rtz(uchar3 v);
OVERLOADABLE short3 convert_short3_rtp(uchar3 v);
OVERLOADABLE short3 convert_short3_rtn(uchar3 v);
OVERLOADABLE ushort3 convert_ushort3_rte(uchar3 v);
OVERLOADABLE ushort3 convert_ushort3_rtz(uchar3 v);
OVERLOADABLE ushort3 convert_ushort3_rtp(uchar3 v);
OVERLOADABLE ushort3 convert_ushort3_rtn(uchar3 v);
OVERLOADABLE char3 convert_char3_rte(uchar3 v);
OVERLOADABLE char3 convert_char3_rtz(uchar3 v);
OVERLOADABLE char3 convert_char3_rtp(uchar3 v);
OVERLOADABLE char3 convert_char3_rtn(uchar3 v);
OVERLOADABLE uchar3 convert_uchar3_rte(uchar3 v);
OVERLOADABLE uchar3 convert_uchar3_rtz(uchar3 v);
OVERLOADABLE uchar3 convert_uchar3_rtp(uchar3 v);
OVERLOADABLE uchar3 convert_uchar3_rtn(uchar3 v);
OVERLOADABLE float3 convert_float3_rte(uchar3 v);
OVERLOADABLE float3 convert_float3_rtz(uchar3 v);
OVERLOADABLE float3 convert_float3_rtp(uchar3 v);
OVERLOADABLE float3 convert_float3_rtn(uchar3 v);
OVERLOADABLE half3 convert_half3_rte(uchar3 v);
OVERLOADABLE half3 convert_half3_rtz(uchar3 v);
OVERLOADABLE half3 convert_half3_rtp(uchar3 v);
OVERLOADABLE half3 convert_half3_rtn(uchar3 v);
OVERLOADABLE long3 convert_long3_rte(double3 v);
OVERLOADABLE long3 convert_long3_rtz(double3 v);
OVERLOADABLE long3 convert_long3_rtp(double3 v);
OVERLOADABLE long3 convert_long3_rtn(double3 v);
OVERLOADABLE ulong3 convert_ulong3_rte(double3 v);
OVERLOADABLE ulong3 convert_ulong3_rtz(double3 v);
OVERLOADABLE ulong3 convert_ulong3_rtp(double3 v);
OVERLOADABLE ulong3 convert_ulong3_rtn(double3 v);
OVERLOADABLE int3 convert_int3_rte(double3 v);
OVERLOADABLE int3 convert_int3_rtz(double3 v);
OVERLOADABLE int3 convert_int3_rtp(double3 v);
OVERLOADABLE int3 convert_int3_rtn(double3 v);
OVERLOADABLE uint3 convert_uint3_rte(double3 v);
OVERLOADABLE uint3 convert_uint3_rtz(double3 v);
OVERLOADABLE uint3 convert_uint3_rtp(double3 v);
OVERLOADABLE uint3 convert_uint3_rtn(double3 v);
OVERLOADABLE short3 convert_short3_rte(double3 v);
OVERLOADABLE short3 convert_short3_rtz(double3 v);
OVERLOADABLE short3 convert_short3_rtp(double3 v);
OVERLOADABLE short3 convert_short3_rtn(double3 v);
OVERLOADABLE ushort3 convert_ushort3_rte(double3 v);
OVERLOADABLE ushort3 convert_ushort3_rtz(double3 v);
OVERLOADABLE ushort3 convert_ushort3_rtp(double3 v);
OVERLOADABLE ushort3 convert_ushort3_rtn(double3 v);
OVERLOADABLE char3 convert_char3_rte(double3 v);
OVERLOADABLE char3 convert_char3_rtz(double3 v);
OVERLOADABLE char3 convert_char3_rtp(double3 v);
OVERLOADABLE char3 convert_char3_rtn(double3 v);
OVERLOADABLE uchar3 convert_uchar3_rte(double3 v);
OVERLOADABLE uchar3 convert_uchar3_rtz(double3 v);
OVERLOADABLE uchar3 convert_uchar3_rtp(double3 v);
OVERLOADABLE uchar3 convert_uchar3_rtn(double3 v);
OVERLOADABLE float3 convert_float3_rte(double3 v);
OVERLOADABLE float3 convert_float3_rtz(double3 v);
OVERLOADABLE float3 convert_float3_rtp(double3 v);
OVERLOADABLE float3 convert_float3_rtn(double3 v);
OVERLOADABLE half3 convert_half3_rte(double3 v);
OVERLOADABLE half3 convert_half3_rtz(double3 v);
OVERLOADABLE half3 convert_half3_rtp(double3 v);
OVERLOADABLE half3 convert_half3_rtn(double3 v);
OVERLOADABLE long3 convert_long3_rte(float3 v);
OVERLOADABLE long3 convert_long3_rtz(float3 v);
OVERLOADABLE long3 convert_long3_rtp(float3 v);
OVERLOADABLE long3 convert_long3_rtn(float3 v);
OVERLOADABLE ulong3 convert_ulong3_rte(float3 v);
OVERLOADABLE ulong3 convert_ulong3_rtz(float3 v);
OVERLOADABLE ulong3 convert_ulong3_rtp(float3 v);
OVERLOADABLE ulong3 convert_ulong3_rtn(float3 v);
OVERLOADABLE int3 convert_int3_rte(float3 v);
OVERLOADABLE int3 convert_int3_rtz(float3 v);
OVERLOADABLE int3 convert_int3_rtp(float3 v);
OVERLOADABLE int3 convert_int3_rtn(float3 v);
OVERLOADABLE uint3 convert_uint3_rte(float3 v);
OVERLOADABLE uint3 convert_uint3_rtz(float3 v);
OVERLOADABLE uint3 convert_uint3_rtp(float3 v);
OVERLOADABLE uint3 convert_uint3_rtn(float3 v);
OVERLOADABLE short3 convert_short3_rte(float3 v);
OVERLOADABLE short3 convert_short3_rtz(float3 v);
OVERLOADABLE short3 convert_short3_rtp(float3 v);
OVERLOADABLE short3 convert_short3_rtn(float3 v);
OVERLOADABLE ushort3 convert_ushort3_rte(float3 v);
OVERLOADABLE ushort3 convert_ushort3_rtz(float3 v);
OVERLOADABLE ushort3 convert_ushort3_rtp(float3 v);
OVERLOADABLE ushort3 convert_ushort3_rtn(float3 v);
OVERLOADABLE char3 convert_char3_rte(float3 v);
OVERLOADABLE char3 convert_char3_rtz(float3 v);
OVERLOADABLE char3 convert_char3_rtp(float3 v);
OVERLOADABLE char3 convert_char3_rtn(float3 v);
OVERLOADABLE uchar3 convert_uchar3_rte(float3 v);
OVERLOADABLE uchar3 convert_uchar3_rtz(float3 v);
OVERLOADABLE uchar3 convert_uchar3_rtp(float3 v);
OVERLOADABLE uchar3 convert_uchar3_rtn(float3 v);
OVERLOADABLE float3 convert_float3_rte(float3 v);
OVERLOADABLE float3 convert_float3_rtz(float3 v);
OVERLOADABLE float3 convert_float3_rtp(float3 v);
OVERLOADABLE float3 convert_float3_rtn(float3 v);
OVERLOADABLE half3 convert_half3_rte(float3 v);
OVERLOADABLE half3 convert_half3_rtz(float3 v);
OVERLOADABLE half3 convert_half3_rtp(float3 v);
OVERLOADABLE half3 convert_half3_rtn(float3 v);
OVERLOADABLE long3 convert_long3_rte(half3 v);
OVERLOADABLE long3 convert_long3_rtz(half3 v);
OVERLOADABLE long3 convert_long3_rtp(half3 v);
OVERLOADABLE long3 convert_long3_rtn(half3 v);
OVERLOADABLE ulong3 convert_ulong3_rte(half3 v);
OVERLOADABLE ulong3 convert_ulong3_rtz(half3 v);
OVERLOADABLE ulong3 convert_ulong3_rtp(half3 v);
OVERLOADABLE ulong3 convert_ulong3_rtn(half3 v);
OVERLOADABLE int3 convert_int3_rte(half3 v);
OVERLOADABLE int3 convert_int3_rtz(half3 v);
OVERLOADABLE int3 convert_int3_rtp(half3 v);
OVERLOADABLE int3 convert_int3_rtn(half3 v);
OVERLOADABLE uint3 convert_uint3_rte(half3 v);
OVERLOADABLE uint3 convert_uint3_rtz(half3 v);
OVERLOADABLE uint3 convert_uint3_rtp(half3 v);
OVERLOADABLE uint3 convert_uint3_rtn(half3 v);
OVERLOADABLE short3 convert_short3_rte(half3 v);
OVERLOADABLE short3 convert_short3_rtz(half3 v);
OVERLOADABLE short3 convert_short3_rtp(half3 v);
OVERLOADABLE short3 convert_short3_rtn(half3 v);
OVERLOADABLE ushort3 convert_ushort3_rte(half3 v);
OVERLOADABLE ushort3 convert_ushort3_rtz(half3 v);
OVERLOADABLE ushort3 convert_ushort3_rtp(half3 v);
OVERLOADABLE ushort3 convert_ushort3_rtn(half3 v);
OVERLOADABLE char3 convert_char3_rte(half3 v);
OVERLOADABLE char3 convert_char3_rtz(half3 v);
OVERLOADABLE char3 convert_char3_rtp(half3 v);
OVERLOADABLE char3 convert_char3_rtn(half3 v);
OVERLOADABLE uchar3 convert_uchar3_rte(half3 v);
OVERLOADABLE uchar3 convert_uchar3_rtz(half3 v);
OVERLOADABLE uchar3 convert_uchar3_rtp(half3 v);
OVERLOADABLE uchar3 convert_uchar3_rtn(half3 v);
OVERLOADABLE float3 convert_float3_rte(half3 v);
OVERLOADABLE float3 convert_float3_rtz(half3 v);
OVERLOADABLE float3 convert_float3_rtp(half3 v);
OVERLOADABLE float3 convert_float3_rtn(half3 v);
OVERLOADABLE half3 convert_half3_rte(half3 v);
OVERLOADABLE half3 convert_half3_rtz(half3 v);
OVERLOADABLE half3 convert_half3_rtp(half3 v);
OVERLOADABLE half3 convert_half3_rtn(half3 v);
OVERLOADABLE long4 convert_long4_rte(long4 v);
OVERLOADABLE long4 convert_long4_rtz(long4 v);
OVERLOADABLE long4 convert_long4_rtp(long4 v);
OVERLOADABLE long4 convert_long4_rtn(long4 v);
OVERLOADABLE ulong4 convert_ulong4_rte(long4 v);
OVERLOADABLE ulong4 convert_ulong4_rtz(long4 v);
OVERLOADABLE ulong4 convert_ulong4_rtp(long4 v);
OVERLOADABLE ulong4 convert_ulong4_rtn(long4 v);
OVERLOADABLE int4 convert_int4_rte(long4 v);
OVERLOADABLE int4 convert_int4_rtz(long4 v);
OVERLOADABLE int4 convert_int4_rtp(long4 v);
OVERLOADABLE int4 convert_int4_rtn(long4 v);
OVERLOADABLE uint4 convert_uint4_rte(long4 v);
OVERLOADABLE uint4 convert_uint4_rtz(long4 v);
OVERLOADABLE uint4 convert_uint4_rtp(long4 v);
OVERLOADABLE uint4 convert_uint4_rtn(long4 v);
OVERLOADABLE short4 convert_short4_rte(long4 v);
OVERLOADABLE short4 convert_short4_rtz(long4 v);
OVERLOADABLE short4 convert_short4_rtp(long4 v);
OVERLOADABLE short4 convert_short4_rtn(long4 v);
OVERLOADABLE ushort4 convert_ushort4_rte(long4 v);
OVERLOADABLE ushort4 convert_ushort4_rtz(long4 v);
OVERLOADABLE ushort4 convert_ushort4_rtp(long4 v);
OVERLOADABLE ushort4 convert_ushort4_rtn(long4 v);
OVERLOADABLE char4 convert_char4_rte(long4 v);
OVERLOADABLE char4 convert_char4_rtz(long4 v);
OVERLOADABLE char4 convert_char4_rtp(long4 v);
OVERLOADABLE char4 convert_char4_rtn(long4 v);
OVERLOADABLE uchar4 convert_uchar4_rte(long4 v);
OVERLOADABLE uchar4 convert_uchar4_rtz(long4 v);
OVERLOADABLE uchar4 convert_uchar4_rtp(long4 v);
OVERLOADABLE uchar4 convert_uchar4_rtn(long4 v);
OVERLOADABLE float4 convert_float4_rte(long4 v);
OVERLOADABLE float4 convert_float4_rtz(long4 v);
OVERLOADABLE float4 convert_float4_rtp(long4 v);
OVERLOADABLE float4 convert_float4_rtn(long4 v);
OVERLOADABLE half4 convert_half4_rte(long4 v);
OVERLOADABLE half4 convert_half4_rtz(long4 v);
OVERLOADABLE half4 convert_half4_rtp(long4 v);
OVERLOADABLE half4 convert_half4_rtn(long4 v);
OVERLOADABLE long4 convert_long4_rte(ulong4 v);
OVERLOADABLE long4 convert_long4_rtz(ulong4 v);
OVERLOADABLE long4 convert_long4_rtp(ulong4 v);
OVERLOADABLE long4 convert_long4_rtn(ulong4 v);
OVERLOADABLE ulong4 convert_ulong4_rte(ulong4 v);
OVERLOADABLE ulong4 convert_ulong4_rtz(ulong4 v);
OVERLOADABLE ulong4 convert_ulong4_rtp(ulong4 v);
OVERLOADABLE ulong4 convert_ulong4_rtn(ulong4 v);
OVERLOADABLE int4 convert_int4_rte(ulong4 v);
OVERLOADABLE int4 convert_int4_rtz(ulong4 v);
OVERLOADABLE int4 convert_int4_rtp(ulong4 v);
OVERLOADABLE int4 convert_int4_rtn(ulong4 v);
OVERLOADABLE uint4 convert_uint4_rte(ulong4 v);
OVERLOADABLE uint4 convert_uint4_rtz(ulong4 v);
OVERLOADABLE uint4 convert_uint4_rtp(ulong4 v);
OVERLOADABLE uint4 convert_uint4_rtn(ulong4 v);
OVERLOADABLE short4 convert_short4_rte(ulong4 v);
OVERLOADABLE short4 convert_short4_rtz(ulong4 v);
OVERLOADABLE short4 convert_short4_rtp(ulong4 v);
OVERLOADABLE short4 convert_short4_rtn(ulong4 v);
OVERLOADABLE ushort4 convert_ushort4_rte(ulong4 v);
OVERLOADABLE ushort4 convert_ushort4_rtz(ulong4 v);
OVERLOADABLE ushort4 convert_ushort4_rtp(ulong4 v);
OVERLOADABLE ushort4 convert_ushort4_rtn(ulong4 v);
OVERLOADABLE char4 convert_char4_rte(ulong4 v);
OVERLOADABLE char4 convert_char4_rtz(ulong4 v);
OVERLOADABLE char4 convert_char4_rtp(ulong4 v);
OVERLOADABLE char4 convert_char4_rtn(ulong4 v);
OVERLOADABLE uchar4 convert_uchar4_rte(ulong4 v);
OVERLOADABLE uchar4 convert_uchar4_rtz(ulong4 v);
OVERLOADABLE uchar4 convert_uchar4_rtp(ulong4 v);
OVERLOADABLE uchar4 convert_uchar4_rtn(ulong4 v);
OVERLOADABLE float4 convert_float4_rte(ulong4 v);
OVERLOADABLE float4 convert_float4_rtz(ulong4 v);
OVERLOADABLE float4 convert_float4_rtp(ulong4 v);
OVERLOADABLE float4 convert_float4_rtn(ulong4 v);
OVERLOADABLE half4 convert_half4_rte(ulong4 v);
OVERLOADABLE half4 convert_half4_rtz(ulong4 v);
OVERLOADABLE half4 convert_half4_rtp(ulong4 v);
OVERLOADABLE half4 convert_half4_rtn(ulong4 v);
OVERLOADABLE long4 convert_long4_rte(int4 v);
OVERLOADABLE long4 convert_long4_rtz(int4 v);
OVERLOADABLE long4 convert_long4_rtp(int4 v);
OVERLOADABLE long4 convert_long4_rtn(int4 v);
OVERLOADABLE ulong4 convert_ulong4_rte(int4 v);
OVERLOADABLE ulong4 convert_ulong4_rtz(int4 v);
OVERLOADABLE ulong4 convert_ulong4_rtp(int4 v);
OVERLOADABLE ulong4 convert_ulong4_rtn(int4 v);
OVERLOADABLE int4 convert_int4_rte(int4 v);
OVERLOADABLE int4 convert_int4_rtz(int4 v);
OVERLOADABLE int4 convert_int4_rtp(int4 v);
OVERLOADABLE int4 convert_int4_rtn(int4 v);
OVERLOADABLE uint4 convert_uint4_rte(int4 v);
OVERLOADABLE uint4 convert_uint4_rtz(int4 v);
OVERLOADABLE uint4 convert_uint4_rtp(int4 v);
OVERLOADABLE uint4 convert_uint4_rtn(int4 v);
OVERLOADABLE short4 convert_short4_rte(int4 v);
OVERLOADABLE short4 convert_short4_rtz(int4 v);
OVERLOADABLE short4 convert_short4_rtp(int4 v);
OVERLOADABLE short4 convert_short4_rtn(int4 v);
OVERLOADABLE ushort4 convert_ushort4_rte(int4 v);
OVERLOADABLE ushort4 convert_ushort4_rtz(int4 v);
OVERLOADABLE ushort4 convert_ushort4_rtp(int4 v);
OVERLOADABLE ushort4 convert_ushort4_rtn(int4 v);
OVERLOADABLE char4 convert_char4_rte(int4 v);
OVERLOADABLE char4 convert_char4_rtz(int4 v);
OVERLOADABLE char4 convert_char4_rtp(int4 v);
OVERLOADABLE char4 convert_char4_rtn(int4 v);
OVERLOADABLE uchar4 convert_uchar4_rte(int4 v);
OVERLOADABLE uchar4 convert_uchar4_rtz(int4 v);
OVERLOADABLE uchar4 convert_uchar4_rtp(int4 v);
OVERLOADABLE uchar4 convert_uchar4_rtn(int4 v);
OVERLOADABLE float4 convert_float4_rte(int4 v);
OVERLOADABLE float4 convert_float4_rtz(int4 v);
OVERLOADABLE float4 convert_float4_rtp(int4 v);
OVERLOADABLE float4 convert_float4_rtn(int4 v);
OVERLOADABLE half4 convert_half4_rte(int4 v);
OVERLOADABLE half4 convert_half4_rtz(int4 v);
OVERLOADABLE half4 convert_half4_rtp(int4 v);
OVERLOADABLE half4 convert_half4_rtn(int4 v);
OVERLOADABLE long4 convert_long4_rte(uint4 v);
OVERLOADABLE long4 convert_long4_rtz(uint4 v);
OVERLOADABLE long4 convert_long4_rtp(uint4 v);
OVERLOADABLE long4 convert_long4_rtn(uint4 v);
OVERLOADABLE ulong4 convert_ulong4_rte(uint4 v);
OVERLOADABLE ulong4 convert_ulong4_rtz(uint4 v);
OVERLOADABLE ulong4 convert_ulong4_rtp(uint4 v);
OVERLOADABLE ulong4 convert_ulong4_rtn(uint4 v);
OVERLOADABLE int4 convert_int4_rte(uint4 v);
OVERLOADABLE int4 convert_int4_rtz(uint4 v);
OVERLOADABLE int4 convert_int4_rtp(uint4 v);
OVERLOADABLE int4 convert_int4_rtn(uint4 v);
OVERLOADABLE uint4 convert_uint4_rte(uint4 v);
OVERLOADABLE uint4 convert_uint4_rtz(uint4 v);
OVERLOADABLE uint4 convert_uint4_rtp(uint4 v);
OVERLOADABLE uint4 convert_uint4_rtn(uint4 v);
OVERLOADABLE short4 convert_short4_rte(uint4 v);
OVERLOADABLE short4 convert_short4_rtz(uint4 v);
OVERLOADABLE short4 convert_short4_rtp(uint4 v);
OVERLOADABLE short4 convert_short4_rtn(uint4 v);
OVERLOADABLE ushort4 convert_ushort4_rte(uint4 v);
OVERLOADABLE ushort4 convert_ushort4_rtz(uint4 v);
OVERLOADABLE ushort4 convert_ushort4_rtp(uint4 v);
OVERLOADABLE ushort4 convert_ushort4_rtn(uint4 v);
OVERLOADABLE char4 convert_char4_rte(uint4 v);
OVERLOADABLE char4 convert_char4_rtz(uint4 v);
OVERLOADABLE char4 convert_char4_rtp(uint4 v);
OVERLOADABLE char4 convert_char4_rtn(uint4 v);
OVERLOADABLE uchar4 convert_uchar4_rte(uint4 v);
OVERLOADABLE uchar4 convert_uchar4_rtz(uint4 v);
OVERLOADABLE uchar4 convert_uchar4_rtp(uint4 v);
OVERLOADABLE uchar4 convert_uchar4_rtn(uint4 v);
OVERLOADABLE float4 convert_float4_rte(uint4 v);
OVERLOADABLE float4 convert_float4_rtz(uint4 v);
OVERLOADABLE float4 convert_float4_rtp(uint4 v);
OVERLOADABLE float4 convert_float4_rtn(uint4 v);
OVERLOADABLE half4 convert_half4_rte(uint4 v);
OVERLOADABLE half4 convert_half4_rtz(uint4 v);
OVERLOADABLE half4 convert_half4_rtp(uint4 v);
OVERLOADABLE half4 convert_half4_rtn(uint4 v);
OVERLOADABLE long4 convert_long4_rte(short4 v);
OVERLOADABLE long4 convert_long4_rtz(short4 v);
OVERLOADABLE long4 convert_long4_rtp(short4 v);
OVERLOADABLE long4 convert_long4_rtn(short4 v);
OVERLOADABLE ulong4 convert_ulong4_rte(short4 v);
OVERLOADABLE ulong4 convert_ulong4_rtz(short4 v);
OVERLOADABLE ulong4 convert_ulong4_rtp(short4 v);
OVERLOADABLE ulong4 convert_ulong4_rtn(short4 v);
OVERLOADABLE int4 convert_int4_rte(short4 v);
OVERLOADABLE int4 convert_int4_rtz(short4 v);
OVERLOADABLE int4 convert_int4_rtp(short4 v);
OVERLOADABLE int4 convert_int4_rtn(short4 v);
OVERLOADABLE uint4 convert_uint4_rte(short4 v);
OVERLOADABLE uint4 convert_uint4_rtz(short4 v);
OVERLOADABLE uint4 convert_uint4_rtp(short4 v);
OVERLOADABLE uint4 convert_uint4_rtn(short4 v);
OVERLOADABLE short4 convert_short4_rte(short4 v);
OVERLOADABLE short4 convert_short4_rtz(short4 v);
OVERLOADABLE short4 convert_short4_rtp(short4 v);
OVERLOADABLE short4 convert_short4_rtn(short4 v);
OVERLOADABLE ushort4 convert_ushort4_rte(short4 v);
OVERLOADABLE ushort4 convert_ushort4_rtz(short4 v);
OVERLOADABLE ushort4 convert_ushort4_rtp(short4 v);
OVERLOADABLE ushort4 convert_ushort4_rtn(short4 v);
OVERLOADABLE char4 convert_char4_rte(short4 v);
OVERLOADABLE char4 convert_char4_rtz(short4 v);
OVERLOADABLE char4 convert_char4_rtp(short4 v);
OVERLOADABLE char4 convert_char4_rtn(short4 v);
OVERLOADABLE uchar4 convert_uchar4_rte(short4 v);
OVERLOADABLE uchar4 convert_uchar4_rtz(short4 v);
OVERLOADABLE uchar4 convert_uchar4_rtp(short4 v);
OVERLOADABLE uchar4 convert_uchar4_rtn(short4 v);
OVERLOADABLE float4 convert_float4_rte(short4 v);
OVERLOADABLE float4 convert_float4_rtz(short4 v);
OVERLOADABLE float4 convert_float4_rtp(short4 v);
OVERLOADABLE float4 convert_float4_rtn(short4 v);
OVERLOADABLE half4 convert_half4_rte(short4 v);
OVERLOADABLE half4 convert_half4_rtz(short4 v);
OVERLOADABLE half4 convert_half4_rtp(short4 v);
OVERLOADABLE half4 convert_half4_rtn(short4 v);
OVERLOADABLE long4 convert_long4_rte(ushort4 v);
OVERLOADABLE long4 convert_long4_rtz(ushort4 v);
OVERLOADABLE long4 convert_long4_rtp(ushort4 v);
OVERLOADABLE long4 convert_long4_rtn(ushort4 v);
OVERLOADABLE ulong4 convert_ulong4_rte(ushort4 v);
OVERLOADABLE ulong4 convert_ulong4_rtz(ushort4 v);
OVERLOADABLE ulong4 convert_ulong4_rtp(ushort4 v);
OVERLOADABLE ulong4 convert_ulong4_rtn(ushort4 v);
OVERLOADABLE int4 convert_int4_rte(ushort4 v);
OVERLOADABLE int4 convert_int4_rtz(ushort4 v);
OVERLOADABLE int4 convert_int4_rtp(ushort4 v);
OVERLOADABLE int4 convert_int4_rtn(ushort4 v);
OVERLOADABLE uint4 convert_uint4_rte(ushort4 v);
OVERLOADABLE uint4 convert_uint4_rtz(ushort4 v);
OVERLOADABLE uint4 convert_uint4_rtp(ushort4 v);
OVERLOADABLE uint4 convert_uint4_rtn(ushort4 v);
OVERLOADABLE short4 convert_short4_rte(ushort4 v);
OVERLOADABLE short4 convert_short4_rtz(ushort4 v);
OVERLOADABLE short4 convert_short4_rtp(ushort4 v);
OVERLOADABLE short4 convert_short4_rtn(ushort4 v);
OVERLOADABLE ushort4 convert_ushort4_rte(ushort4 v);
OVERLOADABLE ushort4 convert_ushort4_rtz(ushort4 v);
OVERLOADABLE ushort4 convert_ushort4_rtp(ushort4 v);
OVERLOADABLE ushort4 convert_ushort4_rtn(ushort4 v);
OVERLOADABLE char4 convert_char4_rte(ushort4 v);
OVERLOADABLE char4 convert_char4_rtz(ushort4 v);
OVERLOADABLE char4 convert_char4_rtp(ushort4 v);
OVERLOADABLE char4 convert_char4_rtn(ushort4 v);
OVERLOADABLE uchar4 convert_uchar4_rte(ushort4 v);
OVERLOADABLE uchar4 convert_uchar4_rtz(ushort4 v);
OVERLOADABLE uchar4 convert_uchar4_rtp(ushort4 v);
OVERLOADABLE uchar4 convert_uchar4_rtn(ushort4 v);
OVERLOADABLE float4 convert_float4_rte(ushort4 v);
OVERLOADABLE float4 convert_float4_rtz(ushort4 v);
OVERLOADABLE float4 convert_float4_rtp(ushort4 v);
OVERLOADABLE float4 convert_float4_rtn(ushort4 v);
OVERLOADABLE half4 convert_half4_rte(ushort4 v);
OVERLOADABLE half4 convert_half4_rtz(ushort4 v);
OVERLOADABLE half4 convert_half4_rtp(ushort4 v);
OVERLOADABLE half4 convert_half4_rtn(ushort4 v);
OVERLOADABLE long4 convert_long4_rte(char4 v);
OVERLOADABLE long4 convert_long4_rtz(char4 v);
OVERLOADABLE long4 convert_long4_rtp(char4 v);
OVERLOADABLE long4 convert_long4_rtn(char4 v);
OVERLOADABLE ulong4 convert_ulong4_rte(char4 v);
OVERLOADABLE ulong4 convert_ulong4_rtz(char4 v);
OVERLOADABLE ulong4 convert_ulong4_rtp(char4 v);
OVERLOADABLE ulong4 convert_ulong4_rtn(char4 v);
OVERLOADABLE int4 convert_int4_rte(char4 v);
OVERLOADABLE int4 convert_int4_rtz(char4 v);
OVERLOADABLE int4 convert_int4_rtp(char4 v);
OVERLOADABLE int4 convert_int4_rtn(char4 v);
OVERLOADABLE uint4 convert_uint4_rte(char4 v);
OVERLOADABLE uint4 convert_uint4_rtz(char4 v);
OVERLOADABLE uint4 convert_uint4_rtp(char4 v);
OVERLOADABLE uint4 convert_uint4_rtn(char4 v);
OVERLOADABLE short4 convert_short4_rte(char4 v);
OVERLOADABLE short4 convert_short4_rtz(char4 v);
OVERLOADABLE short4 convert_short4_rtp(char4 v);
OVERLOADABLE short4 convert_short4_rtn(char4 v);
OVERLOADABLE ushort4 convert_ushort4_rte(char4 v);
OVERLOADABLE ushort4 convert_ushort4_rtz(char4 v);
OVERLOADABLE ushort4 convert_ushort4_rtp(char4 v);
OVERLOADABLE ushort4 convert_ushort4_rtn(char4 v);
OVERLOADABLE char4 convert_char4_rte(char4 v);
OVERLOADABLE char4 convert_char4_rtz(char4 v);
OVERLOADABLE char4 convert_char4_rtp(char4 v);
OVERLOADABLE char4 convert_char4_rtn(char4 v);
OVERLOADABLE uchar4 convert_uchar4_rte(char4 v);
OVERLOADABLE uchar4 convert_uchar4_rtz(char4 v);
OVERLOADABLE uchar4 convert_uchar4_rtp(char4 v);
OVERLOADABLE uchar4 convert_uchar4_rtn(char4 v);
OVERLOADABLE float4 convert_float4_rte(char4 v);
OVERLOADABLE float4 convert_float4_rtz(char4 v);
OVERLOADABLE float4 convert_float4_rtp(char4 v);
OVERLOADABLE float4 convert_float4_rtn(char4 v);
OVERLOADABLE half4 convert_half4_rte(char4 v);
OVERLOADABLE half4 convert_half4_rtz(char4 v);
OVERLOADABLE half4 convert_half4_rtp(char4 v);
OVERLOADABLE half4 convert_half4_rtn(char4 v);
OVERLOADABLE long4 convert_long4_rte(uchar4 v);
OVERLOADABLE long4 convert_long4_rtz(uchar4 v);
OVERLOADABLE long4 convert_long4_rtp(uchar4 v);
OVERLOADABLE long4 convert_long4_rtn(uchar4 v);
OVERLOADABLE ulong4 convert_ulong4_rte(uchar4 v);
OVERLOADABLE ulong4 convert_ulong4_rtz(uchar4 v);
OVERLOADABLE ulong4 convert_ulong4_rtp(uchar4 v);
OVERLOADABLE ulong4 convert_ulong4_rtn(uchar4 v);
OVERLOADABLE int4 convert_int4_rte(uchar4 v);
OVERLOADABLE int4 convert_int4_rtz(uchar4 v);
OVERLOADABLE int4 convert_int4_rtp(uchar4 v);
OVERLOADABLE int4 convert_int4_rtn(uchar4 v);
OVERLOADABLE uint4 convert_uint4_rte(uchar4 v);
OVERLOADABLE uint4 convert_uint4_rtz(uchar4 v);
OVERLOADABLE uint4 convert_uint4_rtp(uchar4 v);
OVERLOADABLE uint4 convert_uint4_rtn(uchar4 v);
OVERLOADABLE short4 convert_short4_rte(uchar4 v);
OVERLOADABLE short4 convert_short4_rtz(uchar4 v);
OVERLOADABLE short4 convert_short4_rtp(uchar4 v);
OVERLOADABLE short4 convert_short4_rtn(uchar4 v);
OVERLOADABLE ushort4 convert_ushort4_rte(uchar4 v);
OVERLOADABLE ushort4 convert_ushort4_rtz(uchar4 v);
OVERLOADABLE ushort4 convert_ushort4_rtp(uchar4 v);
OVERLOADABLE ushort4 convert_ushort4_rtn(uchar4 v);
OVERLOADABLE char4 convert_char4_rte(uchar4 v);
OVERLOADABLE char4 convert_char4_rtz(uchar4 v);
OVERLOADABLE char4 convert_char4_rtp(uchar4 v);
OVERLOADABLE char4 convert_char4_rtn(uchar4 v);
OVERLOADABLE uchar4 convert_uchar4_rte(uchar4 v);
OVERLOADABLE uchar4 convert_uchar4_rtz(uchar4 v);
OVERLOADABLE uchar4 convert_uchar4_rtp(uchar4 v);
OVERLOADABLE uchar4 convert_uchar4_rtn(uchar4 v);
OVERLOADABLE float4 convert_float4_rte(uchar4 v);
OVERLOADABLE float4 convert_float4_rtz(uchar4 v);
OVERLOADABLE float4 convert_float4_rtp(uchar4 v);
OVERLOADABLE float4 convert_float4_rtn(uchar4 v);
OVERLOADABLE half4 convert_half4_rte(uchar4 v);
OVERLOADABLE half4 convert_half4_rtz(uchar4 v);
OVERLOADABLE half4 convert_half4_rtp(uchar4 v);
OVERLOADABLE half4 convert_half4_rtn(uchar4 v);
OVERLOADABLE long4 convert_long4_rte(double4 v);
OVERLOADABLE long4 convert_long4_rtz(double4 v);
OVERLOADABLE long4 convert_long4_rtp(double4 v);
OVERLOADABLE long4 convert_long4_rtn(double4 v);
OVERLOADABLE ulong4 convert_ulong4_rte(double4 v);
OVERLOADABLE ulong4 convert_ulong4_rtz(double4 v);
OVERLOADABLE ulong4 convert_ulong4_rtp(double4 v);
OVERLOADABLE ulong4 convert_ulong4_rtn(double4 v);
OVERLOADABLE int4 convert_int4_rte(double4 v);
OVERLOADABLE int4 convert_int4_rtz(double4 v);
OVERLOADABLE int4 convert_int4_rtp(double4 v);
OVERLOADABLE int4 convert_int4_rtn(double4 v);
OVERLOADABLE uint4 convert_uint4_rte(double4 v);
OVERLOADABLE uint4 convert_uint4_rtz(double4 v);
OVERLOADABLE uint4 convert_uint4_rtp(double4 v);
OVERLOADABLE uint4 convert_uint4_rtn(double4 v);
OVERLOADABLE short4 convert_short4_rte(double4 v);
OVERLOADABLE short4 convert_short4_rtz(double4 v);
OVERLOADABLE short4 convert_short4_rtp(double4 v);
OVERLOADABLE short4 convert_short4_rtn(double4 v);
OVERLOADABLE ushort4 convert_ushort4_rte(double4 v);
OVERLOADABLE ushort4 convert_ushort4_rtz(double4 v);
OVERLOADABLE ushort4 convert_ushort4_rtp(double4 v);
OVERLOADABLE ushort4 convert_ushort4_rtn(double4 v);
OVERLOADABLE char4 convert_char4_rte(double4 v);
OVERLOADABLE char4 convert_char4_rtz(double4 v);
OVERLOADABLE char4 convert_char4_rtp(double4 v);
OVERLOADABLE char4 convert_char4_rtn(double4 v);
OVERLOADABLE uchar4 convert_uchar4_rte(double4 v);
OVERLOADABLE uchar4 convert_uchar4_rtz(double4 v);
OVERLOADABLE uchar4 convert_uchar4_rtp(double4 v);
OVERLOADABLE uchar4 convert_uchar4_rtn(double4 v);
OVERLOADABLE float4 convert_float4_rte(double4 v);
OVERLOADABLE float4 convert_float4_rtz(double4 v);
OVERLOADABLE float4 convert_float4_rtp(double4 v);
OVERLOADABLE float4 convert_float4_rtn(double4 v);
OVERLOADABLE half4 convert_half4_rte(double4 v);
OVERLOADABLE half4 convert_half4_rtz(double4 v);
OVERLOADABLE half4 convert_half4_rtp(double4 v);
OVERLOADABLE half4 convert_half4_rtn(double4 v);
OVERLOADABLE long4 convert_long4_rte(float4 v);
OVERLOADABLE long4 convert_long4_rtz(float4 v);
OVERLOADABLE long4 convert_long4_rtp(float4 v);
OVERLOADABLE long4 convert_long4_rtn(float4 v);
OVERLOADABLE ulong4 convert_ulong4_rte(float4 v);
OVERLOADABLE ulong4 convert_ulong4_rtz(float4 v);
OVERLOADABLE ulong4 convert_ulong4_rtp(float4 v);
OVERLOADABLE ulong4 convert_ulong4_rtn(float4 v);
OVERLOADABLE int4 convert_int4_rte(float4 v);
OVERLOADABLE int4 convert_int4_rtz(float4 v);
OVERLOADABLE int4 convert_int4_rtp(float4 v);
OVERLOADABLE int4 convert_int4_rtn(float4 v);
OVERLOADABLE uint4 convert_uint4_rte(float4 v);
OVERLOADABLE uint4 convert_uint4_rtz(float4 v);
OVERLOADABLE uint4 convert_uint4_rtp(float4 v);
OVERLOADABLE uint4 convert_uint4_rtn(float4 v);
OVERLOADABLE short4 convert_short4_rte(float4 v);
OVERLOADABLE short4 convert_short4_rtz(float4 v);
OVERLOADABLE short4 convert_short4_rtp(float4 v);
OVERLOADABLE short4 convert_short4_rtn(float4 v);
OVERLOADABLE ushort4 convert_ushort4_rte(float4 v);
OVERLOADABLE ushort4 convert_ushort4_rtz(float4 v);
OVERLOADABLE ushort4 convert_ushort4_rtp(float4 v);
OVERLOADABLE ushort4 convert_ushort4_rtn(float4 v);
OVERLOADABLE char4 convert_char4_rte(float4 v);
OVERLOADABLE char4 convert_char4_rtz(float4 v);
OVERLOADABLE char4 convert_char4_rtp(float4 v);
OVERLOADABLE char4 convert_char4_rtn(float4 v);
OVERLOADABLE uchar4 convert_uchar4_rte(float4 v);
OVERLOADABLE uchar4 convert_uchar4_rtz(float4 v);
OVERLOADABLE uchar4 convert_uchar4_rtp(float4 v);
OVERLOADABLE uchar4 convert_uchar4_rtn(float4 v);
OVERLOADABLE float4 convert_float4_rte(float4 v);
OVERLOADABLE float4 convert_float4_rtz(float4 v);
OVERLOADABLE float4 convert_float4_rtp(float4 v);
OVERLOADABLE float4 convert_float4_rtn(float4 v);
OVERLOADABLE half4 convert_half4_rte(float4 v);
OVERLOADABLE half4 convert_half4_rtz(float4 v);
OVERLOADABLE half4 convert_half4_rtp(float4 v);
OVERLOADABLE half4 convert_half4_rtn(float4 v);
OVERLOADABLE long4 convert_long4_rte(half4 v);
OVERLOADABLE long4 convert_long4_rtz(half4 v);
OVERLOADABLE long4 convert_long4_rtp(half4 v);
OVERLOADABLE long4 convert_long4_rtn(half4 v);
OVERLOADABLE ulong4 convert_ulong4_rte(half4 v);
OVERLOADABLE ulong4 convert_ulong4_rtz(half4 v);
OVERLOADABLE ulong4 convert_ulong4_rtp(half4 v);
OVERLOADABLE ulong4 convert_ulong4_rtn(half4 v);
OVERLOADABLE int4 convert_int4_rte(half4 v);
OVERLOADABLE int4 convert_int4_rtz(half4 v);
OVERLOADABLE int4 convert_int4_rtp(half4 v);
OVERLOADABLE int4 convert_int4_rtn(half4 v);
OVERLOADABLE uint4 convert_uint4_rte(half4 v);
OVERLOADABLE uint4 convert_uint4_rtz(half4 v);
OVERLOADABLE uint4 convert_uint4_rtp(half4 v);
OVERLOADABLE uint4 convert_uint4_rtn(half4 v);
OVERLOADABLE short4 convert_short4_rte(half4 v);
OVERLOADABLE short4 convert_short4_rtz(half4 v);
OVERLOADABLE short4 convert_short4_rtp(half4 v);
OVERLOADABLE short4 convert_short4_rtn(half4 v);
OVERLOADABLE ushort4 convert_ushort4_rte(half4 v);
OVERLOADABLE ushort4 convert_ushort4_rtz(half4 v);
OVERLOADABLE ushort4 convert_ushort4_rtp(half4 v);
OVERLOADABLE ushort4 convert_ushort4_rtn(half4 v);
OVERLOADABLE char4 convert_char4_rte(half4 v);
OVERLOADABLE char4 convert_char4_rtz(half4 v);
OVERLOADABLE char4 convert_char4_rtp(half4 v);
OVERLOADABLE char4 convert_char4_rtn(half4 v);
OVERLOADABLE uchar4 convert_uchar4_rte(half4 v);
OVERLOADABLE uchar4 convert_uchar4_rtz(half4 v);
OVERLOADABLE uchar4 convert_uchar4_rtp(half4 v);
OVERLOADABLE uchar4 convert_uchar4_rtn(half4 v);
OVERLOADABLE float4 convert_float4_rte(half4 v);
OVERLOADABLE float4 convert_float4_rtz(half4 v);
OVERLOADABLE float4 convert_float4_rtp(half4 v);
OVERLOADABLE float4 convert_float4_rtn(half4 v);
OVERLOADABLE half4 convert_half4_rte(half4 v);
OVERLOADABLE half4 convert_half4_rtz(half4 v);
OVERLOADABLE half4 convert_half4_rtp(half4 v);
OVERLOADABLE half4 convert_half4_rtn(half4 v);
OVERLOADABLE long8 convert_long8_rte(long8 v);
OVERLOADABLE long8 convert_long8_rtz(long8 v);
OVERLOADABLE long8 convert_long8_rtp(long8 v);
OVERLOADABLE long8 convert_long8_rtn(long8 v);
OVERLOADABLE ulong8 convert_ulong8_rte(long8 v);
OVERLOADABLE ulong8 convert_ulong8_rtz(long8 v);
OVERLOADABLE ulong8 convert_ulong8_rtp(long8 v);
OVERLOADABLE ulong8 convert_ulong8_rtn(long8 v);
OVERLOADABLE int8 convert_int8_rte(long8 v);
OVERLOADABLE int8 convert_int8_rtz(long8 v);
OVERLOADABLE int8 convert_int8_rtp(long8 v);
OVERLOADABLE int8 convert_int8_rtn(long8 v);
OVERLOADABLE uint8 convert_uint8_rte(long8 v);
OVERLOADABLE uint8 convert_uint8_rtz(long8 v);
OVERLOADABLE uint8 convert_uint8_rtp(long8 v);
OVERLOADABLE uint8 convert_uint8_rtn(long8 v);
OVERLOADABLE short8 convert_short8_rte(long8 v);
OVERLOADABLE short8 convert_short8_rtz(long8 v);
OVERLOADABLE short8 convert_short8_rtp(long8 v);
OVERLOADABLE short8 convert_short8_rtn(long8 v);
OVERLOADABLE ushort8 convert_ushort8_rte(long8 v);
OVERLOADABLE ushort8 convert_ushort8_rtz(long8 v);
OVERLOADABLE ushort8 convert_ushort8_rtp(long8 v);
OVERLOADABLE ushort8 convert_ushort8_rtn(long8 v);
OVERLOADABLE char8 convert_char8_rte(long8 v);
OVERLOADABLE char8 convert_char8_rtz(long8 v);
OVERLOADABLE char8 convert_char8_rtp(long8 v);
OVERLOADABLE char8 convert_char8_rtn(long8 v);
OVERLOADABLE uchar8 convert_uchar8_rte(long8 v);
OVERLOADABLE uchar8 convert_uchar8_rtz(long8 v);
OVERLOADABLE uchar8 convert_uchar8_rtp(long8 v);
OVERLOADABLE uchar8 convert_uchar8_rtn(long8 v);
OVERLOADABLE float8 convert_float8_rte(long8 v);
OVERLOADABLE float8 convert_float8_rtz(long8 v);
OVERLOADABLE float8 convert_float8_rtp(long8 v);
OVERLOADABLE float8 convert_float8_rtn(long8 v);
OVERLOADABLE half8 convert_half8_rte(long8 v);
OVERLOADABLE half8 convert_half8_rtz(long8 v);
OVERLOADABLE half8 convert_half8_rtp(long8 v);
OVERLOADABLE half8 convert_half8_rtn(long8 v);
OVERLOADABLE long8 convert_long8_rte(ulong8 v);
OVERLOADABLE long8 convert_long8_rtz(ulong8 v);
OVERLOADABLE long8 convert_long8_rtp(ulong8 v);
OVERLOADABLE long8 convert_long8_rtn(ulong8 v);
OVERLOADABLE ulong8 convert_ulong8_rte(ulong8 v);
OVERLOADABLE ulong8 convert_ulong8_rtz(ulong8 v);
OVERLOADABLE ulong8 convert_ulong8_rtp(ulong8 v);
OVERLOADABLE ulong8 convert_ulong8_rtn(ulong8 v);
OVERLOADABLE int8 convert_int8_rte(ulong8 v);
OVERLOADABLE int8 convert_int8_rtz(ulong8 v);
OVERLOADABLE int8 convert_int8_rtp(ulong8 v);
OVERLOADABLE int8 convert_int8_rtn(ulong8 v);
OVERLOADABLE uint8 convert_uint8_rte(ulong8 v);
OVERLOADABLE uint8 convert_uint8_rtz(ulong8 v);
OVERLOADABLE uint8 convert_uint8_rtp(ulong8 v);
OVERLOADABLE uint8 convert_uint8_rtn(ulong8 v);
OVERLOADABLE short8 convert_short8_rte(ulong8 v);
OVERLOADABLE short8 convert_short8_rtz(ulong8 v);
OVERLOADABLE short8 convert_short8_rtp(ulong8 v);
OVERLOADABLE short8 convert_short8_rtn(ulong8 v);
OVERLOADABLE ushort8 convert_ushort8_rte(ulong8 v);
OVERLOADABLE ushort8 convert_ushort8_rtz(ulong8 v);
OVERLOADABLE ushort8 convert_ushort8_rtp(ulong8 v);
OVERLOADABLE ushort8 convert_ushort8_rtn(ulong8 v);
OVERLOADABLE char8 convert_char8_rte(ulong8 v);
OVERLOADABLE char8 convert_char8_rtz(ulong8 v);
OVERLOADABLE char8 convert_char8_rtp(ulong8 v);
OVERLOADABLE char8 convert_char8_rtn(ulong8 v);
OVERLOADABLE uchar8 convert_uchar8_rte(ulong8 v);
OVERLOADABLE uchar8 convert_uchar8_rtz(ulong8 v);
OVERLOADABLE uchar8 convert_uchar8_rtp(ulong8 v);
OVERLOADABLE uchar8 convert_uchar8_rtn(ulong8 v);
OVERLOADABLE float8 convert_float8_rte(ulong8 v);
OVERLOADABLE float8 convert_float8_rtz(ulong8 v);
OVERLOADABLE float8 convert_float8_rtp(ulong8 v);
OVERLOADABLE float8 convert_float8_rtn(ulong8 v);
OVERLOADABLE half8 convert_half8_rte(ulong8 v);
OVERLOADABLE half8 convert_half8_rtz(ulong8 v);
OVERLOADABLE half8 convert_half8_rtp(ulong8 v);
OVERLOADABLE half8 convert_half8_rtn(ulong8 v);
OVERLOADABLE long8 convert_long8_rte(int8 v);
OVERLOADABLE long8 convert_long8_rtz(int8 v);
OVERLOADABLE long8 convert_long8_rtp(int8 v);
OVERLOADABLE long8 convert_long8_rtn(int8 v);
OVERLOADABLE ulong8 convert_ulong8_rte(int8 v);
OVERLOADABLE ulong8 convert_ulong8_rtz(int8 v);
OVERLOADABLE ulong8 convert_ulong8_rtp(int8 v);
OVERLOADABLE ulong8 convert_ulong8_rtn(int8 v);
OVERLOADABLE int8 convert_int8_rte(int8 v);
OVERLOADABLE int8 convert_int8_rtz(int8 v);
OVERLOADABLE int8 convert_int8_rtp(int8 v);
OVERLOADABLE int8 convert_int8_rtn(int8 v);
OVERLOADABLE uint8 convert_uint8_rte(int8 v);
OVERLOADABLE uint8 convert_uint8_rtz(int8 v);
OVERLOADABLE uint8 convert_uint8_rtp(int8 v);
OVERLOADABLE uint8 convert_uint8_rtn(int8 v);
OVERLOADABLE short8 convert_short8_rte(int8 v);
OVERLOADABLE short8 convert_short8_rtz(int8 v);
OVERLOADABLE short8 convert_short8_rtp(int8 v);
OVERLOADABLE short8 convert_short8_rtn(int8 v);
OVERLOADABLE ushort8 convert_ushort8_rte(int8 v);
OVERLOADABLE ushort8 convert_ushort8_rtz(int8 v);
OVERLOADABLE ushort8 convert_ushort8_rtp(int8 v);
OVERLOADABLE ushort8 convert_ushort8_rtn(int8 v);
OVERLOADABLE char8 convert_char8_rte(int8 v);
OVERLOADABLE char8 convert_char8_rtz(int8 v);
OVERLOADABLE char8 convert_char8_rtp(int8 v);
OVERLOADABLE char8 convert_char8_rtn(int8 v);
OVERLOADABLE uchar8 convert_uchar8_rte(int8 v);
OVERLOADABLE uchar8 convert_uchar8_rtz(int8 v);
OVERLOADABLE uchar8 convert_uchar8_rtp(int8 v);
OVERLOADABLE uchar8 convert_uchar8_rtn(int8 v);
OVERLOADABLE float8 convert_float8_rte(int8 v);
OVERLOADABLE float8 convert_float8_rtz(int8 v);
OVERLOADABLE float8 convert_float8_rtp(int8 v);
OVERLOADABLE float8 convert_float8_rtn(int8 v);
OVERLOADABLE half8 convert_half8_rte(int8 v);
OVERLOADABLE half8 convert_half8_rtz(int8 v);
OVERLOADABLE half8 convert_half8_rtp(int8 v);
OVERLOADABLE half8 convert_half8_rtn(int8 v);
OVERLOADABLE long8 convert_long8_rte(uint8 v);
OVERLOADABLE long8 convert_long8_rtz(uint8 v);
OVERLOADABLE long8 convert_long8_rtp(uint8 v);
OVERLOADABLE long8 convert_long8_rtn(uint8 v);
OVERLOADABLE ulong8 convert_ulong8_rte(uint8 v);
OVERLOADABLE ulong8 convert_ulong8_rtz(uint8 v);
OVERLOADABLE ulong8 convert_ulong8_rtp(uint8 v);
OVERLOADABLE ulong8 convert_ulong8_rtn(uint8 v);
OVERLOADABLE int8 convert_int8_rte(uint8 v);
OVERLOADABLE int8 convert_int8_rtz(uint8 v);
OVERLOADABLE int8 convert_int8_rtp(uint8 v);
OVERLOADABLE int8 convert_int8_rtn(uint8 v);
OVERLOADABLE uint8 convert_uint8_rte(uint8 v);
OVERLOADABLE uint8 convert_uint8_rtz(uint8 v);
OVERLOADABLE uint8 convert_uint8_rtp(uint8 v);
OVERLOADABLE uint8 convert_uint8_rtn(uint8 v);
OVERLOADABLE short8 convert_short8_rte(uint8 v);
OVERLOADABLE short8 convert_short8_rtz(uint8 v);
OVERLOADABLE short8 convert_short8_rtp(uint8 v);
OVERLOADABLE short8 convert_short8_rtn(uint8 v);
OVERLOADABLE ushort8 convert_ushort8_rte(uint8 v);
OVERLOADABLE ushort8 convert_ushort8_rtz(uint8 v);
OVERLOADABLE ushort8 convert_ushort8_rtp(uint8 v);
OVERLOADABLE ushort8 convert_ushort8_rtn(uint8 v);
OVERLOADABLE char8 convert_char8_rte(uint8 v);
OVERLOADABLE char8 convert_char8_rtz(uint8 v);
OVERLOADABLE char8 convert_char8_rtp(uint8 v);
OVERLOADABLE char8 convert_char8_rtn(uint8 v);
OVERLOADABLE uchar8 convert_uchar8_rte(uint8 v);
OVERLOADABLE uchar8 convert_uchar8_rtz(uint8 v);
OVERLOADABLE uchar8 convert_uchar8_rtp(uint8 v);
OVERLOADABLE uchar8 convert_uchar8_rtn(uint8 v);
OVERLOADABLE float8 convert_float8_rte(uint8 v);
OVERLOADABLE float8 convert_float8_rtz(uint8 v);
OVERLOADABLE float8 convert_float8_rtp(uint8 v);
OVERLOADABLE float8 convert_float8_rtn(uint8 v);
OVERLOADABLE half8 convert_half8_rte(uint8 v);
OVERLOADABLE half8 convert_half8_rtz(uint8 v);
OVERLOADABLE half8 convert_half8_rtp(uint8 v);
OVERLOADABLE half8 convert_half8_rtn(uint8 v);
OVERLOADABLE long8 convert_long8_rte(short8 v);
OVERLOADABLE long8 convert_long8_rtz(short8 v);
OVERLOADABLE long8 convert_long8_rtp(short8 v);
OVERLOADABLE long8 convert_long8_rtn(short8 v);
OVERLOADABLE ulong8 convert_ulong8_rte(short8 v);
OVERLOADABLE ulong8 convert_ulong8_rtz(short8 v);
OVERLOADABLE ulong8 convert_ulong8_rtp(short8 v);
OVERLOADABLE ulong8 convert_ulong8_rtn(short8 v);
OVERLOADABLE int8 convert_int8_rte(short8 v);
OVERLOADABLE int8 convert_int8_rtz(short8 v);
OVERLOADABLE int8 convert_int8_rtp(short8 v);
OVERLOADABLE int8 convert_int8_rtn(short8 v);
OVERLOADABLE uint8 convert_uint8_rte(short8 v);
OVERLOADABLE uint8 convert_uint8_rtz(short8 v);
OVERLOADABLE uint8 convert_uint8_rtp(short8 v);
OVERLOADABLE uint8 convert_uint8_rtn(short8 v);
OVERLOADABLE short8 convert_short8_rte(short8 v);
OVERLOADABLE short8 convert_short8_rtz(short8 v);
OVERLOADABLE short8 convert_short8_rtp(short8 v);
OVERLOADABLE short8 convert_short8_rtn(short8 v);
OVERLOADABLE ushort8 convert_ushort8_rte(short8 v);
OVERLOADABLE ushort8 convert_ushort8_rtz(short8 v);
OVERLOADABLE ushort8 convert_ushort8_rtp(short8 v);
OVERLOADABLE ushort8 convert_ushort8_rtn(short8 v);
OVERLOADABLE char8 convert_char8_rte(short8 v);
OVERLOADABLE char8 convert_char8_rtz(short8 v);
OVERLOADABLE char8 convert_char8_rtp(short8 v);
OVERLOADABLE char8 convert_char8_rtn(short8 v);
OVERLOADABLE uchar8 convert_uchar8_rte(short8 v);
OVERLOADABLE uchar8 convert_uchar8_rtz(short8 v);
OVERLOADABLE uchar8 convert_uchar8_rtp(short8 v);
OVERLOADABLE uchar8 convert_uchar8_rtn(short8 v);
OVERLOADABLE float8 convert_float8_rte(short8 v);
OVERLOADABLE float8 convert_float8_rtz(short8 v);
OVERLOADABLE float8 convert_float8_rtp(short8 v);
OVERLOADABLE float8 convert_float8_rtn(short8 v);
OVERLOADABLE half8 convert_half8_rte(short8 v);
OVERLOADABLE half8 convert_half8_rtz(short8 v);
OVERLOADABLE half8 convert_half8_rtp(short8 v);
OVERLOADABLE half8 convert_half8_rtn(short8 v);
OVERLOADABLE long8 convert_long8_rte(ushort8 v);
OVERLOADABLE long8 convert_long8_rtz(ushort8 v);
OVERLOADABLE long8 convert_long8_rtp(ushort8 v);
OVERLOADABLE long8 convert_long8_rtn(ushort8 v);
OVERLOADABLE ulong8 convert_ulong8_rte(ushort8 v);
OVERLOADABLE ulong8 convert_ulong8_rtz(ushort8 v);
OVERLOADABLE ulong8 convert_ulong8_rtp(ushort8 v);
OVERLOADABLE ulong8 convert_ulong8_rtn(ushort8 v);
OVERLOADABLE int8 convert_int8_rte(ushort8 v);
OVERLOADABLE int8 convert_int8_rtz(ushort8 v);
OVERLOADABLE int8 convert_int8_rtp(ushort8 v);
OVERLOADABLE int8 convert_int8_rtn(ushort8 v);
OVERLOADABLE uint8 convert_uint8_rte(ushort8 v);
OVERLOADABLE uint8 convert_uint8_rtz(ushort8 v);
OVERLOADABLE uint8 convert_uint8_rtp(ushort8 v);
OVERLOADABLE uint8 convert_uint8_rtn(ushort8 v);
OVERLOADABLE short8 convert_short8_rte(ushort8 v);
OVERLOADABLE short8 convert_short8_rtz(ushort8 v);
OVERLOADABLE short8 convert_short8_rtp(ushort8 v);
OVERLOADABLE short8 convert_short8_rtn(ushort8 v);
OVERLOADABLE ushort8 convert_ushort8_rte(ushort8 v);
OVERLOADABLE ushort8 convert_ushort8_rtz(ushort8 v);
OVERLOADABLE ushort8 convert_ushort8_rtp(ushort8 v);
OVERLOADABLE ushort8 convert_ushort8_rtn(ushort8 v);
OVERLOADABLE char8 convert_char8_rte(ushort8 v);
OVERLOADABLE char8 convert_char8_rtz(ushort8 v);
OVERLOADABLE char8 convert_char8_rtp(ushort8 v);
OVERLOADABLE char8 convert_char8_rtn(ushort8 v);
OVERLOADABLE uchar8 convert_uchar8_rte(ushort8 v);
OVERLOADABLE uchar8 convert_uchar8_rtz(ushort8 v);
OVERLOADABLE uchar8 convert_uchar8_rtp(ushort8 v);
OVERLOADABLE uchar8 convert_uchar8_rtn(ushort8 v);
OVERLOADABLE float8 convert_float8_rte(ushort8 v);
OVERLOADABLE float8 convert_float8_rtz(ushort8 v);
OVERLOADABLE float8 convert_float8_rtp(ushort8 v);
OVERLOADABLE float8 convert_float8_rtn(ushort8 v);
OVERLOADABLE half8 convert_half8_rte(ushort8 v);
OVERLOADABLE half8 convert_half8_rtz(ushort8 v);
OVERLOADABLE half8 convert_half8_rtp(ushort8 v);
OVERLOADABLE half8 convert_half8_rtn(ushort8 v);
OVERLOADABLE long8 convert_long8_rte(char8 v);
OVERLOADABLE long8 convert_long8_rtz(char8 v);
OVERLOADABLE long8 convert_long8_rtp(char8 v);
OVERLOADABLE long8 convert_long8_rtn(char8 v);
OVERLOADABLE ulong8 convert_ulong8_rte(char8 v);
OVERLOADABLE ulong8 convert_ulong8_rtz(char8 v);
OVERLOADABLE ulong8 convert_ulong8_rtp(char8 v);
OVERLOADABLE ulong8 convert_ulong8_rtn(char8 v);
OVERLOADABLE int8 convert_int8_rte(char8 v);
OVERLOADABLE int8 convert_int8_rtz(char8 v);
OVERLOADABLE int8 convert_int8_rtp(char8 v);
OVERLOADABLE int8 convert_int8_rtn(char8 v);
OVERLOADABLE uint8 convert_uint8_rte(char8 v);
OVERLOADABLE uint8 convert_uint8_rtz(char8 v);
OVERLOADABLE uint8 convert_uint8_rtp(char8 v);
OVERLOADABLE uint8 convert_uint8_rtn(char8 v);
OVERLOADABLE short8 convert_short8_rte(char8 v);
OVERLOADABLE short8 convert_short8_rtz(char8 v);
OVERLOADABLE short8 convert_short8_rtp(char8 v);
OVERLOADABLE short8 convert_short8_rtn(char8 v);
OVERLOADABLE ushort8 convert_ushort8_rte(char8 v);
OVERLOADABLE ushort8 convert_ushort8_rtz(char8 v);
OVERLOADABLE ushort8 convert_ushort8_rtp(char8 v);
OVERLOADABLE ushort8 convert_ushort8_rtn(char8 v);
OVERLOADABLE char8 convert_char8_rte(char8 v);
OVERLOADABLE char8 convert_char8_rtz(char8 v);
OVERLOADABLE char8 convert_char8_rtp(char8 v);
OVERLOADABLE char8 convert_char8_rtn(char8 v);
OVERLOADABLE uchar8 convert_uchar8_rte(char8 v);
OVERLOADABLE uchar8 convert_uchar8_rtz(char8 v);
OVERLOADABLE uchar8 convert_uchar8_rtp(char8 v);
OVERLOADABLE uchar8 convert_uchar8_rtn(char8 v);
OVERLOADABLE float8 convert_float8_rte(char8 v);
OVERLOADABLE float8 convert_float8_rtz(char8 v);
OVERLOADABLE float8 convert_float8_rtp(char8 v);
OVERLOADABLE float8 convert_float8_rtn(char8 v);
OVERLOADABLE half8 convert_half8_rte(char8 v);
OVERLOADABLE half8 convert_half8_rtz(char8 v);
OVERLOADABLE half8 convert_half8_rtp(char8 v);
OVERLOADABLE half8 convert_half8_rtn(char8 v);
OVERLOADABLE long8 convert_long8_rte(uchar8 v);
OVERLOADABLE long8 convert_long8_rtz(uchar8 v);
OVERLOADABLE long8 convert_long8_rtp(uchar8 v);
OVERLOADABLE long8 convert_long8_rtn(uchar8 v);
OVERLOADABLE ulong8 convert_ulong8_rte(uchar8 v);
OVERLOADABLE ulong8 convert_ulong8_rtz(uchar8 v);
OVERLOADABLE ulong8 convert_ulong8_rtp(uchar8 v);
OVERLOADABLE ulong8 convert_ulong8_rtn(uchar8 v);
OVERLOADABLE int8 convert_int8_rte(uchar8 v);
OVERLOADABLE int8 convert_int8_rtz(uchar8 v);
OVERLOADABLE int8 convert_int8_rtp(uchar8 v);
OVERLOADABLE int8 convert_int8_rtn(uchar8 v);
OVERLOADABLE uint8 convert_uint8_rte(uchar8 v);
OVERLOADABLE uint8 convert_uint8_rtz(uchar8 v);
OVERLOADABLE uint8 convert_uint8_rtp(uchar8 v);
OVERLOADABLE uint8 convert_uint8_rtn(uchar8 v);
OVERLOADABLE short8 convert_short8_rte(uchar8 v);
OVERLOADABLE short8 convert_short8_rtz(uchar8 v);
OVERLOADABLE short8 convert_short8_rtp(uchar8 v);
OVERLOADABLE short8 convert_short8_rtn(uchar8 v);
OVERLOADABLE ushort8 convert_ushort8_rte(uchar8 v);
OVERLOADABLE ushort8 convert_ushort8_rtz(uchar8 v);
OVERLOADABLE ushort8 convert_ushort8_rtp(uchar8 v);
OVERLOADABLE ushort8 convert_ushort8_rtn(uchar8 v);
OVERLOADABLE char8 convert_char8_rte(uchar8 v);
OVERLOADABLE char8 convert_char8_rtz(uchar8 v);
OVERLOADABLE char8 convert_char8_rtp(uchar8 v);
OVERLOADABLE char8 convert_char8_rtn(uchar8 v);
OVERLOADABLE uchar8 convert_uchar8_rte(uchar8 v);
OVERLOADABLE uchar8 convert_uchar8_rtz(uchar8 v);
OVERLOADABLE uchar8 convert_uchar8_rtp(uchar8 v);
OVERLOADABLE uchar8 convert_uchar8_rtn(uchar8 v);
OVERLOADABLE float8 convert_float8_rte(uchar8 v);
OVERLOADABLE float8 convert_float8_rtz(uchar8 v);
OVERLOADABLE float8 convert_float8_rtp(uchar8 v);
OVERLOADABLE float8 convert_float8_rtn(uchar8 v);
OVERLOADABLE half8 convert_half8_rte(uchar8 v);
OVERLOADABLE half8 convert_half8_rtz(uchar8 v);
OVERLOADABLE half8 convert_half8_rtp(uchar8 v);
OVERLOADABLE half8 convert_half8_rtn(uchar8 v);
OVERLOADABLE long8 convert_long8_rte(double8 v);
OVERLOADABLE long8 convert_long8_rtz(double8 v);
OVERLOADABLE long8 convert_long8_rtp(double8 v);
OVERLOADABLE long8 convert_long8_rtn(double8 v);
OVERLOADABLE ulong8 convert_ulong8_rte(double8 v);
OVERLOADABLE ulong8 convert_ulong8_rtz(double8 v);
OVERLOADABLE ulong8 convert_ulong8_rtp(double8 v);
OVERLOADABLE ulong8 convert_ulong8_rtn(double8 v);
OVERLOADABLE int8 convert_int8_rte(double8 v);
OVERLOADABLE int8 convert_int8_rtz(double8 v);
OVERLOADABLE int8 convert_int8_rtp(double8 v);
OVERLOADABLE int8 convert_int8_rtn(double8 v);
OVERLOADABLE uint8 convert_uint8_rte(double8 v);
OVERLOADABLE uint8 convert_uint8_rtz(double8 v);
OVERLOADABLE uint8 convert_uint8_rtp(double8 v);
OVERLOADABLE uint8 convert_uint8_rtn(double8 v);
OVERLOADABLE short8 convert_short8_rte(double8 v);
OVERLOADABLE short8 convert_short8_rtz(double8 v);
OVERLOADABLE short8 convert_short8_rtp(double8 v);
OVERLOADABLE short8 convert_short8_rtn(double8 v);
OVERLOADABLE ushort8 convert_ushort8_rte(double8 v);
OVERLOADABLE ushort8 convert_ushort8_rtz(double8 v);
OVERLOADABLE ushort8 convert_ushort8_rtp(double8 v);
OVERLOADABLE ushort8 convert_ushort8_rtn(double8 v);
OVERLOADABLE char8 convert_char8_rte(double8 v);
OVERLOADABLE char8 convert_char8_rtz(double8 v);
OVERLOADABLE char8 convert_char8_rtp(double8 v);
OVERLOADABLE char8 convert_char8_rtn(double8 v);
OVERLOADABLE uchar8 convert_uchar8_rte(double8 v);
OVERLOADABLE uchar8 convert_uchar8_rtz(double8 v);
OVERLOADABLE uchar8 convert_uchar8_rtp(double8 v);
OVERLOADABLE uchar8 convert_uchar8_rtn(double8 v);
OVERLOADABLE float8 convert_float8_rte(double8 v);
OVERLOADABLE float8 convert_float8_rtz(double8 v);
OVERLOADABLE float8 convert_float8_rtp(double8 v);
OVERLOADABLE float8 convert_float8_rtn(double8 v);
OVERLOADABLE half8 convert_half8_rte(double8 v);
OVERLOADABLE half8 convert_half8_rtz(double8 v);
OVERLOADABLE half8 convert_half8_rtp(double8 v);
OVERLOADABLE half8 convert_half8_rtn(double8 v);
OVERLOADABLE long8 convert_long8_rte(float8 v);
OVERLOADABLE long8 convert_long8_rtz(float8 v);
OVERLOADABLE long8 convert_long8_rtp(float8 v);
OVERLOADABLE long8 convert_long8_rtn(float8 v);
OVERLOADABLE ulong8 convert_ulong8_rte(float8 v);
OVERLOADABLE ulong8 convert_ulong8_rtz(float8 v);
OVERLOADABLE ulong8 convert_ulong8_rtp(float8 v);
OVERLOADABLE ulong8 convert_ulong8_rtn(float8 v);
OVERLOADABLE int8 convert_int8_rte(float8 v);
OVERLOADABLE int8 convert_int8_rtz(float8 v);
OVERLOADABLE int8 convert_int8_rtp(float8 v);
OVERLOADABLE int8 convert_int8_rtn(float8 v);
OVERLOADABLE uint8 convert_uint8_rte(float8 v);
OVERLOADABLE uint8 convert_uint8_rtz(float8 v);
OVERLOADABLE uint8 convert_uint8_rtp(float8 v);
OVERLOADABLE uint8 convert_uint8_rtn(float8 v);
OVERLOADABLE short8 convert_short8_rte(float8 v);
OVERLOADABLE short8 convert_short8_rtz(float8 v);
OVERLOADABLE short8 convert_short8_rtp(float8 v);
OVERLOADABLE short8 convert_short8_rtn(float8 v);
OVERLOADABLE ushort8 convert_ushort8_rte(float8 v);
OVERLOADABLE ushort8 convert_ushort8_rtz(float8 v);
OVERLOADABLE ushort8 convert_ushort8_rtp(float8 v);
OVERLOADABLE ushort8 convert_ushort8_rtn(float8 v);
OVERLOADABLE char8 convert_char8_rte(float8 v);
OVERLOADABLE char8 convert_char8_rtz(float8 v);
OVERLOADABLE char8 convert_char8_rtp(float8 v);
OVERLOADABLE char8 convert_char8_rtn(float8 v);
OVERLOADABLE uchar8 convert_uchar8_rte(float8 v);
OVERLOADABLE uchar8 convert_uchar8_rtz(float8 v);
OVERLOADABLE uchar8 convert_uchar8_rtp(float8 v);
OVERLOADABLE uchar8 convert_uchar8_rtn(float8 v);
OVERLOADABLE float8 convert_float8_rte(float8 v);
OVERLOADABLE float8 convert_float8_rtz(float8 v);
OVERLOADABLE float8 convert_float8_rtp(float8 v);
OVERLOADABLE float8 convert_float8_rtn(float8 v);
OVERLOADABLE half8 convert_half8_rte(float8 v);
OVERLOADABLE half8 convert_half8_rtz(float8 v);
OVERLOADABLE half8 convert_half8_rtp(float8 v);
OVERLOADABLE half8 convert_half8_rtn(float8 v);
OVERLOADABLE long8 convert_long8_rte(half8 v);
OVERLOADABLE long8 convert_long8_rtz(half8 v);
OVERLOADABLE long8 convert_long8_rtp(half8 v);
OVERLOADABLE long8 convert_long8_rtn(half8 v);
OVERLOADABLE ulong8 convert_ulong8_rte(half8 v);
OVERLOADABLE ulong8 convert_ulong8_rtz(half8 v);
OVERLOADABLE ulong8 convert_ulong8_rtp(half8 v);
OVERLOADABLE ulong8 convert_ulong8_rtn(half8 v);
OVERLOADABLE int8 convert_int8_rte(half8 v);
OVERLOADABLE int8 convert_int8_rtz(half8 v);
OVERLOADABLE int8 convert_int8_rtp(half8 v);
OVERLOADABLE int8 convert_int8_rtn(half8 v);
OVERLOADABLE uint8 convert_uint8_rte(half8 v);
OVERLOADABLE uint8 convert_uint8_rtz(half8 v);
OVERLOADABLE uint8 convert_uint8_rtp(half8 v);
OVERLOADABLE uint8 convert_uint8_rtn(half8 v);
OVERLOADABLE short8 convert_short8_rte(half8 v);
OVERLOADABLE short8 convert_short8_rtz(half8 v);
OVERLOADABLE short8 convert_short8_rtp(half8 v);
OVERLOADABLE short8 convert_short8_rtn(half8 v);
OVERLOADABLE ushort8 convert_ushort8_rte(half8 v);
OVERLOADABLE ushort8 convert_ushort8_rtz(half8 v);
OVERLOADABLE ushort8 convert_ushort8_rtp(half8 v);
OVERLOADABLE ushort8 convert_ushort8_rtn(half8 v);
OVERLOADABLE char8 convert_char8_rte(half8 v);
OVERLOADABLE char8 convert_char8_rtz(half8 v);
OVERLOADABLE char8 convert_char8_rtp(half8 v);
OVERLOADABLE char8 convert_char8_rtn(half8 v);
OVERLOADABLE uchar8 convert_uchar8_rte(half8 v);
OVERLOADABLE uchar8 convert_uchar8_rtz(half8 v);
OVERLOADABLE uchar8 convert_uchar8_rtp(half8 v);
OVERLOADABLE uchar8 convert_uchar8_rtn(half8 v);
OVERLOADABLE float8 convert_float8_rte(half8 v);
OVERLOADABLE float8 convert_float8_rtz(half8 v);
OVERLOADABLE float8 convert_float8_rtp(half8 v);
OVERLOADABLE float8 convert_float8_rtn(half8 v);
OVERLOADABLE half8 convert_half8_rte(half8 v);
OVERLOADABLE half8 convert_half8_rtz(half8 v);
OVERLOADABLE half8 convert_half8_rtp(half8 v);
OVERLOADABLE half8 convert_half8_rtn(half8 v);
OVERLOADABLE long16 convert_long16_rte(long16 v);
OVERLOADABLE long16 convert_long16_rtz(long16 v);
OVERLOADABLE long16 convert_long16_rtp(long16 v);
OVERLOADABLE long16 convert_long16_rtn(long16 v);
OVERLOADABLE ulong16 convert_ulong16_rte(long16 v);
OVERLOADABLE ulong16 convert_ulong16_rtz(long16 v);
OVERLOADABLE ulong16 convert_ulong16_rtp(long16 v);
OVERLOADABLE ulong16 convert_ulong16_rtn(long16 v);
OVERLOADABLE int16 convert_int16_rte(long16 v);
OVERLOADABLE int16 convert_int16_rtz(long16 v);
OVERLOADABLE int16 convert_int16_rtp(long16 v);
OVERLOADABLE int16 convert_int16_rtn(long16 v);
OVERLOADABLE uint16 convert_uint16_rte(long16 v);
OVERLOADABLE uint16 convert_uint16_rtz(long16 v);
OVERLOADABLE uint16 convert_uint16_rtp(long16 v);
OVERLOADABLE uint16 convert_uint16_rtn(long16 v);
OVERLOADABLE short16 convert_short16_rte(long16 v);
OVERLOADABLE short16 convert_short16_rtz(long16 v);
OVERLOADABLE short16 convert_short16_rtp(long16 v);
OVERLOADABLE short16 convert_short16_rtn(long16 v);
OVERLOADABLE ushort16 convert_ushort16_rte(long16 v);
OVERLOADABLE ushort16 convert_ushort16_rtz(long16 v);
OVERLOADABLE ushort16 convert_ushort16_rtp(long16 v);
OVERLOADABLE ushort16 convert_ushort16_rtn(long16 v);
OVERLOADABLE char16 convert_char16_rte(long16 v);
OVERLOADABLE char16 convert_char16_rtz(long16 v);
OVERLOADABLE char16 convert_char16_rtp(long16 v);
OVERLOADABLE char16 convert_char16_rtn(long16 v);
OVERLOADABLE uchar16 convert_uchar16_rte(long16 v);
OVERLOADABLE uchar16 convert_uchar16_rtz(long16 v);
OVERLOADABLE uchar16 convert_uchar16_rtp(long16 v);
OVERLOADABLE uchar16 convert_uchar16_rtn(long16 v);
OVERLOADABLE float16 convert_float16_rte(long16 v);
OVERLOADABLE float16 convert_float16_rtz(long16 v);
OVERLOADABLE float16 convert_float16_rtp(long16 v);
OVERLOADABLE float16 convert_float16_rtn(long16 v);
OVERLOADABLE half16 convert_half16_rte(long16 v);
OVERLOADABLE half16 convert_half16_rtz(long16 v);
OVERLOADABLE half16 convert_half16_rtp(long16 v);
OVERLOADABLE half16 convert_half16_rtn(long16 v);
OVERLOADABLE long16 convert_long16_rte(ulong16 v);
OVERLOADABLE long16 convert_long16_rtz(ulong16 v);
OVERLOADABLE long16 convert_long16_rtp(ulong16 v);
OVERLOADABLE long16 convert_long16_rtn(ulong16 v);
OVERLOADABLE ulong16 convert_ulong16_rte(ulong16 v);
OVERLOADABLE ulong16 convert_ulong16_rtz(ulong16 v);
OVERLOADABLE ulong16 convert_ulong16_rtp(ulong16 v);
OVERLOADABLE ulong16 convert_ulong16_rtn(ulong16 v);
OVERLOADABLE int16 convert_int16_rte(ulong16 v);
OVERLOADABLE int16 convert_int16_rtz(ulong16 v);
OVERLOADABLE int16 convert_int16_rtp(ulong16 v);
OVERLOADABLE int16 convert_int16_rtn(ulong16 v);
OVERLOADABLE uint16 convert_uint16_rte(ulong16 v);
OVERLOADABLE uint16 convert_uint16_rtz(ulong16 v);
OVERLOADABLE uint16 convert_uint16_rtp(ulong16 v);
OVERLOADABLE uint16 convert_uint16_rtn(ulong16 v);
OVERLOADABLE short16 convert_short16_rte(ulong16 v);
OVERLOADABLE short16 convert_short16_rtz(ulong16 v);
OVERLOADABLE short16 convert_short16_rtp(ulong16 v);
OVERLOADABLE short16 convert_short16_rtn(ulong16 v);
OVERLOADABLE ushort16 convert_ushort16_rte(ulong16 v);
OVERLOADABLE ushort16 convert_ushort16_rtz(ulong16 v);
OVERLOADABLE ushort16 convert_ushort16_rtp(ulong16 v);
OVERLOADABLE ushort16 convert_ushort16_rtn(ulong16 v);
OVERLOADABLE char16 convert_char16_rte(ulong16 v);
OVERLOADABLE char16 convert_char16_rtz(ulong16 v);
OVERLOADABLE char16 convert_char16_rtp(ulong16 v);
OVERLOADABLE char16 convert_char16_rtn(ulong16 v);
OVERLOADABLE uchar16 convert_uchar16_rte(ulong16 v);
OVERLOADABLE uchar16 convert_uchar16_rtz(ulong16 v);
OVERLOADABLE uchar16 convert_uchar16_rtp(ulong16 v);
OVERLOADABLE uchar16 convert_uchar16_rtn(ulong16 v);
OVERLOADABLE float16 convert_float16_rte(ulong16 v);
OVERLOADABLE float16 convert_float16_rtz(ulong16 v);
OVERLOADABLE float16 convert_float16_rtp(ulong16 v);
OVERLOADABLE float16 convert_float16_rtn(ulong16 v);
OVERLOADABLE half16 convert_half16_rte(ulong16 v);
OVERLOADABLE half16 convert_half16_rtz(ulong16 v);
OVERLOADABLE half16 convert_half16_rtp(ulong16 v);
OVERLOADABLE half16 convert_half16_rtn(ulong16 v);
OVERLOADABLE long16 convert_long16_rte(int16 v);
OVERLOADABLE long16 convert_long16_rtz(int16 v);
OVERLOADABLE long16 convert_long16_rtp(int16 v);
OVERLOADABLE long16 convert_long16_rtn(int16 v);
OVERLOADABLE ulong16 convert_ulong16_rte(int16 v);
OVERLOADABLE ulong16 convert_ulong16_rtz(int16 v);
OVERLOADABLE ulong16 convert_ulong16_rtp(int16 v);
OVERLOADABLE ulong16 convert_ulong16_rtn(int16 v);
OVERLOADABLE int16 convert_int16_rte(int16 v);
OVERLOADABLE int16 convert_int16_rtz(int16 v);
OVERLOADABLE int16 convert_int16_rtp(int16 v);
OVERLOADABLE int16 convert_int16_rtn(int16 v);
OVERLOADABLE uint16 convert_uint16_rte(int16 v);
OVERLOADABLE uint16 convert_uint16_rtz(int16 v);
OVERLOADABLE uint16 convert_uint16_rtp(int16 v);
OVERLOADABLE uint16 convert_uint16_rtn(int16 v);
OVERLOADABLE short16 convert_short16_rte(int16 v);
OVERLOADABLE short16 convert_short16_rtz(int16 v);
OVERLOADABLE short16 convert_short16_rtp(int16 v);
OVERLOADABLE short16 convert_short16_rtn(int16 v);
OVERLOADABLE ushort16 convert_ushort16_rte(int16 v);
OVERLOADABLE ushort16 convert_ushort16_rtz(int16 v);
OVERLOADABLE ushort16 convert_ushort16_rtp(int16 v);
OVERLOADABLE ushort16 convert_ushort16_rtn(int16 v);
OVERLOADABLE char16 convert_char16_rte(int16 v);
OVERLOADABLE char16 convert_char16_rtz(int16 v);
OVERLOADABLE char16 convert_char16_rtp(int16 v);
OVERLOADABLE char16 convert_char16_rtn(int16 v);
OVERLOADABLE uchar16 convert_uchar16_rte(int16 v);
OVERLOADABLE uchar16 convert_uchar16_rtz(int16 v);
OVERLOADABLE uchar16 convert_uchar16_rtp(int16 v);
OVERLOADABLE uchar16 convert_uchar16_rtn(int16 v);
OVERLOADABLE float16 convert_float16_rte(int16 v);
OVERLOADABLE float16 convert_float16_rtz(int16 v);
OVERLOADABLE float16 convert_float16_rtp(int16 v);
OVERLOADABLE float16 convert_float16_rtn(int16 v);
OVERLOADABLE half16 convert_half16_rte(int16 v);
OVERLOADABLE half16 convert_half16_rtz(int16 v);
OVERLOADABLE half16 convert_half16_rtp(int16 v);
OVERLOADABLE half16 convert_half16_rtn(int16 v);
OVERLOADABLE long16 convert_long16_rte(uint16 v);
OVERLOADABLE long16 convert_long16_rtz(uint16 v);
OVERLOADABLE long16 convert_long16_rtp(uint16 v);
OVERLOADABLE long16 convert_long16_rtn(uint16 v);
OVERLOADABLE ulong16 convert_ulong16_rte(uint16 v);
OVERLOADABLE ulong16 convert_ulong16_rtz(uint16 v);
OVERLOADABLE ulong16 convert_ulong16_rtp(uint16 v);
OVERLOADABLE ulong16 convert_ulong16_rtn(uint16 v);
OVERLOADABLE int16 convert_int16_rte(uint16 v);
OVERLOADABLE int16 convert_int16_rtz(uint16 v);
OVERLOADABLE int16 convert_int16_rtp(uint16 v);
OVERLOADABLE int16 convert_int16_rtn(uint16 v);
OVERLOADABLE uint16 convert_uint16_rte(uint16 v);
OVERLOADABLE uint16 convert_uint16_rtz(uint16 v);
OVERLOADABLE uint16 convert_uint16_rtp(uint16 v);
OVERLOADABLE uint16 convert_uint16_rtn(uint16 v);
OVERLOADABLE short16 convert_short16_rte(uint16 v);
OVERLOADABLE short16 convert_short16_rtz(uint16 v);
OVERLOADABLE short16 convert_short16_rtp(uint16 v);
OVERLOADABLE short16 convert_short16_rtn(uint16 v);
OVERLOADABLE ushort16 convert_ushort16_rte(uint16 v);
OVERLOADABLE ushort16 convert_ushort16_rtz(uint16 v);
OVERLOADABLE ushort16 convert_ushort16_rtp(uint16 v);
OVERLOADABLE ushort16 convert_ushort16_rtn(uint16 v);
OVERLOADABLE char16 convert_char16_rte(uint16 v);
OVERLOADABLE char16 convert_char16_rtz(uint16 v);
OVERLOADABLE char16 convert_char16_rtp(uint16 v);
OVERLOADABLE char16 convert_char16_rtn(uint16 v);
OVERLOADABLE uchar16 convert_uchar16_rte(uint16 v);
OVERLOADABLE uchar16 convert_uchar16_rtz(uint16 v);
OVERLOADABLE uchar16 convert_uchar16_rtp(uint16 v);
OVERLOADABLE uchar16 convert_uchar16_rtn(uint16 v);
OVERLOADABLE float16 convert_float16_rte(uint16 v);
OVERLOADABLE float16 convert_float16_rtz(uint16 v);
OVERLOADABLE float16 convert_float16_rtp(uint16 v);
OVERLOADABLE float16 convert_float16_rtn(uint16 v);
OVERLOADABLE half16 convert_half16_rte(uint16 v);
OVERLOADABLE half16 convert_half16_rtz(uint16 v);
OVERLOADABLE half16 convert_half16_rtp(uint16 v);
OVERLOADABLE half16 convert_half16_rtn(uint16 v);
OVERLOADABLE long16 convert_long16_rte(short16 v);
OVERLOADABLE long16 convert_long16_rtz(short16 v);
OVERLOADABLE long16 convert_long16_rtp(short16 v);
OVERLOADABLE long16 convert_long16_rtn(short16 v);
OVERLOADABLE ulong16 convert_ulong16_rte(short16 v);
OVERLOADABLE ulong16 convert_ulong16_rtz(short16 v);
OVERLOADABLE ulong16 convert_ulong16_rtp(short16 v);
OVERLOADABLE ulong16 convert_ulong16_rtn(short16 v);
OVERLOADABLE int16 convert_int16_rte(short16 v);
OVERLOADABLE int16 convert_int16_rtz(short16 v);
OVERLOADABLE int16 convert_int16_rtp(short16 v);
OVERLOADABLE int16 convert_int16_rtn(short16 v);
OVERLOADABLE uint16 convert_uint16_rte(short16 v);
OVERLOADABLE uint16 convert_uint16_rtz(short16 v);
OVERLOADABLE uint16 convert_uint16_rtp(short16 v);
OVERLOADABLE uint16 convert_uint16_rtn(short16 v);
OVERLOADABLE short16 convert_short16_rte(short16 v);
OVERLOADABLE short16 convert_short16_rtz(short16 v);
OVERLOADABLE short16 convert_short16_rtp(short16 v);
OVERLOADABLE short16 convert_short16_rtn(short16 v);
OVERLOADABLE ushort16 convert_ushort16_rte(short16 v);
OVERLOADABLE ushort16 convert_ushort16_rtz(short16 v);
OVERLOADABLE ushort16 convert_ushort16_rtp(short16 v);
OVERLOADABLE ushort16 convert_ushort16_rtn(short16 v);
OVERLOADABLE char16 convert_char16_rte(short16 v);
OVERLOADABLE char16 convert_char16_rtz(short16 v);
OVERLOADABLE char16 convert_char16_rtp(short16 v);
OVERLOADABLE char16 convert_char16_rtn(short16 v);
OVERLOADABLE uchar16 convert_uchar16_rte(short16 v);
OVERLOADABLE uchar16 convert_uchar16_rtz(short16 v);
OVERLOADABLE uchar16 convert_uchar16_rtp(short16 v);
OVERLOADABLE uchar16 convert_uchar16_rtn(short16 v);
OVERLOADABLE float16 convert_float16_rte(short16 v);
OVERLOADABLE float16 convert_float16_rtz(short16 v);
OVERLOADABLE float16 convert_float16_rtp(short16 v);
OVERLOADABLE float16 convert_float16_rtn(short16 v);
OVERLOADABLE half16 convert_half16_rte(short16 v);
OVERLOADABLE half16 convert_half16_rtz(short16 v);
OVERLOADABLE half16 convert_half16_rtp(short16 v);
OVERLOADABLE half16 convert_half16_rtn(short16 v);
OVERLOADABLE long16 convert_long16_rte(ushort16 v);
OVERLOADABLE long16 convert_long16_rtz(ushort16 v);
OVERLOADABLE long16 convert_long16_rtp(ushort16 v);
OVERLOADABLE long16 convert_long16_rtn(ushort16 v);
OVERLOADABLE ulong16 convert_ulong16_rte(ushort16 v);
OVERLOADABLE ulong16 convert_ulong16_rtz(ushort16 v);
OVERLOADABLE ulong16 convert_ulong16_rtp(ushort16 v);
OVERLOADABLE ulong16 convert_ulong16_rtn(ushort16 v);
OVERLOADABLE int16 convert_int16_rte(ushort16 v);
OVERLOADABLE int16 convert_int16_rtz(ushort16 v);
OVERLOADABLE int16 convert_int16_rtp(ushort16 v);
OVERLOADABLE int16 convert_int16_rtn(ushort16 v);
OVERLOADABLE uint16 convert_uint16_rte(ushort16 v);
OVERLOADABLE uint16 convert_uint16_rtz(ushort16 v);
OVERLOADABLE uint16 convert_uint16_rtp(ushort16 v);
OVERLOADABLE uint16 convert_uint16_rtn(ushort16 v);
OVERLOADABLE short16 convert_short16_rte(ushort16 v);
OVERLOADABLE short16 convert_short16_rtz(ushort16 v);
OVERLOADABLE short16 convert_short16_rtp(ushort16 v);
OVERLOADABLE short16 convert_short16_rtn(ushort16 v);
OVERLOADABLE ushort16 convert_ushort16_rte(ushort16 v);
OVERLOADABLE ushort16 convert_ushort16_rtz(ushort16 v);
OVERLOADABLE ushort16 convert_ushort16_rtp(ushort16 v);
OVERLOADABLE ushort16 convert_ushort16_rtn(ushort16 v);
OVERLOADABLE char16 convert_char16_rte(ushort16 v);
OVERLOADABLE char16 convert_char16_rtz(ushort16 v);
OVERLOADABLE char16 convert_char16_rtp(ushort16 v);
OVERLOADABLE char16 convert_char16_rtn(ushort16 v);
OVERLOADABLE uchar16 convert_uchar16_rte(ushort16 v);
OVERLOADABLE uchar16 convert_uchar16_rtz(ushort16 v);
OVERLOADABLE uchar16 convert_uchar16_rtp(ushort16 v);
OVERLOADABLE uchar16 convert_uchar16_rtn(ushort16 v);
OVERLOADABLE float16 convert_float16_rte(ushort16 v);
OVERLOADABLE float16 convert_float16_rtz(ushort16 v);
OVERLOADABLE float16 convert_float16_rtp(ushort16 v);
OVERLOADABLE float16 convert_float16_rtn(ushort16 v);
OVERLOADABLE half16 convert_half16_rte(ushort16 v);
OVERLOADABLE half16 convert_half16_rtz(ushort16 v);
OVERLOADABLE half16 convert_half16_rtp(ushort16 v);
OVERLOADABLE half16 convert_half16_rtn(ushort16 v);
OVERLOADABLE long16 convert_long16_rte(char16 v);
OVERLOADABLE long16 convert_long16_rtz(char16 v);
OVERLOADABLE long16 convert_long16_rtp(char16 v);
OVERLOADABLE long16 convert_long16_rtn(char16 v);
OVERLOADABLE ulong16 convert_ulong16_rte(char16 v);
OVERLOADABLE ulong16 convert_ulong16_rtz(char16 v);
OVERLOADABLE ulong16 convert_ulong16_rtp(char16 v);
OVERLOADABLE ulong16 convert_ulong16_rtn(char16 v);
OVERLOADABLE int16 convert_int16_rte(char16 v);
OVERLOADABLE int16 convert_int16_rtz(char16 v);
OVERLOADABLE int16 convert_int16_rtp(char16 v);
OVERLOADABLE int16 convert_int16_rtn(char16 v);
OVERLOADABLE uint16 convert_uint16_rte(char16 v);
OVERLOADABLE uint16 convert_uint16_rtz(char16 v);
OVERLOADABLE uint16 convert_uint16_rtp(char16 v);
OVERLOADABLE uint16 convert_uint16_rtn(char16 v);
OVERLOADABLE short16 convert_short16_rte(char16 v);
OVERLOADABLE short16 convert_short16_rtz(char16 v);
OVERLOADABLE short16 convert_short16_rtp(char16 v);
OVERLOADABLE short16 convert_short16_rtn(char16 v);
OVERLOADABLE ushort16 convert_ushort16_rte(char16 v);
OVERLOADABLE ushort16 convert_ushort16_rtz(char16 v);
OVERLOADABLE ushort16 convert_ushort16_rtp(char16 v);
OVERLOADABLE ushort16 convert_ushort16_rtn(char16 v);
OVERLOADABLE char16 convert_char16_rte(char16 v);
OVERLOADABLE char16 convert_char16_rtz(char16 v);
OVERLOADABLE char16 convert_char16_rtp(char16 v);
OVERLOADABLE char16 convert_char16_rtn(char16 v);
OVERLOADABLE uchar16 convert_uchar16_rte(char16 v);
OVERLOADABLE uchar16 convert_uchar16_rtz(char16 v);
OVERLOADABLE uchar16 convert_uchar16_rtp(char16 v);
OVERLOADABLE uchar16 convert_uchar16_rtn(char16 v);
OVERLOADABLE float16 convert_float16_rte(char16 v);
OVERLOADABLE float16 convert_float16_rtz(char16 v);
OVERLOADABLE float16 convert_float16_rtp(char16 v);
OVERLOADABLE float16 convert_float16_rtn(char16 v);
OVERLOADABLE half16 convert_half16_rte(char16 v);
OVERLOADABLE half16 convert_half16_rtz(char16 v);
OVERLOADABLE half16 convert_half16_rtp(char16 v);
OVERLOADABLE half16 convert_half16_rtn(char16 v);
OVERLOADABLE long16 convert_long16_rte(uchar16 v);
OVERLOADABLE long16 convert_long16_rtz(uchar16 v);
OVERLOADABLE long16 convert_long16_rtp(uchar16 v);
OVERLOADABLE long16 convert_long16_rtn(uchar16 v);
OVERLOADABLE ulong16 convert_ulong16_rte(uchar16 v);
OVERLOADABLE ulong16 convert_ulong16_rtz(uchar16 v);
OVERLOADABLE ulong16 convert_ulong16_rtp(uchar16 v);
OVERLOADABLE ulong16 convert_ulong16_rtn(uchar16 v);
OVERLOADABLE int16 convert_int16_rte(uchar16 v);
OVERLOADABLE int16 convert_int16_rtz(uchar16 v);
OVERLOADABLE int16 convert_int16_rtp(uchar16 v);
OVERLOADABLE int16 convert_int16_rtn(uchar16 v);
OVERLOADABLE uint16 convert_uint16_rte(uchar16 v);
OVERLOADABLE uint16 convert_uint16_rtz(uchar16 v);
OVERLOADABLE uint16 convert_uint16_rtp(uchar16 v);
OVERLOADABLE uint16 convert_uint16_rtn(uchar16 v);
OVERLOADABLE short16 convert_short16_rte(uchar16 v);
OVERLOADABLE short16 convert_short16_rtz(uchar16 v);
OVERLOADABLE short16 convert_short16_rtp(uchar16 v);
OVERLOADABLE short16 convert_short16_rtn(uchar16 v);
OVERLOADABLE ushort16 convert_ushort16_rte(uchar16 v);
OVERLOADABLE ushort16 convert_ushort16_rtz(uchar16 v);
OVERLOADABLE ushort16 convert_ushort16_rtp(uchar16 v);
OVERLOADABLE ushort16 convert_ushort16_rtn(uchar16 v);
OVERLOADABLE char16 convert_char16_rte(uchar16 v);
OVERLOADABLE char16 convert_char16_rtz(uchar16 v);
OVERLOADABLE char16 convert_char16_rtp(uchar16 v);
OVERLOADABLE char16 convert_char16_rtn(uchar16 v);
OVERLOADABLE uchar16 convert_uchar16_rte(uchar16 v);
OVERLOADABLE uchar16 convert_uchar16_rtz(uchar16 v);
OVERLOADABLE uchar16 convert_uchar16_rtp(uchar16 v);
OVERLOADABLE uchar16 convert_uchar16_rtn(uchar16 v);
OVERLOADABLE float16 convert_float16_rte(uchar16 v);
OVERLOADABLE float16 convert_float16_rtz(uchar16 v);
OVERLOADABLE float16 convert_float16_rtp(uchar16 v);
OVERLOADABLE float16 convert_float16_rtn(uchar16 v);
OVERLOADABLE half16 convert_half16_rte(uchar16 v);
OVERLOADABLE half16 convert_half16_rtz(uchar16 v);
OVERLOADABLE half16 convert_half16_rtp(uchar16 v);
OVERLOADABLE half16 convert_half16_rtn(uchar16 v);
OVERLOADABLE long16 convert_long16_rte(double16 v);
OVERLOADABLE long16 convert_long16_rtz(double16 v);
OVERLOADABLE long16 convert_long16_rtp(double16 v);
OVERLOADABLE long16 convert_long16_rtn(double16 v);
OVERLOADABLE ulong16 convert_ulong16_rte(double16 v);
OVERLOADABLE ulong16 convert_ulong16_rtz(double16 v);
OVERLOADABLE ulong16 convert_ulong16_rtp(double16 v);
OVERLOADABLE ulong16 convert_ulong16_rtn(double16 v);
OVERLOADABLE int16 convert_int16_rte(double16 v);
OVERLOADABLE int16 convert_int16_rtz(double16 v);
OVERLOADABLE int16 convert_int16_rtp(double16 v);
OVERLOADABLE int16 convert_int16_rtn(double16 v);
OVERLOADABLE uint16 convert_uint16_rte(double16 v);
OVERLOADABLE uint16 convert_uint16_rtz(double16 v);
OVERLOADABLE uint16 convert_uint16_rtp(double16 v);
OVERLOADABLE uint16 convert_uint16_rtn(double16 v);
OVERLOADABLE short16 convert_short16_rte(double16 v);
OVERLOADABLE short16 convert_short16_rtz(double16 v);
OVERLOADABLE short16 convert_short16_rtp(double16 v);
OVERLOADABLE short16 convert_short16_rtn(double16 v);
OVERLOADABLE ushort16 convert_ushort16_rte(double16 v);
OVERLOADABLE ushort16 convert_ushort16_rtz(double16 v);
OVERLOADABLE ushort16 convert_ushort16_rtp(double16 v);
OVERLOADABLE ushort16 convert_ushort16_rtn(double16 v);
OVERLOADABLE char16 convert_char16_rte(double16 v);
OVERLOADABLE char16 convert_char16_rtz(double16 v);
OVERLOADABLE char16 convert_char16_rtp(double16 v);
OVERLOADABLE char16 convert_char16_rtn(double16 v);
OVERLOADABLE uchar16 convert_uchar16_rte(double16 v);
OVERLOADABLE uchar16 convert_uchar16_rtz(double16 v);
OVERLOADABLE uchar16 convert_uchar16_rtp(double16 v);
OVERLOADABLE uchar16 convert_uchar16_rtn(double16 v);
OVERLOADABLE float16 convert_float16_rte(double16 v);
OVERLOADABLE float16 convert_float16_rtz(double16 v);
OVERLOADABLE float16 convert_float16_rtp(double16 v);
OVERLOADABLE float16 convert_float16_rtn(double16 v);
OVERLOADABLE half16 convert_half16_rte(double16 v);
OVERLOADABLE half16 convert_half16_rtz(double16 v);
OVERLOADABLE half16 convert_half16_rtp(double16 v);
OVERLOADABLE half16 convert_half16_rtn(double16 v);
OVERLOADABLE long16 convert_long16_rte(float16 v);
OVERLOADABLE long16 convert_long16_rtz(float16 v);
OVERLOADABLE long16 convert_long16_rtp(float16 v);
OVERLOADABLE long16 convert_long16_rtn(float16 v);
OVERLOADABLE ulong16 convert_ulong16_rte(float16 v);
OVERLOADABLE ulong16 convert_ulong16_rtz(float16 v);
OVERLOADABLE ulong16 convert_ulong16_rtp(float16 v);
OVERLOADABLE ulong16 convert_ulong16_rtn(float16 v);
OVERLOADABLE int16 convert_int16_rte(float16 v);
OVERLOADABLE int16 convert_int16_rtz(float16 v);
OVERLOADABLE int16 convert_int16_rtp(float16 v);
OVERLOADABLE int16 convert_int16_rtn(float16 v);
OVERLOADABLE uint16 convert_uint16_rte(float16 v);
OVERLOADABLE uint16 convert_uint16_rtz(float16 v);
OVERLOADABLE uint16 convert_uint16_rtp(float16 v);
OVERLOADABLE uint16 convert_uint16_rtn(float16 v);
OVERLOADABLE short16 convert_short16_rte(float16 v);
OVERLOADABLE short16 convert_short16_rtz(float16 v);
OVERLOADABLE short16 convert_short16_rtp(float16 v);
OVERLOADABLE short16 convert_short16_rtn(float16 v);
OVERLOADABLE ushort16 convert_ushort16_rte(float16 v);
OVERLOADABLE ushort16 convert_ushort16_rtz(float16 v);
OVERLOADABLE ushort16 convert_ushort16_rtp(float16 v);
OVERLOADABLE ushort16 convert_ushort16_rtn(float16 v);
OVERLOADABLE char16 convert_char16_rte(float16 v);
OVERLOADABLE char16 convert_char16_rtz(float16 v);
OVERLOADABLE char16 convert_char16_rtp(float16 v);
OVERLOADABLE char16 convert_char16_rtn(float16 v);
OVERLOADABLE uchar16 convert_uchar16_rte(float16 v);
OVERLOADABLE uchar16 convert_uchar16_rtz(float16 v);
OVERLOADABLE uchar16 convert_uchar16_rtp(float16 v);
OVERLOADABLE uchar16 convert_uchar16_rtn(float16 v);
OVERLOADABLE float16 convert_float16_rte(float16 v);
OVERLOADABLE float16 convert_float16_rtz(float16 v);
OVERLOADABLE float16 convert_float16_rtp(float16 v);
OVERLOADABLE float16 convert_float16_rtn(float16 v);
OVERLOADABLE half16 convert_half16_rte(float16 v);
OVERLOADABLE half16 convert_half16_rtz(float16 v);
OVERLOADABLE half16 convert_half16_rtp(float16 v);
OVERLOADABLE half16 convert_half16_rtn(float16 v);
OVERLOADABLE long16 convert_long16_rte(half16 v);
OVERLOADABLE long16 convert_long16_rtz(half16 v);
OVERLOADABLE long16 convert_long16_rtp(half16 v);
OVERLOADABLE long16 convert_long16_rtn(half16 v);
OVERLOADABLE ulong16 convert_ulong16_rte(half16 v);
OVERLOADABLE ulong16 convert_ulong16_rtz(half16 v);
OVERLOADABLE ulong16 convert_ulong16_rtp(half16 v);
OVERLOADABLE ulong16 convert_ulong16_rtn(half16 v);
OVERLOADABLE int16 convert_int16_rte(half16 v);
OVERLOADABLE int16 convert_int16_rtz(half16 v);
OVERLOADABLE int16 convert_int16_rtp(half16 v);
OVERLOADABLE int16 convert_int16_rtn(half16 v);
OVERLOADABLE uint16 convert_uint16_rte(half16 v);
OVERLOADABLE uint16 convert_uint16_rtz(half16 v);
OVERLOADABLE uint16 convert_uint16_rtp(half16 v);
OVERLOADABLE uint16 convert_uint16_rtn(half16 v);
OVERLOADABLE short16 convert_short16_rte(half16 v);
OVERLOADABLE short16 convert_short16_rtz(half16 v);
OVERLOADABLE short16 convert_short16_rtp(half16 v);
OVERLOADABLE short16 convert_short16_rtn(half16 v);
OVERLOADABLE ushort16 convert_ushort16_rte(half16 v);
OVERLOADABLE ushort16 convert_ushort16_rtz(half16 v);
OVERLOADABLE ushort16 convert_ushort16_rtp(half16 v);
OVERLOADABLE ushort16 convert_ushort16_rtn(half16 v);
OVERLOADABLE char16 convert_char16_rte(half16 v);
OVERLOADABLE char16 convert_char16_rtz(half16 v);
OVERLOADABLE char16 convert_char16_rtp(half16 v);
OVERLOADABLE char16 convert_char16_rtn(half16 v);
OVERLOADABLE uchar16 convert_uchar16_rte(half16 v);
OVERLOADABLE uchar16 convert_uchar16_rtz(half16 v);
OVERLOADABLE uchar16 convert_uchar16_rtp(half16 v);
OVERLOADABLE uchar16 convert_uchar16_rtn(half16 v);
OVERLOADABLE float16 convert_float16_rte(half16 v);
OVERLOADABLE float16 convert_float16_rtz(half16 v);
OVERLOADABLE float16 convert_float16_rtp(half16 v);
OVERLOADABLE float16 convert_float16_rtn(half16 v);
OVERLOADABLE half16 convert_half16_rte(half16 v);
OVERLOADABLE half16 convert_half16_rtz(half16 v);
OVERLOADABLE half16 convert_half16_rtp(half16 v);
OVERLOADABLE half16 convert_half16_rtn(half16 v);
#define DEF(DSTTYPE, SRCTYPE, SRC_MIN, SRC_MAX, DST_MIN, DST_MAX)             OVERLOADABLE DSTTYPE convert_ ## DSTTYPE ## _sat_rte(SRCTYPE x);             OVERLOADABLE DSTTYPE convert_ ## DSTTYPE ## _sat_rtz(SRCTYPE x);             OVERLOADABLE DSTTYPE convert_ ## DSTTYPE ## _sat_rtn(SRCTYPE x);             OVERLOADABLE DSTTYPE convert_ ## DSTTYPE ## _sat_rtp(SRCTYPE x);

    DEF(char, double, -0x1.0p7, 0x1.0p7-1,  0x80, 0x7F);
    DEF(uchar, double, 0, 0x1.0p8-1, 0, 0xFF);
    DEF(short, double, -0x1.0p15, 0x1.0p15-1, 0x8000, 0x7FFF);
    DEF(ushort, double, 0, 0x1.0p16-1, 0, 0xFFFF);
    DEF(int, double, -0x1.0p31, 0x1.0p31-1, 0x80000000, 0x7FFFFFFF);
    DEF(uint, double, 0, 0x1.0p32-1, 0, 0xFFFFFFFF);
    DEF(long, double, -0x1.0p63, 0x1.0p63, 0x8000000000000000, 0x7FFFFFFFFFFFFFFF);
    DEF(ulong, double, 0, 0x1.0p64, 0, 0xFFFFFFFFFFFFFFFF);
    #undef DEF
    
OVERLOADABLE long convert_long_sat_rte(long x);
OVERLOADABLE long convert_long_sat_rtz(long x);
OVERLOADABLE long convert_long_sat_rtp(long x);
OVERLOADABLE long convert_long_sat_rtn(long x);
OVERLOADABLE ulong convert_ulong_sat_rte(long x);
OVERLOADABLE ulong convert_ulong_sat_rtz(long x);
OVERLOADABLE ulong convert_ulong_sat_rtp(long x);
OVERLOADABLE ulong convert_ulong_sat_rtn(long x);
OVERLOADABLE int convert_int_sat_rte(long x);
OVERLOADABLE int convert_int_sat_rtz(long x);
OVERLOADABLE int convert_int_sat_rtp(long x);
OVERLOADABLE int convert_int_sat_rtn(long x);
OVERLOADABLE uint convert_uint_sat_rte(long x);
OVERLOADABLE uint convert_uint_sat_rtz(long x);
OVERLOADABLE uint convert_uint_sat_rtp(long x);
OVERLOADABLE uint convert_uint_sat_rtn(long x);
OVERLOADABLE short convert_short_sat_rte(long x);
OVERLOADABLE short convert_short_sat_rtz(long x);
OVERLOADABLE short convert_short_sat_rtp(long x);
OVERLOADABLE short convert_short_sat_rtn(long x);
OVERLOADABLE ushort convert_ushort_sat_rte(long x);
OVERLOADABLE ushort convert_ushort_sat_rtz(long x);
OVERLOADABLE ushort convert_ushort_sat_rtp(long x);
OVERLOADABLE ushort convert_ushort_sat_rtn(long x);
OVERLOADABLE char convert_char_sat_rte(long x);
OVERLOADABLE char convert_char_sat_rtz(long x);
OVERLOADABLE char convert_char_sat_rtp(long x);
OVERLOADABLE char convert_char_sat_rtn(long x);
OVERLOADABLE uchar convert_uchar_sat_rte(long x);
OVERLOADABLE uchar convert_uchar_sat_rtz(long x);
OVERLOADABLE uchar convert_uchar_sat_rtp(long x);
OVERLOADABLE uchar convert_uchar_sat_rtn(long x);
OVERLOADABLE long convert_long_sat_rte(ulong x);
OVERLOADABLE long convert_long_sat_rtz(ulong x);
OVERLOADABLE long convert_long_sat_rtp(ulong x);
OVERLOADABLE long convert_long_sat_rtn(ulong x);
OVERLOADABLE ulong convert_ulong_sat_rte(ulong x);
OVERLOADABLE ulong convert_ulong_sat_rtz(ulong x);
OVERLOADABLE ulong convert_ulong_sat_rtp(ulong x);
OVERLOADABLE ulong convert_ulong_sat_rtn(ulong x);
OVERLOADABLE int convert_int_sat_rte(ulong x);
OVERLOADABLE int convert_int_sat_rtz(ulong x);
OVERLOADABLE int convert_int_sat_rtp(ulong x);
OVERLOADABLE int convert_int_sat_rtn(ulong x);
OVERLOADABLE uint convert_uint_sat_rte(ulong x);
OVERLOADABLE uint convert_uint_sat_rtz(ulong x);
OVERLOADABLE uint convert_uint_sat_rtp(ulong x);
OVERLOADABLE uint convert_uint_sat_rtn(ulong x);
OVERLOADABLE short convert_short_sat_rte(ulong x);
OVERLOADABLE short convert_short_sat_rtz(ulong x);
OVERLOADABLE short convert_short_sat_rtp(ulong x);
OVERLOADABLE short convert_short_sat_rtn(ulong x);
OVERLOADABLE ushort convert_ushort_sat_rte(ulong x);
OVERLOADABLE ushort convert_ushort_sat_rtz(ulong x);
OVERLOADABLE ushort convert_ushort_sat_rtp(ulong x);
OVERLOADABLE ushort convert_ushort_sat_rtn(ulong x);
OVERLOADABLE char convert_char_sat_rte(ulong x);
OVERLOADABLE char convert_char_sat_rtz(ulong x);
OVERLOADABLE char convert_char_sat_rtp(ulong x);
OVERLOADABLE char convert_char_sat_rtn(ulong x);
OVERLOADABLE uchar convert_uchar_sat_rte(ulong x);
OVERLOADABLE uchar convert_uchar_sat_rtz(ulong x);
OVERLOADABLE uchar convert_uchar_sat_rtp(ulong x);
OVERLOADABLE uchar convert_uchar_sat_rtn(ulong x);
OVERLOADABLE long convert_long_sat_rte(int x);
OVERLOADABLE long convert_long_sat_rtz(int x);
OVERLOADABLE long convert_long_sat_rtp(int x);
OVERLOADABLE long convert_long_sat_rtn(int x);
OVERLOADABLE ulong convert_ulong_sat_rte(int x);
OVERLOADABLE ulong convert_ulong_sat_rtz(int x);
OVERLOADABLE ulong convert_ulong_sat_rtp(int x);
OVERLOADABLE ulong convert_ulong_sat_rtn(int x);
OVERLOADABLE int convert_int_sat_rte(int x);
OVERLOADABLE int convert_int_sat_rtz(int x);
OVERLOADABLE int convert_int_sat_rtp(int x);
OVERLOADABLE int convert_int_sat_rtn(int x);
OVERLOADABLE uint convert_uint_sat_rte(int x);
OVERLOADABLE uint convert_uint_sat_rtz(int x);
OVERLOADABLE uint convert_uint_sat_rtp(int x);
OVERLOADABLE uint convert_uint_sat_rtn(int x);
OVERLOADABLE short convert_short_sat_rte(int x);
OVERLOADABLE short convert_short_sat_rtz(int x);
OVERLOADABLE short convert_short_sat_rtp(int x);
OVERLOADABLE short convert_short_sat_rtn(int x);
OVERLOADABLE ushort convert_ushort_sat_rte(int x);
OVERLOADABLE ushort convert_ushort_sat_rtz(int x);
OVERLOADABLE ushort convert_ushort_sat_rtp(int x);
OVERLOADABLE ushort convert_ushort_sat_rtn(int x);
OVERLOADABLE char convert_char_sat_rte(int x);
OVERLOADABLE char convert_char_sat_rtz(int x);
OVERLOADABLE char convert_char_sat_rtp(int x);
OVERLOADABLE char convert_char_sat_rtn(int x);
OVERLOADABLE uchar convert_uchar_sat_rte(int x);
OVERLOADABLE uchar convert_uchar_sat_rtz(int x);
OVERLOADABLE uchar convert_uchar_sat_rtp(int x);
OVERLOADABLE uchar convert_uchar_sat_rtn(int x);
OVERLOADABLE long convert_long_sat_rte(uint x);
OVERLOADABLE long convert_long_sat_rtz(uint x);
OVERLOADABLE long convert_long_sat_rtp(uint x);
OVERLOADABLE long convert_long_sat_rtn(uint x);
OVERLOADABLE ulong convert_ulong_sat_rte(uint x);
OVERLOADABLE ulong convert_ulong_sat_rtz(uint x);
OVERLOADABLE ulong convert_ulong_sat_rtp(uint x);
OVERLOADABLE ulong convert_ulong_sat_rtn(uint x);
OVERLOADABLE int convert_int_sat_rte(uint x);
OVERLOADABLE int convert_int_sat_rtz(uint x);
OVERLOADABLE int convert_int_sat_rtp(uint x);
OVERLOADABLE int convert_int_sat_rtn(uint x);
OVERLOADABLE uint convert_uint_sat_rte(uint x);
OVERLOADABLE uint convert_uint_sat_rtz(uint x);
OVERLOADABLE uint convert_uint_sat_rtp(uint x);
OVERLOADABLE uint convert_uint_sat_rtn(uint x);
OVERLOADABLE short convert_short_sat_rte(uint x);
OVERLOADABLE short convert_short_sat_rtz(uint x);
OVERLOADABLE short convert_short_sat_rtp(uint x);
OVERLOADABLE short convert_short_sat_rtn(uint x);
OVERLOADABLE ushort convert_ushort_sat_rte(uint x);
OVERLOADABLE ushort convert_ushort_sat_rtz(uint x);
OVERLOADABLE ushort convert_ushort_sat_rtp(uint x);
OVERLOADABLE ushort convert_ushort_sat_rtn(uint x);
OVERLOADABLE char convert_char_sat_rte(uint x);
OVERLOADABLE char convert_char_sat_rtz(uint x);
OVERLOADABLE char convert_char_sat_rtp(uint x);
OVERLOADABLE char convert_char_sat_rtn(uint x);
OVERLOADABLE uchar convert_uchar_sat_rte(uint x);
OVERLOADABLE uchar convert_uchar_sat_rtz(uint x);
OVERLOADABLE uchar convert_uchar_sat_rtp(uint x);
OVERLOADABLE uchar convert_uchar_sat_rtn(uint x);
OVERLOADABLE long convert_long_sat_rte(short x);
OVERLOADABLE long convert_long_sat_rtz(short x);
OVERLOADABLE long convert_long_sat_rtp(short x);
OVERLOADABLE long convert_long_sat_rtn(short x);
OVERLOADABLE ulong convert_ulong_sat_rte(short x);
OVERLOADABLE ulong convert_ulong_sat_rtz(short x);
OVERLOADABLE ulong convert_ulong_sat_rtp(short x);
OVERLOADABLE ulong convert_ulong_sat_rtn(short x);
OVERLOADABLE int convert_int_sat_rte(short x);
OVERLOADABLE int convert_int_sat_rtz(short x);
OVERLOADABLE int convert_int_sat_rtp(short x);
OVERLOADABLE int convert_int_sat_rtn(short x);
OVERLOADABLE uint convert_uint_sat_rte(short x);
OVERLOADABLE uint convert_uint_sat_rtz(short x);
OVERLOADABLE uint convert_uint_sat_rtp(short x);
OVERLOADABLE uint convert_uint_sat_rtn(short x);
OVERLOADABLE short convert_short_sat_rte(short x);
OVERLOADABLE short convert_short_sat_rtz(short x);
OVERLOADABLE short convert_short_sat_rtp(short x);
OVERLOADABLE short convert_short_sat_rtn(short x);
OVERLOADABLE ushort convert_ushort_sat_rte(short x);
OVERLOADABLE ushort convert_ushort_sat_rtz(short x);
OVERLOADABLE ushort convert_ushort_sat_rtp(short x);
OVERLOADABLE ushort convert_ushort_sat_rtn(short x);
OVERLOADABLE char convert_char_sat_rte(short x);
OVERLOADABLE char convert_char_sat_rtz(short x);
OVERLOADABLE char convert_char_sat_rtp(short x);
OVERLOADABLE char convert_char_sat_rtn(short x);
OVERLOADABLE uchar convert_uchar_sat_rte(short x);
OVERLOADABLE uchar convert_uchar_sat_rtz(short x);
OVERLOADABLE uchar convert_uchar_sat_rtp(short x);
OVERLOADABLE uchar convert_uchar_sat_rtn(short x);
OVERLOADABLE long convert_long_sat_rte(ushort x);
OVERLOADABLE long convert_long_sat_rtz(ushort x);
OVERLOADABLE long convert_long_sat_rtp(ushort x);
OVERLOADABLE long convert_long_sat_rtn(ushort x);
OVERLOADABLE ulong convert_ulong_sat_rte(ushort x);
OVERLOADABLE ulong convert_ulong_sat_rtz(ushort x);
OVERLOADABLE ulong convert_ulong_sat_rtp(ushort x);
OVERLOADABLE ulong convert_ulong_sat_rtn(ushort x);
OVERLOADABLE int convert_int_sat_rte(ushort x);
OVERLOADABLE int convert_int_sat_rtz(ushort x);
OVERLOADABLE int convert_int_sat_rtp(ushort x);
OVERLOADABLE int convert_int_sat_rtn(ushort x);
OVERLOADABLE uint convert_uint_sat_rte(ushort x);
OVERLOADABLE uint convert_uint_sat_rtz(ushort x);
OVERLOADABLE uint convert_uint_sat_rtp(ushort x);
OVERLOADABLE uint convert_uint_sat_rtn(ushort x);
OVERLOADABLE short convert_short_sat_rte(ushort x);
OVERLOADABLE short convert_short_sat_rtz(ushort x);
OVERLOADABLE short convert_short_sat_rtp(ushort x);
OVERLOADABLE short convert_short_sat_rtn(ushort x);
OVERLOADABLE ushort convert_ushort_sat_rte(ushort x);
OVERLOADABLE ushort convert_ushort_sat_rtz(ushort x);
OVERLOADABLE ushort convert_ushort_sat_rtp(ushort x);
OVERLOADABLE ushort convert_ushort_sat_rtn(ushort x);
OVERLOADABLE char convert_char_sat_rte(ushort x);
OVERLOADABLE char convert_char_sat_rtz(ushort x);
OVERLOADABLE char convert_char_sat_rtp(ushort x);
OVERLOADABLE char convert_char_sat_rtn(ushort x);
OVERLOADABLE uchar convert_uchar_sat_rte(ushort x);
OVERLOADABLE uchar convert_uchar_sat_rtz(ushort x);
OVERLOADABLE uchar convert_uchar_sat_rtp(ushort x);
OVERLOADABLE uchar convert_uchar_sat_rtn(ushort x);
OVERLOADABLE long convert_long_sat_rte(char x);
OVERLOADABLE long convert_long_sat_rtz(char x);
OVERLOADABLE long convert_long_sat_rtp(char x);
OVERLOADABLE long convert_long_sat_rtn(char x);
OVERLOADABLE ulong convert_ulong_sat_rte(char x);
OVERLOADABLE ulong convert_ulong_sat_rtz(char x);
OVERLOADABLE ulong convert_ulong_sat_rtp(char x);
OVERLOADABLE ulong convert_ulong_sat_rtn(char x);
OVERLOADABLE int convert_int_sat_rte(char x);
OVERLOADABLE int convert_int_sat_rtz(char x);
OVERLOADABLE int convert_int_sat_rtp(char x);
OVERLOADABLE int convert_int_sat_rtn(char x);
OVERLOADABLE uint convert_uint_sat_rte(char x);
OVERLOADABLE uint convert_uint_sat_rtz(char x);
OVERLOADABLE uint convert_uint_sat_rtp(char x);
OVERLOADABLE uint convert_uint_sat_rtn(char x);
OVERLOADABLE short convert_short_sat_rte(char x);
OVERLOADABLE short convert_short_sat_rtz(char x);
OVERLOADABLE short convert_short_sat_rtp(char x);
OVERLOADABLE short convert_short_sat_rtn(char x);
OVERLOADABLE ushort convert_ushort_sat_rte(char x);
OVERLOADABLE ushort convert_ushort_sat_rtz(char x);
OVERLOADABLE ushort convert_ushort_sat_rtp(char x);
OVERLOADABLE ushort convert_ushort_sat_rtn(char x);
OVERLOADABLE char convert_char_sat_rte(char x);
OVERLOADABLE char convert_char_sat_rtz(char x);
OVERLOADABLE char convert_char_sat_rtp(char x);
OVERLOADABLE char convert_char_sat_rtn(char x);
OVERLOADABLE uchar convert_uchar_sat_rte(char x);
OVERLOADABLE uchar convert_uchar_sat_rtz(char x);
OVERLOADABLE uchar convert_uchar_sat_rtp(char x);
OVERLOADABLE uchar convert_uchar_sat_rtn(char x);
OVERLOADABLE long convert_long_sat_rte(uchar x);
OVERLOADABLE long convert_long_sat_rtz(uchar x);
OVERLOADABLE long convert_long_sat_rtp(uchar x);
OVERLOADABLE long convert_long_sat_rtn(uchar x);
OVERLOADABLE ulong convert_ulong_sat_rte(uchar x);
OVERLOADABLE ulong convert_ulong_sat_rtz(uchar x);
OVERLOADABLE ulong convert_ulong_sat_rtp(uchar x);
OVERLOADABLE ulong convert_ulong_sat_rtn(uchar x);
OVERLOADABLE int convert_int_sat_rte(uchar x);
OVERLOADABLE int convert_int_sat_rtz(uchar x);
OVERLOADABLE int convert_int_sat_rtp(uchar x);
OVERLOADABLE int convert_int_sat_rtn(uchar x);
OVERLOADABLE uint convert_uint_sat_rte(uchar x);
OVERLOADABLE uint convert_uint_sat_rtz(uchar x);
OVERLOADABLE uint convert_uint_sat_rtp(uchar x);
OVERLOADABLE uint convert_uint_sat_rtn(uchar x);
OVERLOADABLE short convert_short_sat_rte(uchar x);
OVERLOADABLE short convert_short_sat_rtz(uchar x);
OVERLOADABLE short convert_short_sat_rtp(uchar x);
OVERLOADABLE short convert_short_sat_rtn(uchar x);
OVERLOADABLE ushort convert_ushort_sat_rte(uchar x);
OVERLOADABLE ushort convert_ushort_sat_rtz(uchar x);
OVERLOADABLE ushort convert_ushort_sat_rtp(uchar x);
OVERLOADABLE ushort convert_ushort_sat_rtn(uchar x);
OVERLOADABLE char convert_char_sat_rte(uchar x);
OVERLOADABLE char convert_char_sat_rtz(uchar x);
OVERLOADABLE char convert_char_sat_rtp(uchar x);
OVERLOADABLE char convert_char_sat_rtn(uchar x);
OVERLOADABLE uchar convert_uchar_sat_rte(uchar x);
OVERLOADABLE uchar convert_uchar_sat_rtz(uchar x);
OVERLOADABLE uchar convert_uchar_sat_rtp(uchar x);
OVERLOADABLE uchar convert_uchar_sat_rtn(uchar x);
OVERLOADABLE long convert_long_sat_rte(float x);
OVERLOADABLE long convert_long_sat_rtz(float x);
OVERLOADABLE long convert_long_sat_rtp(float x);
OVERLOADABLE long convert_long_sat_rtn(float x);
OVERLOADABLE ulong convert_ulong_sat_rte(float x);
OVERLOADABLE ulong convert_ulong_sat_rtz(float x);
OVERLOADABLE ulong convert_ulong_sat_rtp(float x);
OVERLOADABLE ulong convert_ulong_sat_rtn(float x);
OVERLOADABLE int convert_int_sat_rte(float x);
OVERLOADABLE int convert_int_sat_rtz(float x);
OVERLOADABLE int convert_int_sat_rtp(float x);
OVERLOADABLE int convert_int_sat_rtn(float x);
OVERLOADABLE uint convert_uint_sat_rte(float x);
OVERLOADABLE uint convert_uint_sat_rtz(float x);
OVERLOADABLE uint convert_uint_sat_rtp(float x);
OVERLOADABLE uint convert_uint_sat_rtn(float x);
OVERLOADABLE short convert_short_sat_rte(float x);
OVERLOADABLE short convert_short_sat_rtz(float x);
OVERLOADABLE short convert_short_sat_rtp(float x);
OVERLOADABLE short convert_short_sat_rtn(float x);
OVERLOADABLE ushort convert_ushort_sat_rte(float x);
OVERLOADABLE ushort convert_ushort_sat_rtz(float x);
OVERLOADABLE ushort convert_ushort_sat_rtp(float x);
OVERLOADABLE ushort convert_ushort_sat_rtn(float x);
OVERLOADABLE char convert_char_sat_rte(float x);
OVERLOADABLE char convert_char_sat_rtz(float x);
OVERLOADABLE char convert_char_sat_rtp(float x);
OVERLOADABLE char convert_char_sat_rtn(float x);
OVERLOADABLE uchar convert_uchar_sat_rte(float x);
OVERLOADABLE uchar convert_uchar_sat_rtz(float x);
OVERLOADABLE uchar convert_uchar_sat_rtp(float x);
OVERLOADABLE uchar convert_uchar_sat_rtn(float x);
OVERLOADABLE long convert_long_sat_rte(half x);
OVERLOADABLE long convert_long_sat_rtz(half x);
OVERLOADABLE long convert_long_sat_rtp(half x);
OVERLOADABLE long convert_long_sat_rtn(half x);
OVERLOADABLE ulong convert_ulong_sat_rte(half x);
OVERLOADABLE ulong convert_ulong_sat_rtz(half x);
OVERLOADABLE ulong convert_ulong_sat_rtp(half x);
OVERLOADABLE ulong convert_ulong_sat_rtn(half x);
OVERLOADABLE int convert_int_sat_rte(half x);
OVERLOADABLE int convert_int_sat_rtz(half x);
OVERLOADABLE int convert_int_sat_rtp(half x);
OVERLOADABLE int convert_int_sat_rtn(half x);
OVERLOADABLE uint convert_uint_sat_rte(half x);
OVERLOADABLE uint convert_uint_sat_rtz(half x);
OVERLOADABLE uint convert_uint_sat_rtp(half x);
OVERLOADABLE uint convert_uint_sat_rtn(half x);
OVERLOADABLE short convert_short_sat_rte(half x);
OVERLOADABLE short convert_short_sat_rtz(half x);
OVERLOADABLE short convert_short_sat_rtp(half x);
OVERLOADABLE short convert_short_sat_rtn(half x);
OVERLOADABLE ushort convert_ushort_sat_rte(half x);
OVERLOADABLE ushort convert_ushort_sat_rtz(half x);
OVERLOADABLE ushort convert_ushort_sat_rtp(half x);
OVERLOADABLE ushort convert_ushort_sat_rtn(half x);
OVERLOADABLE char convert_char_sat_rte(half x);
OVERLOADABLE char convert_char_sat_rtz(half x);
OVERLOADABLE char convert_char_sat_rtp(half x);
OVERLOADABLE char convert_char_sat_rtn(half x);
OVERLOADABLE uchar convert_uchar_sat_rte(half x);
OVERLOADABLE uchar convert_uchar_sat_rtz(half x);
OVERLOADABLE uchar convert_uchar_sat_rtp(half x);
OVERLOADABLE uchar convert_uchar_sat_rtn(half x);
OVERLOADABLE long2 convert_long2_sat_rte(long2 v);
OVERLOADABLE long2 convert_long2_sat_rtz(long2 v);
OVERLOADABLE long2 convert_long2_sat_rtp(long2 v);
OVERLOADABLE long2 convert_long2_sat_rtn(long2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rte(long2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtz(long2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtp(long2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtn(long2 v);
OVERLOADABLE int2 convert_int2_sat_rte(long2 v);
OVERLOADABLE int2 convert_int2_sat_rtz(long2 v);
OVERLOADABLE int2 convert_int2_sat_rtp(long2 v);
OVERLOADABLE int2 convert_int2_sat_rtn(long2 v);
OVERLOADABLE uint2 convert_uint2_sat_rte(long2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtz(long2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtp(long2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtn(long2 v);
OVERLOADABLE short2 convert_short2_sat_rte(long2 v);
OVERLOADABLE short2 convert_short2_sat_rtz(long2 v);
OVERLOADABLE short2 convert_short2_sat_rtp(long2 v);
OVERLOADABLE short2 convert_short2_sat_rtn(long2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rte(long2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtz(long2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtp(long2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtn(long2 v);
OVERLOADABLE char2 convert_char2_sat_rte(long2 v);
OVERLOADABLE char2 convert_char2_sat_rtz(long2 v);
OVERLOADABLE char2 convert_char2_sat_rtp(long2 v);
OVERLOADABLE char2 convert_char2_sat_rtn(long2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rte(long2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtz(long2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtp(long2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtn(long2 v);
OVERLOADABLE long2 convert_long2_sat_rte(ulong2 v);
OVERLOADABLE long2 convert_long2_sat_rtz(ulong2 v);
OVERLOADABLE long2 convert_long2_sat_rtp(ulong2 v);
OVERLOADABLE long2 convert_long2_sat_rtn(ulong2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rte(ulong2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtz(ulong2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtp(ulong2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtn(ulong2 v);
OVERLOADABLE int2 convert_int2_sat_rte(ulong2 v);
OVERLOADABLE int2 convert_int2_sat_rtz(ulong2 v);
OVERLOADABLE int2 convert_int2_sat_rtp(ulong2 v);
OVERLOADABLE int2 convert_int2_sat_rtn(ulong2 v);
OVERLOADABLE uint2 convert_uint2_sat_rte(ulong2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtz(ulong2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtp(ulong2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtn(ulong2 v);
OVERLOADABLE short2 convert_short2_sat_rte(ulong2 v);
OVERLOADABLE short2 convert_short2_sat_rtz(ulong2 v);
OVERLOADABLE short2 convert_short2_sat_rtp(ulong2 v);
OVERLOADABLE short2 convert_short2_sat_rtn(ulong2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rte(ulong2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtz(ulong2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtp(ulong2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtn(ulong2 v);
OVERLOADABLE char2 convert_char2_sat_rte(ulong2 v);
OVERLOADABLE char2 convert_char2_sat_rtz(ulong2 v);
OVERLOADABLE char2 convert_char2_sat_rtp(ulong2 v);
OVERLOADABLE char2 convert_char2_sat_rtn(ulong2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rte(ulong2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtz(ulong2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtp(ulong2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtn(ulong2 v);
OVERLOADABLE long2 convert_long2_sat_rte(int2 v);
OVERLOADABLE long2 convert_long2_sat_rtz(int2 v);
OVERLOADABLE long2 convert_long2_sat_rtp(int2 v);
OVERLOADABLE long2 convert_long2_sat_rtn(int2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rte(int2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtz(int2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtp(int2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtn(int2 v);
OVERLOADABLE int2 convert_int2_sat_rte(int2 v);
OVERLOADABLE int2 convert_int2_sat_rtz(int2 v);
OVERLOADABLE int2 convert_int2_sat_rtp(int2 v);
OVERLOADABLE int2 convert_int2_sat_rtn(int2 v);
OVERLOADABLE uint2 convert_uint2_sat_rte(int2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtz(int2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtp(int2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtn(int2 v);
OVERLOADABLE short2 convert_short2_sat_rte(int2 v);
OVERLOADABLE short2 convert_short2_sat_rtz(int2 v);
OVERLOADABLE short2 convert_short2_sat_rtp(int2 v);
OVERLOADABLE short2 convert_short2_sat_rtn(int2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rte(int2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtz(int2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtp(int2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtn(int2 v);
OVERLOADABLE char2 convert_char2_sat_rte(int2 v);
OVERLOADABLE char2 convert_char2_sat_rtz(int2 v);
OVERLOADABLE char2 convert_char2_sat_rtp(int2 v);
OVERLOADABLE char2 convert_char2_sat_rtn(int2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rte(int2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtz(int2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtp(int2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtn(int2 v);
OVERLOADABLE long2 convert_long2_sat_rte(uint2 v);
OVERLOADABLE long2 convert_long2_sat_rtz(uint2 v);
OVERLOADABLE long2 convert_long2_sat_rtp(uint2 v);
OVERLOADABLE long2 convert_long2_sat_rtn(uint2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rte(uint2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtz(uint2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtp(uint2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtn(uint2 v);
OVERLOADABLE int2 convert_int2_sat_rte(uint2 v);
OVERLOADABLE int2 convert_int2_sat_rtz(uint2 v);
OVERLOADABLE int2 convert_int2_sat_rtp(uint2 v);
OVERLOADABLE int2 convert_int2_sat_rtn(uint2 v);
OVERLOADABLE uint2 convert_uint2_sat_rte(uint2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtz(uint2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtp(uint2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtn(uint2 v);
OVERLOADABLE short2 convert_short2_sat_rte(uint2 v);
OVERLOADABLE short2 convert_short2_sat_rtz(uint2 v);
OVERLOADABLE short2 convert_short2_sat_rtp(uint2 v);
OVERLOADABLE short2 convert_short2_sat_rtn(uint2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rte(uint2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtz(uint2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtp(uint2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtn(uint2 v);
OVERLOADABLE char2 convert_char2_sat_rte(uint2 v);
OVERLOADABLE char2 convert_char2_sat_rtz(uint2 v);
OVERLOADABLE char2 convert_char2_sat_rtp(uint2 v);
OVERLOADABLE char2 convert_char2_sat_rtn(uint2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rte(uint2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtz(uint2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtp(uint2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtn(uint2 v);
OVERLOADABLE long2 convert_long2_sat_rte(short2 v);
OVERLOADABLE long2 convert_long2_sat_rtz(short2 v);
OVERLOADABLE long2 convert_long2_sat_rtp(short2 v);
OVERLOADABLE long2 convert_long2_sat_rtn(short2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rte(short2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtz(short2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtp(short2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtn(short2 v);
OVERLOADABLE int2 convert_int2_sat_rte(short2 v);
OVERLOADABLE int2 convert_int2_sat_rtz(short2 v);
OVERLOADABLE int2 convert_int2_sat_rtp(short2 v);
OVERLOADABLE int2 convert_int2_sat_rtn(short2 v);
OVERLOADABLE uint2 convert_uint2_sat_rte(short2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtz(short2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtp(short2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtn(short2 v);
OVERLOADABLE short2 convert_short2_sat_rte(short2 v);
OVERLOADABLE short2 convert_short2_sat_rtz(short2 v);
OVERLOADABLE short2 convert_short2_sat_rtp(short2 v);
OVERLOADABLE short2 convert_short2_sat_rtn(short2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rte(short2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtz(short2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtp(short2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtn(short2 v);
OVERLOADABLE char2 convert_char2_sat_rte(short2 v);
OVERLOADABLE char2 convert_char2_sat_rtz(short2 v);
OVERLOADABLE char2 convert_char2_sat_rtp(short2 v);
OVERLOADABLE char2 convert_char2_sat_rtn(short2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rte(short2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtz(short2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtp(short2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtn(short2 v);
OVERLOADABLE long2 convert_long2_sat_rte(ushort2 v);
OVERLOADABLE long2 convert_long2_sat_rtz(ushort2 v);
OVERLOADABLE long2 convert_long2_sat_rtp(ushort2 v);
OVERLOADABLE long2 convert_long2_sat_rtn(ushort2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rte(ushort2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtz(ushort2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtp(ushort2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtn(ushort2 v);
OVERLOADABLE int2 convert_int2_sat_rte(ushort2 v);
OVERLOADABLE int2 convert_int2_sat_rtz(ushort2 v);
OVERLOADABLE int2 convert_int2_sat_rtp(ushort2 v);
OVERLOADABLE int2 convert_int2_sat_rtn(ushort2 v);
OVERLOADABLE uint2 convert_uint2_sat_rte(ushort2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtz(ushort2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtp(ushort2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtn(ushort2 v);
OVERLOADABLE short2 convert_short2_sat_rte(ushort2 v);
OVERLOADABLE short2 convert_short2_sat_rtz(ushort2 v);
OVERLOADABLE short2 convert_short2_sat_rtp(ushort2 v);
OVERLOADABLE short2 convert_short2_sat_rtn(ushort2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rte(ushort2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtz(ushort2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtp(ushort2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtn(ushort2 v);
OVERLOADABLE char2 convert_char2_sat_rte(ushort2 v);
OVERLOADABLE char2 convert_char2_sat_rtz(ushort2 v);
OVERLOADABLE char2 convert_char2_sat_rtp(ushort2 v);
OVERLOADABLE char2 convert_char2_sat_rtn(ushort2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rte(ushort2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtz(ushort2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtp(ushort2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtn(ushort2 v);
OVERLOADABLE long2 convert_long2_sat_rte(char2 v);
OVERLOADABLE long2 convert_long2_sat_rtz(char2 v);
OVERLOADABLE long2 convert_long2_sat_rtp(char2 v);
OVERLOADABLE long2 convert_long2_sat_rtn(char2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rte(char2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtz(char2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtp(char2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtn(char2 v);
OVERLOADABLE int2 convert_int2_sat_rte(char2 v);
OVERLOADABLE int2 convert_int2_sat_rtz(char2 v);
OVERLOADABLE int2 convert_int2_sat_rtp(char2 v);
OVERLOADABLE int2 convert_int2_sat_rtn(char2 v);
OVERLOADABLE uint2 convert_uint2_sat_rte(char2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtz(char2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtp(char2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtn(char2 v);
OVERLOADABLE short2 convert_short2_sat_rte(char2 v);
OVERLOADABLE short2 convert_short2_sat_rtz(char2 v);
OVERLOADABLE short2 convert_short2_sat_rtp(char2 v);
OVERLOADABLE short2 convert_short2_sat_rtn(char2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rte(char2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtz(char2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtp(char2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtn(char2 v);
OVERLOADABLE char2 convert_char2_sat_rte(char2 v);
OVERLOADABLE char2 convert_char2_sat_rtz(char2 v);
OVERLOADABLE char2 convert_char2_sat_rtp(char2 v);
OVERLOADABLE char2 convert_char2_sat_rtn(char2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rte(char2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtz(char2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtp(char2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtn(char2 v);
OVERLOADABLE long2 convert_long2_sat_rte(uchar2 v);
OVERLOADABLE long2 convert_long2_sat_rtz(uchar2 v);
OVERLOADABLE long2 convert_long2_sat_rtp(uchar2 v);
OVERLOADABLE long2 convert_long2_sat_rtn(uchar2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rte(uchar2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtz(uchar2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtp(uchar2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtn(uchar2 v);
OVERLOADABLE int2 convert_int2_sat_rte(uchar2 v);
OVERLOADABLE int2 convert_int2_sat_rtz(uchar2 v);
OVERLOADABLE int2 convert_int2_sat_rtp(uchar2 v);
OVERLOADABLE int2 convert_int2_sat_rtn(uchar2 v);
OVERLOADABLE uint2 convert_uint2_sat_rte(uchar2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtz(uchar2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtp(uchar2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtn(uchar2 v);
OVERLOADABLE short2 convert_short2_sat_rte(uchar2 v);
OVERLOADABLE short2 convert_short2_sat_rtz(uchar2 v);
OVERLOADABLE short2 convert_short2_sat_rtp(uchar2 v);
OVERLOADABLE short2 convert_short2_sat_rtn(uchar2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rte(uchar2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtz(uchar2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtp(uchar2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtn(uchar2 v);
OVERLOADABLE char2 convert_char2_sat_rte(uchar2 v);
OVERLOADABLE char2 convert_char2_sat_rtz(uchar2 v);
OVERLOADABLE char2 convert_char2_sat_rtp(uchar2 v);
OVERLOADABLE char2 convert_char2_sat_rtn(uchar2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rte(uchar2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtz(uchar2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtp(uchar2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtn(uchar2 v);
OVERLOADABLE long2 convert_long2_sat_rte(double2 v);
OVERLOADABLE long2 convert_long2_sat_rtz(double2 v);
OVERLOADABLE long2 convert_long2_sat_rtp(double2 v);
OVERLOADABLE long2 convert_long2_sat_rtn(double2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rte(double2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtz(double2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtp(double2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtn(double2 v);
OVERLOADABLE int2 convert_int2_sat_rte(double2 v);
OVERLOADABLE int2 convert_int2_sat_rtz(double2 v);
OVERLOADABLE int2 convert_int2_sat_rtp(double2 v);
OVERLOADABLE int2 convert_int2_sat_rtn(double2 v);
OVERLOADABLE uint2 convert_uint2_sat_rte(double2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtz(double2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtp(double2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtn(double2 v);
OVERLOADABLE short2 convert_short2_sat_rte(double2 v);
OVERLOADABLE short2 convert_short2_sat_rtz(double2 v);
OVERLOADABLE short2 convert_short2_sat_rtp(double2 v);
OVERLOADABLE short2 convert_short2_sat_rtn(double2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rte(double2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtz(double2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtp(double2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtn(double2 v);
OVERLOADABLE char2 convert_char2_sat_rte(double2 v);
OVERLOADABLE char2 convert_char2_sat_rtz(double2 v);
OVERLOADABLE char2 convert_char2_sat_rtp(double2 v);
OVERLOADABLE char2 convert_char2_sat_rtn(double2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rte(double2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtz(double2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtp(double2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtn(double2 v);
OVERLOADABLE long2 convert_long2_sat_rte(float2 v);
OVERLOADABLE long2 convert_long2_sat_rtz(float2 v);
OVERLOADABLE long2 convert_long2_sat_rtp(float2 v);
OVERLOADABLE long2 convert_long2_sat_rtn(float2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rte(float2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtz(float2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtp(float2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtn(float2 v);
OVERLOADABLE int2 convert_int2_sat_rte(float2 v);
OVERLOADABLE int2 convert_int2_sat_rtz(float2 v);
OVERLOADABLE int2 convert_int2_sat_rtp(float2 v);
OVERLOADABLE int2 convert_int2_sat_rtn(float2 v);
OVERLOADABLE uint2 convert_uint2_sat_rte(float2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtz(float2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtp(float2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtn(float2 v);
OVERLOADABLE short2 convert_short2_sat_rte(float2 v);
OVERLOADABLE short2 convert_short2_sat_rtz(float2 v);
OVERLOADABLE short2 convert_short2_sat_rtp(float2 v);
OVERLOADABLE short2 convert_short2_sat_rtn(float2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rte(float2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtz(float2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtp(float2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtn(float2 v);
OVERLOADABLE char2 convert_char2_sat_rte(float2 v);
OVERLOADABLE char2 convert_char2_sat_rtz(float2 v);
OVERLOADABLE char2 convert_char2_sat_rtp(float2 v);
OVERLOADABLE char2 convert_char2_sat_rtn(float2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rte(float2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtz(float2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtp(float2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtn(float2 v);
OVERLOADABLE long2 convert_long2_sat_rte(half2 v);
OVERLOADABLE long2 convert_long2_sat_rtz(half2 v);
OVERLOADABLE long2 convert_long2_sat_rtp(half2 v);
OVERLOADABLE long2 convert_long2_sat_rtn(half2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rte(half2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtz(half2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtp(half2 v);
OVERLOADABLE ulong2 convert_ulong2_sat_rtn(half2 v);
OVERLOADABLE int2 convert_int2_sat_rte(half2 v);
OVERLOADABLE int2 convert_int2_sat_rtz(half2 v);
OVERLOADABLE int2 convert_int2_sat_rtp(half2 v);
OVERLOADABLE int2 convert_int2_sat_rtn(half2 v);
OVERLOADABLE uint2 convert_uint2_sat_rte(half2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtz(half2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtp(half2 v);
OVERLOADABLE uint2 convert_uint2_sat_rtn(half2 v);
OVERLOADABLE short2 convert_short2_sat_rte(half2 v);
OVERLOADABLE short2 convert_short2_sat_rtz(half2 v);
OVERLOADABLE short2 convert_short2_sat_rtp(half2 v);
OVERLOADABLE short2 convert_short2_sat_rtn(half2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rte(half2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtz(half2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtp(half2 v);
OVERLOADABLE ushort2 convert_ushort2_sat_rtn(half2 v);
OVERLOADABLE char2 convert_char2_sat_rte(half2 v);
OVERLOADABLE char2 convert_char2_sat_rtz(half2 v);
OVERLOADABLE char2 convert_char2_sat_rtp(half2 v);
OVERLOADABLE char2 convert_char2_sat_rtn(half2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rte(half2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtz(half2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtp(half2 v);
OVERLOADABLE uchar2 convert_uchar2_sat_rtn(half2 v);
OVERLOADABLE long3 convert_long3_sat_rte(long3 v);
OVERLOADABLE long3 convert_long3_sat_rtz(long3 v);
OVERLOADABLE long3 convert_long3_sat_rtp(long3 v);
OVERLOADABLE long3 convert_long3_sat_rtn(long3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rte(long3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtz(long3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtp(long3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtn(long3 v);
OVERLOADABLE int3 convert_int3_sat_rte(long3 v);
OVERLOADABLE int3 convert_int3_sat_rtz(long3 v);
OVERLOADABLE int3 convert_int3_sat_rtp(long3 v);
OVERLOADABLE int3 convert_int3_sat_rtn(long3 v);
OVERLOADABLE uint3 convert_uint3_sat_rte(long3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtz(long3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtp(long3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtn(long3 v);
OVERLOADABLE short3 convert_short3_sat_rte(long3 v);
OVERLOADABLE short3 convert_short3_sat_rtz(long3 v);
OVERLOADABLE short3 convert_short3_sat_rtp(long3 v);
OVERLOADABLE short3 convert_short3_sat_rtn(long3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rte(long3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtz(long3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtp(long3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtn(long3 v);
OVERLOADABLE char3 convert_char3_sat_rte(long3 v);
OVERLOADABLE char3 convert_char3_sat_rtz(long3 v);
OVERLOADABLE char3 convert_char3_sat_rtp(long3 v);
OVERLOADABLE char3 convert_char3_sat_rtn(long3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rte(long3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtz(long3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtp(long3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtn(long3 v);
OVERLOADABLE long3 convert_long3_sat_rte(ulong3 v);
OVERLOADABLE long3 convert_long3_sat_rtz(ulong3 v);
OVERLOADABLE long3 convert_long3_sat_rtp(ulong3 v);
OVERLOADABLE long3 convert_long3_sat_rtn(ulong3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rte(ulong3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtz(ulong3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtp(ulong3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtn(ulong3 v);
OVERLOADABLE int3 convert_int3_sat_rte(ulong3 v);
OVERLOADABLE int3 convert_int3_sat_rtz(ulong3 v);
OVERLOADABLE int3 convert_int3_sat_rtp(ulong3 v);
OVERLOADABLE int3 convert_int3_sat_rtn(ulong3 v);
OVERLOADABLE uint3 convert_uint3_sat_rte(ulong3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtz(ulong3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtp(ulong3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtn(ulong3 v);
OVERLOADABLE short3 convert_short3_sat_rte(ulong3 v);
OVERLOADABLE short3 convert_short3_sat_rtz(ulong3 v);
OVERLOADABLE short3 convert_short3_sat_rtp(ulong3 v);
OVERLOADABLE short3 convert_short3_sat_rtn(ulong3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rte(ulong3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtz(ulong3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtp(ulong3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtn(ulong3 v);
OVERLOADABLE char3 convert_char3_sat_rte(ulong3 v);
OVERLOADABLE char3 convert_char3_sat_rtz(ulong3 v);
OVERLOADABLE char3 convert_char3_sat_rtp(ulong3 v);
OVERLOADABLE char3 convert_char3_sat_rtn(ulong3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rte(ulong3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtz(ulong3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtp(ulong3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtn(ulong3 v);
OVERLOADABLE long3 convert_long3_sat_rte(int3 v);
OVERLOADABLE long3 convert_long3_sat_rtz(int3 v);
OVERLOADABLE long3 convert_long3_sat_rtp(int3 v);
OVERLOADABLE long3 convert_long3_sat_rtn(int3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rte(int3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtz(int3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtp(int3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtn(int3 v);
OVERLOADABLE int3 convert_int3_sat_rte(int3 v);
OVERLOADABLE int3 convert_int3_sat_rtz(int3 v);
OVERLOADABLE int3 convert_int3_sat_rtp(int3 v);
OVERLOADABLE int3 convert_int3_sat_rtn(int3 v);
OVERLOADABLE uint3 convert_uint3_sat_rte(int3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtz(int3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtp(int3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtn(int3 v);
OVERLOADABLE short3 convert_short3_sat_rte(int3 v);
OVERLOADABLE short3 convert_short3_sat_rtz(int3 v);
OVERLOADABLE short3 convert_short3_sat_rtp(int3 v);
OVERLOADABLE short3 convert_short3_sat_rtn(int3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rte(int3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtz(int3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtp(int3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtn(int3 v);
OVERLOADABLE char3 convert_char3_sat_rte(int3 v);
OVERLOADABLE char3 convert_char3_sat_rtz(int3 v);
OVERLOADABLE char3 convert_char3_sat_rtp(int3 v);
OVERLOADABLE char3 convert_char3_sat_rtn(int3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rte(int3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtz(int3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtp(int3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtn(int3 v);
OVERLOADABLE long3 convert_long3_sat_rte(uint3 v);
OVERLOADABLE long3 convert_long3_sat_rtz(uint3 v);
OVERLOADABLE long3 convert_long3_sat_rtp(uint3 v);
OVERLOADABLE long3 convert_long3_sat_rtn(uint3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rte(uint3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtz(uint3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtp(uint3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtn(uint3 v);
OVERLOADABLE int3 convert_int3_sat_rte(uint3 v);
OVERLOADABLE int3 convert_int3_sat_rtz(uint3 v);
OVERLOADABLE int3 convert_int3_sat_rtp(uint3 v);
OVERLOADABLE int3 convert_int3_sat_rtn(uint3 v);
OVERLOADABLE uint3 convert_uint3_sat_rte(uint3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtz(uint3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtp(uint3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtn(uint3 v);
OVERLOADABLE short3 convert_short3_sat_rte(uint3 v);
OVERLOADABLE short3 convert_short3_sat_rtz(uint3 v);
OVERLOADABLE short3 convert_short3_sat_rtp(uint3 v);
OVERLOADABLE short3 convert_short3_sat_rtn(uint3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rte(uint3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtz(uint3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtp(uint3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtn(uint3 v);
OVERLOADABLE char3 convert_char3_sat_rte(uint3 v);
OVERLOADABLE char3 convert_char3_sat_rtz(uint3 v);
OVERLOADABLE char3 convert_char3_sat_rtp(uint3 v);
OVERLOADABLE char3 convert_char3_sat_rtn(uint3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rte(uint3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtz(uint3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtp(uint3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtn(uint3 v);
OVERLOADABLE long3 convert_long3_sat_rte(short3 v);
OVERLOADABLE long3 convert_long3_sat_rtz(short3 v);
OVERLOADABLE long3 convert_long3_sat_rtp(short3 v);
OVERLOADABLE long3 convert_long3_sat_rtn(short3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rte(short3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtz(short3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtp(short3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtn(short3 v);
OVERLOADABLE int3 convert_int3_sat_rte(short3 v);
OVERLOADABLE int3 convert_int3_sat_rtz(short3 v);
OVERLOADABLE int3 convert_int3_sat_rtp(short3 v);
OVERLOADABLE int3 convert_int3_sat_rtn(short3 v);
OVERLOADABLE uint3 convert_uint3_sat_rte(short3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtz(short3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtp(short3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtn(short3 v);
OVERLOADABLE short3 convert_short3_sat_rte(short3 v);
OVERLOADABLE short3 convert_short3_sat_rtz(short3 v);
OVERLOADABLE short3 convert_short3_sat_rtp(short3 v);
OVERLOADABLE short3 convert_short3_sat_rtn(short3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rte(short3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtz(short3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtp(short3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtn(short3 v);
OVERLOADABLE char3 convert_char3_sat_rte(short3 v);
OVERLOADABLE char3 convert_char3_sat_rtz(short3 v);
OVERLOADABLE char3 convert_char3_sat_rtp(short3 v);
OVERLOADABLE char3 convert_char3_sat_rtn(short3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rte(short3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtz(short3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtp(short3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtn(short3 v);
OVERLOADABLE long3 convert_long3_sat_rte(ushort3 v);
OVERLOADABLE long3 convert_long3_sat_rtz(ushort3 v);
OVERLOADABLE long3 convert_long3_sat_rtp(ushort3 v);
OVERLOADABLE long3 convert_long3_sat_rtn(ushort3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rte(ushort3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtz(ushort3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtp(ushort3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtn(ushort3 v);
OVERLOADABLE int3 convert_int3_sat_rte(ushort3 v);
OVERLOADABLE int3 convert_int3_sat_rtz(ushort3 v);
OVERLOADABLE int3 convert_int3_sat_rtp(ushort3 v);
OVERLOADABLE int3 convert_int3_sat_rtn(ushort3 v);
OVERLOADABLE uint3 convert_uint3_sat_rte(ushort3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtz(ushort3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtp(ushort3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtn(ushort3 v);
OVERLOADABLE short3 convert_short3_sat_rte(ushort3 v);
OVERLOADABLE short3 convert_short3_sat_rtz(ushort3 v);
OVERLOADABLE short3 convert_short3_sat_rtp(ushort3 v);
OVERLOADABLE short3 convert_short3_sat_rtn(ushort3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rte(ushort3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtz(ushort3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtp(ushort3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtn(ushort3 v);
OVERLOADABLE char3 convert_char3_sat_rte(ushort3 v);
OVERLOADABLE char3 convert_char3_sat_rtz(ushort3 v);
OVERLOADABLE char3 convert_char3_sat_rtp(ushort3 v);
OVERLOADABLE char3 convert_char3_sat_rtn(ushort3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rte(ushort3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtz(ushort3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtp(ushort3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtn(ushort3 v);
OVERLOADABLE long3 convert_long3_sat_rte(char3 v);
OVERLOADABLE long3 convert_long3_sat_rtz(char3 v);
OVERLOADABLE long3 convert_long3_sat_rtp(char3 v);
OVERLOADABLE long3 convert_long3_sat_rtn(char3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rte(char3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtz(char3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtp(char3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtn(char3 v);
OVERLOADABLE int3 convert_int3_sat_rte(char3 v);
OVERLOADABLE int3 convert_int3_sat_rtz(char3 v);
OVERLOADABLE int3 convert_int3_sat_rtp(char3 v);
OVERLOADABLE int3 convert_int3_sat_rtn(char3 v);
OVERLOADABLE uint3 convert_uint3_sat_rte(char3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtz(char3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtp(char3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtn(char3 v);
OVERLOADABLE short3 convert_short3_sat_rte(char3 v);
OVERLOADABLE short3 convert_short3_sat_rtz(char3 v);
OVERLOADABLE short3 convert_short3_sat_rtp(char3 v);
OVERLOADABLE short3 convert_short3_sat_rtn(char3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rte(char3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtz(char3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtp(char3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtn(char3 v);
OVERLOADABLE char3 convert_char3_sat_rte(char3 v);
OVERLOADABLE char3 convert_char3_sat_rtz(char3 v);
OVERLOADABLE char3 convert_char3_sat_rtp(char3 v);
OVERLOADABLE char3 convert_char3_sat_rtn(char3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rte(char3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtz(char3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtp(char3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtn(char3 v);
OVERLOADABLE long3 convert_long3_sat_rte(uchar3 v);
OVERLOADABLE long3 convert_long3_sat_rtz(uchar3 v);
OVERLOADABLE long3 convert_long3_sat_rtp(uchar3 v);
OVERLOADABLE long3 convert_long3_sat_rtn(uchar3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rte(uchar3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtz(uchar3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtp(uchar3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtn(uchar3 v);
OVERLOADABLE int3 convert_int3_sat_rte(uchar3 v);
OVERLOADABLE int3 convert_int3_sat_rtz(uchar3 v);
OVERLOADABLE int3 convert_int3_sat_rtp(uchar3 v);
OVERLOADABLE int3 convert_int3_sat_rtn(uchar3 v);
OVERLOADABLE uint3 convert_uint3_sat_rte(uchar3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtz(uchar3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtp(uchar3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtn(uchar3 v);
OVERLOADABLE short3 convert_short3_sat_rte(uchar3 v);
OVERLOADABLE short3 convert_short3_sat_rtz(uchar3 v);
OVERLOADABLE short3 convert_short3_sat_rtp(uchar3 v);
OVERLOADABLE short3 convert_short3_sat_rtn(uchar3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rte(uchar3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtz(uchar3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtp(uchar3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtn(uchar3 v);
OVERLOADABLE char3 convert_char3_sat_rte(uchar3 v);
OVERLOADABLE char3 convert_char3_sat_rtz(uchar3 v);
OVERLOADABLE char3 convert_char3_sat_rtp(uchar3 v);
OVERLOADABLE char3 convert_char3_sat_rtn(uchar3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rte(uchar3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtz(uchar3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtp(uchar3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtn(uchar3 v);
OVERLOADABLE long3 convert_long3_sat_rte(double3 v);
OVERLOADABLE long3 convert_long3_sat_rtz(double3 v);
OVERLOADABLE long3 convert_long3_sat_rtp(double3 v);
OVERLOADABLE long3 convert_long3_sat_rtn(double3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rte(double3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtz(double3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtp(double3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtn(double3 v);
OVERLOADABLE int3 convert_int3_sat_rte(double3 v);
OVERLOADABLE int3 convert_int3_sat_rtz(double3 v);
OVERLOADABLE int3 convert_int3_sat_rtp(double3 v);
OVERLOADABLE int3 convert_int3_sat_rtn(double3 v);
OVERLOADABLE uint3 convert_uint3_sat_rte(double3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtz(double3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtp(double3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtn(double3 v);
OVERLOADABLE short3 convert_short3_sat_rte(double3 v);
OVERLOADABLE short3 convert_short3_sat_rtz(double3 v);
OVERLOADABLE short3 convert_short3_sat_rtp(double3 v);
OVERLOADABLE short3 convert_short3_sat_rtn(double3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rte(double3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtz(double3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtp(double3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtn(double3 v);
OVERLOADABLE char3 convert_char3_sat_rte(double3 v);
OVERLOADABLE char3 convert_char3_sat_rtz(double3 v);
OVERLOADABLE char3 convert_char3_sat_rtp(double3 v);
OVERLOADABLE char3 convert_char3_sat_rtn(double3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rte(double3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtz(double3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtp(double3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtn(double3 v);
OVERLOADABLE long3 convert_long3_sat_rte(float3 v);
OVERLOADABLE long3 convert_long3_sat_rtz(float3 v);
OVERLOADABLE long3 convert_long3_sat_rtp(float3 v);
OVERLOADABLE long3 convert_long3_sat_rtn(float3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rte(float3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtz(float3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtp(float3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtn(float3 v);
OVERLOADABLE int3 convert_int3_sat_rte(float3 v);
OVERLOADABLE int3 convert_int3_sat_rtz(float3 v);
OVERLOADABLE int3 convert_int3_sat_rtp(float3 v);
OVERLOADABLE int3 convert_int3_sat_rtn(float3 v);
OVERLOADABLE uint3 convert_uint3_sat_rte(float3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtz(float3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtp(float3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtn(float3 v);
OVERLOADABLE short3 convert_short3_sat_rte(float3 v);
OVERLOADABLE short3 convert_short3_sat_rtz(float3 v);
OVERLOADABLE short3 convert_short3_sat_rtp(float3 v);
OVERLOADABLE short3 convert_short3_sat_rtn(float3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rte(float3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtz(float3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtp(float3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtn(float3 v);
OVERLOADABLE char3 convert_char3_sat_rte(float3 v);
OVERLOADABLE char3 convert_char3_sat_rtz(float3 v);
OVERLOADABLE char3 convert_char3_sat_rtp(float3 v);
OVERLOADABLE char3 convert_char3_sat_rtn(float3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rte(float3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtz(float3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtp(float3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtn(float3 v);
OVERLOADABLE long3 convert_long3_sat_rte(half3 v);
OVERLOADABLE long3 convert_long3_sat_rtz(half3 v);
OVERLOADABLE long3 convert_long3_sat_rtp(half3 v);
OVERLOADABLE long3 convert_long3_sat_rtn(half3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rte(half3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtz(half3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtp(half3 v);
OVERLOADABLE ulong3 convert_ulong3_sat_rtn(half3 v);
OVERLOADABLE int3 convert_int3_sat_rte(half3 v);
OVERLOADABLE int3 convert_int3_sat_rtz(half3 v);
OVERLOADABLE int3 convert_int3_sat_rtp(half3 v);
OVERLOADABLE int3 convert_int3_sat_rtn(half3 v);
OVERLOADABLE uint3 convert_uint3_sat_rte(half3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtz(half3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtp(half3 v);
OVERLOADABLE uint3 convert_uint3_sat_rtn(half3 v);
OVERLOADABLE short3 convert_short3_sat_rte(half3 v);
OVERLOADABLE short3 convert_short3_sat_rtz(half3 v);
OVERLOADABLE short3 convert_short3_sat_rtp(half3 v);
OVERLOADABLE short3 convert_short3_sat_rtn(half3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rte(half3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtz(half3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtp(half3 v);
OVERLOADABLE ushort3 convert_ushort3_sat_rtn(half3 v);
OVERLOADABLE char3 convert_char3_sat_rte(half3 v);
OVERLOADABLE char3 convert_char3_sat_rtz(half3 v);
OVERLOADABLE char3 convert_char3_sat_rtp(half3 v);
OVERLOADABLE char3 convert_char3_sat_rtn(half3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rte(half3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtz(half3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtp(half3 v);
OVERLOADABLE uchar3 convert_uchar3_sat_rtn(half3 v);
OVERLOADABLE long4 convert_long4_sat_rte(long4 v);
OVERLOADABLE long4 convert_long4_sat_rtz(long4 v);
OVERLOADABLE long4 convert_long4_sat_rtp(long4 v);
OVERLOADABLE long4 convert_long4_sat_rtn(long4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rte(long4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtz(long4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtp(long4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtn(long4 v);
OVERLOADABLE int4 convert_int4_sat_rte(long4 v);
OVERLOADABLE int4 convert_int4_sat_rtz(long4 v);
OVERLOADABLE int4 convert_int4_sat_rtp(long4 v);
OVERLOADABLE int4 convert_int4_sat_rtn(long4 v);
OVERLOADABLE uint4 convert_uint4_sat_rte(long4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtz(long4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtp(long4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtn(long4 v);
OVERLOADABLE short4 convert_short4_sat_rte(long4 v);
OVERLOADABLE short4 convert_short4_sat_rtz(long4 v);
OVERLOADABLE short4 convert_short4_sat_rtp(long4 v);
OVERLOADABLE short4 convert_short4_sat_rtn(long4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rte(long4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtz(long4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtp(long4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtn(long4 v);
OVERLOADABLE char4 convert_char4_sat_rte(long4 v);
OVERLOADABLE char4 convert_char4_sat_rtz(long4 v);
OVERLOADABLE char4 convert_char4_sat_rtp(long4 v);
OVERLOADABLE char4 convert_char4_sat_rtn(long4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rte(long4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtz(long4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtp(long4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtn(long4 v);
OVERLOADABLE long4 convert_long4_sat_rte(ulong4 v);
OVERLOADABLE long4 convert_long4_sat_rtz(ulong4 v);
OVERLOADABLE long4 convert_long4_sat_rtp(ulong4 v);
OVERLOADABLE long4 convert_long4_sat_rtn(ulong4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rte(ulong4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtz(ulong4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtp(ulong4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtn(ulong4 v);
OVERLOADABLE int4 convert_int4_sat_rte(ulong4 v);
OVERLOADABLE int4 convert_int4_sat_rtz(ulong4 v);
OVERLOADABLE int4 convert_int4_sat_rtp(ulong4 v);
OVERLOADABLE int4 convert_int4_sat_rtn(ulong4 v);
OVERLOADABLE uint4 convert_uint4_sat_rte(ulong4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtz(ulong4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtp(ulong4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtn(ulong4 v);
OVERLOADABLE short4 convert_short4_sat_rte(ulong4 v);
OVERLOADABLE short4 convert_short4_sat_rtz(ulong4 v);
OVERLOADABLE short4 convert_short4_sat_rtp(ulong4 v);
OVERLOADABLE short4 convert_short4_sat_rtn(ulong4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rte(ulong4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtz(ulong4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtp(ulong4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtn(ulong4 v);
OVERLOADABLE char4 convert_char4_sat_rte(ulong4 v);
OVERLOADABLE char4 convert_char4_sat_rtz(ulong4 v);
OVERLOADABLE char4 convert_char4_sat_rtp(ulong4 v);
OVERLOADABLE char4 convert_char4_sat_rtn(ulong4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rte(ulong4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtz(ulong4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtp(ulong4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtn(ulong4 v);
OVERLOADABLE long4 convert_long4_sat_rte(int4 v);
OVERLOADABLE long4 convert_long4_sat_rtz(int4 v);
OVERLOADABLE long4 convert_long4_sat_rtp(int4 v);
OVERLOADABLE long4 convert_long4_sat_rtn(int4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rte(int4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtz(int4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtp(int4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtn(int4 v);
OVERLOADABLE int4 convert_int4_sat_rte(int4 v);
OVERLOADABLE int4 convert_int4_sat_rtz(int4 v);
OVERLOADABLE int4 convert_int4_sat_rtp(int4 v);
OVERLOADABLE int4 convert_int4_sat_rtn(int4 v);
OVERLOADABLE uint4 convert_uint4_sat_rte(int4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtz(int4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtp(int4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtn(int4 v);
OVERLOADABLE short4 convert_short4_sat_rte(int4 v);
OVERLOADABLE short4 convert_short4_sat_rtz(int4 v);
OVERLOADABLE short4 convert_short4_sat_rtp(int4 v);
OVERLOADABLE short4 convert_short4_sat_rtn(int4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rte(int4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtz(int4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtp(int4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtn(int4 v);
OVERLOADABLE char4 convert_char4_sat_rte(int4 v);
OVERLOADABLE char4 convert_char4_sat_rtz(int4 v);
OVERLOADABLE char4 convert_char4_sat_rtp(int4 v);
OVERLOADABLE char4 convert_char4_sat_rtn(int4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rte(int4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtz(int4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtp(int4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtn(int4 v);
OVERLOADABLE long4 convert_long4_sat_rte(uint4 v);
OVERLOADABLE long4 convert_long4_sat_rtz(uint4 v);
OVERLOADABLE long4 convert_long4_sat_rtp(uint4 v);
OVERLOADABLE long4 convert_long4_sat_rtn(uint4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rte(uint4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtz(uint4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtp(uint4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtn(uint4 v);
OVERLOADABLE int4 convert_int4_sat_rte(uint4 v);
OVERLOADABLE int4 convert_int4_sat_rtz(uint4 v);
OVERLOADABLE int4 convert_int4_sat_rtp(uint4 v);
OVERLOADABLE int4 convert_int4_sat_rtn(uint4 v);
OVERLOADABLE uint4 convert_uint4_sat_rte(uint4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtz(uint4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtp(uint4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtn(uint4 v);
OVERLOADABLE short4 convert_short4_sat_rte(uint4 v);
OVERLOADABLE short4 convert_short4_sat_rtz(uint4 v);
OVERLOADABLE short4 convert_short4_sat_rtp(uint4 v);
OVERLOADABLE short4 convert_short4_sat_rtn(uint4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rte(uint4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtz(uint4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtp(uint4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtn(uint4 v);
OVERLOADABLE char4 convert_char4_sat_rte(uint4 v);
OVERLOADABLE char4 convert_char4_sat_rtz(uint4 v);
OVERLOADABLE char4 convert_char4_sat_rtp(uint4 v);
OVERLOADABLE char4 convert_char4_sat_rtn(uint4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rte(uint4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtz(uint4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtp(uint4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtn(uint4 v);
OVERLOADABLE long4 convert_long4_sat_rte(short4 v);
OVERLOADABLE long4 convert_long4_sat_rtz(short4 v);
OVERLOADABLE long4 convert_long4_sat_rtp(short4 v);
OVERLOADABLE long4 convert_long4_sat_rtn(short4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rte(short4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtz(short4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtp(short4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtn(short4 v);
OVERLOADABLE int4 convert_int4_sat_rte(short4 v);
OVERLOADABLE int4 convert_int4_sat_rtz(short4 v);
OVERLOADABLE int4 convert_int4_sat_rtp(short4 v);
OVERLOADABLE int4 convert_int4_sat_rtn(short4 v);
OVERLOADABLE uint4 convert_uint4_sat_rte(short4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtz(short4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtp(short4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtn(short4 v);
OVERLOADABLE short4 convert_short4_sat_rte(short4 v);
OVERLOADABLE short4 convert_short4_sat_rtz(short4 v);
OVERLOADABLE short4 convert_short4_sat_rtp(short4 v);
OVERLOADABLE short4 convert_short4_sat_rtn(short4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rte(short4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtz(short4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtp(short4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtn(short4 v);
OVERLOADABLE char4 convert_char4_sat_rte(short4 v);
OVERLOADABLE char4 convert_char4_sat_rtz(short4 v);
OVERLOADABLE char4 convert_char4_sat_rtp(short4 v);
OVERLOADABLE char4 convert_char4_sat_rtn(short4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rte(short4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtz(short4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtp(short4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtn(short4 v);
OVERLOADABLE long4 convert_long4_sat_rte(ushort4 v);
OVERLOADABLE long4 convert_long4_sat_rtz(ushort4 v);
OVERLOADABLE long4 convert_long4_sat_rtp(ushort4 v);
OVERLOADABLE long4 convert_long4_sat_rtn(ushort4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rte(ushort4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtz(ushort4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtp(ushort4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtn(ushort4 v);
OVERLOADABLE int4 convert_int4_sat_rte(ushort4 v);
OVERLOADABLE int4 convert_int4_sat_rtz(ushort4 v);
OVERLOADABLE int4 convert_int4_sat_rtp(ushort4 v);
OVERLOADABLE int4 convert_int4_sat_rtn(ushort4 v);
OVERLOADABLE uint4 convert_uint4_sat_rte(ushort4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtz(ushort4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtp(ushort4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtn(ushort4 v);
OVERLOADABLE short4 convert_short4_sat_rte(ushort4 v);
OVERLOADABLE short4 convert_short4_sat_rtz(ushort4 v);
OVERLOADABLE short4 convert_short4_sat_rtp(ushort4 v);
OVERLOADABLE short4 convert_short4_sat_rtn(ushort4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rte(ushort4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtz(ushort4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtp(ushort4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtn(ushort4 v);
OVERLOADABLE char4 convert_char4_sat_rte(ushort4 v);
OVERLOADABLE char4 convert_char4_sat_rtz(ushort4 v);
OVERLOADABLE char4 convert_char4_sat_rtp(ushort4 v);
OVERLOADABLE char4 convert_char4_sat_rtn(ushort4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rte(ushort4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtz(ushort4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtp(ushort4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtn(ushort4 v);
OVERLOADABLE long4 convert_long4_sat_rte(char4 v);
OVERLOADABLE long4 convert_long4_sat_rtz(char4 v);
OVERLOADABLE long4 convert_long4_sat_rtp(char4 v);
OVERLOADABLE long4 convert_long4_sat_rtn(char4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rte(char4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtz(char4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtp(char4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtn(char4 v);
OVERLOADABLE int4 convert_int4_sat_rte(char4 v);
OVERLOADABLE int4 convert_int4_sat_rtz(char4 v);
OVERLOADABLE int4 convert_int4_sat_rtp(char4 v);
OVERLOADABLE int4 convert_int4_sat_rtn(char4 v);
OVERLOADABLE uint4 convert_uint4_sat_rte(char4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtz(char4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtp(char4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtn(char4 v);
OVERLOADABLE short4 convert_short4_sat_rte(char4 v);
OVERLOADABLE short4 convert_short4_sat_rtz(char4 v);
OVERLOADABLE short4 convert_short4_sat_rtp(char4 v);
OVERLOADABLE short4 convert_short4_sat_rtn(char4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rte(char4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtz(char4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtp(char4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtn(char4 v);
OVERLOADABLE char4 convert_char4_sat_rte(char4 v);
OVERLOADABLE char4 convert_char4_sat_rtz(char4 v);
OVERLOADABLE char4 convert_char4_sat_rtp(char4 v);
OVERLOADABLE char4 convert_char4_sat_rtn(char4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rte(char4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtz(char4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtp(char4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtn(char4 v);
OVERLOADABLE long4 convert_long4_sat_rte(uchar4 v);
OVERLOADABLE long4 convert_long4_sat_rtz(uchar4 v);
OVERLOADABLE long4 convert_long4_sat_rtp(uchar4 v);
OVERLOADABLE long4 convert_long4_sat_rtn(uchar4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rte(uchar4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtz(uchar4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtp(uchar4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtn(uchar4 v);
OVERLOADABLE int4 convert_int4_sat_rte(uchar4 v);
OVERLOADABLE int4 convert_int4_sat_rtz(uchar4 v);
OVERLOADABLE int4 convert_int4_sat_rtp(uchar4 v);
OVERLOADABLE int4 convert_int4_sat_rtn(uchar4 v);
OVERLOADABLE uint4 convert_uint4_sat_rte(uchar4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtz(uchar4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtp(uchar4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtn(uchar4 v);
OVERLOADABLE short4 convert_short4_sat_rte(uchar4 v);
OVERLOADABLE short4 convert_short4_sat_rtz(uchar4 v);
OVERLOADABLE short4 convert_short4_sat_rtp(uchar4 v);
OVERLOADABLE short4 convert_short4_sat_rtn(uchar4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rte(uchar4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtz(uchar4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtp(uchar4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtn(uchar4 v);
OVERLOADABLE char4 convert_char4_sat_rte(uchar4 v);
OVERLOADABLE char4 convert_char4_sat_rtz(uchar4 v);
OVERLOADABLE char4 convert_char4_sat_rtp(uchar4 v);
OVERLOADABLE char4 convert_char4_sat_rtn(uchar4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rte(uchar4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtz(uchar4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtp(uchar4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtn(uchar4 v);
OVERLOADABLE long4 convert_long4_sat_rte(double4 v);
OVERLOADABLE long4 convert_long4_sat_rtz(double4 v);
OVERLOADABLE long4 convert_long4_sat_rtp(double4 v);
OVERLOADABLE long4 convert_long4_sat_rtn(double4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rte(double4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtz(double4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtp(double4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtn(double4 v);
OVERLOADABLE int4 convert_int4_sat_rte(double4 v);
OVERLOADABLE int4 convert_int4_sat_rtz(double4 v);
OVERLOADABLE int4 convert_int4_sat_rtp(double4 v);
OVERLOADABLE int4 convert_int4_sat_rtn(double4 v);
OVERLOADABLE uint4 convert_uint4_sat_rte(double4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtz(double4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtp(double4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtn(double4 v);
OVERLOADABLE short4 convert_short4_sat_rte(double4 v);
OVERLOADABLE short4 convert_short4_sat_rtz(double4 v);
OVERLOADABLE short4 convert_short4_sat_rtp(double4 v);
OVERLOADABLE short4 convert_short4_sat_rtn(double4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rte(double4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtz(double4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtp(double4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtn(double4 v);
OVERLOADABLE char4 convert_char4_sat_rte(double4 v);
OVERLOADABLE char4 convert_char4_sat_rtz(double4 v);
OVERLOADABLE char4 convert_char4_sat_rtp(double4 v);
OVERLOADABLE char4 convert_char4_sat_rtn(double4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rte(double4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtz(double4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtp(double4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtn(double4 v);
OVERLOADABLE long4 convert_long4_sat_rte(float4 v);
OVERLOADABLE long4 convert_long4_sat_rtz(float4 v);
OVERLOADABLE long4 convert_long4_sat_rtp(float4 v);
OVERLOADABLE long4 convert_long4_sat_rtn(float4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rte(float4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtz(float4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtp(float4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtn(float4 v);
OVERLOADABLE int4 convert_int4_sat_rte(float4 v);
OVERLOADABLE int4 convert_int4_sat_rtz(float4 v);
OVERLOADABLE int4 convert_int4_sat_rtp(float4 v);
OVERLOADABLE int4 convert_int4_sat_rtn(float4 v);
OVERLOADABLE uint4 convert_uint4_sat_rte(float4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtz(float4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtp(float4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtn(float4 v);
OVERLOADABLE short4 convert_short4_sat_rte(float4 v);
OVERLOADABLE short4 convert_short4_sat_rtz(float4 v);
OVERLOADABLE short4 convert_short4_sat_rtp(float4 v);
OVERLOADABLE short4 convert_short4_sat_rtn(float4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rte(float4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtz(float4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtp(float4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtn(float4 v);
OVERLOADABLE char4 convert_char4_sat_rte(float4 v);
OVERLOADABLE char4 convert_char4_sat_rtz(float4 v);
OVERLOADABLE char4 convert_char4_sat_rtp(float4 v);
OVERLOADABLE char4 convert_char4_sat_rtn(float4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rte(float4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtz(float4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtp(float4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtn(float4 v);
OVERLOADABLE long4 convert_long4_sat_rte(half4 v);
OVERLOADABLE long4 convert_long4_sat_rtz(half4 v);
OVERLOADABLE long4 convert_long4_sat_rtp(half4 v);
OVERLOADABLE long4 convert_long4_sat_rtn(half4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rte(half4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtz(half4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtp(half4 v);
OVERLOADABLE ulong4 convert_ulong4_sat_rtn(half4 v);
OVERLOADABLE int4 convert_int4_sat_rte(half4 v);
OVERLOADABLE int4 convert_int4_sat_rtz(half4 v);
OVERLOADABLE int4 convert_int4_sat_rtp(half4 v);
OVERLOADABLE int4 convert_int4_sat_rtn(half4 v);
OVERLOADABLE uint4 convert_uint4_sat_rte(half4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtz(half4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtp(half4 v);
OVERLOADABLE uint4 convert_uint4_sat_rtn(half4 v);
OVERLOADABLE short4 convert_short4_sat_rte(half4 v);
OVERLOADABLE short4 convert_short4_sat_rtz(half4 v);
OVERLOADABLE short4 convert_short4_sat_rtp(half4 v);
OVERLOADABLE short4 convert_short4_sat_rtn(half4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rte(half4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtz(half4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtp(half4 v);
OVERLOADABLE ushort4 convert_ushort4_sat_rtn(half4 v);
OVERLOADABLE char4 convert_char4_sat_rte(half4 v);
OVERLOADABLE char4 convert_char4_sat_rtz(half4 v);
OVERLOADABLE char4 convert_char4_sat_rtp(half4 v);
OVERLOADABLE char4 convert_char4_sat_rtn(half4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rte(half4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtz(half4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtp(half4 v);
OVERLOADABLE uchar4 convert_uchar4_sat_rtn(half4 v);
OVERLOADABLE long8 convert_long8_sat_rte(long8 v);
OVERLOADABLE long8 convert_long8_sat_rtz(long8 v);
OVERLOADABLE long8 convert_long8_sat_rtp(long8 v);
OVERLOADABLE long8 convert_long8_sat_rtn(long8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rte(long8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtz(long8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtp(long8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtn(long8 v);
OVERLOADABLE int8 convert_int8_sat_rte(long8 v);
OVERLOADABLE int8 convert_int8_sat_rtz(long8 v);
OVERLOADABLE int8 convert_int8_sat_rtp(long8 v);
OVERLOADABLE int8 convert_int8_sat_rtn(long8 v);
OVERLOADABLE uint8 convert_uint8_sat_rte(long8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtz(long8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtp(long8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtn(long8 v);
OVERLOADABLE short8 convert_short8_sat_rte(long8 v);
OVERLOADABLE short8 convert_short8_sat_rtz(long8 v);
OVERLOADABLE short8 convert_short8_sat_rtp(long8 v);
OVERLOADABLE short8 convert_short8_sat_rtn(long8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rte(long8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtz(long8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtp(long8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtn(long8 v);
OVERLOADABLE char8 convert_char8_sat_rte(long8 v);
OVERLOADABLE char8 convert_char8_sat_rtz(long8 v);
OVERLOADABLE char8 convert_char8_sat_rtp(long8 v);
OVERLOADABLE char8 convert_char8_sat_rtn(long8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rte(long8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtz(long8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtp(long8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtn(long8 v);
OVERLOADABLE long8 convert_long8_sat_rte(ulong8 v);
OVERLOADABLE long8 convert_long8_sat_rtz(ulong8 v);
OVERLOADABLE long8 convert_long8_sat_rtp(ulong8 v);
OVERLOADABLE long8 convert_long8_sat_rtn(ulong8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rte(ulong8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtz(ulong8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtp(ulong8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtn(ulong8 v);
OVERLOADABLE int8 convert_int8_sat_rte(ulong8 v);
OVERLOADABLE int8 convert_int8_sat_rtz(ulong8 v);
OVERLOADABLE int8 convert_int8_sat_rtp(ulong8 v);
OVERLOADABLE int8 convert_int8_sat_rtn(ulong8 v);
OVERLOADABLE uint8 convert_uint8_sat_rte(ulong8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtz(ulong8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtp(ulong8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtn(ulong8 v);
OVERLOADABLE short8 convert_short8_sat_rte(ulong8 v);
OVERLOADABLE short8 convert_short8_sat_rtz(ulong8 v);
OVERLOADABLE short8 convert_short8_sat_rtp(ulong8 v);
OVERLOADABLE short8 convert_short8_sat_rtn(ulong8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rte(ulong8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtz(ulong8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtp(ulong8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtn(ulong8 v);
OVERLOADABLE char8 convert_char8_sat_rte(ulong8 v);
OVERLOADABLE char8 convert_char8_sat_rtz(ulong8 v);
OVERLOADABLE char8 convert_char8_sat_rtp(ulong8 v);
OVERLOADABLE char8 convert_char8_sat_rtn(ulong8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rte(ulong8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtz(ulong8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtp(ulong8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtn(ulong8 v);
OVERLOADABLE long8 convert_long8_sat_rte(int8 v);
OVERLOADABLE long8 convert_long8_sat_rtz(int8 v);
OVERLOADABLE long8 convert_long8_sat_rtp(int8 v);
OVERLOADABLE long8 convert_long8_sat_rtn(int8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rte(int8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtz(int8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtp(int8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtn(int8 v);
OVERLOADABLE int8 convert_int8_sat_rte(int8 v);
OVERLOADABLE int8 convert_int8_sat_rtz(int8 v);
OVERLOADABLE int8 convert_int8_sat_rtp(int8 v);
OVERLOADABLE int8 convert_int8_sat_rtn(int8 v);
OVERLOADABLE uint8 convert_uint8_sat_rte(int8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtz(int8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtp(int8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtn(int8 v);
OVERLOADABLE short8 convert_short8_sat_rte(int8 v);
OVERLOADABLE short8 convert_short8_sat_rtz(int8 v);
OVERLOADABLE short8 convert_short8_sat_rtp(int8 v);
OVERLOADABLE short8 convert_short8_sat_rtn(int8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rte(int8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtz(int8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtp(int8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtn(int8 v);
OVERLOADABLE char8 convert_char8_sat_rte(int8 v);
OVERLOADABLE char8 convert_char8_sat_rtz(int8 v);
OVERLOADABLE char8 convert_char8_sat_rtp(int8 v);
OVERLOADABLE char8 convert_char8_sat_rtn(int8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rte(int8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtz(int8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtp(int8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtn(int8 v);
OVERLOADABLE long8 convert_long8_sat_rte(uint8 v);
OVERLOADABLE long8 convert_long8_sat_rtz(uint8 v);
OVERLOADABLE long8 convert_long8_sat_rtp(uint8 v);
OVERLOADABLE long8 convert_long8_sat_rtn(uint8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rte(uint8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtz(uint8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtp(uint8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtn(uint8 v);
OVERLOADABLE int8 convert_int8_sat_rte(uint8 v);
OVERLOADABLE int8 convert_int8_sat_rtz(uint8 v);
OVERLOADABLE int8 convert_int8_sat_rtp(uint8 v);
OVERLOADABLE int8 convert_int8_sat_rtn(uint8 v);
OVERLOADABLE uint8 convert_uint8_sat_rte(uint8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtz(uint8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtp(uint8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtn(uint8 v);
OVERLOADABLE short8 convert_short8_sat_rte(uint8 v);
OVERLOADABLE short8 convert_short8_sat_rtz(uint8 v);
OVERLOADABLE short8 convert_short8_sat_rtp(uint8 v);
OVERLOADABLE short8 convert_short8_sat_rtn(uint8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rte(uint8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtz(uint8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtp(uint8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtn(uint8 v);
OVERLOADABLE char8 convert_char8_sat_rte(uint8 v);
OVERLOADABLE char8 convert_char8_sat_rtz(uint8 v);
OVERLOADABLE char8 convert_char8_sat_rtp(uint8 v);
OVERLOADABLE char8 convert_char8_sat_rtn(uint8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rte(uint8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtz(uint8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtp(uint8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtn(uint8 v);
OVERLOADABLE long8 convert_long8_sat_rte(short8 v);
OVERLOADABLE long8 convert_long8_sat_rtz(short8 v);
OVERLOADABLE long8 convert_long8_sat_rtp(short8 v);
OVERLOADABLE long8 convert_long8_sat_rtn(short8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rte(short8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtz(short8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtp(short8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtn(short8 v);
OVERLOADABLE int8 convert_int8_sat_rte(short8 v);
OVERLOADABLE int8 convert_int8_sat_rtz(short8 v);
OVERLOADABLE int8 convert_int8_sat_rtp(short8 v);
OVERLOADABLE int8 convert_int8_sat_rtn(short8 v);
OVERLOADABLE uint8 convert_uint8_sat_rte(short8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtz(short8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtp(short8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtn(short8 v);
OVERLOADABLE short8 convert_short8_sat_rte(short8 v);
OVERLOADABLE short8 convert_short8_sat_rtz(short8 v);
OVERLOADABLE short8 convert_short8_sat_rtp(short8 v);
OVERLOADABLE short8 convert_short8_sat_rtn(short8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rte(short8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtz(short8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtp(short8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtn(short8 v);
OVERLOADABLE char8 convert_char8_sat_rte(short8 v);
OVERLOADABLE char8 convert_char8_sat_rtz(short8 v);
OVERLOADABLE char8 convert_char8_sat_rtp(short8 v);
OVERLOADABLE char8 convert_char8_sat_rtn(short8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rte(short8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtz(short8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtp(short8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtn(short8 v);
OVERLOADABLE long8 convert_long8_sat_rte(ushort8 v);
OVERLOADABLE long8 convert_long8_sat_rtz(ushort8 v);
OVERLOADABLE long8 convert_long8_sat_rtp(ushort8 v);
OVERLOADABLE long8 convert_long8_sat_rtn(ushort8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rte(ushort8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtz(ushort8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtp(ushort8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtn(ushort8 v);
OVERLOADABLE int8 convert_int8_sat_rte(ushort8 v);
OVERLOADABLE int8 convert_int8_sat_rtz(ushort8 v);
OVERLOADABLE int8 convert_int8_sat_rtp(ushort8 v);
OVERLOADABLE int8 convert_int8_sat_rtn(ushort8 v);
OVERLOADABLE uint8 convert_uint8_sat_rte(ushort8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtz(ushort8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtp(ushort8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtn(ushort8 v);
OVERLOADABLE short8 convert_short8_sat_rte(ushort8 v);
OVERLOADABLE short8 convert_short8_sat_rtz(ushort8 v);
OVERLOADABLE short8 convert_short8_sat_rtp(ushort8 v);
OVERLOADABLE short8 convert_short8_sat_rtn(ushort8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rte(ushort8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtz(ushort8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtp(ushort8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtn(ushort8 v);
OVERLOADABLE char8 convert_char8_sat_rte(ushort8 v);
OVERLOADABLE char8 convert_char8_sat_rtz(ushort8 v);
OVERLOADABLE char8 convert_char8_sat_rtp(ushort8 v);
OVERLOADABLE char8 convert_char8_sat_rtn(ushort8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rte(ushort8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtz(ushort8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtp(ushort8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtn(ushort8 v);
OVERLOADABLE long8 convert_long8_sat_rte(char8 v);
OVERLOADABLE long8 convert_long8_sat_rtz(char8 v);
OVERLOADABLE long8 convert_long8_sat_rtp(char8 v);
OVERLOADABLE long8 convert_long8_sat_rtn(char8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rte(char8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtz(char8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtp(char8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtn(char8 v);
OVERLOADABLE int8 convert_int8_sat_rte(char8 v);
OVERLOADABLE int8 convert_int8_sat_rtz(char8 v);
OVERLOADABLE int8 convert_int8_sat_rtp(char8 v);
OVERLOADABLE int8 convert_int8_sat_rtn(char8 v);
OVERLOADABLE uint8 convert_uint8_sat_rte(char8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtz(char8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtp(char8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtn(char8 v);
OVERLOADABLE short8 convert_short8_sat_rte(char8 v);
OVERLOADABLE short8 convert_short8_sat_rtz(char8 v);
OVERLOADABLE short8 convert_short8_sat_rtp(char8 v);
OVERLOADABLE short8 convert_short8_sat_rtn(char8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rte(char8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtz(char8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtp(char8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtn(char8 v);
OVERLOADABLE char8 convert_char8_sat_rte(char8 v);
OVERLOADABLE char8 convert_char8_sat_rtz(char8 v);
OVERLOADABLE char8 convert_char8_sat_rtp(char8 v);
OVERLOADABLE char8 convert_char8_sat_rtn(char8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rte(char8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtz(char8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtp(char8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtn(char8 v);
OVERLOADABLE long8 convert_long8_sat_rte(uchar8 v);
OVERLOADABLE long8 convert_long8_sat_rtz(uchar8 v);
OVERLOADABLE long8 convert_long8_sat_rtp(uchar8 v);
OVERLOADABLE long8 convert_long8_sat_rtn(uchar8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rte(uchar8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtz(uchar8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtp(uchar8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtn(uchar8 v);
OVERLOADABLE int8 convert_int8_sat_rte(uchar8 v);
OVERLOADABLE int8 convert_int8_sat_rtz(uchar8 v);
OVERLOADABLE int8 convert_int8_sat_rtp(uchar8 v);
OVERLOADABLE int8 convert_int8_sat_rtn(uchar8 v);
OVERLOADABLE uint8 convert_uint8_sat_rte(uchar8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtz(uchar8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtp(uchar8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtn(uchar8 v);
OVERLOADABLE short8 convert_short8_sat_rte(uchar8 v);
OVERLOADABLE short8 convert_short8_sat_rtz(uchar8 v);
OVERLOADABLE short8 convert_short8_sat_rtp(uchar8 v);
OVERLOADABLE short8 convert_short8_sat_rtn(uchar8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rte(uchar8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtz(uchar8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtp(uchar8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtn(uchar8 v);
OVERLOADABLE char8 convert_char8_sat_rte(uchar8 v);
OVERLOADABLE char8 convert_char8_sat_rtz(uchar8 v);
OVERLOADABLE char8 convert_char8_sat_rtp(uchar8 v);
OVERLOADABLE char8 convert_char8_sat_rtn(uchar8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rte(uchar8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtz(uchar8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtp(uchar8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtn(uchar8 v);
OVERLOADABLE long8 convert_long8_sat_rte(double8 v);
OVERLOADABLE long8 convert_long8_sat_rtz(double8 v);
OVERLOADABLE long8 convert_long8_sat_rtp(double8 v);
OVERLOADABLE long8 convert_long8_sat_rtn(double8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rte(double8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtz(double8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtp(double8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtn(double8 v);
OVERLOADABLE int8 convert_int8_sat_rte(double8 v);
OVERLOADABLE int8 convert_int8_sat_rtz(double8 v);
OVERLOADABLE int8 convert_int8_sat_rtp(double8 v);
OVERLOADABLE int8 convert_int8_sat_rtn(double8 v);
OVERLOADABLE uint8 convert_uint8_sat_rte(double8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtz(double8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtp(double8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtn(double8 v);
OVERLOADABLE short8 convert_short8_sat_rte(double8 v);
OVERLOADABLE short8 convert_short8_sat_rtz(double8 v);
OVERLOADABLE short8 convert_short8_sat_rtp(double8 v);
OVERLOADABLE short8 convert_short8_sat_rtn(double8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rte(double8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtz(double8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtp(double8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtn(double8 v);
OVERLOADABLE char8 convert_char8_sat_rte(double8 v);
OVERLOADABLE char8 convert_char8_sat_rtz(double8 v);
OVERLOADABLE char8 convert_char8_sat_rtp(double8 v);
OVERLOADABLE char8 convert_char8_sat_rtn(double8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rte(double8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtz(double8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtp(double8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtn(double8 v);
OVERLOADABLE long8 convert_long8_sat_rte(float8 v);
OVERLOADABLE long8 convert_long8_sat_rtz(float8 v);
OVERLOADABLE long8 convert_long8_sat_rtp(float8 v);
OVERLOADABLE long8 convert_long8_sat_rtn(float8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rte(float8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtz(float8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtp(float8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtn(float8 v);
OVERLOADABLE int8 convert_int8_sat_rte(float8 v);
OVERLOADABLE int8 convert_int8_sat_rtz(float8 v);
OVERLOADABLE int8 convert_int8_sat_rtp(float8 v);
OVERLOADABLE int8 convert_int8_sat_rtn(float8 v);
OVERLOADABLE uint8 convert_uint8_sat_rte(float8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtz(float8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtp(float8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtn(float8 v);
OVERLOADABLE short8 convert_short8_sat_rte(float8 v);
OVERLOADABLE short8 convert_short8_sat_rtz(float8 v);
OVERLOADABLE short8 convert_short8_sat_rtp(float8 v);
OVERLOADABLE short8 convert_short8_sat_rtn(float8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rte(float8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtz(float8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtp(float8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtn(float8 v);
OVERLOADABLE char8 convert_char8_sat_rte(float8 v);
OVERLOADABLE char8 convert_char8_sat_rtz(float8 v);
OVERLOADABLE char8 convert_char8_sat_rtp(float8 v);
OVERLOADABLE char8 convert_char8_sat_rtn(float8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rte(float8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtz(float8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtp(float8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtn(float8 v);
OVERLOADABLE long8 convert_long8_sat_rte(half8 v);
OVERLOADABLE long8 convert_long8_sat_rtz(half8 v);
OVERLOADABLE long8 convert_long8_sat_rtp(half8 v);
OVERLOADABLE long8 convert_long8_sat_rtn(half8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rte(half8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtz(half8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtp(half8 v);
OVERLOADABLE ulong8 convert_ulong8_sat_rtn(half8 v);
OVERLOADABLE int8 convert_int8_sat_rte(half8 v);
OVERLOADABLE int8 convert_int8_sat_rtz(half8 v);
OVERLOADABLE int8 convert_int8_sat_rtp(half8 v);
OVERLOADABLE int8 convert_int8_sat_rtn(half8 v);
OVERLOADABLE uint8 convert_uint8_sat_rte(half8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtz(half8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtp(half8 v);
OVERLOADABLE uint8 convert_uint8_sat_rtn(half8 v);
OVERLOADABLE short8 convert_short8_sat_rte(half8 v);
OVERLOADABLE short8 convert_short8_sat_rtz(half8 v);
OVERLOADABLE short8 convert_short8_sat_rtp(half8 v);
OVERLOADABLE short8 convert_short8_sat_rtn(half8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rte(half8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtz(half8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtp(half8 v);
OVERLOADABLE ushort8 convert_ushort8_sat_rtn(half8 v);
OVERLOADABLE char8 convert_char8_sat_rte(half8 v);
OVERLOADABLE char8 convert_char8_sat_rtz(half8 v);
OVERLOADABLE char8 convert_char8_sat_rtp(half8 v);
OVERLOADABLE char8 convert_char8_sat_rtn(half8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rte(half8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtz(half8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtp(half8 v);
OVERLOADABLE uchar8 convert_uchar8_sat_rtn(half8 v);
OVERLOADABLE long16 convert_long16_sat_rte(long16 v);
OVERLOADABLE long16 convert_long16_sat_rtz(long16 v);
OVERLOADABLE long16 convert_long16_sat_rtp(long16 v);
OVERLOADABLE long16 convert_long16_sat_rtn(long16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rte(long16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtz(long16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtp(long16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtn(long16 v);
OVERLOADABLE int16 convert_int16_sat_rte(long16 v);
OVERLOADABLE int16 convert_int16_sat_rtz(long16 v);
OVERLOADABLE int16 convert_int16_sat_rtp(long16 v);
OVERLOADABLE int16 convert_int16_sat_rtn(long16 v);
OVERLOADABLE uint16 convert_uint16_sat_rte(long16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtz(long16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtp(long16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtn(long16 v);
OVERLOADABLE short16 convert_short16_sat_rte(long16 v);
OVERLOADABLE short16 convert_short16_sat_rtz(long16 v);
OVERLOADABLE short16 convert_short16_sat_rtp(long16 v);
OVERLOADABLE short16 convert_short16_sat_rtn(long16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rte(long16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtz(long16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtp(long16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtn(long16 v);
OVERLOADABLE char16 convert_char16_sat_rte(long16 v);
OVERLOADABLE char16 convert_char16_sat_rtz(long16 v);
OVERLOADABLE char16 convert_char16_sat_rtp(long16 v);
OVERLOADABLE char16 convert_char16_sat_rtn(long16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rte(long16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtz(long16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtp(long16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtn(long16 v);
OVERLOADABLE long16 convert_long16_sat_rte(ulong16 v);
OVERLOADABLE long16 convert_long16_sat_rtz(ulong16 v);
OVERLOADABLE long16 convert_long16_sat_rtp(ulong16 v);
OVERLOADABLE long16 convert_long16_sat_rtn(ulong16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rte(ulong16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtz(ulong16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtp(ulong16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtn(ulong16 v);
OVERLOADABLE int16 convert_int16_sat_rte(ulong16 v);
OVERLOADABLE int16 convert_int16_sat_rtz(ulong16 v);
OVERLOADABLE int16 convert_int16_sat_rtp(ulong16 v);
OVERLOADABLE int16 convert_int16_sat_rtn(ulong16 v);
OVERLOADABLE uint16 convert_uint16_sat_rte(ulong16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtz(ulong16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtp(ulong16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtn(ulong16 v);
OVERLOADABLE short16 convert_short16_sat_rte(ulong16 v);
OVERLOADABLE short16 convert_short16_sat_rtz(ulong16 v);
OVERLOADABLE short16 convert_short16_sat_rtp(ulong16 v);
OVERLOADABLE short16 convert_short16_sat_rtn(ulong16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rte(ulong16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtz(ulong16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtp(ulong16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtn(ulong16 v);
OVERLOADABLE char16 convert_char16_sat_rte(ulong16 v);
OVERLOADABLE char16 convert_char16_sat_rtz(ulong16 v);
OVERLOADABLE char16 convert_char16_sat_rtp(ulong16 v);
OVERLOADABLE char16 convert_char16_sat_rtn(ulong16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rte(ulong16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtz(ulong16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtp(ulong16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtn(ulong16 v);
OVERLOADABLE long16 convert_long16_sat_rte(int16 v);
OVERLOADABLE long16 convert_long16_sat_rtz(int16 v);
OVERLOADABLE long16 convert_long16_sat_rtp(int16 v);
OVERLOADABLE long16 convert_long16_sat_rtn(int16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rte(int16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtz(int16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtp(int16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtn(int16 v);
OVERLOADABLE int16 convert_int16_sat_rte(int16 v);
OVERLOADABLE int16 convert_int16_sat_rtz(int16 v);
OVERLOADABLE int16 convert_int16_sat_rtp(int16 v);
OVERLOADABLE int16 convert_int16_sat_rtn(int16 v);
OVERLOADABLE uint16 convert_uint16_sat_rte(int16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtz(int16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtp(int16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtn(int16 v);
OVERLOADABLE short16 convert_short16_sat_rte(int16 v);
OVERLOADABLE short16 convert_short16_sat_rtz(int16 v);
OVERLOADABLE short16 convert_short16_sat_rtp(int16 v);
OVERLOADABLE short16 convert_short16_sat_rtn(int16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rte(int16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtz(int16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtp(int16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtn(int16 v);
OVERLOADABLE char16 convert_char16_sat_rte(int16 v);
OVERLOADABLE char16 convert_char16_sat_rtz(int16 v);
OVERLOADABLE char16 convert_char16_sat_rtp(int16 v);
OVERLOADABLE char16 convert_char16_sat_rtn(int16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rte(int16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtz(int16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtp(int16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtn(int16 v);
OVERLOADABLE long16 convert_long16_sat_rte(uint16 v);
OVERLOADABLE long16 convert_long16_sat_rtz(uint16 v);
OVERLOADABLE long16 convert_long16_sat_rtp(uint16 v);
OVERLOADABLE long16 convert_long16_sat_rtn(uint16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rte(uint16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtz(uint16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtp(uint16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtn(uint16 v);
OVERLOADABLE int16 convert_int16_sat_rte(uint16 v);
OVERLOADABLE int16 convert_int16_sat_rtz(uint16 v);
OVERLOADABLE int16 convert_int16_sat_rtp(uint16 v);
OVERLOADABLE int16 convert_int16_sat_rtn(uint16 v);
OVERLOADABLE uint16 convert_uint16_sat_rte(uint16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtz(uint16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtp(uint16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtn(uint16 v);
OVERLOADABLE short16 convert_short16_sat_rte(uint16 v);
OVERLOADABLE short16 convert_short16_sat_rtz(uint16 v);
OVERLOADABLE short16 convert_short16_sat_rtp(uint16 v);
OVERLOADABLE short16 convert_short16_sat_rtn(uint16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rte(uint16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtz(uint16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtp(uint16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtn(uint16 v);
OVERLOADABLE char16 convert_char16_sat_rte(uint16 v);
OVERLOADABLE char16 convert_char16_sat_rtz(uint16 v);
OVERLOADABLE char16 convert_char16_sat_rtp(uint16 v);
OVERLOADABLE char16 convert_char16_sat_rtn(uint16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rte(uint16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtz(uint16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtp(uint16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtn(uint16 v);
OVERLOADABLE long16 convert_long16_sat_rte(short16 v);
OVERLOADABLE long16 convert_long16_sat_rtz(short16 v);
OVERLOADABLE long16 convert_long16_sat_rtp(short16 v);
OVERLOADABLE long16 convert_long16_sat_rtn(short16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rte(short16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtz(short16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtp(short16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtn(short16 v);
OVERLOADABLE int16 convert_int16_sat_rte(short16 v);
OVERLOADABLE int16 convert_int16_sat_rtz(short16 v);
OVERLOADABLE int16 convert_int16_sat_rtp(short16 v);
OVERLOADABLE int16 convert_int16_sat_rtn(short16 v);
OVERLOADABLE uint16 convert_uint16_sat_rte(short16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtz(short16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtp(short16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtn(short16 v);
OVERLOADABLE short16 convert_short16_sat_rte(short16 v);
OVERLOADABLE short16 convert_short16_sat_rtz(short16 v);
OVERLOADABLE short16 convert_short16_sat_rtp(short16 v);
OVERLOADABLE short16 convert_short16_sat_rtn(short16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rte(short16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtz(short16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtp(short16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtn(short16 v);
OVERLOADABLE char16 convert_char16_sat_rte(short16 v);
OVERLOADABLE char16 convert_char16_sat_rtz(short16 v);
OVERLOADABLE char16 convert_char16_sat_rtp(short16 v);
OVERLOADABLE char16 convert_char16_sat_rtn(short16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rte(short16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtz(short16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtp(short16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtn(short16 v);
OVERLOADABLE long16 convert_long16_sat_rte(ushort16 v);
OVERLOADABLE long16 convert_long16_sat_rtz(ushort16 v);
OVERLOADABLE long16 convert_long16_sat_rtp(ushort16 v);
OVERLOADABLE long16 convert_long16_sat_rtn(ushort16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rte(ushort16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtz(ushort16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtp(ushort16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtn(ushort16 v);
OVERLOADABLE int16 convert_int16_sat_rte(ushort16 v);
OVERLOADABLE int16 convert_int16_sat_rtz(ushort16 v);
OVERLOADABLE int16 convert_int16_sat_rtp(ushort16 v);
OVERLOADABLE int16 convert_int16_sat_rtn(ushort16 v);
OVERLOADABLE uint16 convert_uint16_sat_rte(ushort16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtz(ushort16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtp(ushort16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtn(ushort16 v);
OVERLOADABLE short16 convert_short16_sat_rte(ushort16 v);
OVERLOADABLE short16 convert_short16_sat_rtz(ushort16 v);
OVERLOADABLE short16 convert_short16_sat_rtp(ushort16 v);
OVERLOADABLE short16 convert_short16_sat_rtn(ushort16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rte(ushort16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtz(ushort16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtp(ushort16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtn(ushort16 v);
OVERLOADABLE char16 convert_char16_sat_rte(ushort16 v);
OVERLOADABLE char16 convert_char16_sat_rtz(ushort16 v);
OVERLOADABLE char16 convert_char16_sat_rtp(ushort16 v);
OVERLOADABLE char16 convert_char16_sat_rtn(ushort16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rte(ushort16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtz(ushort16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtp(ushort16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtn(ushort16 v);
OVERLOADABLE long16 convert_long16_sat_rte(char16 v);
OVERLOADABLE long16 convert_long16_sat_rtz(char16 v);
OVERLOADABLE long16 convert_long16_sat_rtp(char16 v);
OVERLOADABLE long16 convert_long16_sat_rtn(char16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rte(char16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtz(char16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtp(char16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtn(char16 v);
OVERLOADABLE int16 convert_int16_sat_rte(char16 v);
OVERLOADABLE int16 convert_int16_sat_rtz(char16 v);
OVERLOADABLE int16 convert_int16_sat_rtp(char16 v);
OVERLOADABLE int16 convert_int16_sat_rtn(char16 v);
OVERLOADABLE uint16 convert_uint16_sat_rte(char16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtz(char16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtp(char16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtn(char16 v);
OVERLOADABLE short16 convert_short16_sat_rte(char16 v);
OVERLOADABLE short16 convert_short16_sat_rtz(char16 v);
OVERLOADABLE short16 convert_short16_sat_rtp(char16 v);
OVERLOADABLE short16 convert_short16_sat_rtn(char16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rte(char16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtz(char16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtp(char16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtn(char16 v);
OVERLOADABLE char16 convert_char16_sat_rte(char16 v);
OVERLOADABLE char16 convert_char16_sat_rtz(char16 v);
OVERLOADABLE char16 convert_char16_sat_rtp(char16 v);
OVERLOADABLE char16 convert_char16_sat_rtn(char16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rte(char16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtz(char16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtp(char16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtn(char16 v);
OVERLOADABLE long16 convert_long16_sat_rte(uchar16 v);
OVERLOADABLE long16 convert_long16_sat_rtz(uchar16 v);
OVERLOADABLE long16 convert_long16_sat_rtp(uchar16 v);
OVERLOADABLE long16 convert_long16_sat_rtn(uchar16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rte(uchar16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtz(uchar16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtp(uchar16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtn(uchar16 v);
OVERLOADABLE int16 convert_int16_sat_rte(uchar16 v);
OVERLOADABLE int16 convert_int16_sat_rtz(uchar16 v);
OVERLOADABLE int16 convert_int16_sat_rtp(uchar16 v);
OVERLOADABLE int16 convert_int16_sat_rtn(uchar16 v);
OVERLOADABLE uint16 convert_uint16_sat_rte(uchar16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtz(uchar16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtp(uchar16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtn(uchar16 v);
OVERLOADABLE short16 convert_short16_sat_rte(uchar16 v);
OVERLOADABLE short16 convert_short16_sat_rtz(uchar16 v);
OVERLOADABLE short16 convert_short16_sat_rtp(uchar16 v);
OVERLOADABLE short16 convert_short16_sat_rtn(uchar16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rte(uchar16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtz(uchar16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtp(uchar16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtn(uchar16 v);
OVERLOADABLE char16 convert_char16_sat_rte(uchar16 v);
OVERLOADABLE char16 convert_char16_sat_rtz(uchar16 v);
OVERLOADABLE char16 convert_char16_sat_rtp(uchar16 v);
OVERLOADABLE char16 convert_char16_sat_rtn(uchar16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rte(uchar16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtz(uchar16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtp(uchar16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtn(uchar16 v);
OVERLOADABLE long16 convert_long16_sat_rte(double16 v);
OVERLOADABLE long16 convert_long16_sat_rtz(double16 v);
OVERLOADABLE long16 convert_long16_sat_rtp(double16 v);
OVERLOADABLE long16 convert_long16_sat_rtn(double16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rte(double16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtz(double16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtp(double16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtn(double16 v);
OVERLOADABLE int16 convert_int16_sat_rte(double16 v);
OVERLOADABLE int16 convert_int16_sat_rtz(double16 v);
OVERLOADABLE int16 convert_int16_sat_rtp(double16 v);
OVERLOADABLE int16 convert_int16_sat_rtn(double16 v);
OVERLOADABLE uint16 convert_uint16_sat_rte(double16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtz(double16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtp(double16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtn(double16 v);
OVERLOADABLE short16 convert_short16_sat_rte(double16 v);
OVERLOADABLE short16 convert_short16_sat_rtz(double16 v);
OVERLOADABLE short16 convert_short16_sat_rtp(double16 v);
OVERLOADABLE short16 convert_short16_sat_rtn(double16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rte(double16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtz(double16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtp(double16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtn(double16 v);
OVERLOADABLE char16 convert_char16_sat_rte(double16 v);
OVERLOADABLE char16 convert_char16_sat_rtz(double16 v);
OVERLOADABLE char16 convert_char16_sat_rtp(double16 v);
OVERLOADABLE char16 convert_char16_sat_rtn(double16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rte(double16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtz(double16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtp(double16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtn(double16 v);
OVERLOADABLE long16 convert_long16_sat_rte(float16 v);
OVERLOADABLE long16 convert_long16_sat_rtz(float16 v);
OVERLOADABLE long16 convert_long16_sat_rtp(float16 v);
OVERLOADABLE long16 convert_long16_sat_rtn(float16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rte(float16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtz(float16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtp(float16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtn(float16 v);
OVERLOADABLE int16 convert_int16_sat_rte(float16 v);
OVERLOADABLE int16 convert_int16_sat_rtz(float16 v);
OVERLOADABLE int16 convert_int16_sat_rtp(float16 v);
OVERLOADABLE int16 convert_int16_sat_rtn(float16 v);
OVERLOADABLE uint16 convert_uint16_sat_rte(float16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtz(float16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtp(float16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtn(float16 v);
OVERLOADABLE short16 convert_short16_sat_rte(float16 v);
OVERLOADABLE short16 convert_short16_sat_rtz(float16 v);
OVERLOADABLE short16 convert_short16_sat_rtp(float16 v);
OVERLOADABLE short16 convert_short16_sat_rtn(float16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rte(float16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtz(float16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtp(float16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtn(float16 v);
OVERLOADABLE char16 convert_char16_sat_rte(float16 v);
OVERLOADABLE char16 convert_char16_sat_rtz(float16 v);
OVERLOADABLE char16 convert_char16_sat_rtp(float16 v);
OVERLOADABLE char16 convert_char16_sat_rtn(float16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rte(float16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtz(float16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtp(float16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtn(float16 v);
OVERLOADABLE long16 convert_long16_sat_rte(half16 v);
OVERLOADABLE long16 convert_long16_sat_rtz(half16 v);
OVERLOADABLE long16 convert_long16_sat_rtp(half16 v);
OVERLOADABLE long16 convert_long16_sat_rtn(half16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rte(half16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtz(half16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtp(half16 v);
OVERLOADABLE ulong16 convert_ulong16_sat_rtn(half16 v);
OVERLOADABLE int16 convert_int16_sat_rte(half16 v);
OVERLOADABLE int16 convert_int16_sat_rtz(half16 v);
OVERLOADABLE int16 convert_int16_sat_rtp(half16 v);
OVERLOADABLE int16 convert_int16_sat_rtn(half16 v);
OVERLOADABLE uint16 convert_uint16_sat_rte(half16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtz(half16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtp(half16 v);
OVERLOADABLE uint16 convert_uint16_sat_rtn(half16 v);
OVERLOADABLE short16 convert_short16_sat_rte(half16 v);
OVERLOADABLE short16 convert_short16_sat_rtz(half16 v);
OVERLOADABLE short16 convert_short16_sat_rtp(half16 v);
OVERLOADABLE short16 convert_short16_sat_rtn(half16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rte(half16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtz(half16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtp(half16 v);
OVERLOADABLE ushort16 convert_ushort16_sat_rtn(half16 v);
OVERLOADABLE char16 convert_char16_sat_rte(half16 v);
OVERLOADABLE char16 convert_char16_sat_rtz(half16 v);
OVERLOADABLE char16 convert_char16_sat_rtp(half16 v);
OVERLOADABLE char16 convert_char16_sat_rtn(half16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rte(half16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtz(half16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtp(half16 v);
OVERLOADABLE uchar16 convert_uchar16_sat_rtn(half16 v);
OVERLOADABLE double convert_double_rte(double x);
OVERLOADABLE double convert_double_rtz(double x);
OVERLOADABLE double convert_double_rtp(double x);
OVERLOADABLE double convert_double_rtn(double x);
OVERLOADABLE double convert_double_rte(float x);
OVERLOADABLE double convert_double_rtz(float x);
OVERLOADABLE double convert_double_rtp(float x);
OVERLOADABLE double convert_double_rtn(float x);
OVERLOADABLE double convert_double_rte(int x);
OVERLOADABLE double convert_double_rtz(int x);
OVERLOADABLE double convert_double_rtp(int x);
OVERLOADABLE double convert_double_rtn(int x);
OVERLOADABLE double convert_double_rte(uint x);
OVERLOADABLE double convert_double_rtz(uint x);
OVERLOADABLE double convert_double_rtp(uint x);
OVERLOADABLE double convert_double_rtn(uint x);
OVERLOADABLE double convert_double_rte(short x);
OVERLOADABLE double convert_double_rtz(short x);
OVERLOADABLE double convert_double_rtp(short x);
OVERLOADABLE double convert_double_rtn(short x);
OVERLOADABLE double convert_double_rte(ushort x);
OVERLOADABLE double convert_double_rtz(ushort x);
OVERLOADABLE double convert_double_rtp(ushort x);
OVERLOADABLE double convert_double_rtn(ushort x);
OVERLOADABLE double convert_double_rte(char x);
OVERLOADABLE double convert_double_rtz(char x);
OVERLOADABLE double convert_double_rtp(char x);
OVERLOADABLE double convert_double_rtn(char x);
OVERLOADABLE double convert_double_rte(uchar x);
OVERLOADABLE double convert_double_rtz(uchar x);
OVERLOADABLE double convert_double_rtp(uchar x);
OVERLOADABLE double convert_double_rtn(uchar x);
OVERLOADABLE double2 convert_double2_rte(double2 v);
OVERLOADABLE double2 convert_double2_rtz(double2 v);
OVERLOADABLE double2 convert_double2_rtp(double2 v);
OVERLOADABLE double2 convert_double2_rtn(double2 v);
OVERLOADABLE double2 convert_double2_rte(float2 v);
OVERLOADABLE double2 convert_double2_rtz(float2 v);
OVERLOADABLE double2 convert_double2_rtp(float2 v);
OVERLOADABLE double2 convert_double2_rtn(float2 v);
OVERLOADABLE double2 convert_double2_rte(int2 v);
OVERLOADABLE double2 convert_double2_rtz(int2 v);
OVERLOADABLE double2 convert_double2_rtp(int2 v);
OVERLOADABLE double2 convert_double2_rtn(int2 v);
OVERLOADABLE double2 convert_double2_rte(uint2 v);
OVERLOADABLE double2 convert_double2_rtz(uint2 v);
OVERLOADABLE double2 convert_double2_rtp(uint2 v);
OVERLOADABLE double2 convert_double2_rtn(uint2 v);
OVERLOADABLE double2 convert_double2_rte(short2 v);
OVERLOADABLE double2 convert_double2_rtz(short2 v);
OVERLOADABLE double2 convert_double2_rtp(short2 v);
OVERLOADABLE double2 convert_double2_rtn(short2 v);
OVERLOADABLE double2 convert_double2_rte(ushort2 v);
OVERLOADABLE double2 convert_double2_rtz(ushort2 v);
OVERLOADABLE double2 convert_double2_rtp(ushort2 v);
OVERLOADABLE double2 convert_double2_rtn(ushort2 v);
OVERLOADABLE double2 convert_double2_rte(char2 v);
OVERLOADABLE double2 convert_double2_rtz(char2 v);
OVERLOADABLE double2 convert_double2_rtp(char2 v);
OVERLOADABLE double2 convert_double2_rtn(char2 v);
OVERLOADABLE double2 convert_double2_rte(uchar2 v);
OVERLOADABLE double2 convert_double2_rtz(uchar2 v);
OVERLOADABLE double2 convert_double2_rtp(uchar2 v);
OVERLOADABLE double2 convert_double2_rtn(uchar2 v);
OVERLOADABLE double3 convert_double3_rte(double3 v);
OVERLOADABLE double3 convert_double3_rtz(double3 v);
OVERLOADABLE double3 convert_double3_rtp(double3 v);
OVERLOADABLE double3 convert_double3_rtn(double3 v);
OVERLOADABLE double3 convert_double3_rte(float3 v);
OVERLOADABLE double3 convert_double3_rtz(float3 v);
OVERLOADABLE double3 convert_double3_rtp(float3 v);
OVERLOADABLE double3 convert_double3_rtn(float3 v);
OVERLOADABLE double3 convert_double3_rte(int3 v);
OVERLOADABLE double3 convert_double3_rtz(int3 v);
OVERLOADABLE double3 convert_double3_rtp(int3 v);
OVERLOADABLE double3 convert_double3_rtn(int3 v);
OVERLOADABLE double3 convert_double3_rte(uint3 v);
OVERLOADABLE double3 convert_double3_rtz(uint3 v);
OVERLOADABLE double3 convert_double3_rtp(uint3 v);
OVERLOADABLE double3 convert_double3_rtn(uint3 v);
OVERLOADABLE double3 convert_double3_rte(short3 v);
OVERLOADABLE double3 convert_double3_rtz(short3 v);
OVERLOADABLE double3 convert_double3_rtp(short3 v);
OVERLOADABLE double3 convert_double3_rtn(short3 v);
OVERLOADABLE double3 convert_double3_rte(ushort3 v);
OVERLOADABLE double3 convert_double3_rtz(ushort3 v);
OVERLOADABLE double3 convert_double3_rtp(ushort3 v);
OVERLOADABLE double3 convert_double3_rtn(ushort3 v);
OVERLOADABLE double3 convert_double3_rte(char3 v);
OVERLOADABLE double3 convert_double3_rtz(char3 v);
OVERLOADABLE double3 convert_double3_rtp(char3 v);
OVERLOADABLE double3 convert_double3_rtn(char3 v);
OVERLOADABLE double3 convert_double3_rte(uchar3 v);
OVERLOADABLE double3 convert_double3_rtz(uchar3 v);
OVERLOADABLE double3 convert_double3_rtp(uchar3 v);
OVERLOADABLE double3 convert_double3_rtn(uchar3 v);
OVERLOADABLE double4 convert_double4_rte(double4 v);
OVERLOADABLE double4 convert_double4_rtz(double4 v);
OVERLOADABLE double4 convert_double4_rtp(double4 v);
OVERLOADABLE double4 convert_double4_rtn(double4 v);
OVERLOADABLE double4 convert_double4_rte(float4 v);
OVERLOADABLE double4 convert_double4_rtz(float4 v);
OVERLOADABLE double4 convert_double4_rtp(float4 v);
OVERLOADABLE double4 convert_double4_rtn(float4 v);
OVERLOADABLE double4 convert_double4_rte(int4 v);
OVERLOADABLE double4 convert_double4_rtz(int4 v);
OVERLOADABLE double4 convert_double4_rtp(int4 v);
OVERLOADABLE double4 convert_double4_rtn(int4 v);
OVERLOADABLE double4 convert_double4_rte(uint4 v);
OVERLOADABLE double4 convert_double4_rtz(uint4 v);
OVERLOADABLE double4 convert_double4_rtp(uint4 v);
OVERLOADABLE double4 convert_double4_rtn(uint4 v);
OVERLOADABLE double4 convert_double4_rte(short4 v);
OVERLOADABLE double4 convert_double4_rtz(short4 v);
OVERLOADABLE double4 convert_double4_rtp(short4 v);
OVERLOADABLE double4 convert_double4_rtn(short4 v);
OVERLOADABLE double4 convert_double4_rte(ushort4 v);
OVERLOADABLE double4 convert_double4_rtz(ushort4 v);
OVERLOADABLE double4 convert_double4_rtp(ushort4 v);
OVERLOADABLE double4 convert_double4_rtn(ushort4 v);
OVERLOADABLE double4 convert_double4_rte(char4 v);
OVERLOADABLE double4 convert_double4_rtz(char4 v);
OVERLOADABLE double4 convert_double4_rtp(char4 v);
OVERLOADABLE double4 convert_double4_rtn(char4 v);
OVERLOADABLE double4 convert_double4_rte(uchar4 v);
OVERLOADABLE double4 convert_double4_rtz(uchar4 v);
OVERLOADABLE double4 convert_double4_rtp(uchar4 v);
OVERLOADABLE double4 convert_double4_rtn(uchar4 v);
OVERLOADABLE double8 convert_double8_rte(double8 v);
OVERLOADABLE double8 convert_double8_rtz(double8 v);
OVERLOADABLE double8 convert_double8_rtp(double8 v);
OVERLOADABLE double8 convert_double8_rtn(double8 v);
OVERLOADABLE double8 convert_double8_rte(float8 v);
OVERLOADABLE double8 convert_double8_rtz(float8 v);
OVERLOADABLE double8 convert_double8_rtp(float8 v);
OVERLOADABLE double8 convert_double8_rtn(float8 v);
OVERLOADABLE double8 convert_double8_rte(int8 v);
OVERLOADABLE double8 convert_double8_rtz(int8 v);
OVERLOADABLE double8 convert_double8_rtp(int8 v);
OVERLOADABLE double8 convert_double8_rtn(int8 v);
OVERLOADABLE double8 convert_double8_rte(uint8 v);
OVERLOADABLE double8 convert_double8_rtz(uint8 v);
OVERLOADABLE double8 convert_double8_rtp(uint8 v);
OVERLOADABLE double8 convert_double8_rtn(uint8 v);
OVERLOADABLE double8 convert_double8_rte(short8 v);
OVERLOADABLE double8 convert_double8_rtz(short8 v);
OVERLOADABLE double8 convert_double8_rtp(short8 v);
OVERLOADABLE double8 convert_double8_rtn(short8 v);
OVERLOADABLE double8 convert_double8_rte(ushort8 v);
OVERLOADABLE double8 convert_double8_rtz(ushort8 v);
OVERLOADABLE double8 convert_double8_rtp(ushort8 v);
OVERLOADABLE double8 convert_double8_rtn(ushort8 v);
OVERLOADABLE double8 convert_double8_rte(char8 v);
OVERLOADABLE double8 convert_double8_rtz(char8 v);
OVERLOADABLE double8 convert_double8_rtp(char8 v);
OVERLOADABLE double8 convert_double8_rtn(char8 v);
OVERLOADABLE double8 convert_double8_rte(uchar8 v);
OVERLOADABLE double8 convert_double8_rtz(uchar8 v);
OVERLOADABLE double8 convert_double8_rtp(uchar8 v);
OVERLOADABLE double8 convert_double8_rtn(uchar8 v);
OVERLOADABLE double16 convert_double16_rte(double16 v);
OVERLOADABLE double16 convert_double16_rtz(double16 v);
OVERLOADABLE double16 convert_double16_rtp(double16 v);
OVERLOADABLE double16 convert_double16_rtn(double16 v);
OVERLOADABLE double16 convert_double16_rte(float16 v);
OVERLOADABLE double16 convert_double16_rtz(float16 v);
OVERLOADABLE double16 convert_double16_rtp(float16 v);
OVERLOADABLE double16 convert_double16_rtn(float16 v);
OVERLOADABLE double16 convert_double16_rte(int16 v);
OVERLOADABLE double16 convert_double16_rtz(int16 v);
OVERLOADABLE double16 convert_double16_rtp(int16 v);
OVERLOADABLE double16 convert_double16_rtn(int16 v);
OVERLOADABLE double16 convert_double16_rte(uint16 v);
OVERLOADABLE double16 convert_double16_rtz(uint16 v);
OVERLOADABLE double16 convert_double16_rtp(uint16 v);
OVERLOADABLE double16 convert_double16_rtn(uint16 v);
OVERLOADABLE double16 convert_double16_rte(short16 v);
OVERLOADABLE double16 convert_double16_rtz(short16 v);
OVERLOADABLE double16 convert_double16_rtp(short16 v);
OVERLOADABLE double16 convert_double16_rtn(short16 v);
OVERLOADABLE double16 convert_double16_rte(ushort16 v);
OVERLOADABLE double16 convert_double16_rtz(ushort16 v);
OVERLOADABLE double16 convert_double16_rtp(ushort16 v);
OVERLOADABLE double16 convert_double16_rtn(ushort16 v);
OVERLOADABLE double16 convert_double16_rte(char16 v);
OVERLOADABLE double16 convert_double16_rtz(char16 v);
OVERLOADABLE double16 convert_double16_rtp(char16 v);
OVERLOADABLE double16 convert_double16_rtn(char16 v);
OVERLOADABLE double16 convert_double16_rte(uchar16 v);
OVERLOADABLE double16 convert_double16_rtz(uchar16 v);
OVERLOADABLE double16 convert_double16_rtp(uchar16 v);
OVERLOADABLE double16 convert_double16_rtn(uchar16 v);
OVERLOADABLE double convert_double_rte(ulong x);
OVERLOADABLE double convert_double_rtz(ulong x);
OVERLOADABLE double convert_double_rtp(ulong x);
OVERLOADABLE double convert_double_rtn(ulong x);
OVERLOADABLE double convert_double_rte(long x);
OVERLOADABLE double convert_double_rtz(long x);
OVERLOADABLE double convert_double_rtp(long x);
OVERLOADABLE double convert_double_rtn(long x);
OVERLOADABLE double2 convert_double2_rte(ulong2 v);
OVERLOADABLE double2 convert_double2_rtz(ulong2 v);
OVERLOADABLE double2 convert_double2_rtp(ulong2 v);
OVERLOADABLE double2 convert_double2_rtn(ulong2 v);
OVERLOADABLE double2 convert_double2_rte(long2 v);
OVERLOADABLE double2 convert_double2_rtz(long2 v);
OVERLOADABLE double2 convert_double2_rtp(long2 v);
OVERLOADABLE double2 convert_double2_rtn(long2 v);
OVERLOADABLE double3 convert_double3_rte(ulong3 v);
OVERLOADABLE double3 convert_double3_rtz(ulong3 v);
OVERLOADABLE double3 convert_double3_rtp(ulong3 v);
OVERLOADABLE double3 convert_double3_rtn(ulong3 v);
OVERLOADABLE double3 convert_double3_rte(long3 v);
OVERLOADABLE double3 convert_double3_rtz(long3 v);
OVERLOADABLE double3 convert_double3_rtp(long3 v);
OVERLOADABLE double3 convert_double3_rtn(long3 v);
OVERLOADABLE double4 convert_double4_rte(ulong4 v);
OVERLOADABLE double4 convert_double4_rtz(ulong4 v);
OVERLOADABLE double4 convert_double4_rtp(ulong4 v);
OVERLOADABLE double4 convert_double4_rtn(ulong4 v);
OVERLOADABLE double4 convert_double4_rte(long4 v);
OVERLOADABLE double4 convert_double4_rtz(long4 v);
OVERLOADABLE double4 convert_double4_rtp(long4 v);
OVERLOADABLE double4 convert_double4_rtn(long4 v);
OVERLOADABLE double8 convert_double8_rte(ulong8 v);
OVERLOADABLE double8 convert_double8_rtz(ulong8 v);
OVERLOADABLE double8 convert_double8_rtp(ulong8 v);
OVERLOADABLE double8 convert_double8_rtn(ulong8 v);
OVERLOADABLE double8 convert_double8_rte(long8 v);
OVERLOADABLE double8 convert_double8_rtz(long8 v);
OVERLOADABLE double8 convert_double8_rtp(long8 v);
OVERLOADABLE double8 convert_double8_rtn(long8 v);
OVERLOADABLE double16 convert_double16_rte(ulong16 v);
OVERLOADABLE double16 convert_double16_rtz(ulong16 v);
OVERLOADABLE double16 convert_double16_rtp(ulong16 v);
OVERLOADABLE double16 convert_double16_rtn(ulong16 v);
OVERLOADABLE double16 convert_double16_rte(long16 v);
OVERLOADABLE double16 convert_double16_rtz(long16 v);
OVERLOADABLE double16 convert_double16_rtp(long16 v);
OVERLOADABLE double16 convert_double16_rtn(long16 v);
#endif /* __OCL_CONVERT_H__ */
