(function() {
  var SystemChecker, pathspec, spellchecker;

  spellchecker = require('spellchecker');

  pathspec = require('atom-pathspec');

  SystemChecker = (function() {
    SystemChecker.prototype.spellchecker = null;

    SystemChecker.prototype.locale = null;

    SystemChecker.prototype.enabled = true;

    SystemChecker.prototype.reason = null;

    SystemChecker.prototype.paths = null;

    function SystemChecker(locale, paths) {
      this.locale = locale;
      this.paths = paths;
    }

    SystemChecker.prototype.deactivate = function() {};

    SystemChecker.prototype.getId = function() {
      return "spell-check:" + this.locale.toLowerCase().replace("_", "-");
    };

    SystemChecker.prototype.getName = function() {
      return "System Dictionary (" + this.locale + ")";
    };

    SystemChecker.prototype.getPriority = function() {
      return 100;
    };

    SystemChecker.prototype.isEnabled = function() {
      return this.enabled;
    };

    SystemChecker.prototype.getStatus = function() {
      if (this.enabled) {
        return "Working correctly.";
      } else {
        return this.reason;
      }
    };

    SystemChecker.prototype.providesSpelling = function(args) {
      return true;
    };

    SystemChecker.prototype.providesSuggestions = function(args) {
      return true;
    };

    SystemChecker.prototype.providesAdding = function(args) {
      return false;
    };

    SystemChecker.prototype.check = function(args, text) {
      this.deferredInit();
      return this.spellchecker.checkSpellingAsync(text).then(function(incorrect) {
        return {
          invertIncorrectAsCorrect: true,
          incorrect: incorrect
        };
      });
    };

    SystemChecker.prototype.suggest = function(args, word) {
      this.deferredInit();
      return this.spellchecker.getCorrectionsForMisspelling(word);
    };

    SystemChecker.prototype.deferredInit = function() {
      var i, j, len, len1, message, noticesMode, path, ref, searchPaths, searches;
      if (this.spellchecker) {
        return;
      }
      this.spellchecker = new spellchecker.Spellchecker;
      searchPaths = [];
      if (/win32/.test(process.platform)) {
        searchPaths.push("C:\\");
      }
      ref = this.paths;
      for (i = 0, len = ref.length; i < len; i++) {
        path = ref[i];
        searchPaths.push(pathspec.getPath(path));
      }
      if (/linux/.test(process.platform)) {
        searchPaths.push("/usr/share/hunspell");
        searchPaths.push("/usr/share/myspell");
        searchPaths.push("/usr/share/myspell/dicts");
      }
      if (/darwin/.test(process.platform)) {
        searchPaths.push("/");
        searchPaths.push("/System/Library/Spelling");
      }
      searchPaths.push(spellchecker.getDictionaryPath());
      for (j = 0, len1 = searchPaths.length; j < len1; j++) {
        path = searchPaths[j];
        if (this.spellchecker.setDictionary(this.locale, path)) {
          return;
        }
      }
      this.enabled = false;
      this.reason = "Cannot load the system dictionary for `" + this.locale + "`.";
      message = "The package `spell-check` cannot load the " + "system dictionary for `" + this.locale + "`." + " See the settings for ways of changing the languages used, " + " resolving missing dictionaries, or hiding this warning.";
      searches = "\n\nThe plugin checked the following paths for dictionary files:\n* " + searchPaths.join("\n* ");
      if (/(win32|darwin)/.test(process.platform && !process.env.SPELLCHECKER_PREFER_HUNSPELL)) {
        searches = "\n\nThe plugin tried to use the system dictionaries to find the locale.";
      }
      noticesMode = atom.config.get('spell-check.noticesMode');
      if (noticesMode === "console" || noticesMode === "both") {
        console.log(this.getId(), message + searches);
      }
      if (noticesMode === "popup" || noticesMode === "both") {
        return atom.notifications.addWarning(message, {
          buttons: [
            {
              className: "btn",
              onDidClick: function() {
                return atom.workspace.open("atom://config/packages/spell-check");
              },
              text: "Settings"
            }
          ]
        });
      }
    };

    return SystemChecker;

  })();

  module.exports = SystemChecker;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
