Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var PackageUpdatesStatusView = (function () {
  function PackageUpdatesStatusView() {
    _classCallCheck(this, PackageUpdatesStatusView);
  }

  _createClass(PackageUpdatesStatusView, [{
    key: 'initialize',
    value: function initialize(statusBar, packageManager, updates) {
      var _this = this;

      this.statusBar = statusBar;
      this.updates = updates;
      this.destroyed = true;
      this.updatingPackages = [];
      this.failedUpdates = [];
      this.disposables = new _atom.CompositeDisposable();

      this.element = document.createElement('div');
      this.element.classList.add('package-updates-status-view', 'inline-block', 'text', 'text-info');

      var iconPackage = document.createElement('span');
      iconPackage.classList.add('icon', 'icon-package');
      this.element.appendChild(iconPackage);

      this.countLabel = document.createElement('span');
      this.countLabel.classList.add('available-updates-status');
      this.element.appendChild(this.countLabel);

      this.disposables.add(packageManager.on('package-update-available theme-update-available', function (_ref) {
        var pack = _ref.pack;
        var error = _ref.error;
        _this.onPackageUpdateAvailable(pack);
      }));
      this.disposables.add(packageManager.on('package-updating theme-updating', function (_ref2) {
        var pack = _ref2.pack;
        var error = _ref2.error;
        _this.onPackageUpdating(pack);
      }));
      this.disposables.add(packageManager.on('package-updated theme-updated package-uninstalled theme-uninstalled', function (_ref3) {
        var pack = _ref3.pack;
        var error = _ref3.error;
        _this.onPackageUpdated(pack);
      }));
      this.disposables.add(packageManager.on('package-update-failed theme-update-failed', function (_ref4) {
        var pack = _ref4.pack;
        var error = _ref4.error;
        _this.onPackageUpdateFailed(pack);
      }));

      var clickHandler = function clickHandler() {
        atom.commands.dispatch(atom.views.getView(atom.workspace), 'settings-view:check-for-package-updates');
      };
      this.element.addEventListener('click', clickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this.element.removeEventListener('click', clickHandler);
      }));

      this.updateTile();
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.element.remove();

      if (this.tile) {
        this.tile.destroy();
        this.tile = null;
      }

      if (this.tooltip) {
        this.tooltip.dispose();
        this.tooltip = null;
      }
    }
  }, {
    key: 'onPackageUpdateAvailable',
    value: function onPackageUpdateAvailable(pack) {
      for (var update of this.updates) {
        if (update.name === pack.name) {
          return;
        }
      }

      this.updates.push(pack);
      this.updateTile();
    }
  }, {
    key: 'onPackageUpdating',
    value: function onPackageUpdating(pack) {
      // Wipe failed status when an update is retried
      for (var index = 0; index < this.failedUpdates.length; index++) {
        var update = this.failedUpdates[index];
        if (update.name === pack.name) {
          this.failedUpdates.splice(index, 1);
        }
      }

      this.updatingPackages.push(pack);
      this.updateTile();
    }
  }, {
    key: 'onPackageUpdated',
    value: function onPackageUpdated(pack) {
      for (var index = 0; index < this.updates.length; index++) {
        var update = this.updates[index];
        if (update.name === pack.name) {
          this.updates.splice(index, 1);
        }
      }

      for (var index = 0; index < this.updatingPackages.length; index++) {
        var update = this.updatingPackages[index];
        if (update.name === pack.name) {
          this.updatingPackages.splice(index, 1);
        }
      }

      for (var index = 0; index < this.failedUpdates.length; index++) {
        var update = this.failedUpdates[index];
        if (update.name === pack.name) {
          this.failedUpdates.splice(index, 1);
        }
      }

      this.updateTile();
    }
  }, {
    key: 'onPackageUpdateFailed',
    value: function onPackageUpdateFailed(pack) {
      for (var update of this.failedUpdates) {
        if (update.name === pack.name) {
          return;
        }
      }

      for (var index = 0; index < this.updatingPackages.length; index++) {
        var update = this.updatingPackages[index];
        if (update.name === pack.name) {
          this.updatingPackages.splice(index, 1);
        }
      }

      this.failedUpdates.push(pack);
      this.updateTile();
    }
  }, {
    key: 'updateTile',
    value: function updateTile() {
      if (this.updates.length) {
        if (this.tooltip) {
          this.tooltip.dispose();
          this.tooltip = null;
        }

        if (this.destroyed) {
          // Priority of -99 should put us just to the left of the Squirrel icon, which displays when Atom has updates available
          this.tile = this.statusBar.addRightTile({ item: this, priority: -99 });
          this.destroyed = false;
        }

        var labelText = '' + _underscorePlus2['default'].pluralize(this.updates.length, 'update'); // 5 updates
        var tooltipText = _underscorePlus2['default'].pluralize(this.updates.length, 'package update') + ' available';

        if (this.updatingPackages.length) {
          labelText = this.updatingPackages.length + '/' + this.updates.length + ' updating'; // 3/5 updating
          tooltipText += ', ' + _underscorePlus2['default'].pluralize(this.updatingPackages.length, 'package') + ' currently updating';
        }

        if (this.failedUpdates.length) {
          labelText += ' (' + this.failedUpdates.length + ' failed)'; // 1 update (1 failed), or 3/5 updating (1 failed)
          tooltipText += ', ' + _underscorePlus2['default'].pluralize(this.failedUpdates.length, 'failed update');
        }

        this.countLabel.textContent = labelText;
        this.tooltip = atom.tooltips.add(this.element, { title: tooltipText });
      } else if (!this.destroyed) {
        this.tile.destroy();
        this.tile = null;
        this.destroyed = true;
      }
    }
  }]);

  return PackageUpdatesStatusView;
})();

exports['default'] = PackageUpdatesStatusView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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