(function() {
  var PropertySet, deepExtend, getValueAtKeyPath, hasKeyPath, _ref;

  deepExtend = require('underscore-plus').deepExtend;

  _ref = require('key-path-helpers'), hasKeyPath = _ref.hasKeyPath, getValueAtKeyPath = _ref.getValueAtKeyPath;

  module.exports = PropertySet = (function() {
    function PropertySet(source, selector, properties) {
      this.source = source;
      this.selector = selector;
      this.properties = properties;
      this.name = this.source;
    }

    PropertySet.prototype.matches = function(scope) {
      return this.selector.matches(scope);
    };

    PropertySet.prototype.compare = function(other) {
      return this.selector.compare(other.selector);
    };

    PropertySet.prototype.merge = function(other) {
      return new PropertySet(this.source, this.selector, deepExtend({}, other.properties, this.properties));
    };

    PropertySet.prototype.has = function(keyPath) {
      return hasKeyPath(this.properties, keyPath);
    };

    PropertySet.prototype.get = function(keyPath) {
      return getValueAtKeyPath(this.properties, keyPath);
    };

    return PropertySet;

  })();

}).call(this);
