"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _accordion = _interopRequireDefault(require("./accordion"));

var _timeago = _interopRequireDefault(require("./timeago"));

var _statusDonutChart = _interopRequireDefault(require("./status-donut-chart"));

var _queryErrorTile = _interopRequireDefault(require("./query-error-tile"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishListView extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "renderReviewsButton", () => {
      if (!this.props.needReviewsButton || this.props.total < 1) {
        return null;
      }

      return _react["default"].createElement("button", {
        className: "btn btn-primary btn-sm github-IssueishList-openReviewsButton",
        onClick: this.openReviews
      }, "See reviews");
    });

    _defineProperty(this, "openReviews", e => {
      e.stopPropagation();
      this.props.openReviews();
    });

    (0, _helpers.autobind)(this, 'renderIssueish', 'renderLoadingTile', 'renderEmptyTile', 'renderMoreTile');
  }

  render() {
    return _react["default"].createElement(_accordion["default"], {
      leftTitle: this.props.title,
      isLoading: this.props.isLoading,
      results: this.props.issueishes,
      total: this.props.total,
      loadingComponent: this.renderLoadingTile,
      emptyComponent: this.renderEmptyTile,
      moreComponent: this.renderMoreTile,
      reviewsButton: this.renderReviewsButton,
      onClickItem: this.props.onIssueishClick
    }, this.renderIssueish);
  }

  renderIssueish(issueish) {
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("img", {
      className: "github-IssueishList-item github-IssueishList-item--avatar",
      src: issueish.getAuthorAvatarURL(32),
      title: issueish.getAuthorLogin(),
      alt: issueish.getAuthorLogin()
    }), _react["default"].createElement("span", {
      className: "github-IssueishList-item github-IssueishList-item--title"
    }, issueish.getTitle()), _react["default"].createElement("span", {
      className: "github-IssueishList-item github-IssueishList-item--number"
    }, "#", issueish.getNumber()), this.renderStatusSummary(issueish.getStatusCounts()), _react["default"].createElement(_timeago["default"], {
      time: issueish.getCreatedAt(),
      displayStyle: "short",
      className: "github-IssueishList-item github-IssueishList-item--age"
    }));
  }

  renderStatusSummary(statusCounts) {
    if (['success', 'failure', 'pending'].every(kind => statusCounts[kind] === 0)) {
      return _react["default"].createElement(_octicon["default"], {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "dash"
      });
    }

    if (statusCounts.success > 0 && statusCounts.failure === 0 && statusCounts.pending === 0) {
      return _react["default"].createElement(_octicon["default"], {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "check"
      });
    }

    if (statusCounts.success === 0 && statusCounts.failure > 0 && statusCounts.pending === 0) {
      return _react["default"].createElement(_octicon["default"], {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "x"
      });
    }

    return _react["default"].createElement(_statusDonutChart["default"], _extends({}, statusCounts, {
      className: "github-IssueishList-item github-IssueishList-item--status"
    }));
  }

  renderLoadingTile() {
    return _react["default"].createElement("div", {
      className: "github-IssueishList-loading"
    }, "Loading");
  }

  renderEmptyTile() {
    if (this.props.error) {
      return _react["default"].createElement(_queryErrorTile["default"], {
        error: this.props.error
      });
    }

    if (this.props.emptyComponent) {
      const EmptyComponent = this.props.emptyComponent;
      return _react["default"].createElement(EmptyComponent, null);
    }

    return null;
  }

  renderMoreTile() {
    /* eslint-disable jsx-a11y/anchor-is-valid */
    if (this.props.onMoreClick) {
      return _react["default"].createElement("div", {
        className: "github-IssueishList-more"
      }, _react["default"].createElement("a", {
        onClick: this.props.onMoreClick
      }, "More..."));
    }

    return null;
  }

}

exports["default"] = IssueishListView;

_defineProperty(IssueishListView, "propTypes", {
  title: _propTypes["default"].string.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  total: _propTypes["default"].number.isRequired,
  issueishes: _propTypes["default"].arrayOf(_propTypes2.IssueishPropType).isRequired,
  repository: _propTypes["default"].shape({
    defaultBranchRef: _propTypes["default"].shape({
      prefix: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired
    })
  }),
  needReviewsButton: _propTypes["default"].bool,
  onIssueishClick: _propTypes["default"].func.isRequired,
  onMoreClick: _propTypes["default"].func,
  openReviews: _propTypes["default"].func,
  emptyComponent: _propTypes["default"].func,
  error: _propTypes["default"].object
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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