"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ErrorView extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderDescription');
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-Message"
    }, _react["default"].createElement("div", {
      className: "github-Message-wrapper"
    }, _react["default"].createElement("h1", {
      className: "github-Message-title"
    }, this.props.title), this.props.descriptions.map(this.renderDescription), _react["default"].createElement("div", {
      className: "github-Message-action"
    }, this.props.retry && _react["default"].createElement("button", {
      className: "github-Message-button btn btn-primary",
      onClick: this.props.retry
    }, "Try Again"), this.props.logout && _react["default"].createElement("button", {
      className: "github-Message-button btn btn-logout",
      onClick: this.props.logout
    }, "Logout"))));
  }

  renderDescription(description, key) {
    if (this.props.preformatted) {
      return _react["default"].createElement("pre", {
        key: key,
        className: "github-Message-description"
      }, description);
    } else {
      return _react["default"].createElement("p", {
        key: key,
        className: "github-Message-description"
      }, description);
    }
  }

}

exports["default"] = ErrorView;

_defineProperty(ErrorView, "propTypes", {
  title: _propTypes["default"].string,
  descriptions: _propTypes["default"].arrayOf(_propTypes["default"].string),
  preformatted: _propTypes["default"].bool,
  retry: _propTypes["default"].func,
  logout: _propTypes["default"].func
});

_defineProperty(ErrorView, "defaultProps", {
  title: 'Error',
  descriptions: ['An unknown error occurred'],
  preformatted: false
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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