"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _propTypes2 = require("../prop-types");

var _gitShellOutStrategy = require("../git-shell-out-strategy");

var _helpers = require("../helpers");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BranchMenuView extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'didSelectItem', 'createBranch', 'checkout', 'cancelCreateNewBranch');
    this.state = {
      createNew: false,
      checkedOutBranch: null
    };
  }

  render() {
    const branchNames = this.props.branches.getNames();
    let currentBranchName = this.props.currentBranch.isDetached() ? 'detached' : this.props.currentBranch.getName();

    if (this.state.checkedOutBranch) {
      currentBranchName = this.state.checkedOutBranch;

      if (branchNames.indexOf(this.state.checkedOutBranch) === -1) {
        branchNames.push(this.state.checkedOutBranch);
      }
    }

    const disableControls = !!this.state.checkedOutBranch;
    const branchEditorClasses = (0, _classnames["default"])('github-BranchMenuView-item', 'github-BranchMenuView-editor', {
      hidden: !this.state.createNew
    });
    const branchSelectListClasses = (0, _classnames["default"])('github-BranchMenuView-item', 'github-BranchMenuView-select', 'input-select', {
      hidden: !!this.state.createNew
    });
    const iconClasses = (0, _classnames["default"])('github-BranchMenuView-item', 'icon', {
      'icon-git-branch': !disableControls,
      'icon-sync': disableControls
    });

    const newBranchEditor = _react["default"].createElement("div", {
      className: branchEditorClasses
    }, _react["default"].createElement("atom-text-editor", {
      ref: e => {
        this.editorElement = e;
      },
      mini: true,
      readonly: disableControls ? true : undefined
    }));

    const selectBranchView =
    /* eslint-disable jsx-a11y/no-onchange */
    _react["default"].createElement("select", {
      className: branchSelectListClasses,
      onChange: this.didSelectItem,
      disabled: disableControls,
      value: currentBranchName
    }, this.props.currentBranch.isDetached() && _react["default"].createElement("option", {
      key: "detached",
      value: "detached",
      disabled: true
    }, this.props.currentBranch.getName()), branchNames.map(branchName => {
      return _react["default"].createElement("option", {
        key: branchName,
        value: branchName
      }, branchName);
    }));

    return _react["default"].createElement("div", {
      className: "github-BranchMenuView"
    }, _react["default"].createElement(_commands["default"], {
      registry: this.props.commandRegistry,
      target: ".github-BranchMenuView-editor atom-text-editor[mini]"
    }, _react["default"].createElement(_commands.Command, {
      command: "tool-panel:unfocus",
      callback: this.cancelCreateNewBranch
    }), _react["default"].createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.cancelCreateNewBranch
    }), _react["default"].createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.createBranch
    })), _react["default"].createElement("div", {
      className: "github-BranchMenuView-selector"
    }, _react["default"].createElement("span", {
      className: iconClasses
    }), newBranchEditor, selectBranchView, _react["default"].createElement("button", {
      className: "github-BranchMenuView-item github-BranchMenuView-button btn",
      onClick: this.createBranch,
      disabled: disableControls
    }, " New Branch ")));
  }

  async didSelectItem(event) {
    const branchName = event.target.value;
    await this.checkout(branchName);
  }

  async createBranch() {
    if (this.state.createNew) {
      const branchName = this.editorElement.getModel().getText().trim();
      await this.checkout(branchName, {
        createNew: true
      });
    } else {
      await new Promise(resolve => {
        this.setState({
          createNew: true
        }, () => {
          this.editorElement.focus();
          resolve();
        });
      });
    }
  }

  async checkout(branchName, options) {
    this.editorElement.classList.remove('is-focused');
    await new Promise(resolve => {
      this.setState({
        checkedOutBranch: branchName
      }, resolve);
    });

    try {
      await this.props.checkout(branchName, options);
      await new Promise(resolve => {
        this.setState({
          checkedOutBranch: null,
          createNew: false
        }, resolve);
      });
      this.editorElement.getModel().setText('');
    } catch (error) {
      this.editorElement.classList.add('is-focused');
      await new Promise(resolve => {
        this.setState({
          checkedOutBranch: null
        }, resolve);
      });

      if (!(error instanceof _gitShellOutStrategy.GitError)) {
        throw error;
      }
    }
  }

  cancelCreateNewBranch() {
    this.setState({
      createNew: false
    });
  }

}

exports["default"] = BranchMenuView;

_defineProperty(BranchMenuView, "propTypes", {
  workspace: _propTypes["default"].object.isRequired,
  commandRegistry: _propTypes["default"].object.isRequired,
  notificationManager: _propTypes["default"].object.isRequired,
  repository: _propTypes["default"].object,
  branches: _propTypes2.BranchSetPropType.isRequired,
  currentBranch: _propTypes2.BranchPropType.isRequired,
  checkout: _propTypes["default"].func
});

_defineProperty(BranchMenuView, "defaultProps", {
  checkout: () => Promise.resolve()
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImJyYW5jaC1tZW51LXZpZXcuanMiXSwibmFtZXMiOlsiQnJhbmNoTWVudVZpZXciLCJSZWFjdCIsIkNvbXBvbmVudCIsImNvbnN0cnVjdG9yIiwicHJvcHMiLCJjb250ZXh0Iiwic3RhdGUiLCJjcmVhdGVOZXciLCJjaGVja2VkT3V0QnJhbmNoIiwicmVuZGVyIiwiYnJhbmNoTmFtZXMiLCJicmFuY2hlcyIsImdldE5hbWVzIiwiY3VycmVudEJyYW5jaE5hbWUiLCJjdXJyZW50QnJhbmNoIiwiaXNEZXRhY2hlZCIsImdldE5hbWUiLCJpbmRleE9mIiwicHVzaCIsImRpc2FibGVDb250cm9scyIsImJyYW5jaEVkaXRvckNsYXNzZXMiLCJoaWRkZW4iLCJicmFuY2hTZWxlY3RMaXN0Q2xhc3NlcyIsImljb25DbGFzc2VzIiwibmV3QnJhbmNoRWRpdG9yIiwiZSIsImVkaXRvckVsZW1lbnQiLCJ1bmRlZmluZWQiLCJzZWxlY3RCcmFuY2hWaWV3IiwiZGlkU2VsZWN0SXRlbSIsIm1hcCIsImJyYW5jaE5hbWUiLCJjb21tYW5kUmVnaXN0cnkiLCJjYW5jZWxDcmVhdGVOZXdCcmFuY2giLCJjcmVhdGVCcmFuY2giLCJldmVudCIsInRhcmdldCIsInZhbHVlIiwiY2hlY2tvdXQiLCJnZXRNb2RlbCIsImdldFRleHQiLCJ0cmltIiwiUHJvbWlzZSIsInJlc29sdmUiLCJzZXRTdGF0ZSIsImZvY3VzIiwib3B0aW9ucyIsImNsYXNzTGlzdCIsInJlbW92ZSIsInNldFRleHQiLCJlcnJvciIsImFkZCIsIkdpdEVycm9yIiwid29ya3NwYWNlIiwiUHJvcFR5cGVzIiwib2JqZWN0IiwiaXNSZXF1aXJlZCIsIm5vdGlmaWNhdGlvbk1hbmFnZXIiLCJyZXBvc2l0b3J5IiwiQnJhbmNoU2V0UHJvcFR5cGUiLCJCcmFuY2hQcm9wVHlwZSIsImZ1bmMiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFDQTs7QUFDQTs7QUFFQTs7QUFDQTs7QUFDQTs7QUFDQTs7Ozs7Ozs7QUFFZSxNQUFNQSxjQUFOLFNBQTZCQyxrQkFBTUMsU0FBbkMsQ0FBNkM7QUFlMURDLEVBQUFBLFdBQVcsQ0FBQ0MsS0FBRCxFQUFRQyxPQUFSLEVBQWlCO0FBQzFCLFVBQU1ELEtBQU4sRUFBYUMsT0FBYjtBQUNBLDJCQUFTLElBQVQsRUFBZSxlQUFmLEVBQWdDLGNBQWhDLEVBQWdELFVBQWhELEVBQTRELHVCQUE1RDtBQUVBLFNBQUtDLEtBQUwsR0FBYTtBQUNYQyxNQUFBQSxTQUFTLEVBQUUsS0FEQTtBQUVYQyxNQUFBQSxnQkFBZ0IsRUFBRTtBQUZQLEtBQWI7QUFJRDs7QUFFREMsRUFBQUEsTUFBTSxHQUFHO0FBQ1AsVUFBTUMsV0FBVyxHQUFHLEtBQUtOLEtBQUwsQ0FBV08sUUFBWCxDQUFvQkMsUUFBcEIsRUFBcEI7QUFDQSxRQUFJQyxpQkFBaUIsR0FBRyxLQUFLVCxLQUFMLENBQVdVLGFBQVgsQ0FBeUJDLFVBQXpCLEtBQXdDLFVBQXhDLEdBQXFELEtBQUtYLEtBQUwsQ0FBV1UsYUFBWCxDQUF5QkUsT0FBekIsRUFBN0U7O0FBQ0EsUUFBSSxLQUFLVixLQUFMLENBQVdFLGdCQUFmLEVBQWlDO0FBQy9CSyxNQUFBQSxpQkFBaUIsR0FBRyxLQUFLUCxLQUFMLENBQVdFLGdCQUEvQjs7QUFDQSxVQUFJRSxXQUFXLENBQUNPLE9BQVosQ0FBb0IsS0FBS1gsS0FBTCxDQUFXRSxnQkFBL0IsTUFBcUQsQ0FBQyxDQUExRCxFQUE2RDtBQUMzREUsUUFBQUEsV0FBVyxDQUFDUSxJQUFaLENBQWlCLEtBQUtaLEtBQUwsQ0FBV0UsZ0JBQTVCO0FBQ0Q7QUFDRjs7QUFFRCxVQUFNVyxlQUFlLEdBQUcsQ0FBQyxDQUFDLEtBQUtiLEtBQUwsQ0FBV0UsZ0JBQXJDO0FBRUEsVUFBTVksbUJBQW1CLEdBQUcsNEJBQUcsNEJBQUgsRUFBaUMsOEJBQWpDLEVBQWlFO0FBQzNGQyxNQUFBQSxNQUFNLEVBQUUsQ0FBQyxLQUFLZixLQUFMLENBQVdDO0FBRHVFLEtBQWpFLENBQTVCO0FBSUEsVUFBTWUsdUJBQXVCLEdBQUcsNEJBQUcsNEJBQUgsRUFBaUMsOEJBQWpDLEVBQWlFLGNBQWpFLEVBQWlGO0FBQy9HRCxNQUFBQSxNQUFNLEVBQUUsQ0FBQyxDQUFDLEtBQUtmLEtBQUwsQ0FBV0M7QUFEMEYsS0FBakYsQ0FBaEM7QUFJQSxVQUFNZ0IsV0FBVyxHQUFHLDRCQUFHLDRCQUFILEVBQWlDLE1BQWpDLEVBQXlDO0FBQzNELHlCQUFtQixDQUFDSixlQUR1QztBQUUzRCxtQkFBYUE7QUFGOEMsS0FBekMsQ0FBcEI7O0FBS0EsVUFBTUssZUFBZSxHQUNuQjtBQUFLLE1BQUEsU0FBUyxFQUFFSjtBQUFoQixPQUNFO0FBQ0UsTUFBQSxHQUFHLEVBQUVLLENBQUMsSUFBSTtBQUFFLGFBQUtDLGFBQUwsR0FBcUJELENBQXJCO0FBQXlCLE9BRHZDO0FBRUUsTUFBQSxJQUFJLEVBQUUsSUFGUjtBQUdFLE1BQUEsUUFBUSxFQUFFTixlQUFlLEdBQUcsSUFBSCxHQUFVUTtBQUhyQyxNQURGLENBREY7O0FBVUEsVUFBTUMsZ0JBQWdCO0FBQ3BCO0FBQ0E7QUFDRSxNQUFBLFNBQVMsRUFBRU4sdUJBRGI7QUFFRSxNQUFBLFFBQVEsRUFBRSxLQUFLTyxhQUZqQjtBQUdFLE1BQUEsUUFBUSxFQUFFVixlQUhaO0FBSUUsTUFBQSxLQUFLLEVBQUVOO0FBSlQsT0FLRyxLQUFLVCxLQUFMLENBQVdVLGFBQVgsQ0FBeUJDLFVBQXpCLE1BQ0M7QUFBUSxNQUFBLEdBQUcsRUFBQyxVQUFaO0FBQXVCLE1BQUEsS0FBSyxFQUFDLFVBQTdCO0FBQXdDLE1BQUEsUUFBUTtBQUFoRCxPQUFrRCxLQUFLWCxLQUFMLENBQVdVLGFBQVgsQ0FBeUJFLE9BQXpCLEVBQWxELENBTkosRUFRR04sV0FBVyxDQUFDb0IsR0FBWixDQUFnQkMsVUFBVSxJQUFJO0FBQzdCLGFBQU87QUFBUSxRQUFBLEdBQUcsRUFBRUEsVUFBYjtBQUF5QixRQUFBLEtBQUssRUFBRUE7QUFBaEMsU0FBNkNBLFVBQTdDLENBQVA7QUFDRCxLQUZBLENBUkgsQ0FGRjs7QUFnQkEsV0FDRTtBQUFLLE1BQUEsU0FBUyxFQUFDO0FBQWYsT0FDRSxnQ0FBQyxvQkFBRDtBQUFVLE1BQUEsUUFBUSxFQUFFLEtBQUszQixLQUFMLENBQVc0QixlQUEvQjtBQUFnRCxNQUFBLE1BQU0sRUFBQztBQUF2RCxPQUNFLGdDQUFDLGlCQUFEO0FBQVMsTUFBQSxPQUFPLEVBQUMsb0JBQWpCO0FBQXNDLE1BQUEsUUFBUSxFQUFFLEtBQUtDO0FBQXJELE1BREYsRUFFRSxnQ0FBQyxpQkFBRDtBQUFTLE1BQUEsT0FBTyxFQUFDLGFBQWpCO0FBQStCLE1BQUEsUUFBUSxFQUFFLEtBQUtBO0FBQTlDLE1BRkYsRUFHRSxnQ0FBQyxpQkFBRDtBQUFTLE1BQUEsT0FBTyxFQUFDLGNBQWpCO0FBQWdDLE1BQUEsUUFBUSxFQUFFLEtBQUtDO0FBQS9DLE1BSEYsQ0FERixFQU1FO0FBQUssTUFBQSxTQUFTLEVBQUM7QUFBZixPQUNFO0FBQU0sTUFBQSxTQUFTLEVBQUVYO0FBQWpCLE1BREYsRUFFR0MsZUFGSCxFQUdHSSxnQkFISCxFQUlFO0FBQVEsTUFBQSxTQUFTLEVBQUMsNkRBQWxCO0FBQ0UsTUFBQSxPQUFPLEVBQUUsS0FBS00sWUFEaEI7QUFDOEIsTUFBQSxRQUFRLEVBQUVmO0FBRHhDLHNCQUpGLENBTkYsQ0FERjtBQWdCRDs7QUFFRCxRQUFNVSxhQUFOLENBQW9CTSxLQUFwQixFQUEyQjtBQUN6QixVQUFNSixVQUFVLEdBQUdJLEtBQUssQ0FBQ0MsTUFBTixDQUFhQyxLQUFoQztBQUNBLFVBQU0sS0FBS0MsUUFBTCxDQUFjUCxVQUFkLENBQU47QUFDRDs7QUFFRCxRQUFNRyxZQUFOLEdBQXFCO0FBQ25CLFFBQUksS0FBSzVCLEtBQUwsQ0FBV0MsU0FBZixFQUEwQjtBQUN4QixZQUFNd0IsVUFBVSxHQUFHLEtBQUtMLGFBQUwsQ0FBbUJhLFFBQW5CLEdBQThCQyxPQUE5QixHQUF3Q0MsSUFBeEMsRUFBbkI7QUFDQSxZQUFNLEtBQUtILFFBQUwsQ0FBY1AsVUFBZCxFQUEwQjtBQUFDeEIsUUFBQUEsU0FBUyxFQUFFO0FBQVosT0FBMUIsQ0FBTjtBQUNELEtBSEQsTUFHTztBQUNMLFlBQU0sSUFBSW1DLE9BQUosQ0FBWUMsT0FBTyxJQUFJO0FBQzNCLGFBQUtDLFFBQUwsQ0FBYztBQUFDckMsVUFBQUEsU0FBUyxFQUFFO0FBQVosU0FBZCxFQUFpQyxNQUFNO0FBQ3JDLGVBQUttQixhQUFMLENBQW1CbUIsS0FBbkI7QUFDQUYsVUFBQUEsT0FBTztBQUNSLFNBSEQ7QUFJRCxPQUxLLENBQU47QUFNRDtBQUNGOztBQUVELFFBQU1MLFFBQU4sQ0FBZVAsVUFBZixFQUEyQmUsT0FBM0IsRUFBb0M7QUFDbEMsU0FBS3BCLGFBQUwsQ0FBbUJxQixTQUFuQixDQUE2QkMsTUFBN0IsQ0FBb0MsWUFBcEM7QUFDQSxVQUFNLElBQUlOLE9BQUosQ0FBWUMsT0FBTyxJQUFJO0FBQzNCLFdBQUtDLFFBQUwsQ0FBYztBQUFDcEMsUUFBQUEsZ0JBQWdCLEVBQUV1QjtBQUFuQixPQUFkLEVBQThDWSxPQUE5QztBQUNELEtBRkssQ0FBTjs7QUFHQSxRQUFJO0FBQ0YsWUFBTSxLQUFLdkMsS0FBTCxDQUFXa0MsUUFBWCxDQUFvQlAsVUFBcEIsRUFBZ0NlLE9BQWhDLENBQU47QUFDQSxZQUFNLElBQUlKLE9BQUosQ0FBWUMsT0FBTyxJQUFJO0FBQzNCLGFBQUtDLFFBQUwsQ0FBYztBQUFDcEMsVUFBQUEsZ0JBQWdCLEVBQUUsSUFBbkI7QUFBeUJELFVBQUFBLFNBQVMsRUFBRTtBQUFwQyxTQUFkLEVBQTBEb0MsT0FBMUQ7QUFDRCxPQUZLLENBQU47QUFHQSxXQUFLakIsYUFBTCxDQUFtQmEsUUFBbkIsR0FBOEJVLE9BQTlCLENBQXNDLEVBQXRDO0FBQ0QsS0FORCxDQU1FLE9BQU9DLEtBQVAsRUFBYztBQUNkLFdBQUt4QixhQUFMLENBQW1CcUIsU0FBbkIsQ0FBNkJJLEdBQTdCLENBQWlDLFlBQWpDO0FBQ0EsWUFBTSxJQUFJVCxPQUFKLENBQVlDLE9BQU8sSUFBSTtBQUMzQixhQUFLQyxRQUFMLENBQWM7QUFBQ3BDLFVBQUFBLGdCQUFnQixFQUFFO0FBQW5CLFNBQWQsRUFBd0NtQyxPQUF4QztBQUNELE9BRkssQ0FBTjs7QUFHQSxVQUFJLEVBQUVPLEtBQUssWUFBWUUsNkJBQW5CLENBQUosRUFBa0M7QUFDaEMsY0FBTUYsS0FBTjtBQUNEO0FBQ0Y7QUFDRjs7QUFFRGpCLEVBQUFBLHFCQUFxQixHQUFHO0FBQ3RCLFNBQUtXLFFBQUwsQ0FBYztBQUFDckMsTUFBQUEsU0FBUyxFQUFFO0FBQVosS0FBZDtBQUNEOztBQXpJeUQ7Ozs7Z0JBQXZDUCxjLGVBQ0E7QUFDakJxRCxFQUFBQSxTQUFTLEVBQUVDLHNCQUFVQyxNQUFWLENBQWlCQyxVQURYO0FBRWpCeEIsRUFBQUEsZUFBZSxFQUFFc0Isc0JBQVVDLE1BQVYsQ0FBaUJDLFVBRmpCO0FBR2pCQyxFQUFBQSxtQkFBbUIsRUFBRUgsc0JBQVVDLE1BQVYsQ0FBaUJDLFVBSHJCO0FBSWpCRSxFQUFBQSxVQUFVLEVBQUVKLHNCQUFVQyxNQUpMO0FBS2pCNUMsRUFBQUEsUUFBUSxFQUFFZ0QsOEJBQWtCSCxVQUxYO0FBTWpCMUMsRUFBQUEsYUFBYSxFQUFFOEMsMkJBQWVKLFVBTmI7QUFPakJsQixFQUFBQSxRQUFRLEVBQUVnQixzQkFBVU87QUFQSCxDOztnQkFEQTdELGMsa0JBV0c7QUFDcEJzQyxFQUFBQSxRQUFRLEVBQUUsTUFBTUksT0FBTyxDQUFDQyxPQUFSO0FBREksQyIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjM3LjAvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgY3ggZnJvbSAnY2xhc3NuYW1lcyc7XG5cbmltcG9ydCBDb21tYW5kcywge0NvbW1hbmR9IGZyb20gJy4uL2F0b20vY29tbWFuZHMnO1xuaW1wb3J0IHtCcmFuY2hQcm9wVHlwZSwgQnJhbmNoU2V0UHJvcFR5cGV9IGZyb20gJy4uL3Byb3AtdHlwZXMnO1xuaW1wb3J0IHtHaXRFcnJvcn0gZnJvbSAnLi4vZ2l0LXNoZWxsLW91dC1zdHJhdGVneSc7XG5pbXBvcnQge2F1dG9iaW5kfSBmcm9tICcuLi9oZWxwZXJzJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgQnJhbmNoTWVudVZpZXcgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIHdvcmtzcGFjZTogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIGNvbW1hbmRSZWdpc3RyeTogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIG5vdGlmaWNhdGlvbk1hbmFnZXI6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICByZXBvc2l0b3J5OiBQcm9wVHlwZXMub2JqZWN0LFxuICAgIGJyYW5jaGVzOiBCcmFuY2hTZXRQcm9wVHlwZS5pc1JlcXVpcmVkLFxuICAgIGN1cnJlbnRCcmFuY2g6IEJyYW5jaFByb3BUeXBlLmlzUmVxdWlyZWQsXG4gICAgY2hlY2tvdXQ6IFByb3BUeXBlcy5mdW5jLFxuICB9XG5cbiAgc3RhdGljIGRlZmF1bHRQcm9wcyA9IHtcbiAgICBjaGVja291dDogKCkgPT4gUHJvbWlzZS5yZXNvbHZlKCksXG4gIH1cblxuICBjb25zdHJ1Y3Rvcihwcm9wcywgY29udGV4dCkge1xuICAgIHN1cGVyKHByb3BzLCBjb250ZXh0KTtcbiAgICBhdXRvYmluZCh0aGlzLCAnZGlkU2VsZWN0SXRlbScsICdjcmVhdGVCcmFuY2gnLCAnY2hlY2tvdXQnLCAnY2FuY2VsQ3JlYXRlTmV3QnJhbmNoJyk7XG5cbiAgICB0aGlzLnN0YXRlID0ge1xuICAgICAgY3JlYXRlTmV3OiBmYWxzZSxcbiAgICAgIGNoZWNrZWRPdXRCcmFuY2g6IG51bGwsXG4gICAgfTtcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICBjb25zdCBicmFuY2hOYW1lcyA9IHRoaXMucHJvcHMuYnJhbmNoZXMuZ2V0TmFtZXMoKTtcbiAgICBsZXQgY3VycmVudEJyYW5jaE5hbWUgPSB0aGlzLnByb3BzLmN1cnJlbnRCcmFuY2guaXNEZXRhY2hlZCgpID8gJ2RldGFjaGVkJyA6IHRoaXMucHJvcHMuY3VycmVudEJyYW5jaC5nZXROYW1lKCk7XG4gICAgaWYgKHRoaXMuc3RhdGUuY2hlY2tlZE91dEJyYW5jaCkge1xuICAgICAgY3VycmVudEJyYW5jaE5hbWUgPSB0aGlzLnN0YXRlLmNoZWNrZWRPdXRCcmFuY2g7XG4gICAgICBpZiAoYnJhbmNoTmFtZXMuaW5kZXhPZih0aGlzLnN0YXRlLmNoZWNrZWRPdXRCcmFuY2gpID09PSAtMSkge1xuICAgICAgICBicmFuY2hOYW1lcy5wdXNoKHRoaXMuc3RhdGUuY2hlY2tlZE91dEJyYW5jaCk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgY29uc3QgZGlzYWJsZUNvbnRyb2xzID0gISF0aGlzLnN0YXRlLmNoZWNrZWRPdXRCcmFuY2g7XG5cbiAgICBjb25zdCBicmFuY2hFZGl0b3JDbGFzc2VzID0gY3goJ2dpdGh1Yi1CcmFuY2hNZW51Vmlldy1pdGVtJywgJ2dpdGh1Yi1CcmFuY2hNZW51Vmlldy1lZGl0b3InLCB7XG4gICAgICBoaWRkZW46ICF0aGlzLnN0YXRlLmNyZWF0ZU5ldyxcbiAgICB9KTtcblxuICAgIGNvbnN0IGJyYW5jaFNlbGVjdExpc3RDbGFzc2VzID0gY3goJ2dpdGh1Yi1CcmFuY2hNZW51Vmlldy1pdGVtJywgJ2dpdGh1Yi1CcmFuY2hNZW51Vmlldy1zZWxlY3QnLCAnaW5wdXQtc2VsZWN0Jywge1xuICAgICAgaGlkZGVuOiAhIXRoaXMuc3RhdGUuY3JlYXRlTmV3LFxuICAgIH0pO1xuXG4gICAgY29uc3QgaWNvbkNsYXNzZXMgPSBjeCgnZ2l0aHViLUJyYW5jaE1lbnVWaWV3LWl0ZW0nLCAnaWNvbicsIHtcbiAgICAgICdpY29uLWdpdC1icmFuY2gnOiAhZGlzYWJsZUNvbnRyb2xzLFxuICAgICAgJ2ljb24tc3luYyc6IGRpc2FibGVDb250cm9scyxcbiAgICB9KTtcblxuICAgIGNvbnN0IG5ld0JyYW5jaEVkaXRvciA9IChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPXticmFuY2hFZGl0b3JDbGFzc2VzfT5cbiAgICAgICAgPGF0b20tdGV4dC1lZGl0b3JcbiAgICAgICAgICByZWY9e2UgPT4geyB0aGlzLmVkaXRvckVsZW1lbnQgPSBlOyB9fVxuICAgICAgICAgIG1pbmk9e3RydWV9XG4gICAgICAgICAgcmVhZG9ubHk9e2Rpc2FibGVDb250cm9scyA/IHRydWUgOiB1bmRlZmluZWR9XG4gICAgICAgIC8+XG4gICAgICA8L2Rpdj5cbiAgICApO1xuXG4gICAgY29uc3Qgc2VsZWN0QnJhbmNoVmlldyA9IChcbiAgICAgIC8qIGVzbGludC1kaXNhYmxlIGpzeC1hMTF5L25vLW9uY2hhbmdlICovXG4gICAgICA8c2VsZWN0XG4gICAgICAgIGNsYXNzTmFtZT17YnJhbmNoU2VsZWN0TGlzdENsYXNzZXN9XG4gICAgICAgIG9uQ2hhbmdlPXt0aGlzLmRpZFNlbGVjdEl0ZW19XG4gICAgICAgIGRpc2FibGVkPXtkaXNhYmxlQ29udHJvbHN9XG4gICAgICAgIHZhbHVlPXtjdXJyZW50QnJhbmNoTmFtZX0+XG4gICAgICAgIHt0aGlzLnByb3BzLmN1cnJlbnRCcmFuY2guaXNEZXRhY2hlZCgpICYmXG4gICAgICAgICAgPG9wdGlvbiBrZXk9XCJkZXRhY2hlZFwiIHZhbHVlPVwiZGV0YWNoZWRcIiBkaXNhYmxlZD57dGhpcy5wcm9wcy5jdXJyZW50QnJhbmNoLmdldE5hbWUoKX08L29wdGlvbj5cbiAgICAgICAgfVxuICAgICAgICB7YnJhbmNoTmFtZXMubWFwKGJyYW5jaE5hbWUgPT4ge1xuICAgICAgICAgIHJldHVybiA8b3B0aW9uIGtleT17YnJhbmNoTmFtZX0gdmFsdWU9e2JyYW5jaE5hbWV9PnticmFuY2hOYW1lfTwvb3B0aW9uPjtcbiAgICAgICAgfSl9XG4gICAgICA8L3NlbGVjdD5cbiAgICApO1xuXG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPVwiZ2l0aHViLUJyYW5jaE1lbnVWaWV3XCI+XG4gICAgICAgIDxDb21tYW5kcyByZWdpc3RyeT17dGhpcy5wcm9wcy5jb21tYW5kUmVnaXN0cnl9IHRhcmdldD1cIi5naXRodWItQnJhbmNoTWVudVZpZXctZWRpdG9yIGF0b20tdGV4dC1lZGl0b3JbbWluaV1cIj5cbiAgICAgICAgICA8Q29tbWFuZCBjb21tYW5kPVwidG9vbC1wYW5lbDp1bmZvY3VzXCIgY2FsbGJhY2s9e3RoaXMuY2FuY2VsQ3JlYXRlTmV3QnJhbmNofSAvPlxuICAgICAgICAgIDxDb21tYW5kIGNvbW1hbmQ9XCJjb3JlOmNhbmNlbFwiIGNhbGxiYWNrPXt0aGlzLmNhbmNlbENyZWF0ZU5ld0JyYW5jaH0gLz5cbiAgICAgICAgICA8Q29tbWFuZCBjb21tYW5kPVwiY29yZTpjb25maXJtXCIgY2FsbGJhY2s9e3RoaXMuY3JlYXRlQnJhbmNofSAvPlxuICAgICAgICA8L0NvbW1hbmRzPlxuICAgICAgICA8ZGl2IGNsYXNzTmFtZT1cImdpdGh1Yi1CcmFuY2hNZW51Vmlldy1zZWxlY3RvclwiPlxuICAgICAgICAgIDxzcGFuIGNsYXNzTmFtZT17aWNvbkNsYXNzZXN9IC8+XG4gICAgICAgICAge25ld0JyYW5jaEVkaXRvcn1cbiAgICAgICAgICB7c2VsZWN0QnJhbmNoVmlld31cbiAgICAgICAgICA8YnV0dG9uIGNsYXNzTmFtZT1cImdpdGh1Yi1CcmFuY2hNZW51Vmlldy1pdGVtIGdpdGh1Yi1CcmFuY2hNZW51Vmlldy1idXR0b24gYnRuXCJcbiAgICAgICAgICAgIG9uQ2xpY2s9e3RoaXMuY3JlYXRlQnJhbmNofSBkaXNhYmxlZD17ZGlzYWJsZUNvbnRyb2xzfT4gTmV3IEJyYW5jaCA8L2J1dHRvbj5cbiAgICAgICAgPC9kaXY+XG4gICAgICA8L2Rpdj5cbiAgICApO1xuICB9XG5cbiAgYXN5bmMgZGlkU2VsZWN0SXRlbShldmVudCkge1xuICAgIGNvbnN0IGJyYW5jaE5hbWUgPSBldmVudC50YXJnZXQudmFsdWU7XG4gICAgYXdhaXQgdGhpcy5jaGVja291dChicmFuY2hOYW1lKTtcbiAgfVxuXG4gIGFzeW5jIGNyZWF0ZUJyYW5jaCgpIHtcbiAgICBpZiAodGhpcy5zdGF0ZS5jcmVhdGVOZXcpIHtcbiAgICAgIGNvbnN0IGJyYW5jaE5hbWUgPSB0aGlzLmVkaXRvckVsZW1lbnQuZ2V0TW9kZWwoKS5nZXRUZXh0KCkudHJpbSgpO1xuICAgICAgYXdhaXQgdGhpcy5jaGVja291dChicmFuY2hOYW1lLCB7Y3JlYXRlTmV3OiB0cnVlfSk7XG4gICAgfSBlbHNlIHtcbiAgICAgIGF3YWl0IG5ldyBQcm9taXNlKHJlc29sdmUgPT4ge1xuICAgICAgICB0aGlzLnNldFN0YXRlKHtjcmVhdGVOZXc6IHRydWV9LCAoKSA9PiB7XG4gICAgICAgICAgdGhpcy5lZGl0b3JFbGVtZW50LmZvY3VzKCk7XG4gICAgICAgICAgcmVzb2x2ZSgpO1xuICAgICAgICB9KTtcbiAgICAgIH0pO1xuICAgIH1cbiAgfVxuXG4gIGFzeW5jIGNoZWNrb3V0KGJyYW5jaE5hbWUsIG9wdGlvbnMpIHtcbiAgICB0aGlzLmVkaXRvckVsZW1lbnQuY2xhc3NMaXN0LnJlbW92ZSgnaXMtZm9jdXNlZCcpO1xuICAgIGF3YWl0IG5ldyBQcm9taXNlKHJlc29sdmUgPT4ge1xuICAgICAgdGhpcy5zZXRTdGF0ZSh7Y2hlY2tlZE91dEJyYW5jaDogYnJhbmNoTmFtZX0sIHJlc29sdmUpO1xuICAgIH0pO1xuICAgIHRyeSB7XG4gICAgICBhd2FpdCB0aGlzLnByb3BzLmNoZWNrb3V0KGJyYW5jaE5hbWUsIG9wdGlvbnMpO1xuICAgICAgYXdhaXQgbmV3IFByb21pc2UocmVzb2x2ZSA9PiB7XG4gICAgICAgIHRoaXMuc2V0U3RhdGUoe2NoZWNrZWRPdXRCcmFuY2g6IG51bGwsIGNyZWF0ZU5ldzogZmFsc2V9LCByZXNvbHZlKTtcbiAgICAgIH0pO1xuICAgICAgdGhpcy5lZGl0b3JFbGVtZW50LmdldE1vZGVsKCkuc2V0VGV4dCgnJyk7XG4gICAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICAgIHRoaXMuZWRpdG9yRWxlbWVudC5jbGFzc0xpc3QuYWRkKCdpcy1mb2N1c2VkJyk7XG4gICAgICBhd2FpdCBuZXcgUHJvbWlzZShyZXNvbHZlID0+IHtcbiAgICAgICAgdGhpcy5zZXRTdGF0ZSh7Y2hlY2tlZE91dEJyYW5jaDogbnVsbH0sIHJlc29sdmUpO1xuICAgICAgfSk7XG4gICAgICBpZiAoIShlcnJvciBpbnN0YW5jZW9mIEdpdEVycm9yKSkge1xuICAgICAgICB0aHJvdyBlcnJvcjtcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICBjYW5jZWxDcmVhdGVOZXdCcmFuY2goKSB7XG4gICAgdGhpcy5zZXRTdGF0ZSh7Y3JlYXRlTmV3OiBmYWxzZX0pO1xuICB9XG59XG4iXX0=