/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.quicktime;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.imageio.stream.ImageOutputStreamImpl;

public class DataAtomOutputStream
extends FilterOutputStream {
    ImageOutputStreamImpl impl;
    protected static final long MAC_TIMESTAMP_EPOCH = new GregorianCalendar(1904, 0, 1).getTimeInMillis();
    protected long written;
    private byte[] byteBuf = new byte[3];

    public DataAtomOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void writeType(String string) throws IOException {
        if (string.length() != 4) {
            throw new IllegalArgumentException("type string must have 4 characters");
        }
        try {
            this.out.write(string.getBytes("ASCII"), 0, 4);
            this.incCount(4);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(unsupportedEncodingException.toString());
        }
    }

    public final void writeByte(int n) throws IOException {
        this.out.write(n);
        this.incCount(1);
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.incCount(n2);
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.out.write(n);
        this.incCount(1);
    }

    public void writeInt(int n) throws IOException {
        this.out.write(n >>> 24 & 0xFF);
        this.out.write(n >>> 16 & 0xFF);
        this.out.write(n >>> 8 & 0xFF);
        this.out.write(n >>> 0 & 0xFF);
        this.incCount(4);
    }

    public void writeUInt(long l) throws IOException {
        this.out.write((int)(l >>> 24 & 0xFFL));
        this.out.write((int)(l >>> 16 & 0xFFL));
        this.out.write((int)(l >>> 8 & 0xFFL));
        this.out.write((int)(l >>> 0 & 0xFFL));
        this.incCount(4);
    }

    public void writeShort(int n) throws IOException {
        this.out.write(n >> 8 & 0xFF);
        this.out.write(n >>> 0 & 0xFF);
        this.incCount(2);
    }

    public void writeBCD2(int n) throws IOException {
        this.out.write(n % 100 / 10 << 4 | n % 10);
        this.incCount(1);
    }

    public void writeBCD4(int n) throws IOException {
        this.out.write(n % 10000 / 1000 << 4 | n % 1000 / 100);
        this.out.write(n % 100 / 10 << 4 | n % 10);
        this.incCount(2);
    }

    public void writeMacTimestamp(Date date) throws IOException {
        long l = date.getTime();
        long l2 = l - MAC_TIMESTAMP_EPOCH;
        long l3 = l2 / 1000L;
        this.writeUInt(l3);
    }

    public void writeFixed16D16(double d) throws IOException {
        double d2 = d >= 0.0 ? d : -d;
        int n = (int)Math.floor(d2);
        int n2 = (int)((d2 - (double)n) * 65536.0);
        int n3 = (n << 16) + n2;
        if (d < 0.0) {
            --n3;
        }
        this.writeInt(n3);
    }

    public void writeFixed2D30(double d) throws IOException {
        double d2 = d >= 0.0 ? d : -d;
        int n = (int)d2;
        int n2 = (int)((d2 - (double)n) * 1.073741824E9);
        int n3 = (n << 30) + n2;
        if (d < 0.0) {
            --n3;
        }
        this.writeInt(n3);
    }

    public void writeFixed8D8(float f) throws IOException {
        float f2 = f >= 0.0f ? f : -f;
        int n = (int)f2;
        int n2 = (int)((f2 - (float)n) * 256.0f);
        int n3 = (n << 8) + n2;
        if (f < 0.0f) {
            --n3;
        }
        this.writeUShort(n3);
    }

    public void writePString(String string) throws IOException {
        if (string.length() > 65535) {
            throw new IllegalArgumentException("String too long for PString");
        }
        if (string.length() != 0 && string.length() < 256) {
            this.out.write(string.length());
        } else {
            this.out.write(0);
            this.writeShort(string.length());
        }
        int n = 0;
        while (n < string.length()) {
            this.out.write(string.charAt(n));
            ++n;
        }
        this.incCount(1 + string.length());
    }

    public void writePString(String string, int n) throws IOException {
        if (string.length() > n) {
            throw new IllegalArgumentException("String too long for PString of length " + n);
        }
        if (string.length() != 0 && string.length() < 256) {
            this.out.write(string.length());
        } else {
            this.out.write(0);
            this.writeShort(string.length());
        }
        int n2 = 0;
        while (n2 < string.length()) {
            this.out.write(string.charAt(n2));
            ++n2;
        }
        n2 = 1 + string.length();
        while (n2 < n) {
            this.out.write(0);
            ++n2;
        }
        this.incCount(n);
    }

    public void writeLong(long l) throws IOException {
        this.out.write((int)(l >>> 56) & 0xFF);
        this.out.write((int)(l >>> 48) & 0xFF);
        this.out.write((int)(l >>> 40) & 0xFF);
        this.out.write((int)(l >>> 32) & 0xFF);
        this.out.write((int)(l >>> 24) & 0xFF);
        this.out.write((int)(l >>> 16) & 0xFF);
        this.out.write((int)(l >>> 8) & 0xFF);
        this.out.write((int)(l >>> 0) & 0xFF);
        this.incCount(8);
    }

    public void writeUShort(int n) throws IOException {
        this.out.write(n >> 8 & 0xFF);
        this.out.write(n >>> 0 & 0xFF);
        this.incCount(2);
    }

    protected void incCount(int n) {
        long l = this.written + (long)n;
        if (l < 0L) {
            l = Long.MAX_VALUE;
        }
        this.written = l;
    }

    public void writeShorts(short[] sArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > sArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > s.length!");
        }
        byte[] byArray = new byte[n2 * 2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            short s = sArray[n + n4];
            byArray[n3++] = (byte)(s >>> 8);
            byArray[n3++] = (byte)(s >>> 0);
            ++n4;
        }
        this.write(byArray, 0, n2 * 2);
    }

    public void writeInts(int[] nArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > nArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
        }
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = nArray[n + n4];
            byArray[n3++] = (byte)(n5 >>> 24);
            byArray[n3++] = (byte)(n5 >>> 16);
            byArray[n3++] = (byte)(n5 >>> 8);
            byArray[n3++] = (byte)(n5 >>> 0);
            ++n4;
        }
        this.write(byArray, 0, n2 * 4);
    }

    public void writeInt24(int n) throws IOException {
        this.byteBuf[0] = (byte)(n >>> 16);
        this.byteBuf[1] = (byte)(n >>> 8);
        this.byteBuf[2] = (byte)(n >>> 0);
        this.write(this.byteBuf, 0, 3);
    }

    public void writeInts24(int[] nArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > nArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
        }
        byte[] byArray = new byte[n2 * 3];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = nArray[n + n4];
            byArray[n3++] = (byte)(n5 >>> 16);
            byArray[n3++] = (byte)(n5 >>> 8);
            byArray[n3++] = (byte)(n5 >>> 0);
            ++n4;
        }
        this.write(byArray, 0, n2 * 3);
    }

    public final long size() {
        return this.written;
    }
}

