/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnClassLoader;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;

final class AddOnLoaderUtils {
    private static final Logger LOGGER = Logger.getLogger(AddOnLoaderUtils.class);

    private AddOnLoaderUtils() {
    }

    public static <T> T loadAndInstantiateClass(AddOnClassLoader addOnClassLoader, String classname, Class<T> clazz, String type) {
        AddOnLoaderUtils.validateNotNull(addOnClassLoader, "addOnClassLoader");
        AddOnLoaderUtils.validateNotNull(classname, "classname");
        AddOnLoaderUtils.validateNotNull(clazz, "clazz");
        AddOnLoaderUtils.validateNotNull(type, "type");
        return AddOnLoaderUtils.loadAndInstantiateClassImpl(addOnClassLoader, classname, clazz, type);
    }

    private static <T> T loadAndInstantiateClassImpl(AddOnClassLoader addOnClassLoader, String classname, Class<T> clazz, String type) {
        Class<?> cls;
        try {
            cls = addOnClassLoader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)("Declared \"" + type + "\" was not found: " + classname), (Throwable)e);
            return null;
        }
        if (Modifier.isAbstract(cls.getModifiers()) || Modifier.isInterface(cls.getModifiers())) {
            LOGGER.error((Object)("Declared \"" + type + "\" is abstract or an interface: " + classname));
            return null;
        }
        if (!clazz.isAssignableFrom(cls)) {
            LOGGER.error((Object)("Declared \"" + type + "\" is not of type \"" + clazz.getName() + "\": " + classname));
            return null;
        }
        try {
            Constructor<?> c = cls.getConstructor(new Class[0]);
            Object instance = c.newInstance(new Object[0]);
            return (T)instance;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failed to initialise: " + classname), (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> loadDeclaredClasses(AddOnClassLoader addOnClassLoader, List<String> classnames, Class<T> clazz, String type) {
        AddOnLoaderUtils.validateNotNull(addOnClassLoader, "addOnClassLoader");
        AddOnLoaderUtils.validateNotNull(classnames, "classnames");
        AddOnLoaderUtils.validateNotNull(clazz, "clazz");
        AddOnLoaderUtils.validateNotNull(type, "type");
        if (classnames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> instances = new ArrayList<T>(classnames.size());
        for (String classname : classnames) {
            T instance = AddOnLoaderUtils.loadAndInstantiateClassImpl(addOnClassLoader, classname, clazz, type);
            if (instance == null) continue;
            instances.add(instance);
        }
        instances.trimToSize();
        return Collections.unmodifiableList(instances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AbstractPlugin> getActiveScanRules(AddOn addOn, AddOnClassLoader addOnClassLoader) {
        AddOnLoaderUtils.validateNotNull(addOn, "addOn");
        AddOnLoaderUtils.validateNotNull(addOnClassLoader, "addOnClassLoader");
        AddOn addOn2 = addOn;
        synchronized (addOn2) {
            if (addOn.isLoadedAscanrulesSet()) {
                return addOn.getLoadedAscanrules();
            }
            List<AbstractPlugin> ascanrules = AddOnLoaderUtils.loadDeclaredClasses(addOnClassLoader, addOn.getAscanrules(), AbstractPlugin.class, "ascanrule");
            addOn.setLoadedAscanrules(ascanrules);
            addOn.setLoadedAscanrulesSet(true);
            return Collections.unmodifiableList(ascanrules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PluginPassiveScanner> getPassiveScanRules(AddOn addOn, AddOnClassLoader addOnClassLoader) {
        AddOnLoaderUtils.validateNotNull(addOn, "addOn");
        AddOnLoaderUtils.validateNotNull(addOnClassLoader, "addOnClassLoader");
        AddOn addOn2 = addOn;
        synchronized (addOn2) {
            if (addOn.isLoadedPscanrulesSet()) {
                return addOn.getLoadedPscanrules();
            }
            List<PluginPassiveScanner> pscanrules = AddOnLoaderUtils.loadDeclaredClasses(addOnClassLoader, addOn.getPscanrules(), PluginPassiveScanner.class, "pscanrule");
            addOn.setLoadedPscanrules(pscanrules);
            addOn.setLoadedPscanrulesSet(true);
            return Collections.unmodifiableList(pscanrules);
        }
    }

    private static void validateNotNull(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException("Parameter " + name + " must not be null.");
        }
    }
}

