"use strict";
var __values = (this && this.__values) || function (o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
};
Object.defineProperty(exports, "__esModule", { value: true });
var autoLaunch = require("auto-launch");
var electron_1 = require("electron");
var eventType_1 = require("../lib/eventType");
var webViewFocus_1 = require("../lib/webViewFocus");
var locale = require("../locale/locale");
var lifecycle = require("../runtime/lifecycle");
var config = require("../settings/config");
var ConfigurationPersistence_1 = require("../settings/ConfigurationPersistence");
var SettingsType_1 = require("../settings/SettingsType");
var WindowManager_1 = require("../window/WindowManager");
var EnvironmentUtil = require("../runtime/EnvironmentUtil");
var launchCmd = process.env.APPIMAGE || process.execPath;
var menu;
var launcher = new autoLaunch({
    isHidden: true,
    name: config.NAME,
    path: launchCmd,
});
var separatorTemplate = {
    type: 'separator',
};
var createLanguageTemplate = function (languageCode) {
    return {
        click: function () { return changeLocale(languageCode); },
        label: locale.SUPPORTED_LANGUAGES[languageCode],
        type: 'radio',
    };
};
var createLanguageSubmenu = function () {
    return Object.keys(locale.SUPPORTED_LANGUAGES).map(function (supportedLanguage) {
        return createLanguageTemplate(supportedLanguage);
    });
};
var localeTemplate = {
    i18n: 'menuLocale',
    submenu: createLanguageSubmenu(),
};
var aboutTemplate = {
    click: function () { return electron_1.ipcMain.emit(eventType_1.EVENT_TYPE.ABOUT.SHOW); },
    i18n: 'menuAbout',
};
var signOutTemplate = {
    click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.ACTION.SIGN_OUT); },
    i18n: 'menuSignOut',
};
var conversationTemplate = {
    i18n: 'menuConversation',
    submenu: [
        {
            accelerator: 'CmdOrCtrl+N',
            click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.START); },
            i18n: 'menuStart',
        },
        separatorTemplate,
        {
            accelerator: 'CmdOrCtrl+K',
            click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.PING); },
            i18n: 'menuPing',
        },
        {
            click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.CALL); },
            i18n: 'menuCall',
        },
        {
            click: function () {
                return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.VIDEO_CALL);
            },
            i18n: 'menuVideoCall',
        },
        separatorTemplate,
        {
            accelerator: 'CmdOrCtrl+I',
            click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.PEOPLE); },
            i18n: 'menuPeople',
        },
        {
            accelerator: 'Shift+CmdOrCtrl+K',
            click: function () {
                return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.ADD_PEOPLE);
            },
            i18n: 'menuAddPeople',
        },
        separatorTemplate,
        {
            accelerator: 'CmdOrCtrl+D',
            click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.ARCHIVE); },
            i18n: 'menuArchive',
        },
        {
            click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.DELETE); },
            i18n: 'menuDelete',
        },
    ],
};
var showWireTemplate = {
    accelerator: 'CmdOrCtrl+0',
    click: function () { return WindowManager_1.WindowManager.getPrimaryWindow().show(); },
    label: config.NAME,
};
var toggleMenuTemplate = {
    checked: ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.SHOW_MENU_BAR, true),
    click: function () {
        var mainBrowserWindow = WindowManager_1.WindowManager.getPrimaryWindow();
        var showMenu = mainBrowserWindow.isMenuBarAutoHide();
        mainBrowserWindow.setAutoHideMenuBar(!showMenu);
        if (!showMenu) {
            mainBrowserWindow.setMenuBarVisibility(showMenu);
        }
        ConfigurationPersistence_1.settings.save(SettingsType_1.SettingsType.SHOW_MENU_BAR, showMenu);
    },
    i18n: 'menuShowHide',
    type: 'checkbox',
};
var toggleFullScreenTemplate = {
    accelerator: EnvironmentUtil.platform.IS_MAC_OS ? 'Alt+Command+F' : 'F11',
    click: function () {
        var mainBrowserWindow = WindowManager_1.WindowManager.getPrimaryWindow();
        mainBrowserWindow.setFullScreen(!mainBrowserWindow.isFullScreen());
    },
    i18n: 'menuFullScreen',
    type: 'checkbox',
};
var toggleAutoLaunchTemplate = {
    checked: ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.AUTO_LAUNCH, false),
    click: function () {
        var shouldAutoLaunch = !ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.AUTO_LAUNCH);
        ConfigurationPersistence_1.settings.save(SettingsType_1.SettingsType.AUTO_LAUNCH, shouldAutoLaunch);
        return shouldAutoLaunch ? launcher.enable() : launcher.disable();
    },
    i18n: 'menuStartup',
    type: 'checkbox',
};
var editTemplate = {
    i18n: 'menuEdit',
    submenu: [
        {
            accelerator: 'CmdOrCtrl+Z',
            click: function (menuItem, focusedWin) {
                var focusedWebContents = webViewFocus_1.WebViewFocus.getFocusedWebContents();
                if (focusedWebContents) {
                    focusedWebContents.undo();
                }
            },
            i18n: 'menuUndo',
        },
        {
            accelerator: 'Shift+CmdOrCtrl+Z',
            click: function (menuItem, focusedWin) {
                var focusedWebContents = webViewFocus_1.WebViewFocus.getFocusedWebContents();
                if (focusedWebContents) {
                    focusedWebContents.redo();
                }
            },
            i18n: 'menuRedo',
        },
        separatorTemplate,
        {
            i18n: 'menuCut',
            role: 'cut',
        },
        {
            i18n: 'menuCopy',
            role: 'copy',
        },
        {
            i18n: 'menuPaste',
            role: 'paste',
        },
        separatorTemplate,
        {
            i18n: 'menuSelectAll',
            role: 'selectall',
        },
    ],
};
var windowTemplate = {
    i18n: 'menuWindow',
    role: 'window',
    submenu: [
        {
            i18n: 'menuMinimize',
            role: 'minimize',
        },
        {
            i18n: 'menuClose',
            role: 'close',
        },
        separatorTemplate,
        {
            accelerator: EnvironmentUtil.platform.IS_MAC_OS ? 'Alt+Cmd+Up' : 'Alt+Shift+Up',
            click: function () {
                return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.SHOW_NEXT);
            },
            i18n: 'menuNextConversation',
        },
        {
            accelerator: EnvironmentUtil.platform.IS_MAC_OS ? 'Alt+Cmd+Down' : 'Alt+Shift+Down',
            click: function () {
                return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.SHOW_PREVIOUS);
            },
            i18n: 'menuPreviousConversation',
        },
    ],
};
var helpTemplate = {
    i18n: 'menuHelp',
    role: 'help',
    submenu: [
        {
            click: function () { return electron_1.shell.openExternal(EnvironmentUtil.URL_LEGAL); },
            i18n: 'menuLegal',
        },
        {
            click: function () { return electron_1.shell.openExternal(EnvironmentUtil.URL_PRIVACY); },
            i18n: 'menuPrivacy',
        },
        {
            click: function () { return electron_1.shell.openExternal(EnvironmentUtil.URL_LICENSES); },
            i18n: 'menuLicense',
        },
        {
            click: function () { return electron_1.shell.openExternal(EnvironmentUtil.URL_SUPPORT); },
            i18n: 'menuSupport',
        },
        {
            click: function () { return electron_1.shell.openExternal(EnvironmentUtil.web.getWebsiteUrl()); },
            i18n: 'menuWireURL',
        },
    ],
};
var darwinTemplate = {
    label: config.NAME,
    submenu: [
        aboutTemplate,
        separatorTemplate,
        {
            accelerator: 'Command+,',
            click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.PREFERENCES.SHOW); },
            i18n: 'menuPreferences',
        },
        separatorTemplate,
        localeTemplate,
        {
            i18n: 'menuServices',
            role: 'services',
            submenu: [],
        },
        separatorTemplate,
        {
            i18n: 'menuHideWire',
            role: 'hide',
        },
        {
            i18n: 'menuHideOthers',
            role: 'hideothers',
        },
        {
            i18n: 'menuShowAll',
            role: 'unhide',
        },
        separatorTemplate,
        signOutTemplate,
        {
            accelerator: 'Command+Q',
            i18n: 'menuQuit',
            selector: 'terminate:',
        },
    ],
};
var win32Template = {
    label: config.NAME,
    submenu: [
        {
            accelerator: 'Ctrl+,',
            click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.PREFERENCES.SHOW); },
            i18n: 'menuSettings',
        },
        localeTemplate,
        toggleAutoLaunchTemplate,
        separatorTemplate,
        signOutTemplate,
        {
            accelerator: 'Alt+F4',
            click: function () { return lifecycle.quit(); },
            i18n: 'menuQuit',
        },
    ],
};
var linuxTemplate = {
    label: config.NAME,
    submenu: [
        toggleAutoLaunchTemplate,
        separatorTemplate,
        localeTemplate,
        separatorTemplate,
        signOutTemplate,
        {
            accelerator: 'Ctrl+Q',
            click: function () { return lifecycle.quit(); },
            i18n: 'menuQuit',
        },
    ],
};
var menuTemplate = [conversationTemplate, editTemplate, windowTemplate, helpTemplate];
var processMenu = function (template, language) {
    var e_1, _a;
    try {
        for (var template_1 = __values(template), template_1_1 = template_1.next(); !template_1_1.done; template_1_1 = template_1.next()) {
            var item = template_1_1.value;
            if (item.submenu) {
                processMenu(item.submenu, language);
            }
            if (locale.SUPPORTED_LANGUAGES[language] === item.label) {
                item.checked = true;
            }
            if (item.i18n) {
                item.label = locale.getText(item.i18n);
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (template_1_1 && !template_1_1.done && (_a = template_1.return)) _a.call(template_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
};
var changeLocale = function (language) {
    locale.setLocale(language);
    electron_1.dialog.showMessageBox({
        buttons: [
            locale.getText('restartLater'),
            EnvironmentUtil.platform.IS_MAC_OS ? locale.getText('menuQuit') : locale.getText('restartNow'),
        ],
        message: locale.getText('restartLocale'),
        title: locale.getText('restartNeeded'),
        type: 'info',
    }, function (response) {
        if (response === 1) {
            return EnvironmentUtil.platform.IS_MAC_OS ? lifecycle.quit() : lifecycle.relaunch();
        }
    });
};
var createMenu = function (isFullScreen) {
    if (!windowTemplate.submenu) {
        windowTemplate.submenu = [];
    }
    if (!editTemplate.submenu) {
        editTemplate.submenu = [];
    }
    if (!helpTemplate.submenu) {
        helpTemplate.submenu = [];
    }
    if (EnvironmentUtil.platform.IS_MAC_OS) {
        menuTemplate.unshift(darwinTemplate);
        if (Array.isArray(windowTemplate.submenu)) {
            windowTemplate.submenu.push(separatorTemplate, showWireTemplate, separatorTemplate, toggleFullScreenTemplate);
        }
        toggleFullScreenTemplate.checked = isFullScreen;
    }
    if (EnvironmentUtil.platform.IS_WINDOWS) {
        menuTemplate.unshift(win32Template);
        windowTemplate.i18n = 'menuView';
        if (Array.isArray(windowTemplate.submenu)) {
            windowTemplate.submenu.unshift(toggleMenuTemplate, separatorTemplate);
        }
    }
    if (EnvironmentUtil.platform.IS_LINUX) {
        menuTemplate.unshift(linuxTemplate);
        if (Array.isArray(editTemplate.submenu)) {
            editTemplate.submenu.push(separatorTemplate, {
                accelerator: 'Ctrl+,',
                click: function () { return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.PREFERENCES.SHOW); },
                i18n: 'menuPreferences',
            });
        }
        if (Array.isArray(windowTemplate.submenu)) {
            windowTemplate.submenu.push(separatorTemplate, toggleMenuTemplate, separatorTemplate, toggleFullScreenTemplate);
        }
        toggleFullScreenTemplate.checked = isFullScreen;
    }
    if (!EnvironmentUtil.platform.IS_MAC_OS) {
        if (Array.isArray(helpTemplate.submenu)) {
            helpTemplate.submenu.push(separatorTemplate, aboutTemplate);
        }
    }
    processMenu(menuTemplate, locale.getCurrent());
    menu = electron_1.Menu.buildFromTemplate(menuTemplate);
    return menu;
};
exports.createMenu = createMenu;
var registerShortcuts = function () {
    var e_2, _a;
    electron_1.globalShortcut.register('CmdOrCtrl+Alt+M', function () {
        return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, eventType_1.EVENT_TYPE.CONVERSATION.TOGGLE_MUTE);
    });
    var switchAccountShortcut = ['CmdOrCtrl', 'Super'];
    var accountLimit = config.MAXIMUM_ACCOUNTS;
    try {
        for (var switchAccountShortcut_1 = __values(switchAccountShortcut), switchAccountShortcut_1_1 = switchAccountShortcut_1.next(); !switchAccountShortcut_1_1.done; switchAccountShortcut_1_1 = switchAccountShortcut_1.next()) {
            var shortcut = switchAccountShortcut_1_1.value;
            var _loop_1 = function (accountId) {
                electron_1.globalShortcut.register(shortcut + "+" + (accountId + 1), function () {
                    return WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.ACTION.SWITCH_ACCOUNT, accountId);
                });
            };
            for (var accountId = 0; accountId < accountLimit; accountId++) {
                _loop_1(accountId);
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (switchAccountShortcut_1_1 && !switchAccountShortcut_1_1.done && (_a = switchAccountShortcut_1.return)) _a.call(switchAccountShortcut_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
};
exports.registerShortcuts = registerShortcuts;
var unregisterShortcuts = function () {
    electron_1.globalShortcut.unregisterAll();
};
exports.unregisterShortcuts = unregisterShortcuts;
var toggleMenuBar = function () {
    var mainBrowserWindow = WindowManager_1.WindowManager.getPrimaryWindow();
    var isVisible = mainBrowserWindow.isMenuBarVisible();
    var autoHide = mainBrowserWindow.isMenuBarAutoHide();
    if (autoHide) {
        mainBrowserWindow.setMenuBarVisibility(!isVisible);
    }
};
exports.toggleMenuBar = toggleMenuBar;
//# sourceMappingURL=system.js.map