/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.lexer.YAMLFlexLexer;
import org.jetbrains.yaml.parser.YAMLParser;
import org.jetbrains.yaml.psi.impl.YAMLAliasImpl;
import org.jetbrains.yaml.psi.impl.YAMLAnchorImpl;
import org.jetbrains.yaml.psi.impl.YAMLArrayImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockSequenceImpl;
import org.jetbrains.yaml.psi.impl.YAMLCompoundValueImpl;
import org.jetbrains.yaml.psi.impl.YAMLDocumentImpl;
import org.jetbrains.yaml.psi.impl.YAMLFileImpl;
import org.jetbrains.yaml.psi.impl.YAMLHashImpl;
import org.jetbrains.yaml.psi.impl.YAMLKeyValueImpl;
import org.jetbrains.yaml.psi.impl.YAMLPlainTextImpl;
import org.jetbrains.yaml.psi.impl.YAMLPsiElementImpl;
import org.jetbrains.yaml.psi.impl.YAMLQuotedTextImpl;
import org.jetbrains.yaml.psi.impl.YAMLScalarListImpl;
import org.jetbrains.yaml.psi.impl.YAMLScalarTextImpl;
import org.jetbrains.yaml.psi.impl.YAMLSequenceItemImpl;

public class YAMLParserDefinition
implements ParserDefinition,
YAMLElementTypes {
    private static final TokenSet myCommentTokens = TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.COMMENT});

    @NotNull
    public Lexer createLexer(Project project) {
        YAMLFlexLexer yAMLFlexLexer = new YAMLFlexLexer();
        if (yAMLFlexLexer == null) {
            YAMLParserDefinition.$$$reportNull$$$0(0);
        }
        return yAMLFlexLexer;
    }

    @Nullable
    public PsiParser createParser(Project project) {
        return new YAMLParser();
    }

    public IFileElementType getFileNodeType() {
        return FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.WHITESPACE});
        if (tokenSet == null) {
            YAMLParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = myCommentTokens;
        if (tokenSet == null) {
            YAMLParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.SCALAR_STRING, YAMLTokenTypes.SCALAR_DSTRING, YAMLTokenTypes.TEXT});
        if (tokenSet == null) {
            YAMLParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type == DOCUMENT) {
            YAMLDocumentImpl yAMLDocumentImpl = new YAMLDocumentImpl(node);
            if (yAMLDocumentImpl == null) {
                YAMLParserDefinition.$$$reportNull$$$0(4);
            }
            return yAMLDocumentImpl;
        }
        if (type == KEY_VALUE_PAIR) {
            YAMLKeyValueImpl yAMLKeyValueImpl = new YAMLKeyValueImpl(node);
            if (yAMLKeyValueImpl == null) {
                YAMLParserDefinition.$$$reportNull$$$0(5);
            }
            return yAMLKeyValueImpl;
        }
        if (type == COMPOUND_VALUE) {
            YAMLCompoundValueImpl yAMLCompoundValueImpl = new YAMLCompoundValueImpl(node);
            if (yAMLCompoundValueImpl == null) {
                YAMLParserDefinition.$$$reportNull$$$0(6);
            }
            return yAMLCompoundValueImpl;
        }
        if (type == SEQUENCE) {
            YAMLBlockSequenceImpl yAMLBlockSequenceImpl = new YAMLBlockSequenceImpl(node);
            if (yAMLBlockSequenceImpl == null) {
                YAMLParserDefinition.$$$reportNull$$$0(7);
            }
            return yAMLBlockSequenceImpl;
        }
        if (type == MAPPING) {
            YAMLBlockMappingImpl yAMLBlockMappingImpl = new YAMLBlockMappingImpl(node);
            if (yAMLBlockMappingImpl == null) {
                YAMLParserDefinition.$$$reportNull$$$0(8);
            }
            return yAMLBlockMappingImpl;
        }
        if (type == SEQUENCE_ITEM) {
            YAMLSequenceItemImpl yAMLSequenceItemImpl = new YAMLSequenceItemImpl(node);
            if (yAMLSequenceItemImpl == null) {
                YAMLParserDefinition.$$$reportNull$$$0(9);
            }
            return yAMLSequenceItemImpl;
        }
        if (type == HASH) {
            YAMLHashImpl yAMLHashImpl = new YAMLHashImpl(node);
            if (yAMLHashImpl == null) {
                YAMLParserDefinition.$$$reportNull$$$0(10);
            }
            return yAMLHashImpl;
        }
        if (type == ARRAY) {
            YAMLArrayImpl yAMLArrayImpl = new YAMLArrayImpl(node);
            if (yAMLArrayImpl == null) {
                YAMLParserDefinition.$$$reportNull$$$0(11);
            }
            return yAMLArrayImpl;
        }
        if (type == SCALAR_LIST_VALUE) {
            YAMLScalarListImpl yAMLScalarListImpl = new YAMLScalarListImpl(node);
            if (yAMLScalarListImpl == null) {
                YAMLParserDefinition.$$$reportNull$$$0(12);
            }
            return yAMLScalarListImpl;
        }
        if (type == SCALAR_TEXT_VALUE) {
            YAMLScalarTextImpl yAMLScalarTextImpl = new YAMLScalarTextImpl(node);
            if (yAMLScalarTextImpl == null) {
                YAMLParserDefinition.$$$reportNull$$$0(13);
            }
            return yAMLScalarTextImpl;
        }
        if (type == SCALAR_PLAIN_VALUE) {
            YAMLPlainTextImpl yAMLPlainTextImpl = new YAMLPlainTextImpl(node);
            if (yAMLPlainTextImpl == null) {
                YAMLParserDefinition.$$$reportNull$$$0(14);
            }
            return yAMLPlainTextImpl;
        }
        if (type == SCALAR_QUOTED_STRING) {
            YAMLQuotedTextImpl yAMLQuotedTextImpl = new YAMLQuotedTextImpl(node);
            if (yAMLQuotedTextImpl == null) {
                YAMLParserDefinition.$$$reportNull$$$0(15);
            }
            return yAMLQuotedTextImpl;
        }
        if (type == ANCHOR_NODE) {
            YAMLAnchorImpl yAMLAnchorImpl = new YAMLAnchorImpl(node);
            if (yAMLAnchorImpl == null) {
                YAMLParserDefinition.$$$reportNull$$$0(16);
            }
            return yAMLAnchorImpl;
        }
        if (type == ALIAS_NODE) {
            YAMLAliasImpl yAMLAliasImpl = new YAMLAliasImpl(node);
            if (yAMLAliasImpl == null) {
                YAMLParserDefinition.$$$reportNull$$$0(17);
            }
            return yAMLAliasImpl;
        }
        YAMLPsiElementImpl yAMLPsiElementImpl = new YAMLPsiElementImpl(node);
        if (yAMLPsiElementImpl == null) {
            YAMLParserDefinition.$$$reportNull$$$0(18);
        }
        return yAMLPsiElementImpl;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new YAMLFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/yaml/YAMLParserDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

