/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerListener;
import git4idea.commands.GitImpl;
import git4idea.util.GitVcsConsoleWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class GitBinaryHandler
extends GitHandler {
    private static final int BUFFER_SIZE = 8192;
    @NotNull
    private final ByteArrayOutputStream myStdout;
    @NotNull
    private final ByteArrayOutputStream myStderr;
    @NotNull
    private final Semaphore mySteamSemaphore;
    @NotNull
    private final AtomicReference<VcsException> myException;

    public GitBinaryHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command) {
        if (project == null) {
            GitBinaryHandler.$$$reportNull$$$0(0);
        }
        if (vcsRoot == null) {
            GitBinaryHandler.$$$reportNull$$$0(1);
        }
        if (command == null) {
            GitBinaryHandler.$$$reportNull$$$0(2);
        }
        super(project, vcsRoot, command, Collections.emptyList());
        this.myStdout = new ByteArrayOutputStream();
        this.myStderr = new ByteArrayOutputStream();
        this.mySteamSemaphore = new Semaphore(0);
        this.myException = new AtomicReference();
    }

    @Override
    protected Process startProcess() throws ExecutionException {
        return this.myCommandLine.createProcess();
    }

    @Override
    protected void startHandlingStreams() {
        this.handleStream(this.myProcess.getErrorStream(), this.myStderr, "Error stream copy of " + this.myCommandLine.getCommandLineString());
        this.handleStream(this.myProcess.getInputStream(), this.myStdout, "Output stream copy of " + this.myCommandLine.getCommandLineString());
    }

    private void handleStream(InputStream in, ByteArrayOutputStream out, @NotNull String cmd) {
        if (cmd == null) {
            GitBinaryHandler.$$$reportNull$$$0(3);
        }
        Thread t = new Thread(() -> {
            try {
                int rc;
                byte[] buffer = new byte[8192];
                while ((rc = in.read(buffer)) != -1) {
                    out.write(buffer, 0, rc);
                }
            }
            catch (IOException e) {
                if (!this.myException.compareAndSet(null, new VcsException("Stream IO problem", (Throwable)e))) {
                    LOG.error("Problem reading stream", (Throwable)e);
                }
            }
            finally {
                this.mySteamSemaphore.release(1);
            }
        }, cmd);
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void destroyProcess() {
        this.myProcess.destroy();
    }

    @Override
    protected void waitForProcess() {
        int exitCode;
        try {
            this.mySteamSemaphore.acquire(2);
            this.myProcess.waitFor();
            exitCode = this.myProcess.exitValue();
        }
        catch (InterruptedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring process exception: ", (Throwable)e);
            }
            exitCode = 255;
        }
        this.setExitCode(exitCode);
        this.listeners().processTerminated(exitCode);
    }

    public byte[] run() throws VcsException {
        Project project = this.project();
        final GitVcsConsoleWriter vcsConsoleWriter = project != null ? GitVcsConsoleWriter.getInstance(project) : null;
        this.addListener(new GitHandlerListener(){

            public void processTerminated(int exitCode) {
                if (exitCode != 0) {
                    VcsException e;
                    Charset cs = GitBinaryHandler.this.getCharset();
                    String message = new String(GitBinaryHandler.this.myStderr.toByteArray(), cs);
                    if (message.length() == 0) {
                        message = GitBinaryHandler.this.myException.get() != null ? IdeBundle.message((String)"finished.with.exit.code.text.message", (Object[])new Object[]{exitCode}) : null;
                    } else if (vcsConsoleWriter != null && !GitBinaryHandler.this.isStderrSuppressed()) {
                        vcsConsoleWriter.showErrorMessage(message);
                    }
                    if (message != null && (e = GitBinaryHandler.this.myException.getAndSet(new VcsException(message))) != null) {
                        GitHandler.LOG.warn("Dropping previous exception: ", (Throwable)e);
                    }
                }
            }

            public void startFailed(@NotNull Throwable exception) {
                VcsException e;
                if (exception == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((e = GitBinaryHandler.this.myException.getAndSet(new VcsException("Start failed: " + exception.getMessage(), exception))) != null) {
                    GitHandler.LOG.warn("Dropping previous exception: ", (Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "git4idea/commands/GitBinaryHandler$1", "startFailed"));
            }
        });
        if (vcsConsoleWriter != null && !this.mySilent) {
            vcsConsoleWriter.showCommandLine("[" + GitImpl.stringifyWorkingDir(project.getBasePath(), this.getWorkingDirectory()) + "] " + this.printableCommandLine());
        }
        try {
            this.runInCurrentThread();
        }
        catch (IOException e) {
            throw new VcsException(e.getMessage(), (Throwable)e);
        }
        if (this.myException.get() != null) {
            throw this.myException.get();
        }
        return this.myStdout.toByteArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
        }
        objectArray2[1] = "git4idea/commands/GitBinaryHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "handleStream";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

