/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.rebase.GitRebaseActionDialog;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitAbstractRebaseAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GitAbstractRebaseAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        Project project = e.getProject();
        if (project == null || !GitUtil.hasGitRepositories(project)) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabledAndVisible(GitAbstractRebaseAction.hasRebaseInProgress(project));
        }
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GitAbstractRebaseAction.$$$reportNull$$$0(1);
        }
        if (GitUtil.getRepositoryManager(project = (Project)e.getRequiredData(CommonDataKeys.PROJECT)).hasOngoingRebase()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, this.getProgressTitle()){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    GitAbstractRebaseAction.this.performActionForProject(project, indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/GitAbstractRebaseAction$1", "run"));
                }
            });
        } else {
            GitRepository repositoryToOperate = this.chooseRepository(project, GitRebaseUtils.getRebasingRepositories(project));
            if (repositoryToOperate != null) {
                this.performInBackground(repositoryToOperate);
            }
        }
    }

    public void performInBackground(final @NotNull GitRepository repositoryToOperate) {
        if (repositoryToOperate == null) {
            GitAbstractRebaseAction.$$$reportNull$$$0(2);
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(repositoryToOperate.getProject(), this.getProgressTitle()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                GitAbstractRebaseAction.this.performActionForRepository(repositoryToOperate.getProject(), repositoryToOperate, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/GitAbstractRebaseAction$2", "run"));
            }
        });
    }

    @NotNull
    protected abstract String getProgressTitle();

    protected abstract void performActionForProject(@NotNull Project var1, @NotNull ProgressIndicator var2);

    protected abstract void performActionForRepository(@NotNull Project var1, @NotNull GitRepository var2, @NotNull ProgressIndicator var3);

    private static boolean hasRebaseInProgress(@NotNull Project project) {
        if (project == null) {
            GitAbstractRebaseAction.$$$reportNull$$$0(3);
        }
        return !GitRebaseUtils.getRebasingRepositories(project).isEmpty();
    }

    @Nullable
    private GitRepository chooseRepository(@NotNull Project project, @NotNull Collection<GitRepository> repositories) {
        if (project == null) {
            GitAbstractRebaseAction.$$$reportNull$$$0(4);
        }
        if (repositories == null) {
            GitAbstractRebaseAction.$$$reportNull$$$0(5);
        }
        GitRepository firstRepo = (GitRepository)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(repositories));
        if (repositories.size() == 1) {
            return firstRepo;
        }
        ArrayList roots = ContainerUtil.newArrayList(GitUtil.getRootsFromRepositories(repositories));
        GitRebaseActionDialog dialog = new GitRebaseActionDialog(project, this.getTemplatePresentation().getText(), roots, firstRepo.getRoot());
        dialog.show();
        VirtualFile root = dialog.selectRoot();
        if (root == null) {
            return null;
        }
        return (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRootQuick(root);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryToOperate";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
        }
        objectArray2[1] = "git4idea/actions/GitAbstractRebaseAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "performInBackground";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasRebaseInProgress";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseRepository";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

