/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.history.CopyData;
import org.jetbrains.idea.svn.history.FirstInBranch;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.mergeinfo.BranchInfo;
import org.jetbrains.idea.svn.mergeinfo.MergeInfoCached;

public class SvnMergeInfoCache {
    private static final Logger LOG = Logger.getInstance(SvnMergeInfoCache.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<Url, MyCurrentUrlData> myCurrentUrlMapping;
    public static Topic<SvnMergeInfoCacheListener> SVN_MERGE_INFO_CACHE = new Topic("SVN_MERGE_INFO_CACHE", SvnMergeInfoCacheListener.class);

    private SvnMergeInfoCache(@NotNull Project project) {
        if (project == null) {
            SvnMergeInfoCache.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myCurrentUrlMapping = ContainerUtil.newHashMap();
    }

    public static SvnMergeInfoCache getInstance(@NotNull Project project) {
        if (project == null) {
            SvnMergeInfoCache.$$$reportNull$$$0(1);
        }
        return (SvnMergeInfoCache)ServiceManager.getService((Project)project, SvnMergeInfoCache.class);
    }

    public void clear(@NotNull WCInfoWithBranches info, String branchPath) {
        BranchInfo branchInfo;
        if (info == null) {
            SvnMergeInfoCache.$$$reportNull$$$0(2);
        }
        if ((branchInfo = this.getBranchInfo(info, branchPath)) != null) {
            branchInfo.clear();
        }
    }

    @Nullable
    public MergeInfoCached getCachedState(@NotNull WCInfoWithBranches info, String branchPath) {
        BranchInfo branchInfo;
        if (info == null) {
            SvnMergeInfoCache.$$$reportNull$$$0(3);
        }
        return (branchInfo = this.getBranchInfo(info, branchPath)) != null ? branchInfo.getCached() : null;
    }

    public MergeCheckResult getState(@NotNull WCInfoWithBranches info, @NotNull SvnChangeList list, @NotNull WCInfoWithBranches.Branch selectedBranch, String branchPath) {
        if (info == null) {
            SvnMergeInfoCache.$$$reportNull$$$0(4);
        }
        if (list == null) {
            SvnMergeInfoCache.$$$reportNull$$$0(5);
        }
        if (selectedBranch == null) {
            SvnMergeInfoCache.$$$reportNull$$$0(6);
        }
        MyCurrentUrlData rootMapping = this.myCurrentUrlMapping.get(info.getUrl());
        BranchInfo mergeChecker = null;
        if (rootMapping == null) {
            rootMapping = new MyCurrentUrlData();
            this.myCurrentUrlMapping.put(info.getUrl(), rootMapping);
        } else {
            mergeChecker = rootMapping.getBranchInfo(branchPath);
        }
        if (mergeChecker == null) {
            mergeChecker = new BranchInfo(SvnVcs.getInstance(this.myProject), info, selectedBranch);
            rootMapping.addBranchInfo(branchPath, mergeChecker);
        }
        return mergeChecker.checkList(list, branchPath);
    }

    public boolean isMixedRevisions(@NotNull WCInfoWithBranches info, String branchPath) {
        BranchInfo branchInfo;
        if (info == null) {
            SvnMergeInfoCache.$$$reportNull$$$0(7);
        }
        return (branchInfo = this.getBranchInfo(info, branchPath)) != null && branchInfo.isMixedRevisionsFound();
    }

    @Nullable
    private BranchInfo getBranchInfo(@NotNull WCInfoWithBranches info, String branchPath) {
        MyCurrentUrlData rootMapping;
        if (info == null) {
            SvnMergeInfoCache.$$$reportNull$$$0(8);
        }
        return (rootMapping = this.myCurrentUrlMapping.get(info.getUrl())) != null ? rootMapping.getBranchInfo(branchPath) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedBranch";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/mergeinfo/SvnMergeInfoCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "clear";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCachedState";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isMixedRevisions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getBranchInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface SvnMergeInfoCacheListener {
        public void copyRevisionUpdated();
    }

    private static class MyCurrentUrlData {
        @NotNull
        private final Map<String, BranchInfo> myBranchInfo = ContainerUtil.createSoftMap();

        private MyCurrentUrlData() {
        }

        public BranchInfo getBranchInfo(String branchUrl) {
            return this.myBranchInfo.get(branchUrl);
        }

        public void addBranchInfo(@NotNull String branchUrl, @NotNull BranchInfo mergeChecker) {
            if (branchUrl == null) {
                MyCurrentUrlData.$$$reportNull$$$0(0);
            }
            if (mergeChecker == null) {
                MyCurrentUrlData.$$$reportNull$$$0(1);
            }
            this.myBranchInfo.put(branchUrl, mergeChecker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "branchUrl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mergeChecker";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/svn/mergeinfo/SvnMergeInfoCache$MyCurrentUrlData";
            objectArray[2] = "addBranchInfo";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CopyRevison {
        private final String myPath;
        private final long myRevision;

        CopyRevison(final SvnVcs vcs, String path, final @NotNull Url repositoryRoot, final @NotNull Url branchUrl, final @NotNull Url trunkUrl) {
            if (repositoryRoot == null) {
                CopyRevison.$$$reportNull$$$0(0);
            }
            if (branchUrl == null) {
                CopyRevison.$$$reportNull$$$0(1);
            }
            if (trunkUrl == null) {
                CopyRevison.$$$reportNull$$$0(2);
            }
            this.myPath = path;
            this.myRevision = -1L;
            Task.Backgroundable task = new Task.Backgroundable(vcs.getProject(), "Calculating Copy Revision", false){
                private CopyData myData;

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        this.myData = new FirstInBranch(vcs, repositoryRoot, branchUrl, trunkUrl).run();
                    }
                    catch (VcsException e) {
                        this.logAndShow(e);
                    }
                }

                public void onSuccess() {
                    if (this.myData != null && this.myData.getCopySourceRevision() != -1L) {
                        ((SvnMergeInfoCacheListener)BackgroundTaskUtil.syncPublisher((Project)vcs.getProject(), SVN_MERGE_INFO_CACHE)).copyRevisionUpdated();
                    }
                }

                public void onThrowable(@NotNull Throwable error) {
                    if (error == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.logAndShow(error);
                }

                private void logAndShow(@NotNull Throwable error) {
                    if (error == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    LOG.info(error);
                    VcsBalloonProblemNotifier.showOverChangesView((Project)vcs.getProject(), (String)error.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "error";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/idea/svn/mergeinfo/SvnMergeInfoCache$CopyRevison$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onThrowable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "logAndShow";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)new EmptyProgressIndicator());
        }

        public String getPath() {
            return this.myPath;
        }

        public long getRevision() {
            return this.myRevision;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositoryRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "branchUrl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "trunkUrl";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/svn/mergeinfo/SvnMergeInfoCache$CopyRevison";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum MergeCheckResult {
        COMMON,
        MERGED,
        NOT_MERGED,
        NOT_EXISTS;


        @NotNull
        public static MergeCheckResult getInstance(boolean merged) {
            MergeCheckResult mergeCheckResult = merged ? MERGED : NOT_MERGED;
            if (mergeCheckResult == null) {
                MergeCheckResult.$$$reportNull$$$0(0);
            }
            return mergeCheckResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/SvnMergeInfoCache$MergeCheckResult", "getInstance"));
        }
    }
}

