/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import java.io.File;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.impl.sambox.component.AttachmentsSummaryCreator;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.ReadOnlyFilteredCOSStream;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.Source;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.AttachmentsCollectionParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.pdf.viewerpreference.PdfPageMode;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.PDDocumentNameDictionary;
import org.sejda.sambox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.sejda.sambox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.sejda.sambox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.sejda.sambox.pdmodel.common.filespecification.PDFileSpecification;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentsCollectionTask
extends BaseTask<AttachmentsCollectionParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentsCollectionTask.class);
    private static final COSName COLLECTION_ITEM_ORDER_FIELD = COSName.getPDFName((String)"Sejda-Order");
    private int totalSteps;
    private SingleOutputWriter outputWriter;
    private PDDocumentHandler destinationDocument;
    private AttachmentsSummaryCreator tocCreator;

    public void before(AttachmentsCollectionParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.totalSteps = parameters.getSourceList().size();
        this.outputWriter = OutputWriters.newSingleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
    }

    public void execute(AttachmentsCollectionParameters parameters) throws TaskException {
        int currentStep = 0;
        File tmpFile = IOUtils.createTemporaryBuffer((TaskOutput)parameters.getOutput());
        this.outputWriter.taskOutput(tmpFile);
        LOG.debug("Temporary output set to {}", (Object)tmpFile);
        this.destinationDocument = new PDDocumentHandler();
        this.destinationDocument.setCreatorOnPDDocument();
        this.destinationDocument.setVersionOnPDDocument(parameters.getVersion());
        this.destinationDocument.getUnderlyingPDDocument().requireMinVersion("1.7");
        this.destinationDocument.setCompress(parameters.isCompress());
        this.destinationDocument.setPageModeOnDocument(PdfPageMode.USE_ATTACHMENTS);
        this.tocCreator = new AttachmentsSummaryCreator(this.destinationDocument.getUnderlyingPDDocument());
        PDEmbeddedFilesNameTreeNode embeddedFiles = new PDEmbeddedFilesNameTreeNode();
        HashMap<String, PDComplexFileSpecification> names = new HashMap<String, PDComplexFileSpecification>();
        COSDictionary collection = new COSDictionary();
        collection.setName(COSName.getPDFName((String)"View"), parameters.getInitialView().value);
        collection.setItem(COSName.TYPE, (COSBase)COSName.getPDFName((String)"Collection"));
        collection.setItem(COSName.getPDFName((String)"Sort"), (COSBase)this.createSortDictionary());
        LOG.trace("Added sort dictionary");
        collection.setItem(COSName.getPDFName((String)"Schema"), (COSBase)this.createSchemaDictionary());
        LOG.trace("Added schema dictionary");
        for (Source source : parameters.getSourceList()) {
            this.executionContext().assertTaskNotCancelled();
            PDComplexFileSpecification fileSpec = new PDComplexFileSpecification(null);
            fileSpec.setFileUnicode(source.getName());
            fileSpec.setFile(source.getName());
            COSDictionary collectionItem = new COSDictionary();
            collectionItem.setInt(COLLECTION_ITEM_ORDER_FIELD, currentStep);
            fileSpec.setCollectionItem(collectionItem);
            PDEmbeddedFile embeddedFile = this.embeddedFileFromSource(source);
            fileSpec.setEmbeddedFileUnicode(embeddedFile);
            fileSpec.setEmbeddedFile(embeddedFile);
            names.put(currentStep + source.getName(), fileSpec);
            collection.putIfAbsent(COSName.D, currentStep + source.getName());
            this.tocCreator.appendItem(FilenameUtils.getName((String)source.getName()), this.attachmentAnnotation(fileSpec));
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).stepsCompleted(++currentStep).outOf(this.totalSteps);
            LOG.debug("Added embedded file from {}", (Object)source);
        }
        embeddedFiles.setNames(names);
        PDDocumentNameDictionary nameDictionary = new PDDocumentNameDictionary(this.destinationDocument.catalog());
        nameDictionary.setEmbeddedFiles(embeddedFiles);
        this.destinationDocument.catalog().setNames(nameDictionary);
        this.destinationDocument.catalog().getCOSObject().setItem(COSName.getPDFName((String)"Collection"), (COSBase)collection);
        LOG.debug("Adding generated ToC");
        this.tocCreator.addToC();
        this.destinationDocument.savePDDocument(tmpFile);
        ComponentsUtility.nullSafeCloseQuietly((Closeable)this.destinationDocument);
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Created portfolio with {} files and written to {}", (Object)parameters.getSourceList().size(), (Object)parameters.getOutput());
    }

    private COSDictionary createSortDictionary() {
        COSDictionary sortDictionary = new COSDictionary();
        sortDictionary.setItem(COSName.S, (COSBase)COLLECTION_ITEM_ORDER_FIELD);
        return sortDictionary;
    }

    private COSDictionary createSchemaDictionary() {
        COSDictionary schemaDictionary = new COSDictionary();
        COSDictionary fileDateFieldDictionary = new COSDictionary();
        fileDateFieldDictionary.setItem(COSName.SUBTYPE, (COSBase)COSName.F);
        fileDateFieldDictionary.setString(COSName.N, "File");
        fileDateFieldDictionary.setInt(COSName.O, 0);
        schemaDictionary.setItem(COSName.F, (COSBase)fileDateFieldDictionary);
        COSDictionary creationDateFieldDictionary = new COSDictionary();
        creationDateFieldDictionary.setItem(COSName.SUBTYPE, (COSBase)COSName.CREATION_DATE);
        creationDateFieldDictionary.setString(COSName.N, "Created");
        creationDateFieldDictionary.setInt(COSName.O, 1);
        schemaDictionary.setItem(COSName.CREATION_DATE, (COSBase)creationDateFieldDictionary);
        COSDictionary modDateFieldDictionary = new COSDictionary();
        modDateFieldDictionary.setItem(COSName.SUBTYPE, (COSBase)COSName.MOD_DATE);
        modDateFieldDictionary.setString(COSName.N, "Modified");
        modDateFieldDictionary.setInt(COSName.O, 2);
        schemaDictionary.setItem(COSName.MOD_DATE, (COSBase)modDateFieldDictionary);
        COSDictionary sizeDateFieldDictionary = new COSDictionary();
        sizeDateFieldDictionary.setItem(COSName.SUBTYPE, (COSBase)COSName.SIZE);
        sizeDateFieldDictionary.setString(COSName.N, "Size");
        sizeDateFieldDictionary.setInt(COSName.O, 3);
        schemaDictionary.setItem(COSName.SIZE, (COSBase)sizeDateFieldDictionary);
        COSDictionary sortFieldDictionary = new COSDictionary();
        sortFieldDictionary.setItem(COSName.SUBTYPE, (COSBase)COSName.N);
        sortFieldDictionary.setString(COSName.N, "Order");
        sortFieldDictionary.setInt(COSName.O, 4);
        schemaDictionary.setItem(COLLECTION_ITEM_ORDER_FIELD, (COSBase)sortFieldDictionary);
        return schemaDictionary;
    }

    private PDEmbeddedFile embeddedFileFromSource(Source<?> source) throws TaskIOException {
        PDEmbeddedFile embeddedFile = new PDEmbeddedFile((COSStream)ReadOnlyFilteredCOSStream.readOnlyEmbeddedFile(source));
        embeddedFile.setCreationDate((Calendar)new GregorianCalendar());
        return embeddedFile;
    }

    private PDAnnotationFileAttachment attachmentAnnotation(PDComplexFileSpecification fileSpec) {
        PDAnnotationFileAttachment attachmentAnnot = new PDAnnotationFileAttachment();
        attachmentAnnot.setFile((PDFileSpecification)fileSpec);
        attachmentAnnot.setBorder(new COSArray(new COSBase[]{COSInteger.ZERO, COSInteger.ZERO, COSInteger.ZERO}));
        return attachmentAnnot;
    }

    public void after() {
        ComponentsUtility.nullSafeCloseQuietly((Closeable)this.destinationDocument);
    }
}

