/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.signals.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HelperUtility;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.signals.SignalSupport;
import org.netbeans.modules.nativeexecution.signals.SignalSupportImplementation;
import org.netbeans.modules.nativeexecution.support.ShellSession;

public final class NbKillAllSignalSupport
extends HelperUtility
implements SignalSupportImplementation {
    public NbKillAllSignalSupport() {
        super("bin/nativeexecution/${osname}-${platform}${_isa}/killall");
    }

    @Override
    public boolean isSupported(ExecutionEnvironment env, SignalSupport.SIGNAL_SCOPE scope) {
        if (!HostInfoUtils.isHostInfoAvailable(env)) {
            return false;
        }
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo(env);
            if (this.getPath(env, hostInfo) == null) {
                return false;
            }
            switch (hostInfo.getOSFamily()) {
                case LINUX: 
                case SUNOS: {
                    return true;
                }
                case FREEBSD: {
                    return false;
                }
                case WINDOWS: {
                    if (scope == SignalSupport.SIGNAL_SCOPE.SIGNAL_BY_ENV) {
                        return false;
                    }
                    Shell activeShell = WindowsSupport.getInstance().getActiveShell();
                    return activeShell != null && activeShell.type == Shell.ShellType.CYGWIN;
                }
                case MACOSX: {
                    return scope != SignalSupport.SIGNAL_SCOPE.SIGQUEUE_PROCESS;
                }
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public int sendSignal(ExecutionEnvironment env, SignalSupport.SIGNAL_SCOPE scope, int id, Signal signal) {
        String param;
        switch (scope) {
            case SIGNAL_PROCESS: {
                param = "-p";
                break;
            }
            case SIGNAL_GROUP: {
                param = "-g";
                break;
            }
            case SIGNAL_SESSION: {
                param = "-s";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this.doSignal(env, param, signal, Integer.toString(id));
    }

    @Override
    public int sendSignal(ExecutionEnvironment env, String environment, Signal signal) {
        return this.doSignal(env, "-e", signal, environment);
    }

    @Override
    public int sigqueue(ExecutionEnvironment env, int id, Signal signal, int sigdata) {
        return this.doSignal(env, "-q", signal, Integer.toString(id), Integer.toString(sigdata));
    }

    private int doSignal(ExecutionEnvironment env, String scope, Signal signal, String ... args) {
        try {
            String path = this.getPath(env);
            if (path == null) {
                return -1;
            }
            StringBuilder cmd = new StringBuilder();
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo(env);
                if (HostInfo.OSFamily.WINDOWS.equals((Object)hostInfo.getOSFamily())) {
                    path = WindowsSupport.getInstance().convertToShellPath(path);
                }
                if (path == null) {
                    return -1;
                }
            }
            catch (ConnectionManager.CancellationException ex) {
                return -1;
            }
            cmd.append('\"').append(path).append('\"').append(' ');
            cmd.append(scope).append(' ');
            cmd.append(signal == Signal.NULL ? "NULL" : signal.name().substring(3)).append(' ');
            for (String arg : args) {
                cmd.append(arg).append(' ');
            }
            ProcessUtils.ExitStatus status = ShellSession.execute(env, cmd.toString());
            if (!status.getErrorLines().isEmpty()) {
                log.log(Level.FINE, "doSignal: {0}", status.toString());
            }
            return status.exitCode;
        }
        catch (IOException ex) {
            log.log(Level.FINE, "attempt to send signal " + signal.name() + " to " + scope + " " + Arrays.toString(args) + " failed:", ex);
            return -1;
        }
    }
}

