/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import java.io.File;
import org.eclipse.jgit.submodule.SubmoduleStatus;
import org.eclipse.jgit.submodule.SubmoduleStatusType;

public final class GitSubmoduleStatus {
    private final SubmoduleStatus delegate;
    private final StatusType statusType;
    private final File folder;

    GitSubmoduleStatus(SubmoduleStatus delegate, File folder) {
        this.delegate = delegate;
        this.folder = folder;
        this.statusType = GitSubmoduleStatus.parseStatus(delegate.getType());
    }

    public StatusType getStatus() {
        return this.statusType;
    }

    public File getSubmoduleFolder() {
        return this.folder;
    }

    public String getHeadId() {
        return this.delegate.getHeadId().getName();
    }

    public String getReferencedCommitId() {
        return this.delegate.getIndexId().getName();
    }

    static StatusType parseStatus(SubmoduleStatusType status) {
        return StatusType.valueOf(status.name());
    }

    public static enum StatusType {
        MISSING,
        UNINITIALIZED,
        INITIALIZED,
        REV_CHECKED_OUT;

    }
}

